<?php

namespace PHPMaker2024\fibre;

// Page object
$StockOnlineSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stock_online: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fstock_onlinesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fstock_onlinesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["location", [], fields.location.isInvalid],
            ["_barcode", [ew.Validators.integer], fields._barcode.isInvalid],
            ["y__barcode", [ew.Validators.between], false],
            ["design_id", [], fields.design_id.isInvalid],
            ["sqm", [ew.Validators.float], fields.sqm.isInvalid],
            ["Remarks", [], fields.Remarks.isInvalid],
            ["last_remarks", [], fields.last_remarks.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["consumed_by", [], fields.consumed_by.isInvalid],
            ["consumed_sqm", [ew.Validators.float], fields.consumed_sqm.isInvalid],
            ["consumed_status", [], fields.consumed_status.isInvalid],
            ["category", [], fields.category.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "consumed_status": <?= $Page->consumed_status->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fstock_onlinesearch" id="fstock_onlinesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stock_online">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_online_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="stock_online" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location" class="row"<?= $Page->location->rowAttributes() ?>>
        <label for="x_location" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online_location"><?= $Page->location->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_location" id="z_location" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->location->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_online_location" class="ew-search-field ew-search-field-single">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fstock_onlinesearch_x_location"
        <?php } ?>
        data-table="stock_online"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage(false) ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_onlinesearch", function() {
    var options = { name: "x_location", selectId: "fstock_onlinesearch_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_onlinesearch.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fstock_onlinesearch" };
    } else {
        options.ajax = { id: "x_location", form: "fstock_onlinesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_online.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online__barcode"><?= $Page->_barcode->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z__barcode" id="z__barcode" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->_barcode->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->_barcode->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_stock_online__barcode" class="ew-search-field">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="stock_online" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_stock_online__barcode" class="ew-search-field2 d-none">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="y__barcode" id="y__barcode" data-table="stock_online" data-field="x__barcode" value="<?= $Page->_barcode->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id" class="row"<?= $Page->design_id->rowAttributes() ?>>
        <label for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online_design_id"><?= $Page->design_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_design_id" id="z_design_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_online_design_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-select ew-select<?= $Page->design_id->isInvalidClass() ?>"
        <?php if (!$Page->design_id->IsNativeSelect) { ?>
        data-select2-id="fstock_onlinesearch_x_design_id"
        <?php } ?>
        data-table="stock_online"
        data-field="x_design_id"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage(false) ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<?php if (!$Page->design_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_onlinesearch", function() {
    var options = { name: "x_design_id", selectId: "fstock_onlinesearch_x_design_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_onlinesearch.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fstock_onlinesearch" };
    } else {
        options.ajax = { id: "x_design_id", form: "fstock_onlinesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_online.fields.design_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm" class="row"<?= $Page->sqm->rowAttributes() ?>>
        <label for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online_sqm"><?= $Page->sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_sqm" id="z_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_online_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="stock_online" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Remarks->Visible) { // Remarks ?>
    <div id="r_Remarks" class="row"<?= $Page->Remarks->rowAttributes() ?>>
        <label for="x_Remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online_Remarks"><?= $Page->Remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Remarks" id="z_Remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_online_Remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Remarks->getInputTextType() ?>" name="x_Remarks" id="x_Remarks" data-table="stock_online" data-field="x_Remarks" value="<?= $Page->Remarks->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->Remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Remarks->formatPattern()) ?>"<?= $Page->Remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->last_remarks->Visible) { // last_remarks ?>
    <div id="r_last_remarks" class="row"<?= $Page->last_remarks->rowAttributes() ?>>
        <label for="x_last_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online_last_remarks"><?= $Page->last_remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_last_remarks" id="z_last_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->last_remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_online_last_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->last_remarks->getInputTextType() ?>" name="x_last_remarks" id="x_last_remarks" data-table="stock_online" data-field="x_last_remarks" value="<?= $Page->last_remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->last_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->last_remarks->formatPattern()) ?>"<?= $Page->last_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->last_remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_online_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fstock_onlinesearch_x_status"
        <?php } ?>
        data-table="stock_online"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_onlinesearch", function() {
    var options = { name: "x_status", selectId: "fstock_onlinesearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_onlinesearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fstock_onlinesearch" };
    } else {
        options.ajax = { id: "x_status", form: "fstock_onlinesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_online.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->consumed_by->Visible) { // consumed_by ?>
    <div id="r_consumed_by" class="row"<?= $Page->consumed_by->rowAttributes() ?>>
        <label for="x_consumed_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online_consumed_by"><?= $Page->consumed_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_consumed_by" id="z_consumed_by" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->consumed_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_online_consumed_by" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->consumed_by->getInputTextType() ?>" name="x_consumed_by" id="x_consumed_by" data-table="stock_online" data-field="x_consumed_by" value="<?= $Page->consumed_by->EditValue ?>" size="30" maxlength="19" placeholder="<?= HtmlEncode($Page->consumed_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->consumed_by->formatPattern()) ?>"<?= $Page->consumed_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->consumed_by->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->consumed_sqm->Visible) { // consumed_sqm ?>
    <div id="r_consumed_sqm" class="row"<?= $Page->consumed_sqm->rowAttributes() ?>>
        <label for="x_consumed_sqm" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online_consumed_sqm"><?= $Page->consumed_sqm->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_consumed_sqm" id="z_consumed_sqm" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->consumed_sqm->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_online_consumed_sqm" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->consumed_sqm->getInputTextType() ?>" name="x_consumed_sqm" id="x_consumed_sqm" data-table="stock_online" data-field="x_consumed_sqm" value="<?= $Page->consumed_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->consumed_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->consumed_sqm->formatPattern()) ?>"<?= $Page->consumed_sqm->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->consumed_sqm->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->consumed_status->Visible) { // consumed_status ?>
    <div id="r_consumed_status" class="row"<?= $Page->consumed_status->rowAttributes() ?>>
        <label for="x_consumed_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online_consumed_status"><?= $Page->consumed_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_consumed_status" id="z_consumed_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->consumed_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_online_consumed_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_consumed_status"
        name="x_consumed_status"
        class="form-select ew-select<?= $Page->consumed_status->isInvalidClass() ?>"
        <?php if (!$Page->consumed_status->IsNativeSelect) { ?>
        data-select2-id="fstock_onlinesearch_x_consumed_status"
        <?php } ?>
        data-table="stock_online"
        data-field="x_consumed_status"
        data-value-separator="<?= $Page->consumed_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->consumed_status->getPlaceHolder()) ?>"
        <?= $Page->consumed_status->editAttributes() ?>>
        <?= $Page->consumed_status->selectOptionListHtml("x_consumed_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->consumed_status->getErrorMessage(false) ?></div>
<?php if (!$Page->consumed_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_onlinesearch", function() {
    var options = { name: "x_consumed_status", selectId: "fstock_onlinesearch_x_consumed_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_onlinesearch.lists.consumed_status?.lookupOptions.length) {
        options.data = { id: "x_consumed_status", form: "fstock_onlinesearch" };
    } else {
        options.ajax = { id: "x_consumed_status", form: "fstock_onlinesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_online.fields.consumed_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_online_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_category" id="z_category" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_online_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fstock_onlinesearch_x_category"
        <?php } ?>
        data-table="stock_online"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?= $Page->category->Lookup->getParamTag($Page, "p_x_category") ?>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_onlinesearch", function() {
    var options = { name: "x_category", selectId: "fstock_onlinesearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_onlinesearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fstock_onlinesearch" };
    } else {
        options.ajax = { id: "x_category", form: "fstock_onlinesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_online.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fstock_onlinesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fstock_onlinesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fstock_onlinesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stock_online");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
