<?php

namespace PHPMaker2024\fibre;

// Page object
$StockLcgpSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stock_lcgp: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fstock_lcgpsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fstock_lcgpsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["grp", [], fields.grp.isInvalid],
            ["product", [], fields.product.isInvalid],
            ["product_code", [], fields.product_code.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["godown_n", [], fields.godown_n.isInvalid],
            ["IN", [ew.Validators.float], fields.IN.isInvalid],
            ["OUT", [ew.Validators.float], fields.OUT.isInvalid],
            ["Balance", [ew.Validators.float], fields.Balance.isInvalid],
            ["y_Balance", [ew.Validators.between], false],
            ["packets", [ew.Validators.float], fields.packets.isInvalid],
            ["packing_type_n", [], fields.packing_type_n.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["packing_type", [ew.Validators.integer], fields.packing_type.isInvalid],
            ["url", [], fields.url.isInvalid],
            ["HOLD", [ew.Validators.float], fields.HOLD.isInvalid],
            ["avg_quantity", [ew.Validators.float], fields.avg_quantity.isInvalid],
            ["age", [ew.Validators.integer], fields.age.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["s_grp", [], fields.s_grp.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fstock_lcgpsearch" id="fstock_lcgpsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stock_lcgp">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->grp->Visible) { // grp ?>
    <div id="r_grp" class="row"<?= $Page->grp->rowAttributes() ?>>
        <label for="x_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_grp"><?= $Page->grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_grp" id="z_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_grp"
        name="x_grp"
        class="form-select ew-select<?= $Page->grp->isInvalidClass() ?>"
        <?php if (!$Page->grp->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpsearch_x_grp"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_grp"
        data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
        <?= $Page->grp->editAttributes() ?>>
        <?= $Page->grp->selectOptionListHtml("x_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
<?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
<?php if (!$Page->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpsearch", function() {
    var options = { name: "x_grp", selectId: "fstock_lcgpsearch_x_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpsearch.lists.grp?.lookupOptions.length) {
        options.data = { id: "x_grp", form: "fstock_lcgpsearch" };
    } else {
        options.ajax = { id: "x_grp", form: "fstock_lcgpsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpsearch_x_product"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpsearch", function() {
    var options = { name: "x_product", selectId: "fstock_lcgpsearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpsearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fstock_lcgpsearch" };
    } else {
        options.ajax = { id: "x_product", form: "fstock_lcgpsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
    <div id="r_product_code" class="row"<?= $Page->product_code->rowAttributes() ?>>
        <label for="x_product_code" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_product_code"><?= $Page->product_code->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_code" id="z_product_code" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_code->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_product_code" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->product_code->getInputTextType() ?>" name="x_product_code" id="x_product_code" data-table="stock_lcgp" data-field="x_product_code" value="<?= $Page->product_code->EditValue ?>" size="30" maxlength="311" placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->product_code->formatPattern()) ?>"<?= $Page->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label for="x_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpsearch_x_godown"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpsearch", function() {
    var options = { name: "x_godown", selectId: "fstock_lcgpsearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpsearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fstock_lcgpsearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fstock_lcgpsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown_n->Visible) { // godown_n ?>
    <div id="r_godown_n" class="row"<?= $Page->godown_n->rowAttributes() ?>>
        <label for="x_godown_n" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_godown_n"><?= $Page->godown_n->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_godown_n" id="z_godown_n" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown_n->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_godown_n" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->godown_n->getInputTextType() ?>" name="x_godown_n" id="x_godown_n" data-table="stock_lcgp" data-field="x_godown_n" value="<?= $Page->godown_n->EditValue ?>" size="30" maxlength="3" placeholder="<?= HtmlEncode($Page->godown_n->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->godown_n->formatPattern()) ?>"<?= $Page->godown_n->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->godown_n->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->IN->Visible) { // IN ?>
    <div id="r_IN" class="row"<?= $Page->IN->rowAttributes() ?>>
        <label for="x_IN" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_IN"><?= $Page->IN->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_IN" id="z_IN" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->IN->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_IN" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->IN->getInputTextType() ?>" name="x_IN" id="x_IN" data-table="stock_lcgp" data-field="x_IN" value="<?= $Page->IN->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->IN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->IN->formatPattern()) ?>"<?= $Page->IN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->IN->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->OUT->Visible) { // OUT ?>
    <div id="r_OUT" class="row"<?= $Page->OUT->rowAttributes() ?>>
        <label for="x_OUT" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_OUT"><?= $Page->OUT->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_OUT" id="z_OUT" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->OUT->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_OUT" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->OUT->getInputTextType() ?>" name="x_OUT" id="x_OUT" data-table="stock_lcgp" data-field="x_OUT" value="<?= $Page->OUT->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->OUT->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OUT->formatPattern()) ?>"<?= $Page->OUT->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->OUT->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
    <div id="r_Balance" class="row"<?= $Page->Balance->rowAttributes() ?>>
        <label for="x_Balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_Balance"><?= $Page->Balance->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Balance" id="z_Balance" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Balance->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Balance->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_stock_lcgp_Balance" class="ew-search-field">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="x_Balance" id="x_Balance" data-table="stock_lcgp" data-field="x_Balance" value="<?= $Page->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_stock_lcgp_Balance" class="ew-search-field2 d-none">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="y_Balance" id="y_Balance" data-table="stock_lcgp" data-field="x_Balance" value="<?= $Page->Balance->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_packets"><?= $Page->packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets" id="z_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="stock_lcgp" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type_n->Visible) { // packing_type_n ?>
    <div id="r_packing_type_n" class="row"<?= $Page->packing_type_n->rowAttributes() ?>>
        <label for="x_packing_type_n" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_packing_type_n"><?= $Page->packing_type_n->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_packing_type_n" id="z_packing_type_n" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type_n->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_packing_type_n" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packing_type_n->getInputTextType() ?>" name="x_packing_type_n" id="x_packing_type_n" data-table="stock_lcgp" data-field="x_packing_type_n" value="<?= $Page->packing_type_n->EditValue ?>" size="30" maxlength="54" placeholder="<?= HtmlEncode($Page->packing_type_n->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packing_type_n->formatPattern()) ?>"<?= $Page->packing_type_n->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packing_type_n->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="stock_lcgp" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_packing_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packing_type->getInputTextType() ?>" name="x_packing_type" id="x_packing_type" data-table="stock_lcgp" data-field="x_packing_type" value="<?= $Page->packing_type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packing_type->formatPattern()) ?>"<?= $Page->packing_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url" class="row"<?= $Page->url->rowAttributes() ?>>
        <label for="x_url" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_url"><?= $Page->url->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_url" id="z_url" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->url->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_url" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="stock_lcgp" data-field="x_url" value="<?= $Page->url->EditValue ?>" size="30" maxlength="409" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->HOLD->Visible) { // HOLD ?>
    <div id="r_HOLD" class="row"<?= $Page->HOLD->rowAttributes() ?>>
        <label for="x_HOLD" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_HOLD"><?= $Page->HOLD->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_HOLD" id="z_HOLD" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->HOLD->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_HOLD" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->HOLD->getInputTextType() ?>" name="x_HOLD" id="x_HOLD" data-table="stock_lcgp" data-field="x_HOLD" value="<?= $Page->HOLD->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->HOLD->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->HOLD->formatPattern()) ?>"<?= $Page->HOLD->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->HOLD->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->avg_quantity->Visible) { // avg_quantity ?>
    <div id="r_avg_quantity" class="row"<?= $Page->avg_quantity->rowAttributes() ?>>
        <label for="x_avg_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_avg_quantity"><?= $Page->avg_quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_avg_quantity" id="z_avg_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->avg_quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_avg_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->avg_quantity->getInputTextType() ?>" name="x_avg_quantity" id="x_avg_quantity" data-table="stock_lcgp" data-field="x_avg_quantity" value="<?= $Page->avg_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->avg_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->avg_quantity->formatPattern()) ?>"<?= $Page->avg_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->avg_quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->age->Visible) { // age ?>
    <div id="r_age" class="row"<?= $Page->age->rowAttributes() ?>>
        <label for="x_age" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_age"><?= $Page->age->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_age" id="z_age" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->age->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_age" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->age->getInputTextType() ?>" name="x_age" id="x_age" data-table="stock_lcgp" data-field="x_age" value="<?= $Page->age->EditValue ?>" size="30" maxlength="11" placeholder="<?= HtmlEncode($Page->age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->age->formatPattern()) ?>"<?= $Page->age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->age->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpsearch_x_company_id"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpsearch", function() {
    var options = { name: "x_company_id", selectId: "fstock_lcgpsearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpsearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "fstock_lcgpsearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "fstock_lcgpsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
    <div id="r_s_grp" class="row"<?= $Page->s_grp->rowAttributes() ?>>
        <label for="x_s_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_lcgp_s_grp"><?= $Page->s_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_grp" id="z_s_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_lcgp_s_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_grp"
        name="x_s_grp"
        class="form-select ew-select<?= $Page->s_grp->isInvalidClass() ?>"
        <?php if (!$Page->s_grp->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpsearch_x_s_grp"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_s_grp"
        data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
        <?= $Page->s_grp->editAttributes() ?>>
        <?= $Page->s_grp->selectOptionListHtml("x_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
<?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
<?php if (!$Page->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpsearch", function() {
    var options = { name: "x_s_grp", selectId: "fstock_lcgpsearch_x_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpsearch.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x_s_grp", form: "fstock_lcgpsearch" };
    } else {
        options.ajax = { id: "x_s_grp", form: "fstock_lcgpsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fstock_lcgpsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fstock_lcgpsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fstock_lcgpsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stock_lcgp");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
