<?php

namespace PHPMaker2024\fibre;

// Page object
$StockLcgpList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stock_lcgp: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "product_code": <?= $Page->product_code->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "packing_type_n": <?= $Page->packing_type_n->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "required_material_compiled") {
    if ($Page->MasterRecordExists) {
        include_once "views/RequiredMaterialCompiledMaster.php";
    }
}
?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "required_material_compiled_live") {
    if ($Page->MasterRecordExists) {
        include_once "views/RequiredMaterialCompiledLiveMaster.php";
    }
}
?>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fstock_lcgpsrch" id="fstock_lcgpsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fstock_lcgpsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stock_lcgp: currentTable } });
var currentForm;
var fstock_lcgpsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fstock_lcgpsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["lot_no", [], fields.lot_no.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "grp": <?= $Page->grp->toClientList($Page) ?>,
            "product": <?= $Page->product->toClientList($Page) ?>,
            "product_code": <?= $Page->product_code->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
            "packing_type_n": <?= $Page->packing_type_n->toClientList($Page) ?>,
            "s_grp": <?= $Page->s_grp->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->rid->Visible) { // rid ?>
<?php
if (!$Page->rid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_rid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->rid->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_rid"
            name="x_rid[]"
            class="form-control ew-select<?= $Page->rid->isInvalidClass() ?>"
            data-select2-id="fstock_lcgpsrch_x_rid"
            data-table="stock_lcgp"
            data-field="x_rid"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->rid->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->rid->editAttributes() ?>>
            <?= $Page->rid->selectOptionListHtml("x_rid", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fstock_lcgpsrch", function() {
            var options = {
                name: "x_rid",
                selectId: "fstock_lcgpsrch_x_rid",
                ajax: { id: "x_rid", form: "fstock_lcgpsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.stock_lcgp.fields.rid.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
<?php
if (!$Page->grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->grp->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_grp"
            name="x_grp[]"
            class="form-control ew-select<?= $Page->grp->isInvalidClass() ?>"
            data-select2-id="fstock_lcgpsrch_x_grp"
            data-table="stock_lcgp"
            data-field="x_grp"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->grp->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->grp->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->grp->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->grp->editAttributes() ?>>
            <?= $Page->grp->selectOptionListHtml("x_grp", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->grp->getErrorMessage(false) ?></div>
        <?= $Page->grp->Lookup->getParamTag($Page, "p_x_grp") ?>
        <script>
        loadjs.ready("fstock_lcgpsrch", function() {
            var options = {
                name: "x_grp",
                selectId: "fstock_lcgpsrch_x_grp",
                ajax: { id: "x_grp", form: "fstock_lcgpsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.stock_lcgp.fields.grp.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
<?php
if (!$Page->product->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_product"
            name="x_product[]"
            class="form-control ew-select<?= $Page->product->isInvalidClass() ?>"
            data-select2-id="fstock_lcgpsrch_x_product"
            data-table="stock_lcgp"
            data-field="x_product"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->product->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->product->editAttributes() ?>>
            <?= $Page->product->selectOptionListHtml("x_product", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fstock_lcgpsrch", function() {
            var options = {
                name: "x_product",
                selectId: "fstock_lcgpsrch_x_product",
                ajax: { id: "x_product", form: "fstock_lcgpsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.stock_lcgp.fields.product.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
<?php
if (!$Page->product_code->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_product_code" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->product_code->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_product_code"
            name="x_product_code[]"
            class="form-control ew-select<?= $Page->product_code->isInvalidClass() ?>"
            data-select2-id="fstock_lcgpsrch_x_product_code"
            data-table="stock_lcgp"
            data-field="x_product_code"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->product_code->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->product_code->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->product_code->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->product_code->editAttributes() ?>>
            <?= $Page->product_code->selectOptionListHtml("x_product_code", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->product_code->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fstock_lcgpsrch", function() {
            var options = {
                name: "x_product_code",
                selectId: "fstock_lcgpsrch_x_product_code",
                ajax: { id: "x_product_code", form: "fstock_lcgpsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.stock_lcgp.fields.product_code.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
<?php
if (!$Page->godown->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_godown" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->godown->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_godown"
            name="x_godown[]"
            class="form-control ew-select<?= $Page->godown->isInvalidClass() ?>"
            data-select2-id="fstock_lcgpsrch_x_godown"
            data-table="stock_lcgp"
            data-field="x_godown"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->godown->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->godown->editAttributes() ?>>
            <?= $Page->godown->selectOptionListHtml("x_godown", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
        <?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
        <script>
        loadjs.ready("fstock_lcgpsrch", function() {
            var options = {
                name: "x_godown",
                selectId: "fstock_lcgpsrch_x_godown",
                ajax: { id: "x_godown", form: "fstock_lcgpsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.stock_lcgp.fields.godown.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->packing_type_n->Visible) { // packing_type_n ?>
<?php
if (!$Page->packing_type_n->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_packing_type_n" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->packing_type_n->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_packing_type_n"
            name="x_packing_type_n[]"
            class="form-control ew-select<?= $Page->packing_type_n->isInvalidClass() ?>"
            data-select2-id="fstock_lcgpsrch_x_packing_type_n"
            data-table="stock_lcgp"
            data-field="x_packing_type_n"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->packing_type_n->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->packing_type_n->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->packing_type_n->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->packing_type_n->editAttributes() ?>>
            <?= $Page->packing_type_n->selectOptionListHtml("x_packing_type_n", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->packing_type_n->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fstock_lcgpsrch", function() {
            var options = {
                name: "x_packing_type_n",
                selectId: "fstock_lcgpsrch_x_packing_type_n",
                ajax: { id: "x_packing_type_n", form: "fstock_lcgpsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.stock_lcgp.fields.packing_type_n.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
<?php
if (!$Page->lot_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_lot_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->lot_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_lot_no" class="ew-search-caption ew-label"><?= $Page->lot_no->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE">
</div>
        </div>
        <div id="el_stock_lcgp_lot_no" class="ew-search-field">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="stock_lcgp" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
<?php
if (!$Page->s_grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_s_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->s_grp->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_s_grp"
            name="x_s_grp[]"
            class="form-control ew-select<?= $Page->s_grp->isInvalidClass() ?>"
            data-select2-id="fstock_lcgpsrch_x_s_grp"
            data-table="stock_lcgp"
            data-field="x_s_grp"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->s_grp->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->s_grp->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->s_grp->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->s_grp->editAttributes() ?>>
            <?= $Page->s_grp->selectOptionListHtml("x_s_grp", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->s_grp->getErrorMessage(false) ?></div>
        <?= $Page->s_grp->Lookup->getParamTag($Page, "p_x_s_grp") ?>
        <script>
        loadjs.ready("fstock_lcgpsrch", function() {
            var options = {
                name: "x_s_grp",
                selectId: "fstock_lcgpsrch_x_s_grp",
                ajax: { id: "x_s_grp", form: "fstock_lcgpsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.stock_lcgp.fields.s_grp.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fstock_lcgpsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fstock_lcgpsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fstock_lcgpsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fstock_lcgpsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fstock_lcgpsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fstock_lcgpsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fstock_lcgpsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stock_lcgp">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "required_material_compiled" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="required_material_compiled">
<input type="hidden" name="fk_req_material_rid" value="<?= HtmlEncode($Page->rid->getSessionValue()) ?>">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "required_material_compiled_live" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="required_material_compiled_live">
<input type="hidden" name="fk_req_material_rid" value="<?= HtmlEncode($Page->rid->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_stock_lcgp" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_stock_lcgplist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Page->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_stock_lcgp_rid" class="stock_lcgp_rid"><?= $Page->renderFieldHeader($Page->rid) ?></div></th>
<?php } ?>
<?php if ($Page->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Page->grp->headerCellClass() ?>"><div id="elh_stock_lcgp_grp" class="stock_lcgp_grp"><?= $Page->renderFieldHeader($Page->grp) ?></div></th>
<?php } ?>
<?php if ($Page->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Page->product->headerCellClass() ?>"><div id="elh_stock_lcgp_product" class="stock_lcgp_product"><?= $Page->renderFieldHeader($Page->product) ?></div></th>
<?php } ?>
<?php if ($Page->product_code->Visible) { // product_code ?>
        <th data-name="product_code" class="<?= $Page->product_code->headerCellClass() ?>"><div id="elh_stock_lcgp_product_code" class="stock_lcgp_product_code"><?= $Page->renderFieldHeader($Page->product_code) ?></div></th>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
        <th data-name="godown" class="<?= $Page->godown->headerCellClass() ?>"><div id="elh_stock_lcgp_godown" class="stock_lcgp_godown"><?= $Page->renderFieldHeader($Page->godown) ?></div></th>
<?php } ?>
<?php if ($Page->IN->Visible) { // IN ?>
        <th data-name="IN" class="<?= $Page->IN->headerCellClass() ?>"><div id="elh_stock_lcgp_IN" class="stock_lcgp_IN"><?= $Page->renderFieldHeader($Page->IN) ?></div></th>
<?php } ?>
<?php if ($Page->OUT->Visible) { // OUT ?>
        <th data-name="OUT" class="<?= $Page->OUT->headerCellClass() ?>"><div id="elh_stock_lcgp_OUT" class="stock_lcgp_OUT"><?= $Page->renderFieldHeader($Page->OUT) ?></div></th>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
        <th data-name="Balance" class="<?= $Page->Balance->headerCellClass() ?>"><div id="elh_stock_lcgp_Balance" class="stock_lcgp_Balance"><?= $Page->renderFieldHeader($Page->Balance) ?></div></th>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
        <th data-name="packets" class="<?= $Page->packets->headerCellClass() ?>"><div id="elh_stock_lcgp_packets" class="stock_lcgp_packets"><?= $Page->renderFieldHeader($Page->packets) ?></div></th>
<?php } ?>
<?php if ($Page->packing_type_n->Visible) { // packing_type_n ?>
        <th data-name="packing_type_n" class="<?= $Page->packing_type_n->headerCellClass() ?>"><div id="elh_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n"><?= $Page->renderFieldHeader($Page->packing_type_n) ?></div></th>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
        <th data-name="lot_no" class="<?= $Page->lot_no->headerCellClass() ?>"><div id="elh_stock_lcgp_lot_no" class="stock_lcgp_lot_no"><?= $Page->renderFieldHeader($Page->lot_no) ?></div></th>
<?php } ?>
<?php if ($Page->HOLD->Visible) { // HOLD ?>
        <th data-name="HOLD" class="<?= $Page->HOLD->headerCellClass() ?>"><div id="elh_stock_lcgp_HOLD" class="stock_lcgp_HOLD"><?= $Page->renderFieldHeader($Page->HOLD) ?></div></th>
<?php } ?>
<?php if ($Page->age->Visible) { // age ?>
        <th data-name="age" class="<?= $Page->age->headerCellClass() ?>"><div id="elh_stock_lcgp_age" class="stock_lcgp_age"><?= $Page->renderFieldHeader($Page->age) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_stock_lcgp_company_id" class="stock_lcgp_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Page->s_grp->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_stock_lcgp_s_grp" class="stock_lcgp_s_grp"><?= $Page->renderFieldHeader($Page->s_grp) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Page->rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_rid" class="el_stock_lcgp_rid">
<span<?= $Page->rid->viewAttributes() ?>>
<?= $Page->rid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Page->grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_grp" class="el_stock_lcgp_grp">
<span<?= $Page->grp->viewAttributes() ?>>
<?php if (!EmptyString($Page->grp->getViewValue()) && $Page->grp->linkAttributes() != "") { ?>
<a<?= $Page->grp->linkAttributes() ?>><?= $Page->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product"<?= $Page->product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_product" class="el_stock_lcgp_product">
<span<?= $Page->product->viewAttributes() ?>>
<?php if (!EmptyString($Page->product->getViewValue()) && $Page->product->linkAttributes() != "") { ?>
<a<?= $Page->product->linkAttributes() ?>><?= $Page->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->product_code->Visible) { // product_code ?>
        <td data-name="product_code"<?= $Page->product_code->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_product_code" class="el_stock_lcgp_product_code">
<span<?= $Page->product_code->viewAttributes() ?>>
<?php if (!EmptyString($Page->product_code->getViewValue()) && $Page->product_code->linkAttributes() != "") { ?>
<a<?= $Page->product_code->linkAttributes() ?>><?= $Page->product_code->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown"<?= $Page->godown->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_godown" class="el_stock_lcgp_godown">
<span<?= $Page->godown->viewAttributes() ?>>
<?= $Page->godown->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->IN->Visible) { // IN ?>
        <td data-name="IN"<?= $Page->IN->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_IN" class="el_stock_lcgp_IN">
<span<?= $Page->IN->viewAttributes() ?>>
<?= $Page->IN->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->OUT->Visible) { // OUT ?>
        <td data-name="OUT"<?= $Page->OUT->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_OUT" class="el_stock_lcgp_OUT">
<span<?= $Page->OUT->viewAttributes() ?>>
<?= $Page->OUT->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Balance->Visible) { // Balance ?>
        <td data-name="Balance"<?= $Page->Balance->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_Balance" class="el_stock_lcgp_Balance">
<span<?= $Page->Balance->viewAttributes() ?>>
<?php if (!EmptyString($Page->Balance->getViewValue()) && $Page->Balance->linkAttributes() != "") { ?>
<a<?= $Page->Balance->linkAttributes() ?>><?= $Page->Balance->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->Balance->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packets->Visible) { // packets ?>
        <td data-name="packets"<?= $Page->packets->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_packets" class="el_stock_lcgp_packets">
<span<?= $Page->packets->viewAttributes() ?>>
<?= $Page->packets->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->packing_type_n->Visible) { // packing_type_n ?>
        <td data-name="packing_type_n"<?= $Page->packing_type_n->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_packing_type_n" class="el_stock_lcgp_packing_type_n">
<span<?= $Page->packing_type_n->viewAttributes() ?>>
<?= $Page->packing_type_n->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no"<?= $Page->lot_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_lot_no" class="el_stock_lcgp_lot_no">
<span<?= $Page->lot_no->viewAttributes() ?>>
<?= $Page->lot_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->HOLD->Visible) { // HOLD ?>
        <td data-name="HOLD"<?= $Page->HOLD->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_HOLD" class="el_stock_lcgp_HOLD">
<span<?= $Page->HOLD->viewAttributes() ?>>
<?= $Page->HOLD->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->age->Visible) { // age ?>
        <td data-name="age"<?= $Page->age->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_age" class="el_stock_lcgp_age">
<span<?= $Page->age->viewAttributes() ?>>
<?= $Page->age->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_company_id" class="el_stock_lcgp_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Page->s_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_stock_lcgp_s_grp" class="el_stock_lcgp_s_grp">
<span<?= $Page->s_grp->viewAttributes() ?>>
<?= $Page->s_grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->rid->Visible) { // rid ?>
        <td data-name="rid" class="<?= $Page->rid->footerCellClass() ?>"><span id="elf_stock_lcgp_rid" class="stock_lcgp_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->grp->Visible) { // grp ?>
        <td data-name="grp" class="<?= $Page->grp->footerCellClass() ?>"><span id="elf_stock_lcgp_grp" class="stock_lcgp_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->product->Visible) { // product ?>
        <td data-name="product" class="<?= $Page->product->footerCellClass() ?>"><span id="elf_stock_lcgp_product" class="stock_lcgp_product">
        </span></td>
    <?php } ?>
    <?php if ($Page->product_code->Visible) { // product_code ?>
        <td data-name="product_code" class="<?= $Page->product_code->footerCellClass() ?>"><span id="elf_stock_lcgp_product_code" class="stock_lcgp_product_code">
        </span></td>
    <?php } ?>
    <?php if ($Page->godown->Visible) { // godown ?>
        <td data-name="godown" class="<?= $Page->godown->footerCellClass() ?>"><span id="elf_stock_lcgp_godown" class="stock_lcgp_godown">
        </span></td>
    <?php } ?>
    <?php if ($Page->IN->Visible) { // IN ?>
        <td data-name="IN" class="<?= $Page->IN->footerCellClass() ?>"><span id="elf_stock_lcgp_IN" class="stock_lcgp_IN">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->IN->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->OUT->Visible) { // OUT ?>
        <td data-name="OUT" class="<?= $Page->OUT->footerCellClass() ?>"><span id="elf_stock_lcgp_OUT" class="stock_lcgp_OUT">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->OUT->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->Balance->Visible) { // Balance ?>
        <td data-name="Balance" class="<?= $Page->Balance->footerCellClass() ?>"><span id="elf_stock_lcgp_Balance" class="stock_lcgp_Balance">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Page->Balance->ViewValue) && $Page->Balance->linkAttributes() != "") { ?>
        <a<?= $Page->Balance->linkAttributes() ?>><?= $Page->Balance->ViewValue ?></a>
        <?php } else { ?>
        <?= $Page->Balance->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Page->packets->Visible) { // packets ?>
        <td data-name="packets" class="<?= $Page->packets->footerCellClass() ?>"><span id="elf_stock_lcgp_packets" class="stock_lcgp_packets">
        </span></td>
    <?php } ?>
    <?php if ($Page->packing_type_n->Visible) { // packing_type_n ?>
        <td data-name="packing_type_n" class="<?= $Page->packing_type_n->footerCellClass() ?>"><span id="elf_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n">
        </span></td>
    <?php } ?>
    <?php if ($Page->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no" class="<?= $Page->lot_no->footerCellClass() ?>"><span id="elf_stock_lcgp_lot_no" class="stock_lcgp_lot_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->HOLD->Visible) { // HOLD ?>
        <td data-name="HOLD" class="<?= $Page->HOLD->footerCellClass() ?>"><span id="elf_stock_lcgp_HOLD" class="stock_lcgp_HOLD">
        </span></td>
    <?php } ?>
    <?php if ($Page->age->Visible) { // age ?>
        <td data-name="age" class="<?= $Page->age->footerCellClass() ?>"><span id="elf_stock_lcgp_age" class="stock_lcgp_age">
        </span></td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id" class="<?= $Page->company_id->footerCellClass() ?>"><span id="elf_stock_lcgp_company_id" class="stock_lcgp_company_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp" class="<?= $Page->s_grp->footerCellClass() ?>"><span id="elf_stock_lcgp_s_grp" class="stock_lcgp_s_grp">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stock_lcgp");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
