<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("StockLcgpGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fstock_lcgpgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { stock_lcgp: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fstock_lcgpgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["rid", [fields.rid.visible && fields.rid.required ? ew.Validators.required(fields.rid.caption) : null, ew.Validators.integer], fields.rid.isInvalid],
            ["grp", [fields.grp.visible && fields.grp.required ? ew.Validators.required(fields.grp.caption) : null], fields.grp.isInvalid],
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["product_code", [fields.product_code.visible && fields.product_code.required ? ew.Validators.required(fields.product_code.caption) : null], fields.product_code.isInvalid],
            ["godown", [fields.godown.visible && fields.godown.required ? ew.Validators.required(fields.godown.caption) : null], fields.godown.isInvalid],
            ["IN", [fields.IN.visible && fields.IN.required ? ew.Validators.required(fields.IN.caption) : null, ew.Validators.float], fields.IN.isInvalid],
            ["OUT", [fields.OUT.visible && fields.OUT.required ? ew.Validators.required(fields.OUT.caption) : null, ew.Validators.float], fields.OUT.isInvalid],
            ["Balance", [fields.Balance.visible && fields.Balance.required ? ew.Validators.required(fields.Balance.caption) : null, ew.Validators.float], fields.Balance.isInvalid],
            ["packets", [fields.packets.visible && fields.packets.required ? ew.Validators.required(fields.packets.caption) : null, ew.Validators.float], fields.packets.isInvalid],
            ["packing_type_n", [fields.packing_type_n.visible && fields.packing_type_n.required ? ew.Validators.required(fields.packing_type_n.caption) : null], fields.packing_type_n.isInvalid],
            ["lot_no", [fields.lot_no.visible && fields.lot_no.required ? ew.Validators.required(fields.lot_no.caption) : null], fields.lot_no.isInvalid],
            ["HOLD", [fields.HOLD.visible && fields.HOLD.required ? ew.Validators.required(fields.HOLD.caption) : null, ew.Validators.float], fields.HOLD.isInvalid],
            ["age", [fields.age.visible && fields.age.required ? ew.Validators.required(fields.age.caption) : null, ew.Validators.integer], fields.age.isInvalid],
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null], fields.company_id.isInvalid],
            ["s_grp", [fields.s_grp.visible && fields.s_grp.required ? ew.Validators.required(fields.s_grp.caption) : null], fields.s_grp.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["rid",false],["grp",false],["product",false],["product_code",false],["godown",false],["IN",false],["OUT",false],["Balance",false],["packets",false],["packing_type_n",false],["lot_no",false],["HOLD",false],["age",false],["company_id",false],["s_grp",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "grp": <?= $Grid->grp->toClientList($Grid) ?>,
            "product": <?= $Grid->product->toClientList($Grid) ?>,
            "godown": <?= $Grid->godown->toClientList($Grid) ?>,
            "company_id": <?= $Grid->company_id->toClientList($Grid) ?>,
            "s_grp": <?= $Grid->s_grp->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fstock_lcgpgrid" class="ew-form ew-list-form">
<div id="gmp_stock_lcgp" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_stock_lcgpgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->rid->Visible) { // rid ?>
        <th data-name="rid" class="<?= $Grid->rid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_stock_lcgp_rid" class="stock_lcgp_rid"><?= $Grid->renderFieldHeader($Grid->rid) ?></div></th>
<?php } ?>
<?php if ($Grid->grp->Visible) { // grp ?>
        <th data-name="grp" class="<?= $Grid->grp->headerCellClass() ?>"><div id="elh_stock_lcgp_grp" class="stock_lcgp_grp"><?= $Grid->renderFieldHeader($Grid->grp) ?></div></th>
<?php } ?>
<?php if ($Grid->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Grid->product->headerCellClass() ?>"><div id="elh_stock_lcgp_product" class="stock_lcgp_product"><?= $Grid->renderFieldHeader($Grid->product) ?></div></th>
<?php } ?>
<?php if ($Grid->product_code->Visible) { // product_code ?>
        <th data-name="product_code" class="<?= $Grid->product_code->headerCellClass() ?>"><div id="elh_stock_lcgp_product_code" class="stock_lcgp_product_code"><?= $Grid->renderFieldHeader($Grid->product_code) ?></div></th>
<?php } ?>
<?php if ($Grid->godown->Visible) { // godown ?>
        <th data-name="godown" class="<?= $Grid->godown->headerCellClass() ?>"><div id="elh_stock_lcgp_godown" class="stock_lcgp_godown"><?= $Grid->renderFieldHeader($Grid->godown) ?></div></th>
<?php } ?>
<?php if ($Grid->IN->Visible) { // IN ?>
        <th data-name="IN" class="<?= $Grid->IN->headerCellClass() ?>"><div id="elh_stock_lcgp_IN" class="stock_lcgp_IN"><?= $Grid->renderFieldHeader($Grid->IN) ?></div></th>
<?php } ?>
<?php if ($Grid->OUT->Visible) { // OUT ?>
        <th data-name="OUT" class="<?= $Grid->OUT->headerCellClass() ?>"><div id="elh_stock_lcgp_OUT" class="stock_lcgp_OUT"><?= $Grid->renderFieldHeader($Grid->OUT) ?></div></th>
<?php } ?>
<?php if ($Grid->Balance->Visible) { // Balance ?>
        <th data-name="Balance" class="<?= $Grid->Balance->headerCellClass() ?>"><div id="elh_stock_lcgp_Balance" class="stock_lcgp_Balance"><?= $Grid->renderFieldHeader($Grid->Balance) ?></div></th>
<?php } ?>
<?php if ($Grid->packets->Visible) { // packets ?>
        <th data-name="packets" class="<?= $Grid->packets->headerCellClass() ?>"><div id="elh_stock_lcgp_packets" class="stock_lcgp_packets"><?= $Grid->renderFieldHeader($Grid->packets) ?></div></th>
<?php } ?>
<?php if ($Grid->packing_type_n->Visible) { // packing_type_n ?>
        <th data-name="packing_type_n" class="<?= $Grid->packing_type_n->headerCellClass() ?>"><div id="elh_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n"><?= $Grid->renderFieldHeader($Grid->packing_type_n) ?></div></th>
<?php } ?>
<?php if ($Grid->lot_no->Visible) { // lot_no ?>
        <th data-name="lot_no" class="<?= $Grid->lot_no->headerCellClass() ?>"><div id="elh_stock_lcgp_lot_no" class="stock_lcgp_lot_no"><?= $Grid->renderFieldHeader($Grid->lot_no) ?></div></th>
<?php } ?>
<?php if ($Grid->HOLD->Visible) { // HOLD ?>
        <th data-name="HOLD" class="<?= $Grid->HOLD->headerCellClass() ?>"><div id="elh_stock_lcgp_HOLD" class="stock_lcgp_HOLD"><?= $Grid->renderFieldHeader($Grid->HOLD) ?></div></th>
<?php } ?>
<?php if ($Grid->age->Visible) { // age ?>
        <th data-name="age" class="<?= $Grid->age->headerCellClass() ?>"><div id="elh_stock_lcgp_age" class="stock_lcgp_age"><?= $Grid->renderFieldHeader($Grid->age) ?></div></th>
<?php } ?>
<?php if ($Grid->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Grid->company_id->headerCellClass() ?>"><div id="elh_stock_lcgp_company_id" class="stock_lcgp_company_id"><?= $Grid->renderFieldHeader($Grid->company_id) ?></div></th>
<?php } ?>
<?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <th data-name="s_grp" class="<?= $Grid->s_grp->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_stock_lcgp_s_grp" class="stock_lcgp_s_grp"><?= $Grid->renderFieldHeader($Grid->s_grp) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->rid->Visible) { // rid ?>
        <td data-name="rid"<?= $Grid->rid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->rid->getSessionValue() != "") { ?>
<span<?= $Grid->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->rid->getDisplayValue($Grid->rid->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_rid" name="x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_rid" class="el_stock_lcgp_rid">
<input type="<?= $Grid->rid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_rid" id="x<?= $Grid->RowIndex ?>_rid" data-table="stock_lcgp" data-field="x_rid" value="<?= $Grid->rid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->rid->formatPattern()) ?>"<?= $Grid->rid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
</span>
<?php } ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_rid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_rid" id="o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->rid->getSessionValue() != "") { ?>
<span<?= $Grid->rid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->rid->getDisplayValue($Grid->rid->ViewValue))) ?>"></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_rid" name="x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_rid" class="el_stock_lcgp_rid">
<input type="<?= $Grid->rid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_rid" id="x<?= $Grid->RowIndex ?>_rid" data-table="stock_lcgp" data-field="x_rid" value="<?= $Grid->rid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->rid->formatPattern()) ?>"<?= $Grid->rid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->rid->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_rid" class="el_stock_lcgp_rid">
<span<?= $Grid->rid->viewAttributes() ?>>
<?= $Grid->rid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_rid" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_rid" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_rid" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_rid" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_rid" value="<?= HtmlEncode($Grid->rid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->grp->Visible) { // grp ?>
        <td data-name="grp"<?= $Grid->grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_grp" class="el_stock_lcgp_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpgrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fstock_lcgpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fstock_lcgpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_grp" id="o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_grp" class="el_stock_lcgp_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_grp"
        name="x<?= $Grid->RowIndex ?>_grp"
        class="form-select ew-select<?= $Grid->grp->isInvalidClass() ?>"
        <?php if (!$Grid->grp->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_grp"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_grp"
        data-value-separator="<?= $Grid->grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->grp->getPlaceHolder()) ?>"
        <?= $Grid->grp->editAttributes() ?>>
        <?= $Grid->grp->selectOptionListHtml("x{$Grid->RowIndex}_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->grp->getErrorMessage() ?></div>
<?= $Grid->grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_grp") ?>
<?php if (!$Grid->grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_grp", selectId: "fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpgrid.lists.grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fstock_lcgpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_grp", form: "fstock_lcgpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_grp" class="el_stock_lcgp_grp">
<span<?= $Grid->grp->viewAttributes() ?>>
<?php if (!EmptyString($Grid->grp->getViewValue()) && $Grid->grp->linkAttributes() != "") { ?>
<a<?= $Grid->grp->linkAttributes() ?>><?= $Grid->grp->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_grp" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_grp" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_grp" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_grp" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_grp" value="<?= HtmlEncode($Grid->grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product->Visible) { // product ?>
        <td data-name="product"<?= $Grid->product->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_product" class="el_stock_lcgp_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpgrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fstock_lcgpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fstock_lcgpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_product" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product" id="o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_product" class="el_stock_lcgp_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpgrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fstock_lcgpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fstock_lcgpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_product" class="el_stock_lcgp_product">
<span<?= $Grid->product->viewAttributes() ?>>
<?php if (!EmptyString($Grid->product->getViewValue()) && $Grid->product->linkAttributes() != "") { ?>
<a<?= $Grid->product->linkAttributes() ?>><?= $Grid->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->product->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_product" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_product" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_product" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_product" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product_code->Visible) { // product_code ?>
        <td data-name="product_code"<?= $Grid->product_code->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_product_code" class="el_stock_lcgp_product_code">
<input type="<?= $Grid->product_code->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_product_code" id="x<?= $Grid->RowIndex ?>_product_code" data-table="stock_lcgp" data-field="x_product_code" value="<?= $Grid->product_code->EditValue ?>" size="30" maxlength="311" placeholder="<?= HtmlEncode($Grid->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->product_code->formatPattern()) ?>"<?= $Grid->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->product_code->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_product_code" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product_code" id="o<?= $Grid->RowIndex ?>_product_code" value="<?= HtmlEncode($Grid->product_code->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_product_code" class="el_stock_lcgp_product_code">
<input type="<?= $Grid->product_code->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_product_code" id="x<?= $Grid->RowIndex ?>_product_code" data-table="stock_lcgp" data-field="x_product_code" value="<?= $Grid->product_code->EditValue ?>" size="30" maxlength="311" placeholder="<?= HtmlEncode($Grid->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->product_code->formatPattern()) ?>"<?= $Grid->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->product_code->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_product_code" class="el_stock_lcgp_product_code">
<span<?= $Grid->product_code->viewAttributes() ?>>
<?php if (!EmptyString($Grid->product_code->getViewValue()) && $Grid->product_code->linkAttributes() != "") { ?>
<a<?= $Grid->product_code->linkAttributes() ?>><?= $Grid->product_code->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_product_code" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_product_code" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_product_code" value="<?= HtmlEncode($Grid->product_code->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_product_code" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_product_code" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_product_code" value="<?= HtmlEncode($Grid->product_code->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->godown->Visible) { // godown ?>
        <td data-name="godown"<?= $Grid->godown->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_godown" class="el_stock_lcgp_godown">
    <select
        id="x<?= $Grid->RowIndex ?>_godown"
        name="x<?= $Grid->RowIndex ?>_godown"
        class="form-select ew-select<?= $Grid->godown->isInvalidClass() ?>"
        <?php if (!$Grid->godown->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_godown"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_godown"
        data-value-separator="<?= $Grid->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->godown->getPlaceHolder()) ?>"
        <?= $Grid->godown->editAttributes() ?>>
        <?= $Grid->godown->selectOptionListHtml("x{$Grid->RowIndex}_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->godown->getErrorMessage() ?></div>
<?= $Grid->godown->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_godown") ?>
<?php if (!$Grid->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_godown", selectId: "fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpgrid.lists.godown?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_godown", form: "fstock_lcgpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_godown", form: "fstock_lcgpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_godown" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_godown" id="o<?= $Grid->RowIndex ?>_godown" value="<?= HtmlEncode($Grid->godown->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_godown" class="el_stock_lcgp_godown">
    <select
        id="x<?= $Grid->RowIndex ?>_godown"
        name="x<?= $Grid->RowIndex ?>_godown"
        class="form-select ew-select<?= $Grid->godown->isInvalidClass() ?>"
        <?php if (!$Grid->godown->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_godown"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_godown"
        data-value-separator="<?= $Grid->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->godown->getPlaceHolder()) ?>"
        <?= $Grid->godown->editAttributes() ?>>
        <?= $Grid->godown->selectOptionListHtml("x{$Grid->RowIndex}_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->godown->getErrorMessage() ?></div>
<?= $Grid->godown->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_godown") ?>
<?php if (!$Grid->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_godown", selectId: "fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpgrid.lists.godown?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_godown", form: "fstock_lcgpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_godown", form: "fstock_lcgpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_godown" class="el_stock_lcgp_godown">
<span<?= $Grid->godown->viewAttributes() ?>>
<?= $Grid->godown->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_godown" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_godown" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_godown" value="<?= HtmlEncode($Grid->godown->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_godown" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_godown" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_godown" value="<?= HtmlEncode($Grid->godown->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->IN->Visible) { // IN ?>
        <td data-name="IN"<?= $Grid->IN->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_IN" class="el_stock_lcgp_IN">
<input type="<?= $Grid->IN->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_IN" id="x<?= $Grid->RowIndex ?>_IN" data-table="stock_lcgp" data-field="x_IN" value="<?= $Grid->IN->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->IN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->IN->formatPattern()) ?>"<?= $Grid->IN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->IN->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_IN" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_IN" id="o<?= $Grid->RowIndex ?>_IN" value="<?= HtmlEncode($Grid->IN->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_IN" class="el_stock_lcgp_IN">
<input type="<?= $Grid->IN->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_IN" id="x<?= $Grid->RowIndex ?>_IN" data-table="stock_lcgp" data-field="x_IN" value="<?= $Grid->IN->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->IN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->IN->formatPattern()) ?>"<?= $Grid->IN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->IN->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_IN" class="el_stock_lcgp_IN">
<span<?= $Grid->IN->viewAttributes() ?>>
<?= $Grid->IN->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_IN" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_IN" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_IN" value="<?= HtmlEncode($Grid->IN->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_IN" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_IN" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_IN" value="<?= HtmlEncode($Grid->IN->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->OUT->Visible) { // OUT ?>
        <td data-name="OUT"<?= $Grid->OUT->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_OUT" class="el_stock_lcgp_OUT">
<input type="<?= $Grid->OUT->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_OUT" id="x<?= $Grid->RowIndex ?>_OUT" data-table="stock_lcgp" data-field="x_OUT" value="<?= $Grid->OUT->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->OUT->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->OUT->formatPattern()) ?>"<?= $Grid->OUT->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->OUT->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_OUT" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_OUT" id="o<?= $Grid->RowIndex ?>_OUT" value="<?= HtmlEncode($Grid->OUT->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_OUT" class="el_stock_lcgp_OUT">
<input type="<?= $Grid->OUT->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_OUT" id="x<?= $Grid->RowIndex ?>_OUT" data-table="stock_lcgp" data-field="x_OUT" value="<?= $Grid->OUT->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->OUT->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->OUT->formatPattern()) ?>"<?= $Grid->OUT->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->OUT->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_OUT" class="el_stock_lcgp_OUT">
<span<?= $Grid->OUT->viewAttributes() ?>>
<?= $Grid->OUT->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_OUT" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_OUT" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_OUT" value="<?= HtmlEncode($Grid->OUT->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_OUT" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_OUT" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_OUT" value="<?= HtmlEncode($Grid->OUT->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Balance->Visible) { // Balance ?>
        <td data-name="Balance"<?= $Grid->Balance->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_Balance" class="el_stock_lcgp_Balance">
<input type="<?= $Grid->Balance->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Balance" id="x<?= $Grid->RowIndex ?>_Balance" data-table="stock_lcgp" data-field="x_Balance" value="<?= $Grid->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Balance->formatPattern()) ?>"<?= $Grid->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Balance->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_Balance" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Balance" id="o<?= $Grid->RowIndex ?>_Balance" value="<?= HtmlEncode($Grid->Balance->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_Balance" class="el_stock_lcgp_Balance">
<input type="<?= $Grid->Balance->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Balance" id="x<?= $Grid->RowIndex ?>_Balance" data-table="stock_lcgp" data-field="x_Balance" value="<?= $Grid->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Balance->formatPattern()) ?>"<?= $Grid->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Balance->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_Balance" class="el_stock_lcgp_Balance">
<span<?= $Grid->Balance->viewAttributes() ?>>
<?php if (!EmptyString($Grid->Balance->getViewValue()) && $Grid->Balance->linkAttributes() != "") { ?>
<a<?= $Grid->Balance->linkAttributes() ?>><?= $Grid->Balance->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->Balance->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_Balance" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_Balance" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_Balance" value="<?= HtmlEncode($Grid->Balance->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_Balance" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_Balance" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_Balance" value="<?= HtmlEncode($Grid->Balance->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->packets->Visible) { // packets ?>
        <td data-name="packets"<?= $Grid->packets->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_packets" class="el_stock_lcgp_packets">
<input type="<?= $Grid->packets->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packets" id="x<?= $Grid->RowIndex ?>_packets" data-table="stock_lcgp" data-field="x_packets" value="<?= $Grid->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packets->formatPattern()) ?>"<?= $Grid->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packets->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_packets" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_packets" id="o<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_packets" class="el_stock_lcgp_packets">
<input type="<?= $Grid->packets->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packets" id="x<?= $Grid->RowIndex ?>_packets" data-table="stock_lcgp" data-field="x_packets" value="<?= $Grid->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packets->formatPattern()) ?>"<?= $Grid->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packets->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_packets" class="el_stock_lcgp_packets">
<span<?= $Grid->packets->viewAttributes() ?>>
<?= $Grid->packets->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_packets" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_packets" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_packets" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_packets" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->packing_type_n->Visible) { // packing_type_n ?>
        <td data-name="packing_type_n"<?= $Grid->packing_type_n->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_packing_type_n" class="el_stock_lcgp_packing_type_n">
<input type="<?= $Grid->packing_type_n->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packing_type_n" id="x<?= $Grid->RowIndex ?>_packing_type_n" data-table="stock_lcgp" data-field="x_packing_type_n" value="<?= $Grid->packing_type_n->EditValue ?>" size="30" maxlength="54" placeholder="<?= HtmlEncode($Grid->packing_type_n->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packing_type_n->formatPattern()) ?>"<?= $Grid->packing_type_n->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packing_type_n->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_packing_type_n" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_packing_type_n" id="o<?= $Grid->RowIndex ?>_packing_type_n" value="<?= HtmlEncode($Grid->packing_type_n->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_packing_type_n" class="el_stock_lcgp_packing_type_n">
<input type="<?= $Grid->packing_type_n->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packing_type_n" id="x<?= $Grid->RowIndex ?>_packing_type_n" data-table="stock_lcgp" data-field="x_packing_type_n" value="<?= $Grid->packing_type_n->EditValue ?>" size="30" maxlength="54" placeholder="<?= HtmlEncode($Grid->packing_type_n->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packing_type_n->formatPattern()) ?>"<?= $Grid->packing_type_n->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packing_type_n->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_packing_type_n" class="el_stock_lcgp_packing_type_n">
<span<?= $Grid->packing_type_n->viewAttributes() ?>>
<?= $Grid->packing_type_n->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_packing_type_n" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_packing_type_n" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_packing_type_n" value="<?= HtmlEncode($Grid->packing_type_n->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_packing_type_n" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_packing_type_n" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_packing_type_n" value="<?= HtmlEncode($Grid->packing_type_n->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no"<?= $Grid->lot_no->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_lot_no" class="el_stock_lcgp_lot_no">
<input type="<?= $Grid->lot_no->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_lot_no" id="x<?= $Grid->RowIndex ?>_lot_no" data-table="stock_lcgp" data-field="x_lot_no" value="<?= $Grid->lot_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->lot_no->formatPattern()) ?>"<?= $Grid->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->lot_no->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_lot_no" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_lot_no" id="o<?= $Grid->RowIndex ?>_lot_no" value="<?= HtmlEncode($Grid->lot_no->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_lot_no" class="el_stock_lcgp_lot_no">
<input type="<?= $Grid->lot_no->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_lot_no" id="x<?= $Grid->RowIndex ?>_lot_no" data-table="stock_lcgp" data-field="x_lot_no" value="<?= $Grid->lot_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->lot_no->formatPattern()) ?>"<?= $Grid->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->lot_no->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_lot_no" class="el_stock_lcgp_lot_no">
<span<?= $Grid->lot_no->viewAttributes() ?>>
<?= $Grid->lot_no->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_lot_no" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_lot_no" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_lot_no" value="<?= HtmlEncode($Grid->lot_no->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_lot_no" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_lot_no" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_lot_no" value="<?= HtmlEncode($Grid->lot_no->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->HOLD->Visible) { // HOLD ?>
        <td data-name="HOLD"<?= $Grid->HOLD->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_HOLD" class="el_stock_lcgp_HOLD">
<input type="<?= $Grid->HOLD->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_HOLD" id="x<?= $Grid->RowIndex ?>_HOLD" data-table="stock_lcgp" data-field="x_HOLD" value="<?= $Grid->HOLD->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->HOLD->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->HOLD->formatPattern()) ?>"<?= $Grid->HOLD->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->HOLD->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_HOLD" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_HOLD" id="o<?= $Grid->RowIndex ?>_HOLD" value="<?= HtmlEncode($Grid->HOLD->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_HOLD" class="el_stock_lcgp_HOLD">
<input type="<?= $Grid->HOLD->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_HOLD" id="x<?= $Grid->RowIndex ?>_HOLD" data-table="stock_lcgp" data-field="x_HOLD" value="<?= $Grid->HOLD->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->HOLD->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->HOLD->formatPattern()) ?>"<?= $Grid->HOLD->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->HOLD->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_HOLD" class="el_stock_lcgp_HOLD">
<span<?= $Grid->HOLD->viewAttributes() ?>>
<?= $Grid->HOLD->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_HOLD" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_HOLD" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_HOLD" value="<?= HtmlEncode($Grid->HOLD->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_HOLD" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_HOLD" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_HOLD" value="<?= HtmlEncode($Grid->HOLD->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->age->Visible) { // age ?>
        <td data-name="age"<?= $Grid->age->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_age" class="el_stock_lcgp_age">
<input type="<?= $Grid->age->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_age" id="x<?= $Grid->RowIndex ?>_age" data-table="stock_lcgp" data-field="x_age" value="<?= $Grid->age->EditValue ?>" size="30" maxlength="11" placeholder="<?= HtmlEncode($Grid->age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->age->formatPattern()) ?>"<?= $Grid->age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->age->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_age" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_age" id="o<?= $Grid->RowIndex ?>_age" value="<?= HtmlEncode($Grid->age->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_age" class="el_stock_lcgp_age">
<input type="<?= $Grid->age->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_age" id="x<?= $Grid->RowIndex ?>_age" data-table="stock_lcgp" data-field="x_age" value="<?= $Grid->age->EditValue ?>" size="30" maxlength="11" placeholder="<?= HtmlEncode($Grid->age->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->age->formatPattern()) ?>"<?= $Grid->age->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->age->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_age" class="el_stock_lcgp_age">
<span<?= $Grid->age->viewAttributes() ?>>
<?= $Grid->age->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_age" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_age" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_age" value="<?= HtmlEncode($Grid->age->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_age" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_age" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_age" value="<?= HtmlEncode($Grid->age->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Grid->company_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_company_id" class="el_stock_lcgp_company_id">
    <select
        id="x<?= $Grid->RowIndex ?>_company_id"
        name="x<?= $Grid->RowIndex ?>_company_id"
        class="form-select ew-select<?= $Grid->company_id->isInvalidClass() ?>"
        <?php if (!$Grid->company_id->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_company_id"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_company_id"
        data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>"
        <?= $Grid->company_id->editAttributes() ?>>
        <?= $Grid->company_id->selectOptionListHtml("x{$Grid->RowIndex}_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
<?php if (!$Grid->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_company_id", selectId: "fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpgrid.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fstock_lcgpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fstock_lcgpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_company_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_company_id" id="o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_company_id" class="el_stock_lcgp_company_id">
    <select
        id="x<?= $Grid->RowIndex ?>_company_id"
        name="x<?= $Grid->RowIndex ?>_company_id"
        class="form-select ew-select<?= $Grid->company_id->isInvalidClass() ?>"
        <?php if (!$Grid->company_id->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_company_id"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_company_id"
        data-value-separator="<?= $Grid->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->company_id->getPlaceHolder()) ?>"
        <?= $Grid->company_id->editAttributes() ?>>
        <?= $Grid->company_id->selectOptionListHtml("x{$Grid->RowIndex}_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->company_id->getErrorMessage() ?></div>
<?= $Grid->company_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_company_id") ?>
<?php if (!$Grid->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_company_id", selectId: "fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpgrid.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fstock_lcgpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_company_id", form: "fstock_lcgpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_company_id" class="el_stock_lcgp_company_id">
<span<?= $Grid->company_id->viewAttributes() ?>>
<?= $Grid->company_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_company_id" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_company_id" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_company_id" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_company_id" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_company_id" value="<?= HtmlEncode($Grid->company_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp"<?= $Grid->s_grp->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_s_grp" class="el_stock_lcgp_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-select ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        <?php if (!$Grid->s_grp->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_s_grp"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_s_grp"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<?php if (!$Grid->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpgrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fstock_lcgpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fstock_lcgpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="stock_lcgp" data-field="x_s_grp" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_s_grp" id="o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_s_grp" class="el_stock_lcgp_s_grp">
    <select
        id="x<?= $Grid->RowIndex ?>_s_grp"
        name="x<?= $Grid->RowIndex ?>_s_grp"
        class="form-select ew-select<?= $Grid->s_grp->isInvalidClass() ?>"
        <?php if (!$Grid->s_grp->IsNativeSelect) { ?>
        data-select2-id="fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_s_grp"
        <?php } ?>
        data-table="stock_lcgp"
        data-field="x_s_grp"
        data-value-separator="<?= $Grid->s_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_grp->getPlaceHolder()) ?>"
        <?= $Grid->s_grp->editAttributes() ?>>
        <?= $Grid->s_grp->selectOptionListHtml("x{$Grid->RowIndex}_s_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->s_grp->getErrorMessage() ?></div>
<?= $Grid->s_grp->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_grp") ?>
<?php if (!$Grid->s_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_lcgpgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_grp", selectId: "fstock_lcgpgrid_x<?= $Grid->RowIndex ?>_s_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_lcgpgrid.lists.s_grp?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fstock_lcgpgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_grp", form: "fstock_lcgpgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumInputLength = ew.selectMinimumInputLength;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_lcgp.fields.s_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_lcgp_s_grp" class="el_stock_lcgp_s_grp">
<span<?= $Grid->s_grp->viewAttributes() ?>>
<?= $Grid->s_grp->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock_lcgp" data-field="x_s_grp" data-hidden="1" name="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_s_grp" id="fstock_lcgpgrid$x<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->FormValue) ?>">
<input type="hidden" data-table="stock_lcgp" data-field="x_s_grp" data-hidden="1" data-old name="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_s_grp" id="fstock_lcgpgrid$o<?= $Grid->RowIndex ?>_s_grp" value="<?= HtmlEncode($Grid->s_grp->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fstock_lcgpgrid","load"], () => fstock_lcgpgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = RowType::AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->rid->Visible) { // rid ?>
        <td data-name="rid" class="<?= $Grid->rid->footerCellClass() ?>"><span id="elf_stock_lcgp_rid" class="stock_lcgp_rid">
        </span></td>
    <?php } ?>
    <?php if ($Grid->grp->Visible) { // grp ?>
        <td data-name="grp" class="<?= $Grid->grp->footerCellClass() ?>"><span id="elf_stock_lcgp_grp" class="stock_lcgp_grp">
        </span></td>
    <?php } ?>
    <?php if ($Grid->product->Visible) { // product ?>
        <td data-name="product" class="<?= $Grid->product->footerCellClass() ?>"><span id="elf_stock_lcgp_product" class="stock_lcgp_product">
        </span></td>
    <?php } ?>
    <?php if ($Grid->product_code->Visible) { // product_code ?>
        <td data-name="product_code" class="<?= $Grid->product_code->footerCellClass() ?>"><span id="elf_stock_lcgp_product_code" class="stock_lcgp_product_code">
        </span></td>
    <?php } ?>
    <?php if ($Grid->godown->Visible) { // godown ?>
        <td data-name="godown" class="<?= $Grid->godown->footerCellClass() ?>"><span id="elf_stock_lcgp_godown" class="stock_lcgp_godown">
        </span></td>
    <?php } ?>
    <?php if ($Grid->IN->Visible) { // IN ?>
        <td data-name="IN" class="<?= $Grid->IN->footerCellClass() ?>"><span id="elf_stock_lcgp_IN" class="stock_lcgp_IN">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->IN->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->OUT->Visible) { // OUT ?>
        <td data-name="OUT" class="<?= $Grid->OUT->footerCellClass() ?>"><span id="elf_stock_lcgp_OUT" class="stock_lcgp_OUT">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->OUT->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->Balance->Visible) { // Balance ?>
        <td data-name="Balance" class="<?= $Grid->Balance->footerCellClass() ?>"><span id="elf_stock_lcgp_Balance" class="stock_lcgp_Balance">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?php if (!EmptyString($Grid->Balance->ViewValue) && $Grid->Balance->linkAttributes() != "") { ?>
        <a<?= $Grid->Balance->linkAttributes() ?>><?= $Grid->Balance->ViewValue ?></a>
        <?php } else { ?>
        <?= $Grid->Balance->ViewValue ?>
        <?php } ?>
        </span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->packets->Visible) { // packets ?>
        <td data-name="packets" class="<?= $Grid->packets->footerCellClass() ?>"><span id="elf_stock_lcgp_packets" class="stock_lcgp_packets">
        </span></td>
    <?php } ?>
    <?php if ($Grid->packing_type_n->Visible) { // packing_type_n ?>
        <td data-name="packing_type_n" class="<?= $Grid->packing_type_n->footerCellClass() ?>"><span id="elf_stock_lcgp_packing_type_n" class="stock_lcgp_packing_type_n">
        </span></td>
    <?php } ?>
    <?php if ($Grid->lot_no->Visible) { // lot_no ?>
        <td data-name="lot_no" class="<?= $Grid->lot_no->footerCellClass() ?>"><span id="elf_stock_lcgp_lot_no" class="stock_lcgp_lot_no">
        </span></td>
    <?php } ?>
    <?php if ($Grid->HOLD->Visible) { // HOLD ?>
        <td data-name="HOLD" class="<?= $Grid->HOLD->footerCellClass() ?>"><span id="elf_stock_lcgp_HOLD" class="stock_lcgp_HOLD">
        </span></td>
    <?php } ?>
    <?php if ($Grid->age->Visible) { // age ?>
        <td data-name="age" class="<?= $Grid->age->footerCellClass() ?>"><span id="elf_stock_lcgp_age" class="stock_lcgp_age">
        </span></td>
    <?php } ?>
    <?php if ($Grid->company_id->Visible) { // company_id ?>
        <td data-name="company_id" class="<?= $Grid->company_id->footerCellClass() ?>"><span id="elf_stock_lcgp_company_id" class="stock_lcgp_company_id">
        </span></td>
    <?php } ?>
    <?php if ($Grid->s_grp->Visible) { // s_grp ?>
        <td data-name="s_grp" class="<?= $Grid->s_grp->footerCellClass() ?>"><span id="elf_stock_lcgp_s_grp" class="stock_lcgp_s_grp">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fstock_lcgpgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stock_lcgp");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
