<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("StockGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fstockgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { stock: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fstockgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["product", [fields.product.visible && fields.product.required ? ew.Validators.required(fields.product.caption) : null], fields.product.isInvalid],
            ["product_code", [fields.product_code.visible && fields.product_code.required ? ew.Validators.required(fields.product_code.caption) : null], fields.product_code.isInvalid],
            ["packing_type", [fields.packing_type.visible && fields.packing_type.required ? ew.Validators.required(fields.packing_type.caption) : null], fields.packing_type.isInvalid],
            ["Balance", [fields.Balance.visible && fields.Balance.required ? ew.Validators.required(fields.Balance.caption) : null, ew.Validators.float], fields.Balance.isInvalid],
            ["hold", [fields.hold.visible && fields.hold.required ? ew.Validators.required(fields.hold.caption) : null, ew.Validators.float], fields.hold.isInvalid],
            ["packets", [fields.packets.visible && fields.packets.required ? ew.Validators.required(fields.packets.caption) : null, ew.Validators.float], fields.packets.isInvalid],
            ["avg_quantity", [fields.avg_quantity.visible && fields.avg_quantity.required ? ew.Validators.required(fields.avg_quantity.caption) : null, ew.Validators.float], fields.avg_quantity.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["product",false],["product_code",false],["packing_type",false],["Balance",false],["hold",false],["packets",false],["avg_quantity",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "product": <?= $Grid->product->toClientList($Grid) ?>,
            "packing_type": <?= $Grid->packing_type->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fstockgrid" class="ew-form ew-list-form">
<div id="gmp_stock" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_stockgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->product->Visible) { // product ?>
        <th data-name="product" class="<?= $Grid->product->headerCellClass() ?>"><div id="elh_stock_product" class="stock_product"><?= $Grid->renderFieldHeader($Grid->product) ?></div></th>
<?php } ?>
<?php if ($Grid->product_code->Visible) { // product_code ?>
        <th data-name="product_code" class="<?= $Grid->product_code->headerCellClass() ?>"><div id="elh_stock_product_code" class="stock_product_code"><?= $Grid->renderFieldHeader($Grid->product_code) ?></div></th>
<?php } ?>
<?php if ($Grid->packing_type->Visible) { // packing_type ?>
        <th data-name="packing_type" class="<?= $Grid->packing_type->headerCellClass() ?>"><div id="elh_stock_packing_type" class="stock_packing_type"><?= $Grid->renderFieldHeader($Grid->packing_type) ?></div></th>
<?php } ?>
<?php if ($Grid->Balance->Visible) { // Balance ?>
        <th data-name="Balance" class="<?= $Grid->Balance->headerCellClass() ?>"><div id="elh_stock_Balance" class="stock_Balance"><?= $Grid->renderFieldHeader($Grid->Balance) ?></div></th>
<?php } ?>
<?php if ($Grid->hold->Visible) { // hold ?>
        <th data-name="hold" class="<?= $Grid->hold->headerCellClass() ?>"><div id="elh_stock_hold" class="stock_hold"><?= $Grid->renderFieldHeader($Grid->hold) ?></div></th>
<?php } ?>
<?php if ($Grid->packets->Visible) { // packets ?>
        <th data-name="packets" class="<?= $Grid->packets->headerCellClass() ?>"><div id="elh_stock_packets" class="stock_packets"><?= $Grid->renderFieldHeader($Grid->packets) ?></div></th>
<?php } ?>
<?php if ($Grid->avg_quantity->Visible) { // avg_quantity ?>
        <th data-name="avg_quantity" class="<?= $Grid->avg_quantity->headerCellClass() ?>"><div id="elh_stock_avg_quantity" class="stock_avg_quantity"><?= $Grid->renderFieldHeader($Grid->avg_quantity) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->product->Visible) { // product ?>
        <td data-name="product"<?= $Grid->product->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_product" class="el_stock_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fstockgrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="stock"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fstockgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fstockgrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstockgrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fstockgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fstockgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="stock" data-field="x_product" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product" id="o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_product" class="el_stock_product">
    <select
        id="x<?= $Grid->RowIndex ?>_product"
        name="x<?= $Grid->RowIndex ?>_product"
        class="form-select ew-select<?= $Grid->product->isInvalidClass() ?>"
        <?php if (!$Grid->product->IsNativeSelect) { ?>
        data-select2-id="fstockgrid_x<?= $Grid->RowIndex ?>_product"
        <?php } ?>
        data-table="stock"
        data-field="x_product"
        data-value-separator="<?= $Grid->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->product->getPlaceHolder()) ?>"
        <?= $Grid->product->editAttributes() ?>>
        <?= $Grid->product->selectOptionListHtml("x{$Grid->RowIndex}_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->product->getErrorMessage() ?></div>
<?= $Grid->product->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_product") ?>
<?php if (!$Grid->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fstockgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_product", selectId: "fstockgrid_x<?= $Grid->RowIndex ?>_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstockgrid.lists.product?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_product", form: "fstockgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_product", form: "fstockgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_product" class="el_stock_product">
<span<?= $Grid->product->viewAttributes() ?>>
<?php if (!EmptyString($Grid->product->getViewValue()) && $Grid->product->linkAttributes() != "") { ?>
<a<?= $Grid->product->linkAttributes() ?>><?= $Grid->product->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->product->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_product" data-hidden="1" name="fstockgrid$x<?= $Grid->RowIndex ?>_product" id="fstockgrid$x<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_product" data-hidden="1" data-old name="fstockgrid$o<?= $Grid->RowIndex ?>_product" id="fstockgrid$o<?= $Grid->RowIndex ?>_product" value="<?= HtmlEncode($Grid->product->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->product_code->Visible) { // product_code ?>
        <td data-name="product_code"<?= $Grid->product_code->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_product_code" class="el_stock_product_code">
<input type="<?= $Grid->product_code->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_product_code" id="x<?= $Grid->RowIndex ?>_product_code" data-table="stock" data-field="x_product_code" value="<?= $Grid->product_code->EditValue ?>" size="30" maxlength="311" placeholder="<?= HtmlEncode($Grid->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->product_code->formatPattern()) ?>"<?= $Grid->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->product_code->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock" data-field="x_product_code" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_product_code" id="o<?= $Grid->RowIndex ?>_product_code" value="<?= HtmlEncode($Grid->product_code->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_product_code" class="el_stock_product_code">
<input type="<?= $Grid->product_code->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_product_code" id="x<?= $Grid->RowIndex ?>_product_code" data-table="stock" data-field="x_product_code" value="<?= $Grid->product_code->EditValue ?>" size="30" maxlength="311" placeholder="<?= HtmlEncode($Grid->product_code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->product_code->formatPattern()) ?>"<?= $Grid->product_code->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->product_code->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_product_code" class="el_stock_product_code">
<span<?= $Grid->product_code->viewAttributes() ?>>
<?php if (!EmptyString($Grid->product_code->getViewValue()) && $Grid->product_code->linkAttributes() != "") { ?>
<a<?= $Grid->product_code->linkAttributes() ?>><?= $Grid->product_code->getViewValue() ?></a>
<?php } else { ?>
<?= $Grid->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_product_code" data-hidden="1" name="fstockgrid$x<?= $Grid->RowIndex ?>_product_code" id="fstockgrid$x<?= $Grid->RowIndex ?>_product_code" value="<?= HtmlEncode($Grid->product_code->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_product_code" data-hidden="1" data-old name="fstockgrid$o<?= $Grid->RowIndex ?>_product_code" id="fstockgrid$o<?= $Grid->RowIndex ?>_product_code" value="<?= HtmlEncode($Grid->product_code->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type"<?= $Grid->packing_type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_packing_type" class="el_stock_packing_type">
    <select
        id="x<?= $Grid->RowIndex ?>_packing_type"
        name="x<?= $Grid->RowIndex ?>_packing_type"
        class="form-select ew-select<?= $Grid->packing_type->isInvalidClass() ?>"
        <?php if (!$Grid->packing_type->IsNativeSelect) { ?>
        data-select2-id="fstockgrid_x<?= $Grid->RowIndex ?>_packing_type"
        <?php } ?>
        data-table="stock"
        data-field="x_packing_type"
        data-value-separator="<?= $Grid->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->packing_type->getPlaceHolder()) ?>"
        <?= $Grid->packing_type->editAttributes() ?>>
        <?= $Grid->packing_type->selectOptionListHtml("x{$Grid->RowIndex}_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->packing_type->getErrorMessage() ?></div>
<?= $Grid->packing_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_packing_type") ?>
<?php if (!$Grid->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fstockgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_packing_type", selectId: "fstockgrid_x<?= $Grid->RowIndex ?>_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstockgrid.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fstockgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fstockgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="stock" data-field="x_packing_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_packing_type" id="o<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_packing_type" class="el_stock_packing_type">
    <select
        id="x<?= $Grid->RowIndex ?>_packing_type"
        name="x<?= $Grid->RowIndex ?>_packing_type"
        class="form-select ew-select<?= $Grid->packing_type->isInvalidClass() ?>"
        <?php if (!$Grid->packing_type->IsNativeSelect) { ?>
        data-select2-id="fstockgrid_x<?= $Grid->RowIndex ?>_packing_type"
        <?php } ?>
        data-table="stock"
        data-field="x_packing_type"
        data-value-separator="<?= $Grid->packing_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->packing_type->getPlaceHolder()) ?>"
        <?= $Grid->packing_type->editAttributes() ?>>
        <?= $Grid->packing_type->selectOptionListHtml("x{$Grid->RowIndex}_packing_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->packing_type->getErrorMessage() ?></div>
<?= $Grid->packing_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_packing_type") ?>
<?php if (!$Grid->packing_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fstockgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_packing_type", selectId: "fstockgrid_x<?= $Grid->RowIndex ?>_packing_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstockgrid.lists.packing_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fstockgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_packing_type", form: "fstockgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock.fields.packing_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_packing_type" class="el_stock_packing_type">
<span<?= $Grid->packing_type->viewAttributes() ?>>
<?= $Grid->packing_type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_packing_type" data-hidden="1" name="fstockgrid$x<?= $Grid->RowIndex ?>_packing_type" id="fstockgrid$x<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_packing_type" data-hidden="1" data-old name="fstockgrid$o<?= $Grid->RowIndex ?>_packing_type" id="fstockgrid$o<?= $Grid->RowIndex ?>_packing_type" value="<?= HtmlEncode($Grid->packing_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->Balance->Visible) { // Balance ?>
        <td data-name="Balance"<?= $Grid->Balance->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_Balance" class="el_stock_Balance">
<input type="<?= $Grid->Balance->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Balance" id="x<?= $Grid->RowIndex ?>_Balance" data-table="stock" data-field="x_Balance" value="<?= $Grid->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Balance->formatPattern()) ?>"<?= $Grid->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Balance->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock" data-field="x_Balance" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_Balance" id="o<?= $Grid->RowIndex ?>_Balance" value="<?= HtmlEncode($Grid->Balance->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_Balance" class="el_stock_Balance">
<input type="<?= $Grid->Balance->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_Balance" id="x<?= $Grid->RowIndex ?>_Balance" data-table="stock" data-field="x_Balance" value="<?= $Grid->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->Balance->formatPattern()) ?>"<?= $Grid->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->Balance->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_Balance" class="el_stock_Balance">
<span<?= $Grid->Balance->viewAttributes() ?>>
<?= $Grid->Balance->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_Balance" data-hidden="1" name="fstockgrid$x<?= $Grid->RowIndex ?>_Balance" id="fstockgrid$x<?= $Grid->RowIndex ?>_Balance" value="<?= HtmlEncode($Grid->Balance->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_Balance" data-hidden="1" data-old name="fstockgrid$o<?= $Grid->RowIndex ?>_Balance" id="fstockgrid$o<?= $Grid->RowIndex ?>_Balance" value="<?= HtmlEncode($Grid->Balance->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->hold->Visible) { // hold ?>
        <td data-name="hold"<?= $Grid->hold->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_hold" class="el_stock_hold">
<input type="<?= $Grid->hold->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_hold" id="x<?= $Grid->RowIndex ?>_hold" data-table="stock" data-field="x_hold" value="<?= $Grid->hold->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->hold->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->hold->formatPattern()) ?>"<?= $Grid->hold->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->hold->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock" data-field="x_hold" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_hold" id="o<?= $Grid->RowIndex ?>_hold" value="<?= HtmlEncode($Grid->hold->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_hold" class="el_stock_hold">
<input type="<?= $Grid->hold->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_hold" id="x<?= $Grid->RowIndex ?>_hold" data-table="stock" data-field="x_hold" value="<?= $Grid->hold->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->hold->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->hold->formatPattern()) ?>"<?= $Grid->hold->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->hold->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_hold" class="el_stock_hold">
<span<?= $Grid->hold->viewAttributes() ?>>
<?= $Grid->hold->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_hold" data-hidden="1" name="fstockgrid$x<?= $Grid->RowIndex ?>_hold" id="fstockgrid$x<?= $Grid->RowIndex ?>_hold" value="<?= HtmlEncode($Grid->hold->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_hold" data-hidden="1" data-old name="fstockgrid$o<?= $Grid->RowIndex ?>_hold" id="fstockgrid$o<?= $Grid->RowIndex ?>_hold" value="<?= HtmlEncode($Grid->hold->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->packets->Visible) { // packets ?>
        <td data-name="packets"<?= $Grid->packets->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_packets" class="el_stock_packets">
<input type="<?= $Grid->packets->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packets" id="x<?= $Grid->RowIndex ?>_packets" data-table="stock" data-field="x_packets" value="<?= $Grid->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packets->formatPattern()) ?>"<?= $Grid->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packets->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock" data-field="x_packets" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_packets" id="o<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_packets" class="el_stock_packets">
<input type="<?= $Grid->packets->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_packets" id="x<?= $Grid->RowIndex ?>_packets" data-table="stock" data-field="x_packets" value="<?= $Grid->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->packets->formatPattern()) ?>"<?= $Grid->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->packets->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_packets" class="el_stock_packets">
<span<?= $Grid->packets->viewAttributes() ?>>
<?= $Grid->packets->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_packets" data-hidden="1" name="fstockgrid$x<?= $Grid->RowIndex ?>_packets" id="fstockgrid$x<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_packets" data-hidden="1" data-old name="fstockgrid$o<?= $Grid->RowIndex ?>_packets" id="fstockgrid$o<?= $Grid->RowIndex ?>_packets" value="<?= HtmlEncode($Grid->packets->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->avg_quantity->Visible) { // avg_quantity ?>
        <td data-name="avg_quantity"<?= $Grid->avg_quantity->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_avg_quantity" class="el_stock_avg_quantity">
<input type="<?= $Grid->avg_quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_avg_quantity" id="x<?= $Grid->RowIndex ?>_avg_quantity" data-table="stock" data-field="x_avg_quantity" value="<?= $Grid->avg_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->avg_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->avg_quantity->formatPattern()) ?>"<?= $Grid->avg_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->avg_quantity->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="stock" data-field="x_avg_quantity" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_avg_quantity" id="o<?= $Grid->RowIndex ?>_avg_quantity" value="<?= HtmlEncode($Grid->avg_quantity->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_avg_quantity" class="el_stock_avg_quantity">
<input type="<?= $Grid->avg_quantity->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_avg_quantity" id="x<?= $Grid->RowIndex ?>_avg_quantity" data-table="stock" data-field="x_avg_quantity" value="<?= $Grid->avg_quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->avg_quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->avg_quantity->formatPattern()) ?>"<?= $Grid->avg_quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->avg_quantity->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_stock_avg_quantity" class="el_stock_avg_quantity">
<span<?= $Grid->avg_quantity->viewAttributes() ?>>
<?= $Grid->avg_quantity->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="stock" data-field="x_avg_quantity" data-hidden="1" name="fstockgrid$x<?= $Grid->RowIndex ?>_avg_quantity" id="fstockgrid$x<?= $Grid->RowIndex ?>_avg_quantity" value="<?= HtmlEncode($Grid->avg_quantity->FormValue) ?>">
<input type="hidden" data-table="stock" data-field="x_avg_quantity" data-hidden="1" data-old name="fstockgrid$o<?= $Grid->RowIndex ?>_avg_quantity" id="fstockgrid$o<?= $Grid->RowIndex ?>_avg_quantity" value="<?= HtmlEncode($Grid->avg_quantity->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fstockgrid","load"], () => fstockgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Grid->RowType = RowType::AGGREGATE;
$Grid->resetAttributes();
$Grid->renderRow();
?>
<?php if ($Grid->TotalRecords > 0 && $Grid->CurrentMode == "view") { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Grid->renderListOptions();

// Render list options (footer, left)
$Grid->ListOptions->render("footer", "left");
?>
    <?php if ($Grid->product->Visible) { // product ?>
        <td data-name="product" class="<?= $Grid->product->footerCellClass() ?>"><span id="elf_stock_product" class="stock_product">
        </span></td>
    <?php } ?>
    <?php if ($Grid->product_code->Visible) { // product_code ?>
        <td data-name="product_code" class="<?= $Grid->product_code->footerCellClass() ?>"><span id="elf_stock_product_code" class="stock_product_code">
        </span></td>
    <?php } ?>
    <?php if ($Grid->packing_type->Visible) { // packing_type ?>
        <td data-name="packing_type" class="<?= $Grid->packing_type->footerCellClass() ?>"><span id="elf_stock_packing_type" class="stock_packing_type">
        </span></td>
    <?php } ?>
    <?php if ($Grid->Balance->Visible) { // Balance ?>
        <td data-name="Balance" class="<?= $Grid->Balance->footerCellClass() ?>"><span id="elf_stock_Balance" class="stock_Balance">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->Balance->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->hold->Visible) { // hold ?>
        <td data-name="hold" class="<?= $Grid->hold->footerCellClass() ?>"><span id="elf_stock_hold" class="stock_hold">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->hold->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->packets->Visible) { // packets ?>
        <td data-name="packets" class="<?= $Grid->packets->footerCellClass() ?>"><span id="elf_stock_packets" class="stock_packets">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Grid->packets->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Grid->avg_quantity->Visible) { // avg_quantity ?>
        <td data-name="avg_quantity" class="<?= $Grid->avg_quantity->footerCellClass() ?>"><span id="elf_stock_avg_quantity" class="stock_avg_quantity">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Grid->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fstockgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stock");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
