<?php

namespace PHPMaker2024\fibre;

// Page object
$StockConsumeAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stock_consume: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fstock_consumeadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fstock_consumeadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["location", [fields.location.visible && fields.location.required ? ew.Validators.required(fields.location.caption) : null], fields.location.isInvalid],
            ["_barcode", [fields._barcode.visible && fields._barcode.required ? ew.Validators.required(fields._barcode.caption) : null, ew.Validators.integer], fields._barcode.isInvalid],
            ["design_id", [fields.design_id.visible && fields.design_id.required ? ew.Validators.required(fields.design_id.caption) : null], fields.design_id.isInvalid],
            ["w_cm", [fields.w_cm.visible && fields.w_cm.required ? ew.Validators.required(fields.w_cm.caption) : null, ew.Validators.integer], fields.w_cm.isInvalid],
            ["l_cm", [fields.l_cm.visible && fields.l_cm.required ? ew.Validators.required(fields.l_cm.caption) : null, ew.Validators.integer], fields.l_cm.isInvalid],
            ["sqm", [fields.sqm.visible && fields.sqm.required ? ew.Validators.required(fields.sqm.caption) : null, ew.Validators.float], fields.sqm.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["consumed_by", [fields.consumed_by.visible && fields.consumed_by.required ? ew.Validators.required(fields.consumed_by.caption) : null], fields.consumed_by.isInvalid],
            ["consumed_status", [fields.consumed_status.visible && fields.consumed_status.required ? ew.Validators.required(fields.consumed_status.caption) : null], fields.consumed_status.isInvalid],
            ["consumed_sqm", [fields.consumed_sqm.visible && fields.consumed_sqm.required ? ew.Validators.required(fields.consumed_sqm.caption) : null, ew.Validators.float], fields.consumed_sqm.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "location": <?= $Page->location->toClientList($Page) ?>,
            "design_id": <?= $Page->design_id->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "consumed_status": <?= $Page->consumed_status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fstock_consumeadd" id="fstock_consumeadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stock_consume">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->location->Visible) { // location ?>
    <div id="r_location"<?= $Page->location->rowAttributes() ?>>
        <label id="elh_stock_consume_location" for="x_location" class="<?= $Page->LeftColumnClass ?>"><?= $Page->location->caption() ?><?= $Page->location->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->location->cellAttributes() ?>>
<span id="el_stock_consume_location">
    <select
        id="x_location"
        name="x_location"
        class="form-select ew-select<?= $Page->location->isInvalidClass() ?>"
        <?php if (!$Page->location->IsNativeSelect) { ?>
        data-select2-id="fstock_consumeadd_x_location"
        <?php } ?>
        data-table="stock_consume"
        data-field="x_location"
        data-value-separator="<?= $Page->location->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->location->getPlaceHolder()) ?>"
        <?= $Page->location->editAttributes() ?>>
        <?= $Page->location->selectOptionListHtml("x_location") ?>
    </select>
    <?= $Page->location->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->location->getErrorMessage() ?></div>
<?= $Page->location->Lookup->getParamTag($Page, "p_x_location") ?>
<?php if (!$Page->location->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_consumeadd", function() {
    var options = { name: "x_location", selectId: "fstock_consumeadd_x_location" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_consumeadd.lists.location?.lookupOptions.length) {
        options.data = { id: "x_location", form: "fstock_consumeadd" };
    } else {
        options.ajax = { id: "x_location", form: "fstock_consumeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_consume.fields.location.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode"<?= $Page->_barcode->rowAttributes() ?>>
        <label id="elh_stock_consume__barcode" for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_barcode->caption() ?><?= $Page->_barcode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_barcode->cellAttributes() ?>>
<span id="el_stock_consume__barcode">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="stock_consume" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?> aria-describedby="x__barcode_help">
<?= $Page->_barcode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->design_id->Visible) { // design_id ?>
    <div id="r_design_id"<?= $Page->design_id->rowAttributes() ?>>
        <label id="elh_stock_consume_design_id" for="x_design_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->design_id->caption() ?><?= $Page->design_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->design_id->cellAttributes() ?>>
<span id="el_stock_consume_design_id">
    <select
        id="x_design_id"
        name="x_design_id"
        class="form-select ew-select<?= $Page->design_id->isInvalidClass() ?>"
        <?php if (!$Page->design_id->IsNativeSelect) { ?>
        data-select2-id="fstock_consumeadd_x_design_id"
        <?php } ?>
        data-table="stock_consume"
        data-field="x_design_id"
        data-value-separator="<?= $Page->design_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->design_id->getPlaceHolder()) ?>"
        <?= $Page->design_id->editAttributes() ?>>
        <?= $Page->design_id->selectOptionListHtml("x_design_id") ?>
    </select>
    <?= $Page->design_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->design_id->getErrorMessage() ?></div>
<?= $Page->design_id->Lookup->getParamTag($Page, "p_x_design_id") ?>
<?php if (!$Page->design_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_consumeadd", function() {
    var options = { name: "x_design_id", selectId: "fstock_consumeadd_x_design_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_consumeadd.lists.design_id?.lookupOptions.length) {
        options.data = { id: "x_design_id", form: "fstock_consumeadd" };
    } else {
        options.ajax = { id: "x_design_id", form: "fstock_consumeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_consume.fields.design_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->w_cm->Visible) { // w_cm ?>
    <div id="r_w_cm"<?= $Page->w_cm->rowAttributes() ?>>
        <label id="elh_stock_consume_w_cm" for="x_w_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->w_cm->caption() ?><?= $Page->w_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->w_cm->cellAttributes() ?>>
<span id="el_stock_consume_w_cm">
<input type="<?= $Page->w_cm->getInputTextType() ?>" name="x_w_cm" id="x_w_cm" data-table="stock_consume" data-field="x_w_cm" value="<?= $Page->w_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->w_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->w_cm->formatPattern()) ?>"<?= $Page->w_cm->editAttributes() ?> aria-describedby="x_w_cm_help">
<?= $Page->w_cm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->w_cm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->l_cm->Visible) { // l_cm ?>
    <div id="r_l_cm"<?= $Page->l_cm->rowAttributes() ?>>
        <label id="elh_stock_consume_l_cm" for="x_l_cm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->l_cm->caption() ?><?= $Page->l_cm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->l_cm->cellAttributes() ?>>
<span id="el_stock_consume_l_cm">
<input type="<?= $Page->l_cm->getInputTextType() ?>" name="x_l_cm" id="x_l_cm" data-table="stock_consume" data-field="x_l_cm" value="<?= $Page->l_cm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->l_cm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->l_cm->formatPattern()) ?>"<?= $Page->l_cm->editAttributes() ?> aria-describedby="x_l_cm_help">
<?= $Page->l_cm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->l_cm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sqm->Visible) { // sqm ?>
    <div id="r_sqm"<?= $Page->sqm->rowAttributes() ?>>
        <label id="elh_stock_consume_sqm" for="x_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sqm->caption() ?><?= $Page->sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sqm->cellAttributes() ?>>
<span id="el_stock_consume_sqm">
<input type="<?= $Page->sqm->getInputTextType() ?>" name="x_sqm" id="x_sqm" data-table="stock_consume" data-field="x_sqm" value="<?= $Page->sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sqm->formatPattern()) ?>"<?= $Page->sqm->editAttributes() ?> aria-describedby="x_sqm_help">
<?= $Page->sqm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sqm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_stock_consume_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_stock_consume_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fstock_consumeadd_x_status"
        <?php } ?>
        data-table="stock_consume"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_consumeadd", function() {
    var options = { name: "x_status", selectId: "fstock_consumeadd_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_consumeadd.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fstock_consumeadd" };
    } else {
        options.ajax = { id: "x_status", form: "fstock_consumeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_consume.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_stock_consume_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_stock_consume_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="stock_consume" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->consumed_by->Visible) { // consumed_by ?>
    <div id="r_consumed_by"<?= $Page->consumed_by->rowAttributes() ?>>
        <label id="elh_stock_consume_consumed_by" for="x_consumed_by" class="<?= $Page->LeftColumnClass ?>"><?= $Page->consumed_by->caption() ?><?= $Page->consumed_by->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->consumed_by->cellAttributes() ?>>
<span id="el_stock_consume_consumed_by">
<input type="<?= $Page->consumed_by->getInputTextType() ?>" name="x_consumed_by" id="x_consumed_by" data-table="stock_consume" data-field="x_consumed_by" value="<?= $Page->consumed_by->EditValue ?>" size="30" maxlength="19" placeholder="<?= HtmlEncode($Page->consumed_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->consumed_by->formatPattern()) ?>"<?= $Page->consumed_by->editAttributes() ?> aria-describedby="x_consumed_by_help">
<?= $Page->consumed_by->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->consumed_by->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->consumed_status->Visible) { // consumed_status ?>
    <div id="r_consumed_status"<?= $Page->consumed_status->rowAttributes() ?>>
        <label id="elh_stock_consume_consumed_status" for="x_consumed_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->consumed_status->caption() ?><?= $Page->consumed_status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->consumed_status->cellAttributes() ?>>
<span id="el_stock_consume_consumed_status">
    <select
        id="x_consumed_status"
        name="x_consumed_status"
        class="form-select ew-select<?= $Page->consumed_status->isInvalidClass() ?>"
        <?php if (!$Page->consumed_status->IsNativeSelect) { ?>
        data-select2-id="fstock_consumeadd_x_consumed_status"
        <?php } ?>
        data-table="stock_consume"
        data-field="x_consumed_status"
        data-value-separator="<?= $Page->consumed_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->consumed_status->getPlaceHolder()) ?>"
        <?= $Page->consumed_status->editAttributes() ?>>
        <?= $Page->consumed_status->selectOptionListHtml("x_consumed_status") ?>
    </select>
    <?= $Page->consumed_status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->consumed_status->getErrorMessage() ?></div>
<?php if (!$Page->consumed_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_consumeadd", function() {
    var options = { name: "x_consumed_status", selectId: "fstock_consumeadd_x_consumed_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_consumeadd.lists.consumed_status?.lookupOptions.length) {
        options.data = { id: "x_consumed_status", form: "fstock_consumeadd" };
    } else {
        options.ajax = { id: "x_consumed_status", form: "fstock_consumeadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_consume.fields.consumed_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->consumed_sqm->Visible) { // consumed_sqm ?>
    <div id="r_consumed_sqm"<?= $Page->consumed_sqm->rowAttributes() ?>>
        <label id="elh_stock_consume_consumed_sqm" for="x_consumed_sqm" class="<?= $Page->LeftColumnClass ?>"><?= $Page->consumed_sqm->caption() ?><?= $Page->consumed_sqm->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->consumed_sqm->cellAttributes() ?>>
<span id="el_stock_consume_consumed_sqm">
<input type="<?= $Page->consumed_sqm->getInputTextType() ?>" name="x_consumed_sqm" id="x_consumed_sqm" data-table="stock_consume" data-field="x_consumed_sqm" value="<?= $Page->consumed_sqm->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->consumed_sqm->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->consumed_sqm->formatPattern()) ?>"<?= $Page->consumed_sqm->editAttributes() ?> aria-describedby="x_consumed_sqm_help">
<?= $Page->consumed_sqm->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->consumed_sqm->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fstock_consumeadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fstock_consumeadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stock_consume");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
