<?php

namespace PHPMaker2024\fibre;

// Page object
$StockBarcodeSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { stock_barcode: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fstock_barcodesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fstock_barcodesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["product", [], fields.product.isInvalid],
            ["rid", [], fields.rid.isInvalid],
            ["godown", [], fields.godown.isInvalid],
            ["IN", [ew.Validators.float], fields.IN.isInvalid],
            ["OUT", [ew.Validators.float], fields.OUT.isInvalid],
            ["Balance", [ew.Validators.float], fields.Balance.isInvalid],
            ["packets", [ew.Validators.float], fields.packets.isInvalid],
            ["packing_type", [ew.Validators.integer], fields.packing_type.isInvalid],
            ["lot_no", [], fields.lot_no.isInvalid],
            ["dated", [], fields.dated.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["url", [], fields.url.isInvalid],
            ["company_id", [ew.Validators.integer], fields.company_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "product": <?= $Page->product->toClientList($Page) ?>,
            "rid": <?= $Page->rid->toClientList($Page) ?>,
            "godown": <?= $Page->godown->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fstock_barcodesearch" id="fstock_barcodesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="stock_barcode">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->product->Visible) { // product ?>
    <div id="r_product" class="row"<?= $Page->product->rowAttributes() ?>>
        <label for="x_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_product"><?= $Page->product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product" id="z_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_product"
        name="x_product"
        class="form-select ew-select<?= $Page->product->isInvalidClass() ?>"
        <?php if (!$Page->product->IsNativeSelect) { ?>
        data-select2-id="fstock_barcodesearch_x_product"
        <?php } ?>
        data-table="stock_barcode"
        data-field="x_product"
        data-value-separator="<?= $Page->product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product->getPlaceHolder()) ?>"
        <?= $Page->product->editAttributes() ?>>
        <?= $Page->product->selectOptionListHtml("x_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product->getErrorMessage(false) ?></div>
<?= $Page->product->Lookup->getParamTag($Page, "p_x_product") ?>
<?php if (!$Page->product->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_barcodesearch", function() {
    var options = { name: "x_product", selectId: "fstock_barcodesearch_x_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_barcodesearch.lists.product?.lookupOptions.length) {
        options.data = { id: "x_product", form: "fstock_barcodesearch" };
    } else {
        options.ajax = { id: "x_product", form: "fstock_barcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_barcode.fields.product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->rid->Visible) { // rid ?>
    <div id="r_rid" class="row"<?= $Page->rid->rowAttributes() ?>>
        <label for="x_rid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_rid"><?= $Page->rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_rid" id="z_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_rid"
        name="x_rid"
        class="form-select ew-select<?= $Page->rid->isInvalidClass() ?>"
        <?php if (!$Page->rid->IsNativeSelect) { ?>
        data-select2-id="fstock_barcodesearch_x_rid"
        <?php } ?>
        data-table="stock_barcode"
        data-field="x_rid"
        data-value-separator="<?= $Page->rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->rid->getPlaceHolder()) ?>"
        <?= $Page->rid->editAttributes() ?>>
        <?= $Page->rid->selectOptionListHtml("x_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->rid->getErrorMessage(false) ?></div>
<?= $Page->rid->Lookup->getParamTag($Page, "p_x_rid") ?>
<?php if (!$Page->rid->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_barcodesearch", function() {
    var options = { name: "x_rid", selectId: "fstock_barcodesearch_x_rid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_barcodesearch.lists.rid?.lookupOptions.length) {
        options.data = { id: "x_rid", form: "fstock_barcodesearch" };
    } else {
        options.ajax = { id: "x_rid", form: "fstock_barcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_barcode.fields.rid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->godown->Visible) { // godown ?>
    <div id="r_godown" class="row"<?= $Page->godown->rowAttributes() ?>>
        <label for="x_godown" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_godown"><?= $Page->godown->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_godown" id="z_godown" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->godown->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_godown" class="ew-search-field ew-search-field-single">
    <select
        id="x_godown"
        name="x_godown"
        class="form-select ew-select<?= $Page->godown->isInvalidClass() ?>"
        <?php if (!$Page->godown->IsNativeSelect) { ?>
        data-select2-id="fstock_barcodesearch_x_godown"
        <?php } ?>
        data-table="stock_barcode"
        data-field="x_godown"
        data-value-separator="<?= $Page->godown->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->godown->getPlaceHolder()) ?>"
        <?= $Page->godown->editAttributes() ?>>
        <?= $Page->godown->selectOptionListHtml("x_godown") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->godown->getErrorMessage(false) ?></div>
<?= $Page->godown->Lookup->getParamTag($Page, "p_x_godown") ?>
<?php if (!$Page->godown->IsNativeSelect) { ?>
<script>
loadjs.ready("fstock_barcodesearch", function() {
    var options = { name: "x_godown", selectId: "fstock_barcodesearch_x_godown" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fstock_barcodesearch.lists.godown?.lookupOptions.length) {
        options.data = { id: "x_godown", form: "fstock_barcodesearch" };
    } else {
        options.ajax = { id: "x_godown", form: "fstock_barcodesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.stock_barcode.fields.godown.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->IN->Visible) { // IN ?>
    <div id="r_IN" class="row"<?= $Page->IN->rowAttributes() ?>>
        <label for="x_IN" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_IN"><?= $Page->IN->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_IN" id="z_IN" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->IN->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_IN" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->IN->getInputTextType() ?>" name="x_IN" id="x_IN" data-table="stock_barcode" data-field="x_IN" value="<?= $Page->IN->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->IN->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->IN->formatPattern()) ?>"<?= $Page->IN->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->IN->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->OUT->Visible) { // OUT ?>
    <div id="r_OUT" class="row"<?= $Page->OUT->rowAttributes() ?>>
        <label for="x_OUT" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_OUT"><?= $Page->OUT->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_OUT" id="z_OUT" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->OUT->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_OUT" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->OUT->getInputTextType() ?>" name="x_OUT" id="x_OUT" data-table="stock_barcode" data-field="x_OUT" value="<?= $Page->OUT->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->OUT->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->OUT->formatPattern()) ?>"<?= $Page->OUT->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->OUT->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Balance->Visible) { // Balance ?>
    <div id="r_Balance" class="row"<?= $Page->Balance->rowAttributes() ?>>
        <label for="x_Balance" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_Balance"><?= $Page->Balance->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Balance" id="z_Balance" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Balance->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_Balance" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Balance->getInputTextType() ?>" name="x_Balance" id="x_Balance" data-table="stock_barcode" data-field="x_Balance" value="<?= $Page->Balance->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->Balance->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Balance->formatPattern()) ?>"<?= $Page->Balance->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Balance->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packets->Visible) { // packets ?>
    <div id="r_packets" class="row"<?= $Page->packets->rowAttributes() ?>>
        <label for="x_packets" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_packets"><?= $Page->packets->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packets" id="z_packets" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packets->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_packets" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packets->getInputTextType() ?>" name="x_packets" id="x_packets" data-table="stock_barcode" data-field="x_packets" value="<?= $Page->packets->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packets->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packets->formatPattern()) ?>"<?= $Page->packets->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packets->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->packing_type->Visible) { // packing_type ?>
    <div id="r_packing_type" class="row"<?= $Page->packing_type->rowAttributes() ?>>
        <label for="x_packing_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_packing_type"><?= $Page->packing_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_packing_type" id="z_packing_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->packing_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_packing_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->packing_type->getInputTextType() ?>" name="x_packing_type" id="x_packing_type" data-table="stock_barcode" data-field="x_packing_type" value="<?= $Page->packing_type->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->packing_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->packing_type->formatPattern()) ?>"<?= $Page->packing_type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->packing_type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->lot_no->Visible) { // lot_no ?>
    <div id="r_lot_no" class="row"<?= $Page->lot_no->rowAttributes() ?>>
        <label for="x_lot_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_lot_no"><?= $Page->lot_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_lot_no" id="z_lot_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->lot_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_lot_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->lot_no->getInputTextType() ?>" name="x_lot_no" id="x_lot_no" data-table="stock_barcode" data-field="x_lot_no" value="<?= $Page->lot_no->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Page->lot_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->lot_no->formatPattern()) ?>"<?= $Page->lot_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->lot_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_dated"><?= $Page->dated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_dated" id="z_dated" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="stock_barcode" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_type" id="z_type" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_type" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->type->getInputTextType() ?>" name="x_type" id="x_type" data-table="stock_barcode" data-field="x_type" value="<?= $Page->type->EditValue ?>" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->type->formatPattern()) ?>"<?= $Page->type->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->url->Visible) { // url ?>
    <div id="r_url" class="row"<?= $Page->url->rowAttributes() ?>>
        <label for="x_url" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_url"><?= $Page->url->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_url" id="z_url" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->url->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_url" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->url->getInputTextType() ?>" name="x_url" id="x_url" data-table="stock_barcode" data-field="x_url" value="<?= $Page->url->EditValue ?>" size="30" maxlength="31" placeholder="<?= HtmlEncode($Page->url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->url->formatPattern()) ?>"<?= $Page->url->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->url->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_stock_barcode_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_stock_barcode_company_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->company_id->getInputTextType() ?>" name="x_company_id" id="x_company_id" data-table="stock_barcode" data-field="x_company_id" value="<?= $Page->company_id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->company_id->formatPattern()) ?>"<?= $Page->company_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fstock_barcodesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fstock_barcodesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fstock_barcodesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("stock_barcode");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
