<?php

namespace PHPMaker2024\fibre;

// Page object
$StaticPagesView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fstatic_pagesview" id="fstatic_pagesview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { static_pages: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fstatic_pagesview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fstatic_pagesview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="static_pages">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_static_pages_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_static_pages_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->menu_id->Visible) { // menu_id ?>
    <tr id="r_menu_id"<?= $Page->menu_id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_static_pages_menu_id"><?= $Page->menu_id->caption() ?></span></td>
        <td data-name="menu_id"<?= $Page->menu_id->cellAttributes() ?>>
<span id="el_static_pages_menu_id">
<span<?= $Page->menu_id->viewAttributes() ?>>
<?= $Page->menu_id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->meta_desc->Visible) { // meta_desc ?>
    <tr id="r_meta_desc"<?= $Page->meta_desc->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_static_pages_meta_desc"><?= $Page->meta_desc->caption() ?></span></td>
        <td data-name="meta_desc"<?= $Page->meta_desc->cellAttributes() ?>>
<span id="el_static_pages_meta_desc">
<span<?= $Page->meta_desc->viewAttributes() ?>>
<?= $Page->meta_desc->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->meta_keyword->Visible) { // meta_keyword ?>
    <tr id="r_meta_keyword"<?= $Page->meta_keyword->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_static_pages_meta_keyword"><?= $Page->meta_keyword->caption() ?></span></td>
        <td data-name="meta_keyword"<?= $Page->meta_keyword->cellAttributes() ?>>
<span id="el_static_pages_meta_keyword">
<span<?= $Page->meta_keyword->viewAttributes() ?>>
<?= $Page->meta_keyword->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->page_desc->Visible) { // page_desc ?>
    <tr id="r_page_desc"<?= $Page->page_desc->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_static_pages_page_desc"><?= $Page->page_desc->caption() ?></span></td>
        <td data-name="page_desc"<?= $Page->page_desc->cellAttributes() ?>>
<span id="el_static_pages_page_desc">
<span<?= $Page->page_desc->viewAttributes() ?>>
<?= $Page->page_desc->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <tr id="r_operator"<?= $Page->operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_static_pages_operator"><?= $Page->operator->caption() ?></span></td>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el_static_pages_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_static_pages_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_static_pages_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
