<?php

namespace PHPMaker2024\fibre;

// Page object
$SpecialTaskEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fspecial_taskedit" id="fspecial_taskedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { special_task: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fspecial_taskedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fspecial_taskedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["task_title", [fields.task_title.visible && fields.task_title.required ? ew.Validators.required(fields.task_title.caption) : null], fields.task_title.isInvalid],
            ["task_description", [fields.task_description.visible && fields.task_description.required ? ew.Validators.required(fields.task_description.caption) : null], fields.task_description.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="special_task">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_special_task_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_special_task_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="special_task" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->task_title->Visible) { // task_title ?>
    <div id="r_task_title"<?= $Page->task_title->rowAttributes() ?>>
        <label id="elh_special_task_task_title" for="x_task_title" class="<?= $Page->LeftColumnClass ?>"><?= $Page->task_title->caption() ?><?= $Page->task_title->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->task_title->cellAttributes() ?>>
<span id="el_special_task_task_title">
<input type="<?= $Page->task_title->getInputTextType() ?>" name="x_task_title" id="x_task_title" data-table="special_task" data-field="x_task_title" value="<?= $Page->task_title->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->task_title->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->task_title->formatPattern()) ?>"<?= $Page->task_title->editAttributes() ?> aria-describedby="x_task_title_help">
<?= $Page->task_title->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->task_title->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->task_description->Visible) { // task_description ?>
    <div id="r_task_description"<?= $Page->task_description->rowAttributes() ?>>
        <label id="elh_special_task_task_description" for="x_task_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->task_description->caption() ?><?= $Page->task_description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->task_description->cellAttributes() ?>>
<span id="el_special_task_task_description">
<textarea data-table="special_task" data-field="x_task_description" name="x_task_description" id="x_task_description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->task_description->getPlaceHolder()) ?>"<?= $Page->task_description->editAttributes() ?> aria-describedby="x_task_description_help"><?= $Page->task_description->EditValue ?></textarea>
<?= $Page->task_description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->task_description->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fspecial_taskedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fspecial_taskedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("special_task");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
