<?php

namespace PHPMaker2024\fibre;

// Page object
$ShopEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fshopedit" id="fshopedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { shop: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fshopedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fshopedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["short_description", [fields.short_description.visible && fields.short_description.required ? ew.Validators.required(fields.short_description.caption) : null], fields.short_description.isInvalid],
            ["includes", [fields.includes.visible && fields.includes.required ? ew.Validators.required(fields.includes.caption) : null], fields.includes.isInvalid],
            ["description", [fields.description.visible && fields.description.required ? ew.Validators.required(fields.description.caption) : null], fields.description.isInvalid],
            ["price", [fields.price.visible && fields.price.required ? ew.Validators.required(fields.price.caption) : null], fields.price.isInvalid],
            ["discount_coupon", [fields.discount_coupon.visible && fields.discount_coupon.required ? ew.Validators.required(fields.discount_coupon.caption) : null], fields.discount_coupon.isInvalid],
            ["discount", [fields.discount.visible && fields.discount.required ? ew.Validators.required(fields.discount.caption) : null], fields.discount.isInvalid],
            ["amount", [fields.amount.visible && fields.amount.required ? ew.Validators.required(fields.amount.caption) : null], fields.amount.isInvalid],
            ["valid_till", [fields.valid_till.visible && fields.valid_till.required ? ew.Validators.required(fields.valid_till.caption) : null, ew.Validators.datetime(fields.valid_till.clientFormatPattern)], fields.valid_till.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["_response", [fields._response.visible && fields._response.required ? ew.Validators.required(fields._response.caption) : null], fields._response.isInvalid],
            ["admin_notes", [fields.admin_notes.visible && fields.admin_notes.required ? ew.Validators.required(fields.admin_notes.caption) : null], fields.admin_notes.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="shop">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_shop_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_shop_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="shop" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->short_description->Visible) { // short_description ?>
    <div id="r_short_description"<?= $Page->short_description->rowAttributes() ?>>
        <label id="elh_shop_short_description" for="x_short_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->short_description->caption() ?><?= $Page->short_description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->short_description->cellAttributes() ?>>
<span id="el_shop_short_description">
<span<?= $Page->short_description->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->short_description->getDisplayValue($Page->short_description->EditValue) ?></span></span>
<input type="hidden" data-table="shop" data-field="x_short_description" data-hidden="1" name="x_short_description" id="x_short_description" value="<?= HtmlEncode($Page->short_description->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->includes->Visible) { // includes ?>
    <div id="r_includes"<?= $Page->includes->rowAttributes() ?>>
        <label id="elh_shop_includes" class="<?= $Page->LeftColumnClass ?>"><?= $Page->includes->caption() ?><?= $Page->includes->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->includes->cellAttributes() ?>>
<span id="el_shop_includes">
<span<?= $Page->includes->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->includes->getDisplayValue($Page->includes->EditValue) ?></span></span>
<input type="hidden" data-table="shop" data-field="x_includes" data-hidden="1" name="x_includes" id="x_includes" value="<?= HtmlEncode($Page->includes->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->description->Visible) { // description ?>
    <div id="r_description"<?= $Page->description->rowAttributes() ?>>
        <label id="elh_shop_description" for="x_description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->description->caption() ?><?= $Page->description->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->description->cellAttributes() ?>>
<span id="el_shop_description">
<span<?= $Page->description->viewAttributes() ?>>
<?= $Page->description->EditValue ?></span>
<input type="hidden" data-table="shop" data-field="x_description" data-hidden="1" name="x_description" id="x_description" value="<?= HtmlEncode($Page->description->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->price->Visible) { // price ?>
    <div id="r_price"<?= $Page->price->rowAttributes() ?>>
        <label id="elh_shop_price" for="x_price" class="<?= $Page->LeftColumnClass ?>"><?= $Page->price->caption() ?><?= $Page->price->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->price->cellAttributes() ?>>
<span id="el_shop_price">
<span<?= $Page->price->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->price->getDisplayValue($Page->price->EditValue))) ?>"></span>
<input type="hidden" data-table="shop" data-field="x_price" data-hidden="1" name="x_price" id="x_price" value="<?= HtmlEncode($Page->price->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->discount_coupon->Visible) { // discount_coupon ?>
    <div id="r_discount_coupon"<?= $Page->discount_coupon->rowAttributes() ?>>
        <label id="elh_shop_discount_coupon" for="x_discount_coupon" class="<?= $Page->LeftColumnClass ?>"><?= $Page->discount_coupon->caption() ?><?= $Page->discount_coupon->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->discount_coupon->cellAttributes() ?>>
<span id="el_shop_discount_coupon">
<input type="<?= $Page->discount_coupon->getInputTextType() ?>" name="x_discount_coupon" id="x_discount_coupon" data-table="shop" data-field="x_discount_coupon" value="<?= $Page->discount_coupon->EditValue ?>" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->discount_coupon->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->discount_coupon->formatPattern()) ?>"<?= $Page->discount_coupon->editAttributes() ?> aria-describedby="x_discount_coupon_help">
<?= $Page->discount_coupon->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->discount_coupon->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->discount->Visible) { // discount ?>
    <div id="r_discount"<?= $Page->discount->rowAttributes() ?>>
        <label id="elh_shop_discount" for="x_discount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->discount->caption() ?><?= $Page->discount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->discount->cellAttributes() ?>>
<span id="el_shop_discount">
<span<?= $Page->discount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->discount->getDisplayValue($Page->discount->EditValue))) ?>"></span>
<input type="hidden" data-table="shop" data-field="x_discount" data-hidden="1" name="x_discount" id="x_discount" value="<?= HtmlEncode($Page->discount->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->amount->Visible) { // amount ?>
    <div id="r_amount"<?= $Page->amount->rowAttributes() ?>>
        <label id="elh_shop_amount" for="x_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->amount->caption() ?><?= $Page->amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->amount->cellAttributes() ?>>
<span id="el_shop_amount">
<span<?= $Page->amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->amount->getDisplayValue($Page->amount->EditValue))) ?>"></span>
<input type="hidden" data-table="shop" data-field="x_amount" data-hidden="1" name="x_amount" id="x_amount" value="<?= HtmlEncode($Page->amount->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->valid_till->Visible) { // valid_till ?>
    <div id="r_valid_till"<?= $Page->valid_till->rowAttributes() ?>>
        <label id="elh_shop_valid_till" for="x_valid_till" class="<?= $Page->LeftColumnClass ?>"><?= $Page->valid_till->caption() ?><?= $Page->valid_till->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->valid_till->cellAttributes() ?>>
<span id="el_shop_valid_till">
<input type="<?= $Page->valid_till->getInputTextType() ?>" name="x_valid_till" id="x_valid_till" data-table="shop" data-field="x_valid_till" value="<?= $Page->valid_till->EditValue ?>" placeholder="<?= HtmlEncode($Page->valid_till->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->valid_till->formatPattern()) ?>"<?= $Page->valid_till->editAttributes() ?> aria-describedby="x_valid_till_help">
<?= $Page->valid_till->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->valid_till->getErrorMessage() ?></div>
<?php if (!$Page->valid_till->ReadOnly && !$Page->valid_till->Disabled && !isset($Page->valid_till->EditAttrs["readonly"]) && !isset($Page->valid_till->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fshopedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fshopedit", "x_valid_till", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label id="elh_shop_status" for="x_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->status->cellAttributes() ?>>
<span id="el_shop_status">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fshopedit_x_status"
        <?php } ?>
        data-table="shop"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fshopedit", function() {
    var options = { name: "x_status", selectId: "fshopedit_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshopedit.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fshopedit" };
    } else {
        options.ajax = { id: "x_status", form: "fshopedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shop.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_response->Visible) { // response ?>
    <div id="r__response"<?= $Page->_response->rowAttributes() ?>>
        <label id="elh_shop__response" for="x__response" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_response->caption() ?><?= $Page->_response->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_response->cellAttributes() ?>>
<span id="el_shop__response">
<textarea data-table="shop" data-field="x__response" name="x__response" id="x__response" cols="30" rows="3" placeholder="<?= HtmlEncode($Page->_response->getPlaceHolder()) ?>"<?= $Page->_response->editAttributes() ?> aria-describedby="x__response_help"><?= $Page->_response->EditValue ?></textarea>
<?= $Page->_response->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_response->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->admin_notes->Visible) { // admin_notes ?>
    <div id="r_admin_notes"<?= $Page->admin_notes->rowAttributes() ?>>
        <label id="elh_shop_admin_notes" for="x_admin_notes" class="<?= $Page->LeftColumnClass ?>"><?= $Page->admin_notes->caption() ?><?= $Page->admin_notes->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->admin_notes->cellAttributes() ?>>
<span id="el_shop_admin_notes">
<textarea data-table="shop" data-field="x_admin_notes" name="x_admin_notes" id="x_admin_notes" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->admin_notes->getPlaceHolder()) ?>"<?= $Page->admin_notes->editAttributes() ?> aria-describedby="x_admin_notes_help"><?= $Page->admin_notes->EditValue ?></textarea>
<?= $Page->admin_notes->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->admin_notes->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fshopedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fshopedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("shop");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
