<?php

namespace PHPMaker2024\fibre;

// Page object
$ShippingLineAddopt = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { shipping_line: currentTable } });
var currentPageID = ew.PAGE_ID = "addopt";
var currentForm;
var fshipping_lineaddopt;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fshipping_lineaddopt")
        .setPageId("addopt")

        // Add fields
        .setFields([
            ["shipping_line", [fields.shipping_line.visible && fields.shipping_line.required ? ew.Validators.required(fields.shipping_line.caption) : null], fields.shipping_line.isInvalid],
            ["code", [fields.code.visible && fields.code.required ? ew.Validators.required(fields.code.caption) : null, ew.Validators.regex(/^([a-zA-Z0-9_-]){3,3}$/)], fields.code.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["tracking_url", [fields.tracking_url.visible && fields.tracking_url.required ? ew.Validators.required(fields.tracking_url.caption) : null], fields.tracking_url.isInvalid],
            ["variable_details", [fields.variable_details.visible && fields.variable_details.required ? ew.Validators.required(fields.variable_details.caption) : null], fields.variable_details.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<form name="fshipping_lineaddopt" id="fshipping_lineaddopt" class="ew-form" action="<?= HtmlEncode(GetUrl(Config("API_URL"))) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="<?= Config("API_ACTION_NAME") ?>" id="<?= Config("API_ACTION_NAME") ?>" value="<?= Config("API_ADD_ACTION") ?>">
<input type="hidden" name="<?= Config("API_OBJECT_NAME") ?>" id="<?= Config("API_OBJECT_NAME") ?>" value="shipping_line">
<input type="hidden" name="addopt" id="addopt" value="1">
<?php if ($Page->shipping_line->Visible) { // shipping_line ?>
    <div id="r_shipping_line"<?= $Page->shipping_line->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_shipping_line"><?= $Page->shipping_line->caption() ?><?= $Page->shipping_line->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->shipping_line->cellAttributes() ?>>
<input type="<?= $Page->shipping_line->getInputTextType() ?>" name="x_shipping_line" id="x_shipping_line" data-table="shipping_line" data-field="x_shipping_line" value="<?= $Page->shipping_line->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->shipping_line->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->shipping_line->formatPattern()) ?>"<?= $Page->shipping_line->editAttributes() ?> aria-describedby="x_shipping_line_help">
<?= $Page->shipping_line->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->shipping_line->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->code->Visible) { // code ?>
    <div id="r_code"<?= $Page->code->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_code"><?= $Page->code->caption() ?><?= $Page->code->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->code->cellAttributes() ?>>
<input type="<?= $Page->code->getInputTextType() ?>" name="x_code" id="x_code" data-table="shipping_line" data-field="x_code" value="<?= $Page->code->EditValue ?>" size="30" maxlength="3" placeholder="<?= HtmlEncode($Page->code->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->code->formatPattern()) ?>"<?= $Page->code->editAttributes() ?> aria-describedby="x_code_help">
<?= $Page->code->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->code->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status"<?= $Page->status->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_status"><?= $Page->status->caption() ?><?= $Page->status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->status->cellAttributes() ?>>
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fshipping_lineaddopt_x_status"
        <?php } ?>
        data-table="shipping_line"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <?= $Page->status->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fshipping_lineaddopt", function() {
    var options = { name: "x_status", selectId: "fshipping_lineaddopt_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshipping_lineaddopt.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fshipping_lineaddopt" };
    } else {
        options.ajax = { id: "x_status", form: "fshipping_lineaddopt", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shipping_line.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <input type="hidden" data-table="shipping_line" data-field="x_operator" data-hidden="1" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <input type="hidden" data-table="shipping_line" data-field="x_datetime" data-hidden="1" name="x_datetime" id="x_datetime" value="<?= HtmlEncode($Page->datetime->CurrentValue) ?>">
<?php } ?>
<?php if ($Page->tracking_url->Visible) { // tracking_url ?>
    <div id="r_tracking_url"<?= $Page->tracking_url->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_tracking_url"><?= $Page->tracking_url->caption() ?><?= $Page->tracking_url->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->tracking_url->cellAttributes() ?>>
<input type="<?= $Page->tracking_url->getInputTextType() ?>" name="x_tracking_url" id="x_tracking_url" data-table="shipping_line" data-field="x_tracking_url" value="<?= $Page->tracking_url->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->tracking_url->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->tracking_url->formatPattern()) ?>"<?= $Page->tracking_url->editAttributes() ?> aria-describedby="x_tracking_url_help">
<?= $Page->tracking_url->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->tracking_url->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->variable_details->Visible) { // variable_details ?>
    <div id="r_variable_details"<?= $Page->variable_details->rowAttributes() ?>>
        <label class="col-sm-2 col-form-label ew-label" for="x_variable_details"><?= $Page->variable_details->caption() ?><?= $Page->variable_details->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="col-sm-10"><div<?= $Page->variable_details->cellAttributes() ?>>
<input type="<?= $Page->variable_details->getInputTextType() ?>" name="x_variable_details" id="x_variable_details" data-table="shipping_line" data-field="x_variable_details" value="<?= $Page->variable_details->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->variable_details->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->variable_details->formatPattern()) ?>"<?= $Page->variable_details->editAttributes() ?> aria-describedby="x_variable_details_help">
<?= $Page->variable_details->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->variable_details->getErrorMessage() ?></div>
</div></div>
    </div>
<?php } ?>
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("shipping_line");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
