<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("ShippingAddressGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fshipping_addressgrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { shipping_address: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fshipping_addressgrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["type", [fields.type.visible && fields.type.required ? ew.Validators.required(fields.type.caption) : null], fields.type.isInvalid],
            ["_userid", [fields._userid.visible && fields._userid.required ? ew.Validators.required(fields._userid.caption) : null], fields._userid.isInvalid],
            ["formal_name", [fields.formal_name.visible && fields.formal_name.required ? ew.Validators.required(fields.formal_name.caption) : null], fields.formal_name.isInvalid],
            ["country", [fields.country.visible && fields.country.required ? ew.Validators.required(fields.country.caption) : null], fields.country.isInvalid],
            ["state", [fields.state.visible && fields.state.required ? ew.Validators.required(fields.state.caption) : null], fields.state.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["city_name", [fields.city_name.visible && fields.city_name.required ? ew.Validators.required(fields.city_name.caption) : null], fields.city_name.isInvalid],
            ["zipcode", [fields.zipcode.visible && fields.zipcode.required ? ew.Validators.required(fields.zipcode.caption) : null], fields.zipcode.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["_email", [fields._email.visible && fields._email.required ? ew.Validators.required(fields._email.caption) : null], fields._email.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null], fields.mobile.isInvalid],
            ["gst_number", [fields.gst_number.visible && fields.gst_number.required ? ew.Validators.required(fields.gst_number.caption) : null], fields.gst_number.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["type",false],["_userid",false],["formal_name",false],["country",false],["state",false],["address",false],["city_name",false],["zipcode",false],["name",false],["_email",false],["mobile",false],["gst_number",false],["status",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "type": <?= $Grid->type->toClientList($Grid) ?>,
            "_userid": <?= $Grid->_userid->toClientList($Grid) ?>,
            "country": <?= $Grid->country->toClientList($Grid) ?>,
            "state": <?= $Grid->state->toClientList($Grid) ?>,
            "status": <?= $Grid->status->toClientList($Grid) ?>,
            "operator": <?= $Grid->operator->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fshipping_addressgrid" class="ew-form ew-list-form">
<div id="gmp_shipping_address" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_shipping_addressgrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_shipping_address_id" class="shipping_address_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->type->Visible) { // type ?>
        <th data-name="type" class="<?= $Grid->type->headerCellClass() ?>"><div id="elh_shipping_address_type" class="shipping_address_type"><?= $Grid->renderFieldHeader($Grid->type) ?></div></th>
<?php } ?>
<?php if ($Grid->_userid->Visible) { // userid ?>
        <th data-name="_userid" class="<?= $Grid->_userid->headerCellClass() ?>"><div id="elh_shipping_address__userid" class="shipping_address__userid"><?= $Grid->renderFieldHeader($Grid->_userid) ?></div></th>
<?php } ?>
<?php if ($Grid->formal_name->Visible) { // formal_name ?>
        <th data-name="formal_name" class="<?= $Grid->formal_name->headerCellClass() ?>"><div id="elh_shipping_address_formal_name" class="shipping_address_formal_name"><?= $Grid->renderFieldHeader($Grid->formal_name) ?></div></th>
<?php } ?>
<?php if ($Grid->country->Visible) { // country ?>
        <th data-name="country" class="<?= $Grid->country->headerCellClass() ?>"><div id="elh_shipping_address_country" class="shipping_address_country"><?= $Grid->renderFieldHeader($Grid->country) ?></div></th>
<?php } ?>
<?php if ($Grid->state->Visible) { // state ?>
        <th data-name="state" class="<?= $Grid->state->headerCellClass() ?>"><div id="elh_shipping_address_state" class="shipping_address_state"><?= $Grid->renderFieldHeader($Grid->state) ?></div></th>
<?php } ?>
<?php if ($Grid->address->Visible) { // address ?>
        <th data-name="address" class="<?= $Grid->address->headerCellClass() ?>"><div id="elh_shipping_address_address" class="shipping_address_address"><?= $Grid->renderFieldHeader($Grid->address) ?></div></th>
<?php } ?>
<?php if ($Grid->city_name->Visible) { // city_name ?>
        <th data-name="city_name" class="<?= $Grid->city_name->headerCellClass() ?>"><div id="elh_shipping_address_city_name" class="shipping_address_city_name"><?= $Grid->renderFieldHeader($Grid->city_name) ?></div></th>
<?php } ?>
<?php if ($Grid->zipcode->Visible) { // zipcode ?>
        <th data-name="zipcode" class="<?= $Grid->zipcode->headerCellClass() ?>"><div id="elh_shipping_address_zipcode" class="shipping_address_zipcode"><?= $Grid->renderFieldHeader($Grid->zipcode) ?></div></th>
<?php } ?>
<?php if ($Grid->name->Visible) { // name ?>
        <th data-name="name" class="<?= $Grid->name->headerCellClass() ?>"><div id="elh_shipping_address_name" class="shipping_address_name"><?= $Grid->renderFieldHeader($Grid->name) ?></div></th>
<?php } ?>
<?php if ($Grid->_email->Visible) { // email ?>
        <th data-name="_email" class="<?= $Grid->_email->headerCellClass() ?>"><div id="elh_shipping_address__email" class="shipping_address__email"><?= $Grid->renderFieldHeader($Grid->_email) ?></div></th>
<?php } ?>
<?php if ($Grid->mobile->Visible) { // mobile ?>
        <th data-name="mobile" class="<?= $Grid->mobile->headerCellClass() ?>"><div id="elh_shipping_address_mobile" class="shipping_address_mobile"><?= $Grid->renderFieldHeader($Grid->mobile) ?></div></th>
<?php } ?>
<?php if ($Grid->gst_number->Visible) { // gst_number ?>
        <th data-name="gst_number" class="<?= $Grid->gst_number->headerCellClass() ?>"><div id="elh_shipping_address_gst_number" class="shipping_address_gst_number"><?= $Grid->renderFieldHeader($Grid->gst_number) ?></div></th>
<?php } ?>
<?php if ($Grid->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Grid->status->headerCellClass() ?>"><div id="elh_shipping_address_status" class="shipping_address_status"><?= $Grid->renderFieldHeader($Grid->status) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_shipping_address_operator" class="shipping_address_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_shipping_address_datetime" class="shipping_address_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_id" class="el_shipping_address_id"></span>
<input type="hidden" data-table="shipping_address" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_id" class="el_shipping_address_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="shipping_address" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_id" class="el_shipping_address_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_id" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_id" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_id" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_id" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="shipping_address" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->type->Visible) { // type ?>
        <td data-name="type"<?= $Grid->type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_type" class="el_shipping_address_type">
    <select
        id="x<?= $Grid->RowIndex ?>_type"
        name="x<?= $Grid->RowIndex ?>_type"
        class="form-select ew-select<?= $Grid->type->isInvalidClass() ?>"
        <?php if (!$Grid->type->IsNativeSelect) { ?>
        data-select2-id="fshipping_addressgrid_x<?= $Grid->RowIndex ?>_type"
        <?php } ?>
        data-table="shipping_address"
        data-field="x_type"
        data-value-separator="<?= $Grid->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->type->getPlaceHolder()) ?>"
        <?= $Grid->type->editAttributes() ?>>
        <?= $Grid->type->selectOptionListHtml("x{$Grid->RowIndex}_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->type->getErrorMessage() ?></div>
<?php if (!$Grid->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fshipping_addressgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_type", selectId: "fshipping_addressgrid_x<?= $Grid->RowIndex ?>_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshipping_addressgrid.lists.type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_type", form: "fshipping_addressgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_type", form: "fshipping_addressgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shipping_address.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_type" id="o<?= $Grid->RowIndex ?>_type" value="<?= HtmlEncode($Grid->type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_type" class="el_shipping_address_type">
    <select
        id="x<?= $Grid->RowIndex ?>_type"
        name="x<?= $Grid->RowIndex ?>_type"
        class="form-select ew-select<?= $Grid->type->isInvalidClass() ?>"
        <?php if (!$Grid->type->IsNativeSelect) { ?>
        data-select2-id="fshipping_addressgrid_x<?= $Grid->RowIndex ?>_type"
        <?php } ?>
        data-table="shipping_address"
        data-field="x_type"
        data-value-separator="<?= $Grid->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->type->getPlaceHolder()) ?>"
        <?= $Grid->type->editAttributes() ?>>
        <?= $Grid->type->selectOptionListHtml("x{$Grid->RowIndex}_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->type->getErrorMessage() ?></div>
<?php if (!$Grid->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fshipping_addressgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_type", selectId: "fshipping_addressgrid_x<?= $Grid->RowIndex ?>_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshipping_addressgrid.lists.type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_type", form: "fshipping_addressgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_type", form: "fshipping_addressgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shipping_address.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_type" class="el_shipping_address_type">
<span<?= $Grid->type->viewAttributes() ?>>
<?= $Grid->type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_type" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_type" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_type" value="<?= HtmlEncode($Grid->type->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_type" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_type" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_type" value="<?= HtmlEncode($Grid->type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_userid->Visible) { // userid ?>
        <td data-name="_userid"<?= $Grid->_userid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->_userid->getSessionValue() != "") { ?>
<span<?= $Grid->_userid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_userid->getDisplayValue($Grid->_userid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__userid" name="x<?= $Grid->RowIndex ?>__userid" value="<?= HtmlEncode($Grid->_userid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address__userid" class="el_shipping_address__userid">
    <select
        id="x<?= $Grid->RowIndex ?>__userid"
        name="x<?= $Grid->RowIndex ?>__userid"
        class="form-select ew-select<?= $Grid->_userid->isInvalidClass() ?>"
        <?php if (!$Grid->_userid->IsNativeSelect) { ?>
        data-select2-id="fshipping_addressgrid_x<?= $Grid->RowIndex ?>__userid"
        <?php } ?>
        data-table="shipping_address"
        data-field="x__userid"
        data-value-separator="<?= $Grid->_userid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_userid->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->_userid->editAttributes() ?>>
        <?= $Grid->_userid->selectOptionListHtml("x{$Grid->RowIndex}__userid") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_userid->getErrorMessage() ?></div>
<?= $Grid->_userid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__userid") ?>
<?php if (!$Grid->_userid->IsNativeSelect) { ?>
<script>
loadjs.ready("fshipping_addressgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__userid", selectId: "fshipping_addressgrid_x<?= $Grid->RowIndex ?>__userid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshipping_addressgrid.lists._userid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__userid", form: "fshipping_addressgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__userid", form: "fshipping_addressgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shipping_address.fields._userid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="shipping_address" data-field="x__userid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__userid" id="o<?= $Grid->RowIndex ?>__userid" value="<?= HtmlEncode($Grid->_userid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->_userid->getSessionValue() != "") { ?>
<span<?= $Grid->_userid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->_userid->getDisplayValue($Grid->_userid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>__userid" name="x<?= $Grid->RowIndex ?>__userid" value="<?= HtmlEncode($Grid->_userid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address__userid" class="el_shipping_address__userid">
    <select
        id="x<?= $Grid->RowIndex ?>__userid"
        name="x<?= $Grid->RowIndex ?>__userid"
        class="form-select ew-select<?= $Grid->_userid->isInvalidClass() ?>"
        <?php if (!$Grid->_userid->IsNativeSelect) { ?>
        data-select2-id="fshipping_addressgrid_x<?= $Grid->RowIndex ?>__userid"
        <?php } ?>
        data-table="shipping_address"
        data-field="x__userid"
        data-value-separator="<?= $Grid->_userid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->_userid->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Grid->_userid->editAttributes() ?>>
        <?= $Grid->_userid->selectOptionListHtml("x{$Grid->RowIndex}__userid") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->_userid->getErrorMessage() ?></div>
<?= $Grid->_userid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "__userid") ?>
<?php if (!$Grid->_userid->IsNativeSelect) { ?>
<script>
loadjs.ready("fshipping_addressgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>__userid", selectId: "fshipping_addressgrid_x<?= $Grid->RowIndex ?>__userid" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshipping_addressgrid.lists._userid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>__userid", form: "fshipping_addressgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>__userid", form: "fshipping_addressgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shipping_address.fields._userid.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address__userid" class="el_shipping_address__userid">
<span<?= $Grid->_userid->viewAttributes() ?>>
<?= $Grid->_userid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x__userid" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>__userid" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>__userid" value="<?= HtmlEncode($Grid->_userid->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x__userid" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>__userid" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>__userid" value="<?= HtmlEncode($Grid->_userid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->formal_name->Visible) { // formal_name ?>
        <td data-name="formal_name"<?= $Grid->formal_name->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_formal_name" class="el_shipping_address_formal_name">
<input type="<?= $Grid->formal_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_formal_name" id="x<?= $Grid->RowIndex ?>_formal_name" data-table="shipping_address" data-field="x_formal_name" value="<?= $Grid->formal_name->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->formal_name->formatPattern()) ?>"<?= $Grid->formal_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->formal_name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_formal_name" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_formal_name" id="o<?= $Grid->RowIndex ?>_formal_name" value="<?= HtmlEncode($Grid->formal_name->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_formal_name" class="el_shipping_address_formal_name">
<input type="<?= $Grid->formal_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_formal_name" id="x<?= $Grid->RowIndex ?>_formal_name" data-table="shipping_address" data-field="x_formal_name" value="<?= $Grid->formal_name->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->formal_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->formal_name->formatPattern()) ?>"<?= $Grid->formal_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->formal_name->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_formal_name" class="el_shipping_address_formal_name">
<span<?= $Grid->formal_name->viewAttributes() ?>>
<?= $Grid->formal_name->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_formal_name" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_formal_name" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_formal_name" value="<?= HtmlEncode($Grid->formal_name->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_formal_name" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_formal_name" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_formal_name" value="<?= HtmlEncode($Grid->formal_name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->country->Visible) { // country ?>
        <td data-name="country"<?= $Grid->country->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_country" class="el_shipping_address_country">
    <select
        id="x<?= $Grid->RowIndex ?>_country"
        name="x<?= $Grid->RowIndex ?>_country"
        class="form-select ew-select<?= $Grid->country->isInvalidClass() ?>"
        <?php if (!$Grid->country->IsNativeSelect) { ?>
        data-select2-id="fshipping_addressgrid_x<?= $Grid->RowIndex ?>_country"
        <?php } ?>
        data-table="shipping_address"
        data-field="x_country"
        data-value-separator="<?= $Grid->country->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->country->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->country->editAttributes() ?>>
        <?= $Grid->country->selectOptionListHtml("x{$Grid->RowIndex}_country") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->country->getErrorMessage() ?></div>
<?= $Grid->country->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_country") ?>
<?php if (!$Grid->country->IsNativeSelect) { ?>
<script>
loadjs.ready("fshipping_addressgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_country", selectId: "fshipping_addressgrid_x<?= $Grid->RowIndex ?>_country" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshipping_addressgrid.lists.country?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_country", form: "fshipping_addressgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_country", form: "fshipping_addressgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shipping_address.fields.country.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_country" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_country" id="o<?= $Grid->RowIndex ?>_country" value="<?= HtmlEncode($Grid->country->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_country" class="el_shipping_address_country">
    <select
        id="x<?= $Grid->RowIndex ?>_country"
        name="x<?= $Grid->RowIndex ?>_country"
        class="form-select ew-select<?= $Grid->country->isInvalidClass() ?>"
        <?php if (!$Grid->country->IsNativeSelect) { ?>
        data-select2-id="fshipping_addressgrid_x<?= $Grid->RowIndex ?>_country"
        <?php } ?>
        data-table="shipping_address"
        data-field="x_country"
        data-value-separator="<?= $Grid->country->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->country->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Grid->country->editAttributes() ?>>
        <?= $Grid->country->selectOptionListHtml("x{$Grid->RowIndex}_country") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->country->getErrorMessage() ?></div>
<?= $Grid->country->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_country") ?>
<?php if (!$Grid->country->IsNativeSelect) { ?>
<script>
loadjs.ready("fshipping_addressgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_country", selectId: "fshipping_addressgrid_x<?= $Grid->RowIndex ?>_country" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshipping_addressgrid.lists.country?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_country", form: "fshipping_addressgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_country", form: "fshipping_addressgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shipping_address.fields.country.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_country" class="el_shipping_address_country">
<span<?= $Grid->country->viewAttributes() ?>>
<?= $Grid->country->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_country" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_country" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_country" value="<?= HtmlEncode($Grid->country->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_country" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_country" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_country" value="<?= HtmlEncode($Grid->country->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->state->Visible) { // state ?>
        <td data-name="state"<?= $Grid->state->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_state" class="el_shipping_address_state">
    <select
        id="x<?= $Grid->RowIndex ?>_state"
        name="x<?= $Grid->RowIndex ?>_state"
        class="form-select ew-select<?= $Grid->state->isInvalidClass() ?>"
        <?php if (!$Grid->state->IsNativeSelect) { ?>
        data-select2-id="fshipping_addressgrid_x<?= $Grid->RowIndex ?>_state"
        <?php } ?>
        data-table="shipping_address"
        data-field="x_state"
        data-value-separator="<?= $Grid->state->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->state->getPlaceHolder()) ?>"
        <?= $Grid->state->editAttributes() ?>>
        <?= $Grid->state->selectOptionListHtml("x{$Grid->RowIndex}_state") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->state->getErrorMessage() ?></div>
<?= $Grid->state->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_state") ?>
<?php if (!$Grid->state->IsNativeSelect) { ?>
<script>
loadjs.ready("fshipping_addressgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_state", selectId: "fshipping_addressgrid_x<?= $Grid->RowIndex ?>_state" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshipping_addressgrid.lists.state?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_state", form: "fshipping_addressgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_state", form: "fshipping_addressgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shipping_address.fields.state.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_state" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_state" id="o<?= $Grid->RowIndex ?>_state" value="<?= HtmlEncode($Grid->state->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_state" class="el_shipping_address_state">
    <select
        id="x<?= $Grid->RowIndex ?>_state"
        name="x<?= $Grid->RowIndex ?>_state"
        class="form-select ew-select<?= $Grid->state->isInvalidClass() ?>"
        <?php if (!$Grid->state->IsNativeSelect) { ?>
        data-select2-id="fshipping_addressgrid_x<?= $Grid->RowIndex ?>_state"
        <?php } ?>
        data-table="shipping_address"
        data-field="x_state"
        data-value-separator="<?= $Grid->state->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->state->getPlaceHolder()) ?>"
        <?= $Grid->state->editAttributes() ?>>
        <?= $Grid->state->selectOptionListHtml("x{$Grid->RowIndex}_state") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->state->getErrorMessage() ?></div>
<?= $Grid->state->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_state") ?>
<?php if (!$Grid->state->IsNativeSelect) { ?>
<script>
loadjs.ready("fshipping_addressgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_state", selectId: "fshipping_addressgrid_x<?= $Grid->RowIndex ?>_state" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshipping_addressgrid.lists.state?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_state", form: "fshipping_addressgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_state", form: "fshipping_addressgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shipping_address.fields.state.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_state" class="el_shipping_address_state">
<span<?= $Grid->state->viewAttributes() ?>>
<?= $Grid->state->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_state" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_state" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_state" value="<?= HtmlEncode($Grid->state->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_state" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_state" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_state" value="<?= HtmlEncode($Grid->state->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->address->Visible) { // address ?>
        <td data-name="address"<?= $Grid->address->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_address" class="el_shipping_address_address">
<textarea data-table="shipping_address" data-field="x_address" name="x<?= $Grid->RowIndex ?>_address" id="x<?= $Grid->RowIndex ?>_address" cols="35" rows="3" placeholder="<?= HtmlEncode($Grid->address->getPlaceHolder()) ?>"<?= $Grid->address->editAttributes() ?>><?= $Grid->address->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->address->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_address" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_address" id="o<?= $Grid->RowIndex ?>_address" value="<?= HtmlEncode($Grid->address->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_address" class="el_shipping_address_address">
<textarea data-table="shipping_address" data-field="x_address" name="x<?= $Grid->RowIndex ?>_address" id="x<?= $Grid->RowIndex ?>_address" cols="35" rows="3" placeholder="<?= HtmlEncode($Grid->address->getPlaceHolder()) ?>"<?= $Grid->address->editAttributes() ?>><?= $Grid->address->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->address->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_address" class="el_shipping_address_address">
<span<?= $Grid->address->viewAttributes() ?>>
<?= $Grid->address->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_address" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_address" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_address" value="<?= HtmlEncode($Grid->address->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_address" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_address" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_address" value="<?= HtmlEncode($Grid->address->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->city_name->Visible) { // city_name ?>
        <td data-name="city_name"<?= $Grid->city_name->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_city_name" class="el_shipping_address_city_name">
<input type="<?= $Grid->city_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_city_name" id="x<?= $Grid->RowIndex ?>_city_name" data-table="shipping_address" data-field="x_city_name" value="<?= $Grid->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->city_name->formatPattern()) ?>"<?= $Grid->city_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->city_name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_city_name" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_city_name" id="o<?= $Grid->RowIndex ?>_city_name" value="<?= HtmlEncode($Grid->city_name->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_city_name" class="el_shipping_address_city_name">
<input type="<?= $Grid->city_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_city_name" id="x<?= $Grid->RowIndex ?>_city_name" data-table="shipping_address" data-field="x_city_name" value="<?= $Grid->city_name->EditValue ?>" size="30" maxlength="48" placeholder="<?= HtmlEncode($Grid->city_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->city_name->formatPattern()) ?>"<?= $Grid->city_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->city_name->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_city_name" class="el_shipping_address_city_name">
<span<?= $Grid->city_name->viewAttributes() ?>>
<?= $Grid->city_name->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_city_name" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_city_name" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_city_name" value="<?= HtmlEncode($Grid->city_name->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_city_name" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_city_name" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_city_name" value="<?= HtmlEncode($Grid->city_name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->zipcode->Visible) { // zipcode ?>
        <td data-name="zipcode"<?= $Grid->zipcode->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_zipcode" class="el_shipping_address_zipcode">
<input type="<?= $Grid->zipcode->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_zipcode" id="x<?= $Grid->RowIndex ?>_zipcode" data-table="shipping_address" data-field="x_zipcode" value="<?= $Grid->zipcode->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Grid->zipcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->zipcode->formatPattern()) ?>"<?= $Grid->zipcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->zipcode->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_zipcode" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_zipcode" id="o<?= $Grid->RowIndex ?>_zipcode" value="<?= HtmlEncode($Grid->zipcode->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_zipcode" class="el_shipping_address_zipcode">
<input type="<?= $Grid->zipcode->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_zipcode" id="x<?= $Grid->RowIndex ?>_zipcode" data-table="shipping_address" data-field="x_zipcode" value="<?= $Grid->zipcode->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Grid->zipcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->zipcode->formatPattern()) ?>"<?= $Grid->zipcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->zipcode->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_zipcode" class="el_shipping_address_zipcode">
<span<?= $Grid->zipcode->viewAttributes() ?>>
<?= $Grid->zipcode->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_zipcode" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_zipcode" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_zipcode" value="<?= HtmlEncode($Grid->zipcode->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_zipcode" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_zipcode" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_zipcode" value="<?= HtmlEncode($Grid->zipcode->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->name->Visible) { // name ?>
        <td data-name="name"<?= $Grid->name->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_name" class="el_shipping_address_name">
<input type="<?= $Grid->name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_name" id="x<?= $Grid->RowIndex ?>_name" data-table="shipping_address" data-field="x_name" value="<?= $Grid->name->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Grid->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->name->formatPattern()) ?>"<?= $Grid->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_name" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_name" id="o<?= $Grid->RowIndex ?>_name" value="<?= HtmlEncode($Grid->name->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_name" class="el_shipping_address_name">
<input type="<?= $Grid->name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_name" id="x<?= $Grid->RowIndex ?>_name" data-table="shipping_address" data-field="x_name" value="<?= $Grid->name->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Grid->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->name->formatPattern()) ?>"<?= $Grid->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->name->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_name" class="el_shipping_address_name">
<span<?= $Grid->name->viewAttributes() ?>>
<?= $Grid->name->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_name" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_name" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_name" value="<?= HtmlEncode($Grid->name->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_name" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_name" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_name" value="<?= HtmlEncode($Grid->name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->_email->Visible) { // email ?>
        <td data-name="_email"<?= $Grid->_email->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address__email" class="el_shipping_address__email">
<input type="<?= $Grid->_email->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__email" id="x<?= $Grid->RowIndex ?>__email" data-table="shipping_address" data-field="x__email" value="<?= $Grid->_email->EditValue ?>" size="30" maxlength="150" placeholder="<?= HtmlEncode($Grid->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_email->formatPattern()) ?>"<?= $Grid->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_email->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="shipping_address" data-field="x__email" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>__email" id="o<?= $Grid->RowIndex ?>__email" value="<?= HtmlEncode($Grid->_email->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address__email" class="el_shipping_address__email">
<input type="<?= $Grid->_email->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>__email" id="x<?= $Grid->RowIndex ?>__email" data-table="shipping_address" data-field="x__email" value="<?= $Grid->_email->EditValue ?>" size="30" maxlength="150" placeholder="<?= HtmlEncode($Grid->_email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->_email->formatPattern()) ?>"<?= $Grid->_email->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->_email->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address__email" class="el_shipping_address__email">
<span<?= $Grid->_email->viewAttributes() ?>>
<?= $Grid->_email->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x__email" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>__email" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>__email" value="<?= HtmlEncode($Grid->_email->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x__email" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>__email" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>__email" value="<?= HtmlEncode($Grid->_email->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->mobile->Visible) { // mobile ?>
        <td data-name="mobile"<?= $Grid->mobile->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_mobile" class="el_shipping_address_mobile">
<input type="<?= $Grid->mobile->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_mobile" id="x<?= $Grid->RowIndex ?>_mobile" data-table="shipping_address" data-field="x_mobile" value="<?= $Grid->mobile->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Grid->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->mobile->formatPattern()) ?>"<?= $Grid->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->mobile->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_mobile" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_mobile" id="o<?= $Grid->RowIndex ?>_mobile" value="<?= HtmlEncode($Grid->mobile->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_mobile" class="el_shipping_address_mobile">
<input type="<?= $Grid->mobile->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_mobile" id="x<?= $Grid->RowIndex ?>_mobile" data-table="shipping_address" data-field="x_mobile" value="<?= $Grid->mobile->EditValue ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Grid->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->mobile->formatPattern()) ?>"<?= $Grid->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->mobile->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_mobile" class="el_shipping_address_mobile">
<span<?= $Grid->mobile->viewAttributes() ?>>
<?= $Grid->mobile->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_mobile" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_mobile" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_mobile" value="<?= HtmlEncode($Grid->mobile->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_mobile" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_mobile" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_mobile" value="<?= HtmlEncode($Grid->mobile->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->gst_number->Visible) { // gst_number ?>
        <td data-name="gst_number"<?= $Grid->gst_number->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_gst_number" class="el_shipping_address_gst_number">
<input type="<?= $Grid->gst_number->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_gst_number" id="x<?= $Grid->RowIndex ?>_gst_number" data-table="shipping_address" data-field="x_gst_number" value="<?= $Grid->gst_number->EditValue ?>" size="30" maxlength="16" placeholder="<?= HtmlEncode($Grid->gst_number->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->gst_number->formatPattern()) ?>"<?= $Grid->gst_number->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->gst_number->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_gst_number" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_gst_number" id="o<?= $Grid->RowIndex ?>_gst_number" value="<?= HtmlEncode($Grid->gst_number->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_gst_number" class="el_shipping_address_gst_number">
<input type="<?= $Grid->gst_number->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_gst_number" id="x<?= $Grid->RowIndex ?>_gst_number" data-table="shipping_address" data-field="x_gst_number" value="<?= $Grid->gst_number->EditValue ?>" size="30" maxlength="16" placeholder="<?= HtmlEncode($Grid->gst_number->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->gst_number->formatPattern()) ?>"<?= $Grid->gst_number->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->gst_number->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_gst_number" class="el_shipping_address_gst_number">
<span<?= $Grid->gst_number->viewAttributes() ?>>
<?= $Grid->gst_number->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_gst_number" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_gst_number" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_gst_number" value="<?= HtmlEncode($Grid->gst_number->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_gst_number" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_gst_number" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_gst_number" value="<?= HtmlEncode($Grid->gst_number->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status"<?= $Grid->status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_status" class="el_shipping_address_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fshipping_addressgrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="shipping_address"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fshipping_addressgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fshipping_addressgrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshipping_addressgrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fshipping_addressgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fshipping_addressgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shipping_address.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="shipping_address" data-field="x_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_status" id="o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_status" class="el_shipping_address_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fshipping_addressgrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="shipping_address"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fshipping_addressgrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fshipping_addressgrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshipping_addressgrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fshipping_addressgrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fshipping_addressgrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.shipping_address.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_status" class="el_shipping_address_status">
<span<?= $Grid->status->viewAttributes() ?>>
<?= $Grid->status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_status" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_status" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_status" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_status" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="shipping_address" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_operator" class="el_shipping_address_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_operator" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_operator" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_operator" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_operator" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="shipping_address" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_shipping_address_datetime" class="el_shipping_address_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="shipping_address" data-field="x_datetime" data-hidden="1" name="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_datetime" id="fshipping_addressgrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="shipping_address" data-field="x_datetime" data-hidden="1" data-old name="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_datetime" id="fshipping_addressgrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fshipping_addressgrid","load"], () => fshipping_addressgrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fshipping_addressgrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("shipping_address");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
