<?php

namespace PHPMaker2024\fibre;

// Page object
$ShareTransferSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { share_transfer: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fshare_transfersearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fshare_transfersearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["folio_new", [], fields.folio_new.isInvalid],
            ["folio_old", [ew.Validators.integer], fields.folio_old.isInvalid],
            ["adviser", [], fields.adviser.isInvalid],
            ["quantity", [ew.Validators.integer], fields.quantity.isInvalid],
            ["transfer_date", [ew.Validators.datetime(fields.transfer_date.clientFormatPattern)], fields.transfer_date.isInvalid],
            ["y_transfer_date", [ew.Validators.between], false],
            ["share_no_start", [ew.Validators.integer], fields.share_no_start.isInvalid],
            ["share_no_end", [ew.Validators.integer], fields.share_no_end.isInvalid],
            ["pan", [], fields.pan.isInvalid],
            ["aadhaar", [], fields.aadhaar.isInvalid],
            ["duty_folio_new", [ew.Validators.float], fields.duty_folio_new.isInvalid],
            ["duty_company", [ew.Validators.float], fields.duty_company.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.integer], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "folio_new": <?= $Page->folio_new->toClientList($Page) ?>,
            "folio_old": <?= $Page->folio_old->toClientList($Page) ?>,
            "adviser": <?= $Page->adviser->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fshare_transfersearch" id="fshare_transfersearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="share_transfer">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="share_transfer" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->folio_new->Visible) { // folio_new ?>
    <div id="r_folio_new" class="row"<?= $Page->folio_new->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_folio_new"><?= $Page->folio_new->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_folio_new" id="z_folio_new" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->folio_new->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_folio_new" class="ew-search-field ew-search-field-single">
    <select
        id="x_folio_new"
        name="x_folio_new"
        class="form-control ew-select<?= $Page->folio_new->isInvalidClass() ?>"
        data-select2-id="fshare_transfersearch_x_folio_new"
        data-table="share_transfer"
        data-field="x_folio_new"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->folio_new->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->folio_new->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->folio_new->getPlaceHolder()) ?>"
        <?= $Page->folio_new->editAttributes() ?>>
        <?= $Page->folio_new->selectOptionListHtml("x_folio_new") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->folio_new->getErrorMessage(false) ?></div>
<?= $Page->folio_new->Lookup->getParamTag($Page, "p_x_folio_new") ?>
<script>
loadjs.ready("fshare_transfersearch", function() {
    var options = { name: "x_folio_new", selectId: "fshare_transfersearch_x_folio_new" };
    if (fshare_transfersearch.lists.folio_new?.lookupOptions.length) {
        options.data = { id: "x_folio_new", form: "fshare_transfersearch" };
    } else {
        options.ajax = { id: "x_folio_new", form: "fshare_transfersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.share_transfer.fields.folio_new.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->folio_old->Visible) { // folio_old ?>
    <div id="r_folio_old" class="row"<?= $Page->folio_old->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_folio_old"><?= $Page->folio_old->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_folio_old" id="z_folio_old" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->folio_old->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_folio_old" class="ew-search-field ew-search-field-single">
    <select
        id="x_folio_old"
        name="x_folio_old"
        class="form-control ew-select<?= $Page->folio_old->isInvalidClass() ?>"
        data-select2-id="fshare_transfersearch_x_folio_old"
        data-table="share_transfer"
        data-field="x_folio_old"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->folio_old->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->folio_old->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->folio_old->getPlaceHolder()) ?>"
        <?= $Page->folio_old->editAttributes() ?>>
        <?= $Page->folio_old->selectOptionListHtml("x_folio_old") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->folio_old->getErrorMessage(false) ?></div>
<?= $Page->folio_old->Lookup->getParamTag($Page, "p_x_folio_old") ?>
<script>
loadjs.ready("fshare_transfersearch", function() {
    var options = { name: "x_folio_old", selectId: "fshare_transfersearch_x_folio_old" };
    if (fshare_transfersearch.lists.folio_old?.lookupOptions.length) {
        options.data = { id: "x_folio_old", form: "fshare_transfersearch" };
    } else {
        options.ajax = { id: "x_folio_old", form: "fshare_transfersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.share_transfer.fields.folio_old.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->adviser->Visible) { // adviser ?>
    <div id="r_adviser" class="row"<?= $Page->adviser->rowAttributes() ?>>
        <label for="x_adviser" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_adviser"><?= $Page->adviser->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_adviser" id="z_adviser" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->adviser->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_adviser" class="ew-search-field ew-search-field-single">
    <select
        id="x_adviser"
        name="x_adviser"
        class="form-select ew-select<?= $Page->adviser->isInvalidClass() ?>"
        <?php if (!$Page->adviser->IsNativeSelect) { ?>
        data-select2-id="fshare_transfersearch_x_adviser"
        <?php } ?>
        data-table="share_transfer"
        data-field="x_adviser"
        data-value-separator="<?= $Page->adviser->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->adviser->getPlaceHolder()) ?>"
        <?= $Page->adviser->editAttributes() ?>>
        <?= $Page->adviser->selectOptionListHtml("x_adviser") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->adviser->getErrorMessage(false) ?></div>
<?= $Page->adviser->Lookup->getParamTag($Page, "p_x_adviser") ?>
<?php if (!$Page->adviser->IsNativeSelect) { ?>
<script>
loadjs.ready("fshare_transfersearch", function() {
    var options = { name: "x_adviser", selectId: "fshare_transfersearch_x_adviser" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshare_transfersearch.lists.adviser?.lookupOptions.length) {
        options.data = { id: "x_adviser", form: "fshare_transfersearch" };
    } else {
        options.ajax = { id: "x_adviser", form: "fshare_transfersearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.share_transfer.fields.adviser.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="share_transfer" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->transfer_date->Visible) { // transfer_date ?>
    <div id="r_transfer_date" class="row"<?= $Page->transfer_date->rowAttributes() ?>>
        <label for="x_transfer_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_transfer_date"><?= $Page->transfer_date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->transfer_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_transfer_date" id="z_transfer_date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->transfer_date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->transfer_date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_share_transfer_transfer_date" class="ew-search-field">
<input type="<?= $Page->transfer_date->getInputTextType() ?>" name="x_transfer_date" id="x_transfer_date" data-table="share_transfer" data-field="x_transfer_date" value="<?= $Page->transfer_date->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->transfer_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transfer_date->formatPattern()) ?>"<?= $Page->transfer_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->transfer_date->getErrorMessage(false) ?></div>
<?php if (!$Page->transfer_date->ReadOnly && !$Page->transfer_date->Disabled && !isset($Page->transfer_date->EditAttrs["readonly"]) && !isset($Page->transfer_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fshare_transfersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fshare_transfersearch", "x_transfer_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_share_transfer_transfer_date" class="ew-search-field2 d-none">
<input type="<?= $Page->transfer_date->getInputTextType() ?>" name="y_transfer_date" id="y_transfer_date" data-table="share_transfer" data-field="x_transfer_date" value="<?= $Page->transfer_date->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->transfer_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transfer_date->formatPattern()) ?>"<?= $Page->transfer_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->transfer_date->getErrorMessage(false) ?></div>
<?php if (!$Page->transfer_date->ReadOnly && !$Page->transfer_date->Disabled && !isset($Page->transfer_date->EditAttrs["readonly"]) && !isset($Page->transfer_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fshare_transfersearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fshare_transfersearch", "y_transfer_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->share_no_start->Visible) { // share_no_start ?>
    <div id="r_share_no_start" class="row"<?= $Page->share_no_start->rowAttributes() ?>>
        <label for="x_share_no_start" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_share_no_start"><?= $Page->share_no_start->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_share_no_start" id="z_share_no_start" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->share_no_start->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_share_no_start" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->share_no_start->getInputTextType() ?>" name="x_share_no_start" id="x_share_no_start" data-table="share_transfer" data-field="x_share_no_start" value="<?= $Page->share_no_start->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->share_no_start->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->share_no_start->formatPattern()) ?>"<?= $Page->share_no_start->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->share_no_start->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->share_no_end->Visible) { // share_no_end ?>
    <div id="r_share_no_end" class="row"<?= $Page->share_no_end->rowAttributes() ?>>
        <label for="x_share_no_end" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_share_no_end"><?= $Page->share_no_end->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_share_no_end" id="z_share_no_end" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->share_no_end->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_share_no_end" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->share_no_end->getInputTextType() ?>" name="x_share_no_end" id="x_share_no_end" data-table="share_transfer" data-field="x_share_no_end" value="<?= $Page->share_no_end->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->share_no_end->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->share_no_end->formatPattern()) ?>"<?= $Page->share_no_end->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->share_no_end->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pan->Visible) { // pan ?>
    <div id="r_pan" class="row"<?= $Page->pan->rowAttributes() ?>>
        <label for="x_pan" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_pan"><?= $Page->pan->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pan" id="z_pan" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pan->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_pan" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pan->getInputTextType() ?>" name="x_pan" id="x_pan" data-table="share_transfer" data-field="x_pan" value="<?= $Page->pan->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->pan->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pan->formatPattern()) ?>"<?= $Page->pan->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pan->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->aadhaar->Visible) { // aadhaar ?>
    <div id="r_aadhaar" class="row"<?= $Page->aadhaar->rowAttributes() ?>>
        <label for="x_aadhaar" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_aadhaar"><?= $Page->aadhaar->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_aadhaar" id="z_aadhaar" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->aadhaar->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_aadhaar" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->aadhaar->getInputTextType() ?>" name="x_aadhaar" id="x_aadhaar" data-table="share_transfer" data-field="x_aadhaar" value="<?= $Page->aadhaar->EditValue ?>" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->aadhaar->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->aadhaar->formatPattern()) ?>"<?= $Page->aadhaar->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->aadhaar->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->duty_folio_new->Visible) { // duty_folio_new ?>
    <div id="r_duty_folio_new" class="row"<?= $Page->duty_folio_new->rowAttributes() ?>>
        <label for="x_duty_folio_new" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_duty_folio_new"><?= $Page->duty_folio_new->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_duty_folio_new" id="z_duty_folio_new" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->duty_folio_new->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_duty_folio_new" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->duty_folio_new->getInputTextType() ?>" name="x_duty_folio_new" id="x_duty_folio_new" data-table="share_transfer" data-field="x_duty_folio_new" value="<?= $Page->duty_folio_new->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->duty_folio_new->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->duty_folio_new->formatPattern()) ?>"<?= $Page->duty_folio_new->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->duty_folio_new->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->duty_company->Visible) { // duty_company ?>
    <div id="r_duty_company" class="row"<?= $Page->duty_company->rowAttributes() ?>>
        <label for="x_duty_company" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_duty_company"><?= $Page->duty_company->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_duty_company" id="z_duty_company" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->duty_company->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_duty_company" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->duty_company->getInputTextType() ?>" name="x_duty_company" id="x_duty_company" data-table="share_transfer" data-field="x_duty_company" value="<?= $Page->duty_company->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->duty_company->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->duty_company->formatPattern()) ?>"<?= $Page->duty_company->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->duty_company->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="share_transfer" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_share_transfer_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_share_transfer_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="share_transfer" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fshare_transfersearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fshare_transfersearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fshare_transfersearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("share_transfer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
