<?php

namespace PHPMaker2024\fibre;

// Page object
$ShareTransferList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { share_transfer: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fshare_transfersrch" id="fshare_transfersrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fshare_transfersrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { share_transfer: currentTable } });
var currentForm;
var fshare_transfersrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fshare_transfersrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["folio_new", [], fields.folio_new.isInvalid],
            ["folio_old", [ew.Validators.integer], fields.folio_old.isInvalid],
            ["adviser", [], fields.adviser.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "folio_new": <?= $Page->folio_new->toClientList($Page) ?>,
            "folio_old": <?= $Page->folio_old->toClientList($Page) ?>,
            "adviser": <?= $Page->adviser->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->folio_new->Visible) { // folio_new ?>
<?php
if (!$Page->folio_new->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_folio_new" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->folio_new->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->folio_new->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_folio_new" id="z_folio_new" value="LIKE">
</div>
        </div>
        <div id="el_share_transfer_folio_new" class="ew-search-field">
    <select
        id="x_folio_new"
        name="x_folio_new"
        class="form-control ew-select<?= $Page->folio_new->isInvalidClass() ?>"
        data-select2-id="fshare_transfersrch_x_folio_new"
        data-table="share_transfer"
        data-field="x_folio_new"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->folio_new->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->folio_new->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->folio_new->getPlaceHolder()) ?>"
        <?= $Page->folio_new->editAttributes() ?>>
        <?= $Page->folio_new->selectOptionListHtml("x_folio_new") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->folio_new->getErrorMessage(false) ?></div>
<?= $Page->folio_new->Lookup->getParamTag($Page, "p_x_folio_new") ?>
<script>
loadjs.ready("fshare_transfersrch", function() {
    var options = { name: "x_folio_new", selectId: "fshare_transfersrch_x_folio_new" };
    if (fshare_transfersrch.lists.folio_new?.lookupOptions.length) {
        options.data = { id: "x_folio_new", form: "fshare_transfersrch" };
    } else {
        options.ajax = { id: "x_folio_new", form: "fshare_transfersrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.share_transfer.fields.folio_new.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->folio_old->Visible) { // folio_old ?>
<?php
if (!$Page->folio_old->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_folio_old" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->folio_old->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->folio_old->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_folio_old" id="z_folio_old" value="LIKE">
</div>
        </div>
        <div id="el_share_transfer_folio_old" class="ew-search-field">
    <select
        id="x_folio_old"
        name="x_folio_old"
        class="form-control ew-select<?= $Page->folio_old->isInvalidClass() ?>"
        data-select2-id="fshare_transfersrch_x_folio_old"
        data-table="share_transfer"
        data-field="x_folio_old"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->folio_old->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->folio_old->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->folio_old->getPlaceHolder()) ?>"
        <?= $Page->folio_old->editAttributes() ?>>
        <?= $Page->folio_old->selectOptionListHtml("x_folio_old") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->folio_old->getErrorMessage(false) ?></div>
<?= $Page->folio_old->Lookup->getParamTag($Page, "p_x_folio_old") ?>
<script>
loadjs.ready("fshare_transfersrch", function() {
    var options = { name: "x_folio_old", selectId: "fshare_transfersrch_x_folio_old" };
    if (fshare_transfersrch.lists.folio_old?.lookupOptions.length) {
        options.data = { id: "x_folio_old", form: "fshare_transfersrch" };
    } else {
        options.ajax = { id: "x_folio_old", form: "fshare_transfersrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.share_transfer.fields.folio_old.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->adviser->Visible) { // adviser ?>
<?php
if (!$Page->adviser->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_adviser" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->adviser->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_adviser" class="ew-search-caption ew-label"><?= $Page->adviser->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_adviser" id="z_adviser" value="=">
</div>
        </div>
        <div id="el_share_transfer_adviser" class="ew-search-field">
    <select
        id="x_adviser"
        name="x_adviser"
        class="form-select ew-select<?= $Page->adviser->isInvalidClass() ?>"
        <?php if (!$Page->adviser->IsNativeSelect) { ?>
        data-select2-id="fshare_transfersrch_x_adviser"
        <?php } ?>
        data-table="share_transfer"
        data-field="x_adviser"
        data-value-separator="<?= $Page->adviser->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->adviser->getPlaceHolder()) ?>"
        <?= $Page->adviser->editAttributes() ?>>
        <?= $Page->adviser->selectOptionListHtml("x_adviser") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->adviser->getErrorMessage(false) ?></div>
<?= $Page->adviser->Lookup->getParamTag($Page, "p_x_adviser") ?>
<?php if (!$Page->adviser->IsNativeSelect) { ?>
<script>
loadjs.ready("fshare_transfersrch", function() {
    var options = { name: "x_adviser", selectId: "fshare_transfersrch_x_adviser" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshare_transfersrch.lists.adviser?.lookupOptions.length) {
        options.data = { id: "x_adviser", form: "fshare_transfersrch" };
    } else {
        options.ajax = { id: "x_adviser", form: "fshare_transfersrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.share_transfer.fields.adviser.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fshare_transfersrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fshare_transfersrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fshare_transfersrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fshare_transfersrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fshare_transfersrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fshare_transfersrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fshare_transfersrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="share_transfer">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_share_transfer" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_share_transferlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_share_transfer_id" class="share_transfer_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->folio_new->Visible) { // folio_new ?>
        <th data-name="folio_new" class="<?= $Page->folio_new->headerCellClass() ?>"><div id="elh_share_transfer_folio_new" class="share_transfer_folio_new"><?= $Page->renderFieldHeader($Page->folio_new) ?></div></th>
<?php } ?>
<?php if ($Page->folio_old->Visible) { // folio_old ?>
        <th data-name="folio_old" class="<?= $Page->folio_old->headerCellClass() ?>"><div id="elh_share_transfer_folio_old" class="share_transfer_folio_old"><?= $Page->renderFieldHeader($Page->folio_old) ?></div></th>
<?php } ?>
<?php if ($Page->adviser->Visible) { // adviser ?>
        <th data-name="adviser" class="<?= $Page->adviser->headerCellClass() ?>"><div id="elh_share_transfer_adviser" class="share_transfer_adviser"><?= $Page->renderFieldHeader($Page->adviser) ?></div></th>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
        <th data-name="quantity" class="<?= $Page->quantity->headerCellClass() ?>"><div id="elh_share_transfer_quantity" class="share_transfer_quantity"><?= $Page->renderFieldHeader($Page->quantity) ?></div></th>
<?php } ?>
<?php if ($Page->transfer_date->Visible) { // transfer_date ?>
        <th data-name="transfer_date" class="<?= $Page->transfer_date->headerCellClass() ?>"><div id="elh_share_transfer_transfer_date" class="share_transfer_transfer_date"><?= $Page->renderFieldHeader($Page->transfer_date) ?></div></th>
<?php } ?>
<?php if ($Page->share_no_start->Visible) { // share_no_start ?>
        <th data-name="share_no_start" class="<?= $Page->share_no_start->headerCellClass() ?>"><div id="elh_share_transfer_share_no_start" class="share_transfer_share_no_start"><?= $Page->renderFieldHeader($Page->share_no_start) ?></div></th>
<?php } ?>
<?php if ($Page->share_no_end->Visible) { // share_no_end ?>
        <th data-name="share_no_end" class="<?= $Page->share_no_end->headerCellClass() ?>"><div id="elh_share_transfer_share_no_end" class="share_transfer_share_no_end"><?= $Page->renderFieldHeader($Page->share_no_end) ?></div></th>
<?php } ?>
<?php if ($Page->pan->Visible) { // pan ?>
        <th data-name="pan" class="<?= $Page->pan->headerCellClass() ?>"><div id="elh_share_transfer_pan" class="share_transfer_pan"><?= $Page->renderFieldHeader($Page->pan) ?></div></th>
<?php } ?>
<?php if ($Page->aadhaar->Visible) { // aadhaar ?>
        <th data-name="aadhaar" class="<?= $Page->aadhaar->headerCellClass() ?>"><div id="elh_share_transfer_aadhaar" class="share_transfer_aadhaar"><?= $Page->renderFieldHeader($Page->aadhaar) ?></div></th>
<?php } ?>
<?php if ($Page->duty_folio_new->Visible) { // duty_folio_new ?>
        <th data-name="duty_folio_new" class="<?= $Page->duty_folio_new->headerCellClass() ?>"><div id="elh_share_transfer_duty_folio_new" class="share_transfer_duty_folio_new"><?= $Page->renderFieldHeader($Page->duty_folio_new) ?></div></th>
<?php } ?>
<?php if ($Page->duty_company->Visible) { // duty_company ?>
        <th data-name="duty_company" class="<?= $Page->duty_company->headerCellClass() ?>"><div id="elh_share_transfer_duty_company" class="share_transfer_duty_company"><?= $Page->renderFieldHeader($Page->duty_company) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_share_transfer_operator" class="share_transfer_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_share_transfer_datetime" class="share_transfer_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_id" class="el_share_transfer_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->folio_new->Visible) { // folio_new ?>
        <td data-name="folio_new"<?= $Page->folio_new->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_folio_new" class="el_share_transfer_folio_new">
<span<?= $Page->folio_new->viewAttributes() ?>>
<?= $Page->folio_new->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->folio_old->Visible) { // folio_old ?>
        <td data-name="folio_old"<?= $Page->folio_old->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_folio_old" class="el_share_transfer_folio_old">
<span<?= $Page->folio_old->viewAttributes() ?>>
<?= $Page->folio_old->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->adviser->Visible) { // adviser ?>
        <td data-name="adviser"<?= $Page->adviser->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_adviser" class="el_share_transfer_adviser">
<span<?= $Page->adviser->viewAttributes() ?>>
<?= $Page->adviser->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity"<?= $Page->quantity->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_quantity" class="el_share_transfer_quantity">
<span<?= $Page->quantity->viewAttributes() ?>>
<?= $Page->quantity->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->transfer_date->Visible) { // transfer_date ?>
        <td data-name="transfer_date"<?= $Page->transfer_date->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_transfer_date" class="el_share_transfer_transfer_date">
<span<?= $Page->transfer_date->viewAttributes() ?>>
<?= $Page->transfer_date->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->share_no_start->Visible) { // share_no_start ?>
        <td data-name="share_no_start"<?= $Page->share_no_start->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_share_no_start" class="el_share_transfer_share_no_start">
<span<?= $Page->share_no_start->viewAttributes() ?>>
<?= $Page->share_no_start->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->share_no_end->Visible) { // share_no_end ?>
        <td data-name="share_no_end"<?= $Page->share_no_end->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_share_no_end" class="el_share_transfer_share_no_end">
<span<?= $Page->share_no_end->viewAttributes() ?>>
<?= $Page->share_no_end->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pan->Visible) { // pan ?>
        <td data-name="pan"<?= $Page->pan->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_pan" class="el_share_transfer_pan">
<span<?= $Page->pan->viewAttributes() ?>>
<?= $Page->pan->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->aadhaar->Visible) { // aadhaar ?>
        <td data-name="aadhaar"<?= $Page->aadhaar->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_aadhaar" class="el_share_transfer_aadhaar">
<span<?= $Page->aadhaar->viewAttributes() ?>>
<?= $Page->aadhaar->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->duty_folio_new->Visible) { // duty_folio_new ?>
        <td data-name="duty_folio_new"<?= $Page->duty_folio_new->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_duty_folio_new" class="el_share_transfer_duty_folio_new">
<span<?= $Page->duty_folio_new->viewAttributes() ?>>
<?= $Page->duty_folio_new->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->duty_company->Visible) { // duty_company ?>
        <td data-name="duty_company"<?= $Page->duty_company->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_duty_company" class="el_share_transfer_duty_company">
<span<?= $Page->duty_company->viewAttributes() ?>>
<?= $Page->duty_company->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_operator" class="el_share_transfer_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_share_transfer_datetime" class="el_share_transfer_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_share_transfer_id" class="share_transfer_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->folio_new->Visible) { // folio_new ?>
        <td data-name="folio_new" class="<?= $Page->folio_new->footerCellClass() ?>"><span id="elf_share_transfer_folio_new" class="share_transfer_folio_new">
        </span></td>
    <?php } ?>
    <?php if ($Page->folio_old->Visible) { // folio_old ?>
        <td data-name="folio_old" class="<?= $Page->folio_old->footerCellClass() ?>"><span id="elf_share_transfer_folio_old" class="share_transfer_folio_old">
        </span></td>
    <?php } ?>
    <?php if ($Page->adviser->Visible) { // adviser ?>
        <td data-name="adviser" class="<?= $Page->adviser->footerCellClass() ?>"><span id="elf_share_transfer_adviser" class="share_transfer_adviser">
        </span></td>
    <?php } ?>
    <?php if ($Page->quantity->Visible) { // quantity ?>
        <td data-name="quantity" class="<?= $Page->quantity->footerCellClass() ?>"><span id="elf_share_transfer_quantity" class="share_transfer_quantity">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->quantity->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->transfer_date->Visible) { // transfer_date ?>
        <td data-name="transfer_date" class="<?= $Page->transfer_date->footerCellClass() ?>"><span id="elf_share_transfer_transfer_date" class="share_transfer_transfer_date">
        </span></td>
    <?php } ?>
    <?php if ($Page->share_no_start->Visible) { // share_no_start ?>
        <td data-name="share_no_start" class="<?= $Page->share_no_start->footerCellClass() ?>"><span id="elf_share_transfer_share_no_start" class="share_transfer_share_no_start">
        </span></td>
    <?php } ?>
    <?php if ($Page->share_no_end->Visible) { // share_no_end ?>
        <td data-name="share_no_end" class="<?= $Page->share_no_end->footerCellClass() ?>"><span id="elf_share_transfer_share_no_end" class="share_transfer_share_no_end">
        </span></td>
    <?php } ?>
    <?php if ($Page->pan->Visible) { // pan ?>
        <td data-name="pan" class="<?= $Page->pan->footerCellClass() ?>"><span id="elf_share_transfer_pan" class="share_transfer_pan">
        </span></td>
    <?php } ?>
    <?php if ($Page->aadhaar->Visible) { // aadhaar ?>
        <td data-name="aadhaar" class="<?= $Page->aadhaar->footerCellClass() ?>"><span id="elf_share_transfer_aadhaar" class="share_transfer_aadhaar">
        </span></td>
    <?php } ?>
    <?php if ($Page->duty_folio_new->Visible) { // duty_folio_new ?>
        <td data-name="duty_folio_new" class="<?= $Page->duty_folio_new->footerCellClass() ?>"><span id="elf_share_transfer_duty_folio_new" class="share_transfer_duty_folio_new">
        </span></td>
    <?php } ?>
    <?php if ($Page->duty_company->Visible) { // duty_company ?>
        <td data-name="duty_company" class="<?= $Page->duty_company->footerCellClass() ?>"><span id="elf_share_transfer_duty_company" class="share_transfer_duty_company">
        </span></td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator" class="<?= $Page->operator->footerCellClass() ?>"><span id="elf_share_transfer_operator" class="share_transfer_operator">
        </span></td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime" class="<?= $Page->datetime->footerCellClass() ?>"><span id="elf_share_transfer_datetime" class="share_transfer_datetime">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("share_transfer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
