<?php

namespace PHPMaker2024\fibre;

// Page object
$ShareTransferAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { share_transfer: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fshare_transferadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fshare_transferadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["folio_new", [fields.folio_new.visible && fields.folio_new.required ? ew.Validators.required(fields.folio_new.caption) : null], fields.folio_new.isInvalid],
            ["folio_old", [fields.folio_old.visible && fields.folio_old.required ? ew.Validators.required(fields.folio_old.caption) : null, ew.Validators.integer], fields.folio_old.isInvalid],
            ["adviser", [fields.adviser.visible && fields.adviser.required ? ew.Validators.required(fields.adviser.caption) : null], fields.adviser.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.integer], fields.quantity.isInvalid],
            ["transfer_date", [fields.transfer_date.visible && fields.transfer_date.required ? ew.Validators.required(fields.transfer_date.caption) : null, ew.Validators.datetime(fields.transfer_date.clientFormatPattern)], fields.transfer_date.isInvalid],
            ["share_no_start", [fields.share_no_start.visible && fields.share_no_start.required ? ew.Validators.required(fields.share_no_start.caption) : null, ew.Validators.integer], fields.share_no_start.isInvalid],
            ["share_no_end", [fields.share_no_end.visible && fields.share_no_end.required ? ew.Validators.required(fields.share_no_end.caption) : null, ew.Validators.integer], fields.share_no_end.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "folio_new": <?= $Page->folio_new->toClientList($Page) ?>,
            "folio_old": <?= $Page->folio_old->toClientList($Page) ?>,
            "adviser": <?= $Page->adviser->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fshare_transferadd" id="fshare_transferadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="share_transfer">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->folio_new->Visible) { // folio_new ?>
    <div id="r_folio_new"<?= $Page->folio_new->rowAttributes() ?>>
        <label id="elh_share_transfer_folio_new" class="<?= $Page->LeftColumnClass ?>"><?= $Page->folio_new->caption() ?><?= $Page->folio_new->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->folio_new->cellAttributes() ?>>
<span id="el_share_transfer_folio_new">
    <select
        id="x_folio_new"
        name="x_folio_new"
        class="form-control ew-select<?= $Page->folio_new->isInvalidClass() ?>"
        data-select2-id="fshare_transferadd_x_folio_new"
        data-table="share_transfer"
        data-field="x_folio_new"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->folio_new->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->folio_new->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->folio_new->getPlaceHolder()) ?>"
        <?= $Page->folio_new->editAttributes() ?>>
        <?= $Page->folio_new->selectOptionListHtml("x_folio_new") ?>
    </select>
    <?= $Page->folio_new->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->folio_new->getErrorMessage() ?></div>
<?= $Page->folio_new->Lookup->getParamTag($Page, "p_x_folio_new") ?>
<script>
loadjs.ready("fshare_transferadd", function() {
    var options = { name: "x_folio_new", selectId: "fshare_transferadd_x_folio_new" };
    if (fshare_transferadd.lists.folio_new?.lookupOptions.length) {
        options.data = { id: "x_folio_new", form: "fshare_transferadd" };
    } else {
        options.ajax = { id: "x_folio_new", form: "fshare_transferadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.share_transfer.fields.folio_new.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->folio_old->Visible) { // folio_old ?>
    <div id="r_folio_old"<?= $Page->folio_old->rowAttributes() ?>>
        <label id="elh_share_transfer_folio_old" class="<?= $Page->LeftColumnClass ?>"><?= $Page->folio_old->caption() ?><?= $Page->folio_old->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->folio_old->cellAttributes() ?>>
<span id="el_share_transfer_folio_old">
    <select
        id="x_folio_old"
        name="x_folio_old"
        class="form-control ew-select<?= $Page->folio_old->isInvalidClass() ?>"
        data-select2-id="fshare_transferadd_x_folio_old"
        data-table="share_transfer"
        data-field="x_folio_old"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->folio_old->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->folio_old->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->folio_old->getPlaceHolder()) ?>"
        <?= $Page->folio_old->editAttributes() ?>>
        <?= $Page->folio_old->selectOptionListHtml("x_folio_old") ?>
    </select>
    <?= $Page->folio_old->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->folio_old->getErrorMessage() ?></div>
<?= $Page->folio_old->Lookup->getParamTag($Page, "p_x_folio_old") ?>
<script>
loadjs.ready("fshare_transferadd", function() {
    var options = { name: "x_folio_old", selectId: "fshare_transferadd_x_folio_old" };
    if (fshare_transferadd.lists.folio_old?.lookupOptions.length) {
        options.data = { id: "x_folio_old", form: "fshare_transferadd" };
    } else {
        options.ajax = { id: "x_folio_old", form: "fshare_transferadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.share_transfer.fields.folio_old.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->adviser->Visible) { // adviser ?>
    <div id="r_adviser"<?= $Page->adviser->rowAttributes() ?>>
        <label id="elh_share_transfer_adviser" for="x_adviser" class="<?= $Page->LeftColumnClass ?>"><?= $Page->adviser->caption() ?><?= $Page->adviser->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->adviser->cellAttributes() ?>>
<span id="el_share_transfer_adviser">
    <select
        id="x_adviser"
        name="x_adviser"
        class="form-select ew-select<?= $Page->adviser->isInvalidClass() ?>"
        <?php if (!$Page->adviser->IsNativeSelect) { ?>
        data-select2-id="fshare_transferadd_x_adviser"
        <?php } ?>
        data-table="share_transfer"
        data-field="x_adviser"
        data-value-separator="<?= $Page->adviser->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->adviser->getPlaceHolder()) ?>"
        <?= $Page->adviser->editAttributes() ?>>
        <?= $Page->adviser->selectOptionListHtml("x_adviser") ?>
    </select>
    <?= $Page->adviser->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->adviser->getErrorMessage() ?></div>
<?= $Page->adviser->Lookup->getParamTag($Page, "p_x_adviser") ?>
<?php if (!$Page->adviser->IsNativeSelect) { ?>
<script>
loadjs.ready("fshare_transferadd", function() {
    var options = { name: "x_adviser", selectId: "fshare_transferadd_x_adviser" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fshare_transferadd.lists.adviser?.lookupOptions.length) {
        options.data = { id: "x_adviser", form: "fshare_transferadd" };
    } else {
        options.ajax = { id: "x_adviser", form: "fshare_transferadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.share_transfer.fields.adviser.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_share_transfer_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_share_transfer_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="share_transfer" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->transfer_date->Visible) { // transfer_date ?>
    <div id="r_transfer_date"<?= $Page->transfer_date->rowAttributes() ?>>
        <label id="elh_share_transfer_transfer_date" for="x_transfer_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->transfer_date->caption() ?><?= $Page->transfer_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->transfer_date->cellAttributes() ?>>
<span id="el_share_transfer_transfer_date">
<input type="<?= $Page->transfer_date->getInputTextType() ?>" name="x_transfer_date" id="x_transfer_date" data-table="share_transfer" data-field="x_transfer_date" value="<?= $Page->transfer_date->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->transfer_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->transfer_date->formatPattern()) ?>"<?= $Page->transfer_date->editAttributes() ?> aria-describedby="x_transfer_date_help">
<?= $Page->transfer_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->transfer_date->getErrorMessage() ?></div>
<?php if (!$Page->transfer_date->ReadOnly && !$Page->transfer_date->Disabled && !isset($Page->transfer_date->EditAttrs["readonly"]) && !isset($Page->transfer_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fshare_transferadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fshare_transferadd", "x_transfer_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->share_no_start->Visible) { // share_no_start ?>
    <div id="r_share_no_start"<?= $Page->share_no_start->rowAttributes() ?>>
        <label id="elh_share_transfer_share_no_start" for="x_share_no_start" class="<?= $Page->LeftColumnClass ?>"><?= $Page->share_no_start->caption() ?><?= $Page->share_no_start->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->share_no_start->cellAttributes() ?>>
<span id="el_share_transfer_share_no_start">
<input type="<?= $Page->share_no_start->getInputTextType() ?>" name="x_share_no_start" id="x_share_no_start" data-table="share_transfer" data-field="x_share_no_start" value="<?= $Page->share_no_start->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->share_no_start->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->share_no_start->formatPattern()) ?>"<?= $Page->share_no_start->editAttributes() ?> aria-describedby="x_share_no_start_help">
<?= $Page->share_no_start->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->share_no_start->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->share_no_end->Visible) { // share_no_end ?>
    <div id="r_share_no_end"<?= $Page->share_no_end->rowAttributes() ?>>
        <label id="elh_share_transfer_share_no_end" for="x_share_no_end" class="<?= $Page->LeftColumnClass ?>"><?= $Page->share_no_end->caption() ?><?= $Page->share_no_end->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->share_no_end->cellAttributes() ?>>
<span id="el_share_transfer_share_no_end">
<input type="<?= $Page->share_no_end->getInputTextType() ?>" name="x_share_no_end" id="x_share_no_end" data-table="share_transfer" data-field="x_share_no_end" value="<?= $Page->share_no_end->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->share_no_end->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->share_no_end->formatPattern()) ?>"<?= $Page->share_no_end->editAttributes() ?> aria-describedby="x_share_no_end_help">
<?= $Page->share_no_end->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->share_no_end->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fshare_transferadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fshare_transferadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("share_transfer");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
