<?php

namespace PHPMaker2024\fibre;

// Page object
$ServiceScheduleSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { service_schedule: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fservice_schedulesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fservice_schedulesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["buyer_id", [ew.Validators.integer], fields.buyer_id.isInvalid],
            ["hardware_id", [], fields.hardware_id.isInvalid],
            ["service_type", [], fields.service_type.isInvalid],
            ["service_duedate", [ew.Validators.datetime(fields.service_duedate.clientFormatPattern)], fields.service_duedate.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["service_executive", [ew.Validators.integer], fields.service_executive.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "hardware_id": <?= $Page->hardware_id->toClientList($Page) ?>,
            "service_type": <?= $Page->service_type->toClientList($Page) ?>,
            "service_executive": <?= $Page->service_executive->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fservice_schedulesearch" id="fservice_schedulesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="service_schedule">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_schedule_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_schedule_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="service_schedule" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id" class="row"<?= $Page->buyer_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_schedule_buyer_id"><?= $Page->buyer_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_schedule_buyer_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-control ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        data-select2-id="fservice_schedulesearch_x_buyer_id"
        data-table="service_schedule"
        data-field="x_buyer_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<script>
loadjs.ready("fservice_schedulesearch", function() {
    var options = { name: "x_buyer_id", selectId: "fservice_schedulesearch_x_buyer_id" };
    if (fservice_schedulesearch.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fservice_schedulesearch" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fservice_schedulesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.service_schedule.fields.buyer_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->hardware_id->Visible) { // hardware_id ?>
    <div id="r_hardware_id" class="row"<?= $Page->hardware_id->rowAttributes() ?>>
        <label for="x_hardware_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_schedule_hardware_id"><?= $Page->hardware_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_hardware_id" id="z_hardware_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->hardware_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_schedule_hardware_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_hardware_id"
        name="x_hardware_id"
        class="form-select ew-select<?= $Page->hardware_id->isInvalidClass() ?>"
        <?php if (!$Page->hardware_id->IsNativeSelect) { ?>
        data-select2-id="fservice_schedulesearch_x_hardware_id"
        <?php } ?>
        data-table="service_schedule"
        data-field="x_hardware_id"
        data-value-separator="<?= $Page->hardware_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->hardware_id->getPlaceHolder()) ?>"
        <?= $Page->hardware_id->editAttributes() ?>>
        <?= $Page->hardware_id->selectOptionListHtml("x_hardware_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->hardware_id->getErrorMessage(false) ?></div>
<?= $Page->hardware_id->Lookup->getParamTag($Page, "p_x_hardware_id") ?>
<?php if (!$Page->hardware_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_schedulesearch", function() {
    var options = { name: "x_hardware_id", selectId: "fservice_schedulesearch_x_hardware_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_schedulesearch.lists.hardware_id?.lookupOptions.length) {
        options.data = { id: "x_hardware_id", form: "fservice_schedulesearch" };
    } else {
        options.ajax = { id: "x_hardware_id", form: "fservice_schedulesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_schedule.fields.hardware_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->service_type->Visible) { // service_type ?>
    <div id="r_service_type" class="row"<?= $Page->service_type->rowAttributes() ?>>
        <label for="x_service_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_schedule_service_type"><?= $Page->service_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_service_type" id="z_service_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->service_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_schedule_service_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_service_type"
        name="x_service_type"
        class="form-select ew-select<?= $Page->service_type->isInvalidClass() ?>"
        <?php if (!$Page->service_type->IsNativeSelect) { ?>
        data-select2-id="fservice_schedulesearch_x_service_type"
        <?php } ?>
        data-table="service_schedule"
        data-field="x_service_type"
        data-value-separator="<?= $Page->service_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->service_type->getPlaceHolder()) ?>"
        <?= $Page->service_type->editAttributes() ?>>
        <?= $Page->service_type->selectOptionListHtml("x_service_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->service_type->getErrorMessage(false) ?></div>
<?= $Page->service_type->Lookup->getParamTag($Page, "p_x_service_type") ?>
<?php if (!$Page->service_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_schedulesearch", function() {
    var options = { name: "x_service_type", selectId: "fservice_schedulesearch_x_service_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_schedulesearch.lists.service_type?.lookupOptions.length) {
        options.data = { id: "x_service_type", form: "fservice_schedulesearch" };
    } else {
        options.ajax = { id: "x_service_type", form: "fservice_schedulesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_schedule.fields.service_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->service_duedate->Visible) { // service_duedate ?>
    <div id="r_service_duedate" class="row"<?= $Page->service_duedate->rowAttributes() ?>>
        <label for="x_service_duedate" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_schedule_service_duedate"><?= $Page->service_duedate->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_service_duedate" id="z_service_duedate" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->service_duedate->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_schedule_service_duedate" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->service_duedate->getInputTextType() ?>" name="x_service_duedate" id="x_service_duedate" data-table="service_schedule" data-field="x_service_duedate" value="<?= $Page->service_duedate->EditValue ?>" placeholder="<?= HtmlEncode($Page->service_duedate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->service_duedate->formatPattern()) ?>"<?= $Page->service_duedate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->service_duedate->getErrorMessage(false) ?></div>
<?php if (!$Page->service_duedate->ReadOnly && !$Page->service_duedate->Disabled && !isset($Page->service_duedate->EditAttrs["readonly"]) && !isset($Page->service_duedate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_schedulesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_schedulesearch", "x_service_duedate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_schedule_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_schedule_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="service_schedule" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->service_executive->Visible) { // service_executive ?>
    <div id="r_service_executive" class="row"<?= $Page->service_executive->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_schedule_service_executive"><?= $Page->service_executive->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_service_executive" id="z_service_executive" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->service_executive->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_schedule_service_executive" class="ew-search-field ew-search-field-single">
    <select
        id="x_service_executive"
        name="x_service_executive"
        class="form-control ew-select<?= $Page->service_executive->isInvalidClass() ?>"
        data-select2-id="fservice_schedulesearch_x_service_executive"
        data-table="service_schedule"
        data-field="x_service_executive"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->service_executive->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->service_executive->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->service_executive->getPlaceHolder()) ?>"
        <?= $Page->service_executive->editAttributes() ?>>
        <?= $Page->service_executive->selectOptionListHtml("x_service_executive") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->service_executive->getErrorMessage(false) ?></div>
<?= $Page->service_executive->Lookup->getParamTag($Page, "p_x_service_executive") ?>
<script>
loadjs.ready("fservice_schedulesearch", function() {
    var options = { name: "x_service_executive", selectId: "fservice_schedulesearch_x_service_executive" };
    if (fservice_schedulesearch.lists.service_executive?.lookupOptions.length) {
        options.data = { id: "x_service_executive", form: "fservice_schedulesearch" };
    } else {
        options.ajax = { id: "x_service_executive", form: "fservice_schedulesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.service_schedule.fields.service_executive.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_schedule_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_schedule_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fservice_schedulesearch_x_operator"
        <?php } ?>
        data-table="service_schedule"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_schedulesearch", function() {
    var options = { name: "x_operator", selectId: "fservice_schedulesearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_schedulesearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fservice_schedulesearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fservice_schedulesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_schedule.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_schedule_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_schedule_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="service_schedule" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_schedulesearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_schedulesearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fservice_schedulesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fservice_schedulesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fservice_schedulesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("service_schedule");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
