<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("ServiceScheduleGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fservice_schedulegrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { service_schedule: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fservice_schedulegrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["hardware_id", [fields.hardware_id.visible && fields.hardware_id.required ? ew.Validators.required(fields.hardware_id.caption) : null], fields.hardware_id.isInvalid],
            ["service_duedate", [fields.service_duedate.visible && fields.service_duedate.required ? ew.Validators.required(fields.service_duedate.caption) : null, ew.Validators.datetime(fields.service_duedate.clientFormatPattern)], fields.service_duedate.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["service_executive", [fields.service_executive.visible && fields.service_executive.required ? ew.Validators.required(fields.service_executive.caption) : null], fields.service_executive.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["hardware_id",false],["service_duedate",false],["remarks",false],["service_executive",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "hardware_id": <?= $Grid->hardware_id->toClientList($Grid) ?>,
            "service_executive": <?= $Grid->service_executive->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fservice_schedulegrid" class="ew-form ew-list-form">
<div id="gmp_service_schedule" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_service_schedulegrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_service_schedule_id" class="service_schedule_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->hardware_id->Visible) { // hardware_id ?>
        <th data-name="hardware_id" class="<?= $Grid->hardware_id->headerCellClass() ?>"><div id="elh_service_schedule_hardware_id" class="service_schedule_hardware_id"><?= $Grid->renderFieldHeader($Grid->hardware_id) ?></div></th>
<?php } ?>
<?php if ($Grid->service_duedate->Visible) { // service_duedate ?>
        <th data-name="service_duedate" class="<?= $Grid->service_duedate->headerCellClass() ?>"><div id="elh_service_schedule_service_duedate" class="service_schedule_service_duedate"><?= $Grid->renderFieldHeader($Grid->service_duedate) ?></div></th>
<?php } ?>
<?php if ($Grid->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Grid->remarks->headerCellClass() ?>"><div id="elh_service_schedule_remarks" class="service_schedule_remarks"><?= $Grid->renderFieldHeader($Grid->remarks) ?></div></th>
<?php } ?>
<?php if ($Grid->service_executive->Visible) { // service_executive ?>
        <th data-name="service_executive" class="<?= $Grid->service_executive->headerCellClass() ?>"><div id="elh_service_schedule_service_executive" class="service_schedule_service_executive"><?= $Grid->renderFieldHeader($Grid->service_executive) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_id" class="el_service_schedule_id"></span>
<input type="hidden" data-table="service_schedule" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_id" class="el_service_schedule_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="service_schedule" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_id" class="el_service_schedule_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="service_schedule" data-field="x_id" data-hidden="1" name="fservice_schedulegrid$x<?= $Grid->RowIndex ?>_id" id="fservice_schedulegrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="service_schedule" data-field="x_id" data-hidden="1" data-old name="fservice_schedulegrid$o<?= $Grid->RowIndex ?>_id" id="fservice_schedulegrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="service_schedule" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->hardware_id->Visible) { // hardware_id ?>
        <td data-name="hardware_id"<?= $Grid->hardware_id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->hardware_id->getSessionValue() != "") { ?>
<span<?= $Grid->hardware_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->hardware_id->getDisplayValue($Grid->hardware_id->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_hardware_id" name="x<?= $Grid->RowIndex ?>_hardware_id" value="<?= HtmlEncode($Grid->hardware_id->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_hardware_id" class="el_service_schedule_hardware_id">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_hardware_id"
        name="x<?= $Grid->RowIndex ?>_hardware_id"
        class="form-select ew-select<?= $Grid->hardware_id->isInvalidClass() ?>"
        <?php if (!$Grid->hardware_id->IsNativeSelect) { ?>
        data-select2-id="fservice_schedulegrid_x<?= $Grid->RowIndex ?>_hardware_id"
        <?php } ?>
        data-table="service_schedule"
        data-field="x_hardware_id"
        data-value-separator="<?= $Grid->hardware_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->hardware_id->getPlaceHolder()) ?>"
        <?= $Grid->hardware_id->editAttributes() ?>>
        <?= $Grid->hardware_id->selectOptionListHtml("x{$Grid->RowIndex}_hardware_id") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "client_hardware_data") && !$Grid->hardware_id->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_hardware_id" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->hardware_id->caption() ?>" data-title="<?= $Grid->hardware_id->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_hardware_id" data-url="<?= GetUrl("clienthardwaredataaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->hardware_id->getErrorMessage() ?></div>
<?= $Grid->hardware_id->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_hardware_id") ?>
<?php if (!$Grid->hardware_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_schedulegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_hardware_id", selectId: "fservice_schedulegrid_x<?= $Grid->RowIndex ?>_hardware_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_schedulegrid.lists.hardware_id?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_hardware_id", form: "fservice_schedulegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_hardware_id", form: "fservice_schedulegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_schedule.fields.hardware_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<input type="hidden" data-table="service_schedule" data-field="x_hardware_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_hardware_id" id="o<?= $Grid->RowIndex ?>_hardware_id" value="<?= HtmlEncode($Grid->hardware_id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_hardware_id" class="el_service_schedule_hardware_id">
<span<?= $Grid->hardware_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->hardware_id->getDisplayValue($Grid->hardware_id->EditValue) ?></span></span>
<input type="hidden" data-table="service_schedule" data-field="x_hardware_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_hardware_id" id="x<?= $Grid->RowIndex ?>_hardware_id" value="<?= HtmlEncode($Grid->hardware_id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_hardware_id" class="el_service_schedule_hardware_id">
<span<?= $Grid->hardware_id->viewAttributes() ?>>
<?= $Grid->hardware_id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="service_schedule" data-field="x_hardware_id" data-hidden="1" name="fservice_schedulegrid$x<?= $Grid->RowIndex ?>_hardware_id" id="fservice_schedulegrid$x<?= $Grid->RowIndex ?>_hardware_id" value="<?= HtmlEncode($Grid->hardware_id->FormValue) ?>">
<input type="hidden" data-table="service_schedule" data-field="x_hardware_id" data-hidden="1" data-old name="fservice_schedulegrid$o<?= $Grid->RowIndex ?>_hardware_id" id="fservice_schedulegrid$o<?= $Grid->RowIndex ?>_hardware_id" value="<?= HtmlEncode($Grid->hardware_id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->service_duedate->Visible) { // service_duedate ?>
        <td data-name="service_duedate"<?= $Grid->service_duedate->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_service_duedate" class="el_service_schedule_service_duedate">
<input type="<?= $Grid->service_duedate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_service_duedate" id="x<?= $Grid->RowIndex ?>_service_duedate" data-table="service_schedule" data-field="x_service_duedate" value="<?= $Grid->service_duedate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->service_duedate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->service_duedate->formatPattern()) ?>"<?= $Grid->service_duedate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->service_duedate->getErrorMessage() ?></div>
<?php if (!$Grid->service_duedate->ReadOnly && !$Grid->service_duedate->Disabled && !isset($Grid->service_duedate->EditAttrs["readonly"]) && !isset($Grid->service_duedate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_schedulegrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_schedulegrid", "x<?= $Grid->RowIndex ?>_service_duedate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="service_schedule" data-field="x_service_duedate" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_service_duedate" id="o<?= $Grid->RowIndex ?>_service_duedate" value="<?= HtmlEncode($Grid->service_duedate->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_service_duedate" class="el_service_schedule_service_duedate">
<input type="<?= $Grid->service_duedate->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_service_duedate" id="x<?= $Grid->RowIndex ?>_service_duedate" data-table="service_schedule" data-field="x_service_duedate" value="<?= $Grid->service_duedate->EditValue ?>" placeholder="<?= HtmlEncode($Grid->service_duedate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->service_duedate->formatPattern()) ?>"<?= $Grid->service_duedate->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->service_duedate->getErrorMessage() ?></div>
<?php if (!$Grid->service_duedate->ReadOnly && !$Grid->service_duedate->Disabled && !isset($Grid->service_duedate->EditAttrs["readonly"]) && !isset($Grid->service_duedate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_schedulegrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_schedulegrid", "x<?= $Grid->RowIndex ?>_service_duedate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_service_duedate" class="el_service_schedule_service_duedate">
<span<?= $Grid->service_duedate->viewAttributes() ?>>
<?= $Grid->service_duedate->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="service_schedule" data-field="x_service_duedate" data-hidden="1" name="fservice_schedulegrid$x<?= $Grid->RowIndex ?>_service_duedate" id="fservice_schedulegrid$x<?= $Grid->RowIndex ?>_service_duedate" value="<?= HtmlEncode($Grid->service_duedate->FormValue) ?>">
<input type="hidden" data-table="service_schedule" data-field="x_service_duedate" data-hidden="1" data-old name="fservice_schedulegrid$o<?= $Grid->RowIndex ?>_service_duedate" id="fservice_schedulegrid$o<?= $Grid->RowIndex ?>_service_duedate" value="<?= HtmlEncode($Grid->service_duedate->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Grid->remarks->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_remarks" class="el_service_schedule_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="service_schedule" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="service_schedule" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_remarks" id="o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_remarks" class="el_service_schedule_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="service_schedule" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_remarks" class="el_service_schedule_remarks">
<span<?= $Grid->remarks->viewAttributes() ?>>
<?= $Grid->remarks->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="service_schedule" data-field="x_remarks" data-hidden="1" name="fservice_schedulegrid$x<?= $Grid->RowIndex ?>_remarks" id="fservice_schedulegrid$x<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->FormValue) ?>">
<input type="hidden" data-table="service_schedule" data-field="x_remarks" data-hidden="1" data-old name="fservice_schedulegrid$o<?= $Grid->RowIndex ?>_remarks" id="fservice_schedulegrid$o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->service_executive->Visible) { // service_executive ?>
        <td data-name="service_executive"<?= $Grid->service_executive->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_service_executive" class="el_service_schedule_service_executive">
    <select
        id="x<?= $Grid->RowIndex ?>_service_executive"
        name="x<?= $Grid->RowIndex ?>_service_executive"
        class="form-control ew-select<?= $Grid->service_executive->isInvalidClass() ?>"
        data-select2-id="fservice_schedulegrid_x<?= $Grid->RowIndex ?>_service_executive"
        data-table="service_schedule"
        data-field="x_service_executive"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->service_executive->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->service_executive->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->service_executive->getPlaceHolder()) ?>"
        <?= $Grid->service_executive->editAttributes() ?>>
        <?= $Grid->service_executive->selectOptionListHtml("x{$Grid->RowIndex}_service_executive") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->service_executive->getErrorMessage() ?></div>
<?= $Grid->service_executive->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_service_executive") ?>
<script>
loadjs.ready("fservice_schedulegrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_service_executive", selectId: "fservice_schedulegrid_x<?= $Grid->RowIndex ?>_service_executive" };
    if (fservice_schedulegrid.lists.service_executive?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_service_executive", form: "fservice_schedulegrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_service_executive", form: "fservice_schedulegrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.service_schedule.fields.service_executive.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<input type="hidden" data-table="service_schedule" data-field="x_service_executive" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_service_executive" id="o<?= $Grid->RowIndex ?>_service_executive" value="<?= HtmlEncode($Grid->service_executive->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_service_executive" class="el_service_schedule_service_executive">
<span<?= $Grid->service_executive->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->service_executive->getDisplayValue($Grid->service_executive->EditValue) ?></span></span>
<input type="hidden" data-table="service_schedule" data-field="x_service_executive" data-hidden="1" name="x<?= $Grid->RowIndex ?>_service_executive" id="x<?= $Grid->RowIndex ?>_service_executive" value="<?= HtmlEncode($Grid->service_executive->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_service_schedule_service_executive" class="el_service_schedule_service_executive">
<span<?= $Grid->service_executive->viewAttributes() ?>>
<?= $Grid->service_executive->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="service_schedule" data-field="x_service_executive" data-hidden="1" name="fservice_schedulegrid$x<?= $Grid->RowIndex ?>_service_executive" id="fservice_schedulegrid$x<?= $Grid->RowIndex ?>_service_executive" value="<?= HtmlEncode($Grid->service_executive->FormValue) ?>">
<input type="hidden" data-table="service_schedule" data-field="x_service_executive" data-hidden="1" data-old name="fservice_schedulegrid$o<?= $Grid->RowIndex ?>_service_executive" id="fservice_schedulegrid$o<?= $Grid->RowIndex ?>_service_executive" value="<?= HtmlEncode($Grid->service_executive->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fservice_schedulegrid","load"], () => fservice_schedulegrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fservice_schedulegrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("service_schedule");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
