<?php

namespace PHPMaker2024\fibre;

// Page object
$ServiceScheduleEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fservice_scheduleedit" id="fservice_scheduleedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { service_schedule: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fservice_scheduleedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fservice_scheduleedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["hardware_id", [fields.hardware_id.visible && fields.hardware_id.required ? ew.Validators.required(fields.hardware_id.caption) : null], fields.hardware_id.isInvalid],
            ["service_type", [fields.service_type.visible && fields.service_type.required ? ew.Validators.required(fields.service_type.caption) : null], fields.service_type.isInvalid],
            ["service_duedate", [fields.service_duedate.visible && fields.service_duedate.required ? ew.Validators.required(fields.service_duedate.caption) : null, ew.Validators.datetime(fields.service_duedate.clientFormatPattern)], fields.service_duedate.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["service_executive", [fields.service_executive.visible && fields.service_executive.required ? ew.Validators.required(fields.service_executive.caption) : null], fields.service_executive.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "service_type": <?= $Page->service_type->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="service_schedule">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<?php if ($Page->getCurrentMasterTable() == "client_hardware_data") { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="client_hardware_data">
<input type="hidden" name="fk_id" value="<?= HtmlEncode($Page->hardware_id->getSessionValue()) ?>">
<?php } ?>
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_service_schedule_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_service_schedule_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="service_schedule" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <label id="elh_service_schedule_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_id->caption() ?><?= $Page->buyer_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_service_schedule_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->buyer_id->getDisplayValue($Page->buyer_id->EditValue) ?></span></span>
<input type="hidden" data-table="service_schedule" data-field="x_buyer_id" data-hidden="1" name="x_buyer_id" id="x_buyer_id" value="<?= HtmlEncode($Page->buyer_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->hardware_id->Visible) { // hardware_id ?>
    <div id="r_hardware_id"<?= $Page->hardware_id->rowAttributes() ?>>
        <label id="elh_service_schedule_hardware_id" for="x_hardware_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->hardware_id->caption() ?><?= $Page->hardware_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->hardware_id->cellAttributes() ?>>
<span id="el_service_schedule_hardware_id">
<span<?= $Page->hardware_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->hardware_id->getDisplayValue($Page->hardware_id->EditValue) ?></span></span>
<input type="hidden" data-table="service_schedule" data-field="x_hardware_id" data-hidden="1" name="x_hardware_id" id="x_hardware_id" value="<?= HtmlEncode($Page->hardware_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->service_type->Visible) { // service_type ?>
    <div id="r_service_type"<?= $Page->service_type->rowAttributes() ?>>
        <label id="elh_service_schedule_service_type" for="x_service_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->service_type->caption() ?><?= $Page->service_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->service_type->cellAttributes() ?>>
<span id="el_service_schedule_service_type">
<div class="input-group flex-nowrap">
    <select
        id="x_service_type"
        name="x_service_type"
        class="form-select ew-select<?= $Page->service_type->isInvalidClass() ?>"
        <?php if (!$Page->service_type->IsNativeSelect) { ?>
        data-select2-id="fservice_scheduleedit_x_service_type"
        <?php } ?>
        data-table="service_schedule"
        data-field="x_service_type"
        data-value-separator="<?= $Page->service_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->service_type->getPlaceHolder()) ?>"
        <?= $Page->service_type->editAttributes() ?>>
        <?= $Page->service_type->selectOptionListHtml("x_service_type") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "service_misc") && !$Page->service_type->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_service_type" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->service_type->caption() ?>" data-title="<?= $Page->service_type->caption() ?>" data-ew-action="add-option" data-el="x_service_type" data-url="<?= GetUrl("servicemiscaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->service_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->service_type->getErrorMessage() ?></div>
<?= $Page->service_type->Lookup->getParamTag($Page, "p_x_service_type") ?>
<?php if (!$Page->service_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_scheduleedit", function() {
    var options = { name: "x_service_type", selectId: "fservice_scheduleedit_x_service_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_scheduleedit.lists.service_type?.lookupOptions.length) {
        options.data = { id: "x_service_type", form: "fservice_scheduleedit" };
    } else {
        options.ajax = { id: "x_service_type", form: "fservice_scheduleedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_schedule.fields.service_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->service_duedate->Visible) { // service_duedate ?>
    <div id="r_service_duedate"<?= $Page->service_duedate->rowAttributes() ?>>
        <label id="elh_service_schedule_service_duedate" for="x_service_duedate" class="<?= $Page->LeftColumnClass ?>"><?= $Page->service_duedate->caption() ?><?= $Page->service_duedate->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->service_duedate->cellAttributes() ?>>
<span id="el_service_schedule_service_duedate">
<input type="<?= $Page->service_duedate->getInputTextType() ?>" name="x_service_duedate" id="x_service_duedate" data-table="service_schedule" data-field="x_service_duedate" value="<?= $Page->service_duedate->EditValue ?>" placeholder="<?= HtmlEncode($Page->service_duedate->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->service_duedate->formatPattern()) ?>"<?= $Page->service_duedate->editAttributes() ?> aria-describedby="x_service_duedate_help">
<?= $Page->service_duedate->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->service_duedate->getErrorMessage() ?></div>
<?php if (!$Page->service_duedate->ReadOnly && !$Page->service_duedate->Disabled && !isset($Page->service_duedate->EditAttrs["readonly"]) && !isset($Page->service_duedate->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_scheduleedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_scheduleedit", "x_service_duedate", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_service_schedule_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_service_schedule_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="service_schedule" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help">
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->service_executive->Visible) { // service_executive ?>
    <div id="r_service_executive"<?= $Page->service_executive->rowAttributes() ?>>
        <label id="elh_service_schedule_service_executive" class="<?= $Page->LeftColumnClass ?>"><?= $Page->service_executive->caption() ?><?= $Page->service_executive->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->service_executive->cellAttributes() ?>>
<span id="el_service_schedule_service_executive">
<span<?= $Page->service_executive->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->service_executive->getDisplayValue($Page->service_executive->EditValue) ?></span></span>
<input type="hidden" data-table="service_schedule" data-field="x_service_executive" data-hidden="1" name="x_service_executive" id="x_service_executive" value="<?= HtmlEncode($Page->service_executive->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fservice_scheduleedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fservice_scheduleedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("service_schedule");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
