<?php

namespace PHPMaker2024\fibre;

// Page object
$ServiceRequestSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { service_request: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fservice_requestsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fservice_requestsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["buyer_id", [ew.Validators.integer], fields.buyer_id.isInvalid],
            ["product_ref", [], fields.product_ref.isInvalid],
            ["current_reading", [ew.Validators.integer], fields.current_reading.isInvalid],
            ["product_status", [], fields.product_status.isInvalid],
            ["_error", [], fields._error.isInvalid],
            ["last_serve", [ew.Validators.datetime(fields.last_serve.clientFormatPattern)], fields.last_serve.isInvalid],
            ["last_serve_by", [], fields.last_serve_by.isInvalid],
            ["query_by", [], fields.query_by.isInvalid],
            ["service_executive", [], fields.service_executive.isInvalid],
            ["Ins_service_executive", [], fields.Ins_service_executive.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["o_operator", [ew.Validators.integer], fields.o_operator.isInvalid],
            ["o_datetime", [ew.Validators.datetime(fields.o_datetime.clientFormatPattern)], fields.o_datetime.isInvalid],
            ["master_reading", [ew.Validators.integer], fields.master_reading.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "status": <?= $Page->status->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "product_ref": <?= $Page->product_ref->toClientList($Page) ?>,
            "product_status": <?= $Page->product_status->toClientList($Page) ?>,
            "last_serve_by": <?= $Page->last_serve_by->toClientList($Page) ?>,
            "service_executive": <?= $Page->service_executive->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fservice_requestsearch" id="fservice_requestsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="service_request">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="service_request" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fservice_requestsearch_x_status"
        <?php } ?>
        data-table="service_request"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_requestsearch", function() {
    var options = { name: "x_status", selectId: "fservice_requestsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_requestsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fservice_requestsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fservice_requestsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_request.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id" class="row"<?= $Page->buyer_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_buyer_id"><?= $Page->buyer_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_buyer_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-control ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        data-select2-id="fservice_requestsearch_x_buyer_id"
        data-table="service_request"
        data-field="x_buyer_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<script>
loadjs.ready("fservice_requestsearch", function() {
    var options = { name: "x_buyer_id", selectId: "fservice_requestsearch_x_buyer_id" };
    if (fservice_requestsearch.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fservice_requestsearch" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fservice_requestsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.service_request.fields.buyer_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_ref->Visible) { // product_ref ?>
    <div id="r_product_ref" class="row"<?= $Page->product_ref->rowAttributes() ?>>
        <label for="x_product_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_product_ref"><?= $Page->product_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_ref" id="z_product_ref" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_product_ref" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_ref"
        name="x_product_ref"
        class="form-control ew-select<?= $Page->product_ref->isInvalidClass() ?>"
        data-select2-id="fservice_requestsearch_x_product_ref"
        data-table="service_request"
        data-field="x_product_ref"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->product_ref->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->product_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_ref->getPlaceHolder()) ?>"
        <?= $Page->product_ref->editAttributes() ?>>
        <?= $Page->product_ref->selectOptionListHtml("x_product_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_ref->getErrorMessage(false) ?></div>
<?= $Page->product_ref->Lookup->getParamTag($Page, "p_x_product_ref") ?>
<script>
loadjs.ready("fservice_requestsearch", function() {
    var options = { name: "x_product_ref", selectId: "fservice_requestsearch_x_product_ref" };
    if (fservice_requestsearch.lists.product_ref?.lookupOptions.length) {
        options.data = { id: "x_product_ref", form: "fservice_requestsearch" };
    } else {
        options.ajax = { id: "x_product_ref", form: "fservice_requestsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.service_request.fields.product_ref.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->current_reading->Visible) { // current_reading ?>
    <div id="r_current_reading" class="row"<?= $Page->current_reading->rowAttributes() ?>>
        <label for="x_current_reading" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_current_reading"><?= $Page->current_reading->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_current_reading" id="z_current_reading" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->current_reading->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_current_reading" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->current_reading->getInputTextType() ?>" name="x_current_reading" id="x_current_reading" data-table="service_request" data-field="x_current_reading" value="<?= $Page->current_reading->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->current_reading->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->current_reading->formatPattern()) ?>"<?= $Page->current_reading->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->current_reading->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_status->Visible) { // product_status ?>
    <div id="r_product_status" class="row"<?= $Page->product_status->rowAttributes() ?>>
        <label for="x_product_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_product_status"><?= $Page->product_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_product_status" id="z_product_status" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_product_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_product_status"
        name="x_product_status"
        class="form-select ew-select<?= $Page->product_status->isInvalidClass() ?>"
        <?php if (!$Page->product_status->IsNativeSelect) { ?>
        data-select2-id="fservice_requestsearch_x_product_status"
        <?php } ?>
        data-table="service_request"
        data-field="x_product_status"
        data-value-separator="<?= $Page->product_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_status->getPlaceHolder()) ?>"
        <?= $Page->product_status->editAttributes() ?>>
        <?= $Page->product_status->selectOptionListHtml("x_product_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->product_status->getErrorMessage(false) ?></div>
<?= $Page->product_status->Lookup->getParamTag($Page, "p_x_product_status") ?>
<?php if (!$Page->product_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_requestsearch", function() {
    var options = { name: "x_product_status", selectId: "fservice_requestsearch_x_product_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_requestsearch.lists.product_status?.lookupOptions.length) {
        options.data = { id: "x_product_status", form: "fservice_requestsearch" };
    } else {
        options.ajax = { id: "x_product_status", form: "fservice_requestsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_request.fields.product_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_error->Visible) { // error ?>
    <div id="r__error" class="row"<?= $Page->_error->rowAttributes() ?>>
        <label for="x__error" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request__error"><?= $Page->_error->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__error" id="z__error" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_error->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request__error" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_error->getInputTextType() ?>" name="x__error" id="x__error" data-table="service_request" data-field="x__error" value="<?= $Page->_error->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->_error->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_error->formatPattern()) ?>"<?= $Page->_error->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_error->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->last_serve->Visible) { // last_serve ?>
    <div id="r_last_serve" class="row"<?= $Page->last_serve->rowAttributes() ?>>
        <label for="x_last_serve" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_last_serve"><?= $Page->last_serve->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_last_serve" id="z_last_serve" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->last_serve->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_last_serve" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->last_serve->getInputTextType() ?>" name="x_last_serve" id="x_last_serve" data-table="service_request" data-field="x_last_serve" value="<?= $Page->last_serve->EditValue ?>" placeholder="<?= HtmlEncode($Page->last_serve->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->last_serve->formatPattern()) ?>"<?= $Page->last_serve->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->last_serve->getErrorMessage(false) ?></div>
<?php if (!$Page->last_serve->ReadOnly && !$Page->last_serve->Disabled && !isset($Page->last_serve->EditAttrs["readonly"]) && !isset($Page->last_serve->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_requestsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_requestsearch", "x_last_serve", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->last_serve_by->Visible) { // last_serve_by ?>
    <div id="r_last_serve_by" class="row"<?= $Page->last_serve_by->rowAttributes() ?>>
        <label for="x_last_serve_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_last_serve_by"><?= $Page->last_serve_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_last_serve_by" id="z_last_serve_by" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->last_serve_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_last_serve_by" class="ew-search-field ew-search-field-single">
    <select
        id="x_last_serve_by"
        name="x_last_serve_by"
        class="form-select ew-select<?= $Page->last_serve_by->isInvalidClass() ?>"
        <?php if (!$Page->last_serve_by->IsNativeSelect) { ?>
        data-select2-id="fservice_requestsearch_x_last_serve_by"
        <?php } ?>
        data-table="service_request"
        data-field="x_last_serve_by"
        data-value-separator="<?= $Page->last_serve_by->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->last_serve_by->getPlaceHolder()) ?>"
        <?= $Page->last_serve_by->editAttributes() ?>>
        <?= $Page->last_serve_by->selectOptionListHtml("x_last_serve_by") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->last_serve_by->getErrorMessage(false) ?></div>
<?= $Page->last_serve_by->Lookup->getParamTag($Page, "p_x_last_serve_by") ?>
<?php if (!$Page->last_serve_by->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_requestsearch", function() {
    var options = { name: "x_last_serve_by", selectId: "fservice_requestsearch_x_last_serve_by" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_requestsearch.lists.last_serve_by?.lookupOptions.length) {
        options.data = { id: "x_last_serve_by", form: "fservice_requestsearch" };
    } else {
        options.ajax = { id: "x_last_serve_by", form: "fservice_requestsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_request.fields.last_serve_by.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->query_by->Visible) { // query_by ?>
    <div id="r_query_by" class="row"<?= $Page->query_by->rowAttributes() ?>>
        <label for="x_query_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_query_by"><?= $Page->query_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_query_by" id="z_query_by" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->query_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_query_by" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->query_by->getInputTextType() ?>" name="x_query_by" id="x_query_by" data-table="service_request" data-field="x_query_by" value="<?= $Page->query_by->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->query_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->query_by->formatPattern()) ?>"<?= $Page->query_by->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->query_by->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->service_executive->Visible) { // service_executive ?>
    <div id="r_service_executive" class="row"<?= $Page->service_executive->rowAttributes() ?>>
        <label for="x_service_executive" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_service_executive"><?= $Page->service_executive->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_service_executive" id="z_service_executive" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->service_executive->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_service_executive" class="ew-search-field ew-search-field-single">
    <select
        id="x_service_executive"
        name="x_service_executive"
        class="form-select ew-select<?= $Page->service_executive->isInvalidClass() ?>"
        <?php if (!$Page->service_executive->IsNativeSelect) { ?>
        data-select2-id="fservice_requestsearch_x_service_executive"
        <?php } ?>
        data-table="service_request"
        data-field="x_service_executive"
        data-value-separator="<?= $Page->service_executive->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->service_executive->getPlaceHolder()) ?>"
        <?= $Page->service_executive->editAttributes() ?>>
        <?= $Page->service_executive->selectOptionListHtml("x_service_executive") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->service_executive->getErrorMessage(false) ?></div>
<?= $Page->service_executive->Lookup->getParamTag($Page, "p_x_service_executive") ?>
<?php if (!$Page->service_executive->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_requestsearch", function() {
    var options = { name: "x_service_executive", selectId: "fservice_requestsearch_x_service_executive" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_requestsearch.lists.service_executive?.lookupOptions.length) {
        options.data = { id: "x_service_executive", form: "fservice_requestsearch" };
    } else {
        options.ajax = { id: "x_service_executive", form: "fservice_requestsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_request.fields.service_executive.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Ins_service_executive->Visible) { // Ins_service_executive ?>
    <div id="r_Ins_service_executive" class="row"<?= $Page->Ins_service_executive->rowAttributes() ?>>
        <label for="x_Ins_service_executive" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_Ins_service_executive"><?= $Page->Ins_service_executive->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Ins_service_executive" id="z_Ins_service_executive" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Ins_service_executive->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_Ins_service_executive" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Ins_service_executive->getInputTextType() ?>" name="x_Ins_service_executive" id="x_Ins_service_executive" data-table="service_request" data-field="x_Ins_service_executive" value="<?= $Page->Ins_service_executive->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->Ins_service_executive->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Ins_service_executive->formatPattern()) ?>"<?= $Page->Ins_service_executive->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Ins_service_executive->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="service_request" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="service_request" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_requestsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_requestsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->o_operator->Visible) { // o_operator ?>
    <div id="r_o_operator" class="row"<?= $Page->o_operator->rowAttributes() ?>>
        <label for="x_o_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_o_operator"><?= $Page->o_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_o_operator" id="z_o_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->o_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_o_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->o_operator->getInputTextType() ?>" name="x_o_operator" id="x_o_operator" data-table="service_request" data-field="x_o_operator" value="<?= $Page->o_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->o_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->o_operator->formatPattern()) ?>"<?= $Page->o_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->o_operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->o_datetime->Visible) { // o_datetime ?>
    <div id="r_o_datetime" class="row"<?= $Page->o_datetime->rowAttributes() ?>>
        <label for="x_o_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_o_datetime"><?= $Page->o_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_o_datetime" id="z_o_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->o_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_o_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->o_datetime->getInputTextType() ?>" name="x_o_datetime" id="x_o_datetime" data-table="service_request" data-field="x_o_datetime" value="<?= $Page->o_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->o_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->o_datetime->formatPattern()) ?>"<?= $Page->o_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->o_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->o_datetime->ReadOnly && !$Page->o_datetime->Disabled && !isset($Page->o_datetime->EditAttrs["readonly"]) && !isset($Page->o_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_requestsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_requestsearch", "x_o_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->master_reading->Visible) { // master_reading ?>
    <div id="r_master_reading" class="row"<?= $Page->master_reading->rowAttributes() ?>>
        <label for="x_master_reading" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_request_master_reading"><?= $Page->master_reading->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_master_reading" id="z_master_reading" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->master_reading->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_request_master_reading" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->master_reading->getInputTextType() ?>" name="x_master_reading" id="x_master_reading" data-table="service_request" data-field="x_master_reading" value="<?= $Page->master_reading->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->master_reading->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->master_reading->formatPattern()) ?>"<?= $Page->master_reading->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->master_reading->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fservice_requestsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fservice_requestsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fservice_requestsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("service_request");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
