<?php

namespace PHPMaker2024\fibre;

// Page object
$ServiceRequestAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { service_request: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fservice_requestadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fservice_requestadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null, ew.Validators.integer], fields.buyer_id.isInvalid],
            ["product_ref", [fields.product_ref.visible && fields.product_ref.required ? ew.Validators.required(fields.product_ref.caption) : null], fields.product_ref.isInvalid],
            ["current_reading", [fields.current_reading.visible && fields.current_reading.required ? ew.Validators.required(fields.current_reading.caption) : null, ew.Validators.integer], fields.current_reading.isInvalid],
            ["product_status", [fields.product_status.visible && fields.product_status.required ? ew.Validators.required(fields.product_status.caption) : null], fields.product_status.isInvalid],
            ["_error", [fields._error.visible && fields._error.required ? ew.Validators.required(fields._error.caption) : null], fields._error.isInvalid],
            ["query_by", [fields.query_by.visible && fields.query_by.required ? ew.Validators.required(fields.query_by.caption) : null], fields.query_by.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid],
            ["master_reading", [fields.master_reading.visible && fields.master_reading.required ? ew.Validators.required(fields.master_reading.caption) : null, ew.Validators.integer], fields.master_reading.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "product_ref": <?= $Page->product_ref->toClientList($Page) ?>,
            "product_status": <?= $Page->product_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fservice_requestadd" id="fservice_requestadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="service_request">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <label id="elh_service_request_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_id->caption() ?><?= $Page->buyer_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_service_request_buyer_id">
<div class="input-group flex-nowrap">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-control ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        data-select2-id="fservice_requestadd_x_buyer_id"
        data-table="service_request"
        data-field="x_buyer_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "buyer") && !$Page->buyer_id->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer_id" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->buyer_id->caption() ?>" data-title="<?= $Page->buyer_id->caption() ?>" data-ew-action="add-option" data-el="x_buyer_id" data-url="<?= GetUrl("buyeraddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->buyer_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage() ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<script>
loadjs.ready("fservice_requestadd", function() {
    var options = { name: "x_buyer_id", selectId: "fservice_requestadd_x_buyer_id" };
    if (fservice_requestadd.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fservice_requestadd" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fservice_requestadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.service_request.fields.buyer_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_ref->Visible) { // product_ref ?>
    <div id="r_product_ref"<?= $Page->product_ref->rowAttributes() ?>>
        <label id="elh_service_request_product_ref" for="x_product_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_ref->caption() ?><?= $Page->product_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_ref->cellAttributes() ?>>
<span id="el_service_request_product_ref">
<div class="input-group flex-nowrap">
    <select
        id="x_product_ref"
        name="x_product_ref"
        class="form-control ew-select<?= $Page->product_ref->isInvalidClass() ?>"
        data-select2-id="fservice_requestadd_x_product_ref"
        data-table="service_request"
        data-field="x_product_ref"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->product_ref->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->product_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_ref->getPlaceHolder()) ?>"
        <?= $Page->product_ref->editAttributes() ?>>
        <?= $Page->product_ref->selectOptionListHtml("x_product_ref") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "client_hardware_data") && !$Page->product_ref->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product_ref" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->product_ref->caption() ?>" data-title="<?= $Page->product_ref->caption() ?>" data-ew-action="add-option" data-el="x_product_ref" data-url="<?= GetUrl("clienthardwaredataaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->product_ref->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product_ref->getErrorMessage() ?></div>
<?= $Page->product_ref->Lookup->getParamTag($Page, "p_x_product_ref") ?>
<script>
loadjs.ready("fservice_requestadd", function() {
    var options = { name: "x_product_ref", selectId: "fservice_requestadd_x_product_ref" };
    if (fservice_requestadd.lists.product_ref?.lookupOptions.length) {
        options.data = { id: "x_product_ref", form: "fservice_requestadd" };
    } else {
        options.ajax = { id: "x_product_ref", form: "fservice_requestadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.service_request.fields.product_ref.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->current_reading->Visible) { // current_reading ?>
    <div id="r_current_reading"<?= $Page->current_reading->rowAttributes() ?>>
        <label id="elh_service_request_current_reading" for="x_current_reading" class="<?= $Page->LeftColumnClass ?>"><?= $Page->current_reading->caption() ?><?= $Page->current_reading->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->current_reading->cellAttributes() ?>>
<span id="el_service_request_current_reading">
<input type="<?= $Page->current_reading->getInputTextType() ?>" name="x_current_reading" id="x_current_reading" data-table="service_request" data-field="x_current_reading" value="<?= $Page->current_reading->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->current_reading->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->current_reading->formatPattern()) ?>"<?= $Page->current_reading->editAttributes() ?> aria-describedby="x_current_reading_help">
<?= $Page->current_reading->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->current_reading->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_status->Visible) { // product_status ?>
    <div id="r_product_status"<?= $Page->product_status->rowAttributes() ?>>
        <label id="elh_service_request_product_status" for="x_product_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_status->caption() ?><?= $Page->product_status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_status->cellAttributes() ?>>
<span id="el_service_request_product_status">
<div class="input-group flex-nowrap">
    <select
        id="x_product_status"
        name="x_product_status"
        class="form-select ew-select<?= $Page->product_status->isInvalidClass() ?>"
        <?php if (!$Page->product_status->IsNativeSelect) { ?>
        data-select2-id="fservice_requestadd_x_product_status"
        <?php } ?>
        data-table="service_request"
        data-field="x_product_status"
        data-value-separator="<?= $Page->product_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->product_status->getPlaceHolder()) ?>"
        <?= $Page->product_status->editAttributes() ?>>
        <?= $Page->product_status->selectOptionListHtml("x_product_status") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "service_misc") && !$Page->product_status->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_product_status" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->product_status->caption() ?>" data-title="<?= $Page->product_status->caption() ?>" data-ew-action="add-option" data-el="x_product_status" data-url="<?= GetUrl("servicemiscaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->product_status->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product_status->getErrorMessage() ?></div>
<?= $Page->product_status->Lookup->getParamTag($Page, "p_x_product_status") ?>
<?php if (!$Page->product_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_requestadd", function() {
    var options = { name: "x_product_status", selectId: "fservice_requestadd_x_product_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_requestadd.lists.product_status?.lookupOptions.length) {
        options.data = { id: "x_product_status", form: "fservice_requestadd" };
    } else {
        options.ajax = { id: "x_product_status", form: "fservice_requestadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_request.fields.product_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_error->Visible) { // error ?>
    <div id="r__error"<?= $Page->_error->rowAttributes() ?>>
        <label id="elh_service_request__error" for="x__error" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_error->caption() ?><?= $Page->_error->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_error->cellAttributes() ?>>
<span id="el_service_request__error">
<textarea data-table="service_request" data-field="x__error" name="x__error" id="x__error" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->_error->getPlaceHolder()) ?>"<?= $Page->_error->editAttributes() ?> aria-describedby="x__error_help"><?= $Page->_error->EditValue ?></textarea>
<?= $Page->_error->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_error->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->query_by->Visible) { // query_by ?>
    <div id="r_query_by"<?= $Page->query_by->rowAttributes() ?>>
        <label id="elh_service_request_query_by" for="x_query_by" class="<?= $Page->LeftColumnClass ?>"><?= $Page->query_by->caption() ?><?= $Page->query_by->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->query_by->cellAttributes() ?>>
<span id="el_service_request_query_by">
<input type="<?= $Page->query_by->getInputTextType() ?>" name="x_query_by" id="x_query_by" data-table="service_request" data-field="x_query_by" value="<?= $Page->query_by->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->query_by->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->query_by->formatPattern()) ?>"<?= $Page->query_by->editAttributes() ?> aria-describedby="x_query_by_help">
<?= $Page->query_by->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->query_by->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->master_reading->Visible) { // master_reading ?>
    <div id="r_master_reading"<?= $Page->master_reading->rowAttributes() ?>>
        <label id="elh_service_request_master_reading" for="x_master_reading" class="<?= $Page->LeftColumnClass ?>"><?= $Page->master_reading->caption() ?><?= $Page->master_reading->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->master_reading->cellAttributes() ?>>
<span id="el_service_request_master_reading">
<input type="<?= $Page->master_reading->getInputTextType() ?>" name="x_master_reading" id="x_master_reading" data-table="service_request" data-field="x_master_reading" value="<?= $Page->master_reading->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->master_reading->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->master_reading->formatPattern()) ?>"<?= $Page->master_reading->editAttributes() ?> aria-describedby="x_master_reading_help">
<?= $Page->master_reading->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->master_reading->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fservice_requestadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fservice_requestadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("service_request");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
