<?php

namespace PHPMaker2024\fibre;

// Page object
$ServiceReportView = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $Page->ExportOptions->render("body") ?>
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="view">
<form name="fservice_reportview" id="fservice_reportview" class="ew-form ew-view-form overlay-wrapper" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { service_report: currentTable } });
var currentPageID = ew.PAGE_ID = "view";
var currentForm;
var fservice_reportview;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fservice_reportview")
        .setPageId("view")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="service_report">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<table class="<?= $Page->TableClass ?>">
<?php if ($Page->id->Visible) { // id ?>
    <tr id="r_id"<?= $Page->id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_id"><?= $Page->id->caption() ?></span></td>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el_service_report_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <tr id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_buyer_id"><?= $Page->buyer_id->caption() ?></span></td>
        <td data-name="buyer_id"<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_service_report_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<?= $Page->buyer_id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->hardware_id->Visible) { // hardware_id ?>
    <tr id="r_hardware_id"<?= $Page->hardware_id->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_hardware_id"><?= $Page->hardware_id->caption() ?></span></td>
        <td data-name="hardware_id"<?= $Page->hardware_id->cellAttributes() ?>>
<span id="el_service_report_hardware_id">
<span<?= $Page->hardware_id->viewAttributes() ?>>
<?= $Page->hardware_id->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->service_executive->Visible) { // service_executive ?>
    <tr id="r_service_executive"<?= $Page->service_executive->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_service_executive"><?= $Page->service_executive->caption() ?></span></td>
        <td data-name="service_executive"<?= $Page->service_executive->cellAttributes() ?>>
<span id="el_service_report_service_executive">
<span<?= $Page->service_executive->viewAttributes() ?>>
<?= $Page->service_executive->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->entry_time->Visible) { // entry_time ?>
    <tr id="r_entry_time"<?= $Page->entry_time->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_entry_time"><?= $Page->entry_time->caption() ?></span></td>
        <td data-name="entry_time"<?= $Page->entry_time->cellAttributes() ?>>
<span id="el_service_report_entry_time">
<span<?= $Page->entry_time->viewAttributes() ?>>
<?= $Page->entry_time->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->current_reading->Visible) { // current_reading ?>
    <tr id="r_current_reading"<?= $Page->current_reading->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_current_reading"><?= $Page->current_reading->caption() ?></span></td>
        <td data-name="current_reading"<?= $Page->current_reading->cellAttributes() ?>>
<span id="el_service_report_current_reading">
<span<?= $Page->current_reading->viewAttributes() ?>>
<?= $Page->current_reading->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->error_ref->Visible) { // error_ref ?>
    <tr id="r_error_ref"<?= $Page->error_ref->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_error_ref"><?= $Page->error_ref->caption() ?></span></td>
        <td data-name="error_ref"<?= $Page->error_ref->cellAttributes() ?>>
<span id="el_service_report_error_ref">
<span<?= $Page->error_ref->viewAttributes() ?>>
<?= $Page->error_ref->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->service_type->Visible) { // service_type ?>
    <tr id="r_service_type"<?= $Page->service_type->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_service_type"><?= $Page->service_type->caption() ?></span></td>
        <td data-name="service_type"<?= $Page->service_type->cellAttributes() ?>>
<span id="el_service_report_service_type">
<span<?= $Page->service_type->viewAttributes() ?>>
<?= $Page->service_type->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->complaint->Visible) { // complaint ?>
    <tr id="r_complaint"<?= $Page->complaint->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_complaint"><?= $Page->complaint->caption() ?></span></td>
        <td data-name="complaint"<?= $Page->complaint->cellAttributes() ?>>
<span id="el_service_report_complaint">
<span<?= $Page->complaint->viewAttributes() ?>>
<?= $Page->complaint->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->observation->Visible) { // observation ?>
    <tr id="r_observation"<?= $Page->observation->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_observation"><?= $Page->observation->caption() ?></span></td>
        <td data-name="observation"<?= $Page->observation->cellAttributes() ?>>
<span id="el_service_report_observation">
<span<?= $Page->observation->viewAttributes() ?>>
<?= $Page->observation->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->product_replaced->Visible) { // product_replaced ?>
    <tr id="r_product_replaced"<?= $Page->product_replaced->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_product_replaced"><?= $Page->product_replaced->caption() ?></span></td>
        <td data-name="product_replaced"<?= $Page->product_replaced->cellAttributes() ?>>
<span id="el_service_report_product_replaced">
<span<?= $Page->product_replaced->viewAttributes() ?>>
<?= $Page->product_replaced->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->consumable_replaced->Visible) { // consumable_replaced ?>
    <tr id="r_consumable_replaced"<?= $Page->consumable_replaced->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_consumable_replaced"><?= $Page->consumable_replaced->caption() ?></span></td>
        <td data-name="consumable_replaced"<?= $Page->consumable_replaced->cellAttributes() ?>>
<span id="el_service_report_consumable_replaced">
<span<?= $Page->consumable_replaced->viewAttributes() ?>>
<?= $Page->consumable_replaced->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->work_detail->Visible) { // work_detail ?>
    <tr id="r_work_detail"<?= $Page->work_detail->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_work_detail"><?= $Page->work_detail->caption() ?></span></td>
        <td data-name="work_detail"<?= $Page->work_detail->cellAttributes() ?>>
<span id="el_service_report_work_detail">
<span<?= $Page->work_detail->viewAttributes() ?>>
<?= $Page->work_detail->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->future_task->Visible) { // future_task ?>
    <tr id="r_future_task"<?= $Page->future_task->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_future_task"><?= $Page->future_task->caption() ?></span></td>
        <td data-name="future_task"<?= $Page->future_task->cellAttributes() ?>>
<span id="el_service_report_future_task">
<span<?= $Page->future_task->viewAttributes() ?>>
<?= $Page->future_task->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->last_status->Visible) { // last_status ?>
    <tr id="r_last_status"<?= $Page->last_status->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_last_status"><?= $Page->last_status->caption() ?></span></td>
        <td data-name="last_status"<?= $Page->last_status->cellAttributes() ?>>
<span id="el_service_report_last_status">
<span<?= $Page->last_status->viewAttributes() ?>>
<?= $Page->last_status->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <tr id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_uploads"><?= $Page->uploads->caption() ?></span></td>
        <td data-name="uploads"<?= $Page->uploads->cellAttributes() ?>>
<span id="el_service_report_uploads">
<span<?= $Page->uploads->viewAttributes() ?>>
<?= GetFileViewTag($Page->uploads, $Page->uploads->getViewValue(), false) ?>
</span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->out_time->Visible) { // out_time ?>
    <tr id="r_out_time"<?= $Page->out_time->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_out_time"><?= $Page->out_time->caption() ?></span></td>
        <td data-name="out_time"<?= $Page->out_time->cellAttributes() ?>>
<span id="el_service_report_out_time">
<span<?= $Page->out_time->viewAttributes() ?>>
<?= $Page->out_time->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <tr id="r_datetime"<?= $Page->datetime->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_datetime"><?= $Page->datetime->caption() ?></span></td>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el_service_report_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
    <tr id="r_a_operator"<?= $Page->a_operator->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_a_operator"><?= $Page->a_operator->caption() ?></span></td>
        <td data-name="a_operator"<?= $Page->a_operator->cellAttributes() ?>>
<span id="el_service_report_a_operator">
<span<?= $Page->a_operator->viewAttributes() ?>>
<?= $Page->a_operator->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->invoice->Visible) { // invoice ?>
    <tr id="r_invoice"<?= $Page->invoice->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_invoice"><?= $Page->invoice->caption() ?></span></td>
        <td data-name="invoice"<?= $Page->invoice->cellAttributes() ?>>
<span id="el_service_report_invoice">
<span<?= $Page->invoice->viewAttributes() ?>>
<?= $Page->invoice->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
    <tr id="r_invoice_date"<?= $Page->invoice_date->rowAttributes() ?>>
        <td class="<?= $Page->TableLeftColumnClass ?>"><span id="elh_service_report_invoice_date"><?= $Page->invoice_date->caption() ?></span></td>
        <td data-name="invoice_date"<?= $Page->invoice_date->cellAttributes() ?>>
<span id="el_service_report_invoice_date">
<span<?= $Page->invoice_date->viewAttributes() ?>>
<?= $Page->invoice_date->getViewValue() ?></span>
</span>
</td>
    </tr>
<?php } ?>
</table>
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    		var HI = $('#x_hardware_id').val();
    		document.cookie = "HI="+HI+";path=/";
    		if (HI.length > 0)
    		{
    		$('#errorh').remove();
    		$.getJSON(window.location.origin +"/apcajaxtc?clientlastdata="+HI,function(data){
    			$("#r_hardware_id").append('<span style="color:red" id="errorh">'+data+'</span>')
    		});
    		}
});
</script>
<?php } ?>
