<?php

namespace PHPMaker2024\fibre;

// Page object
$ServiceReportSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { service_report: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fservice_reportsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fservice_reportsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["buyer_id", [ew.Validators.integer], fields.buyer_id.isInvalid],
            ["hardware_id", [], fields.hardware_id.isInvalid],
            ["service_executive", [ew.Validators.integer], fields.service_executive.isInvalid],
            ["entry_time", [ew.Validators.datetime(fields.entry_time.clientFormatPattern)], fields.entry_time.isInvalid],
            ["current_reading", [ew.Validators.integer], fields.current_reading.isInvalid],
            ["error_ref", [], fields.error_ref.isInvalid],
            ["service_type", [], fields.service_type.isInvalid],
            ["complaint", [], fields.complaint.isInvalid],
            ["observation", [], fields.observation.isInvalid],
            ["product_replaced", [], fields.product_replaced.isInvalid],
            ["consumable_replaced", [], fields.consumable_replaced.isInvalid],
            ["work_detail", [], fields.work_detail.isInvalid],
            ["future_task", [], fields.future_task.isInvalid],
            ["last_status", [], fields.last_status.isInvalid],
            ["uploads", [], fields.uploads.isInvalid],
            ["out_time", [ew.Validators.datetime(fields.out_time.clientFormatPattern)], fields.out_time.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["a_operator", [], fields.a_operator.isInvalid],
            ["invoice", [], fields.invoice.isInvalid],
            ["invoice_date", [ew.Validators.datetime(fields.invoice_date.clientFormatPattern)], fields.invoice_date.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "hardware_id": <?= $Page->hardware_id->toClientList($Page) ?>,
            "service_executive": <?= $Page->service_executive->toClientList($Page) ?>,
            "error_ref": <?= $Page->error_ref->toClientList($Page) ?>,
            "service_type": <?= $Page->service_type->toClientList($Page) ?>,
            "complaint": <?= $Page->complaint->toClientList($Page) ?>,
            "product_replaced": <?= $Page->product_replaced->toClientList($Page) ?>,
            "consumable_replaced": <?= $Page->consumable_replaced->toClientList($Page) ?>,
            "last_status": <?= $Page->last_status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
            "a_operator": <?= $Page->a_operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fservice_reportsearch" id="fservice_reportsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="service_report">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="service_report" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id" class="row"<?= $Page->buyer_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_buyer_id"><?= $Page->buyer_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_buyer_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-control ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        data-select2-id="fservice_reportsearch_x_buyer_id"
        data-table="service_report"
        data-field="x_buyer_id"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->buyer_id->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<script>
loadjs.ready("fservice_reportsearch", function() {
    var options = { name: "x_buyer_id", selectId: "fservice_reportsearch_x_buyer_id" };
    if (fservice_reportsearch.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fservice_reportsearch" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fservice_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.service_report.fields.buyer_id.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->hardware_id->Visible) { // hardware_id ?>
    <div id="r_hardware_id" class="row"<?= $Page->hardware_id->rowAttributes() ?>>
        <label for="x_hardware_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_hardware_id"><?= $Page->hardware_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_hardware_id" id="z_hardware_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->hardware_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_hardware_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_hardware_id"
        name="x_hardware_id"
        class="form-select ew-select<?= $Page->hardware_id->isInvalidClass() ?>"
        <?php if (!$Page->hardware_id->IsNativeSelect) { ?>
        data-select2-id="fservice_reportsearch_x_hardware_id"
        <?php } ?>
        data-table="service_report"
        data-field="x_hardware_id"
        data-value-separator="<?= $Page->hardware_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->hardware_id->getPlaceHolder()) ?>"
        <?= $Page->hardware_id->editAttributes() ?>>
        <?= $Page->hardware_id->selectOptionListHtml("x_hardware_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->hardware_id->getErrorMessage(false) ?></div>
<?= $Page->hardware_id->Lookup->getParamTag($Page, "p_x_hardware_id") ?>
<?php if (!$Page->hardware_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_reportsearch", function() {
    var options = { name: "x_hardware_id", selectId: "fservice_reportsearch_x_hardware_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_reportsearch.lists.hardware_id?.lookupOptions.length) {
        options.data = { id: "x_hardware_id", form: "fservice_reportsearch" };
    } else {
        options.ajax = { id: "x_hardware_id", form: "fservice_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_report.fields.hardware_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->service_executive->Visible) { // service_executive ?>
    <div id="r_service_executive" class="row"<?= $Page->service_executive->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_service_executive"><?= $Page->service_executive->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_service_executive" id="z_service_executive" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->service_executive->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_service_executive" class="ew-search-field ew-search-field-single">
    <select
        id="x_service_executive"
        name="x_service_executive"
        class="form-control ew-select<?= $Page->service_executive->isInvalidClass() ?>"
        data-select2-id="fservice_reportsearch_x_service_executive"
        data-table="service_report"
        data-field="x_service_executive"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->service_executive->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->service_executive->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->service_executive->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->service_executive->editAttributes() ?>>
        <?= $Page->service_executive->selectOptionListHtml("x_service_executive") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->service_executive->getErrorMessage(false) ?></div>
<?= $Page->service_executive->Lookup->getParamTag($Page, "p_x_service_executive") ?>
<script>
loadjs.ready("fservice_reportsearch", function() {
    var options = { name: "x_service_executive", selectId: "fservice_reportsearch_x_service_executive" };
    if (fservice_reportsearch.lists.service_executive?.lookupOptions.length) {
        options.data = { id: "x_service_executive", form: "fservice_reportsearch" };
    } else {
        options.ajax = { id: "x_service_executive", form: "fservice_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.service_report.fields.service_executive.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->entry_time->Visible) { // entry_time ?>
    <div id="r_entry_time" class="row"<?= $Page->entry_time->rowAttributes() ?>>
        <label for="x_entry_time" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_entry_time"><?= $Page->entry_time->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_entry_time" id="z_entry_time" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->entry_time->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_entry_time" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->entry_time->getInputTextType() ?>" name="x_entry_time" id="x_entry_time" data-table="service_report" data-field="x_entry_time" value="<?= $Page->entry_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->entry_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->entry_time->formatPattern()) ?>"<?= $Page->entry_time->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->entry_time->getErrorMessage(false) ?></div>
<?php if (!$Page->entry_time->ReadOnly && !$Page->entry_time->Disabled && !isset($Page->entry_time->EditAttrs["readonly"]) && !isset($Page->entry_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_reportsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_reportsearch", "x_entry_time", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->current_reading->Visible) { // current_reading ?>
    <div id="r_current_reading" class="row"<?= $Page->current_reading->rowAttributes() ?>>
        <label for="x_current_reading" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_current_reading"><?= $Page->current_reading->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_current_reading" id="z_current_reading" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->current_reading->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_current_reading" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->current_reading->getInputTextType() ?>" name="x_current_reading" id="x_current_reading" data-table="service_report" data-field="x_current_reading" value="<?= $Page->current_reading->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->current_reading->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->current_reading->formatPattern()) ?>"<?= $Page->current_reading->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->current_reading->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->error_ref->Visible) { // error_ref ?>
    <div id="r_error_ref" class="row"<?= $Page->error_ref->rowAttributes() ?>>
        <label for="x_error_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_error_ref"><?= $Page->error_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_error_ref" id="z_error_ref" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->error_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_error_ref" class="ew-search-field ew-search-field-single">
    <select
        id="x_error_ref"
        name="x_error_ref"
        class="form-select ew-select<?= $Page->error_ref->isInvalidClass() ?>"
        <?php if (!$Page->error_ref->IsNativeSelect) { ?>
        data-select2-id="fservice_reportsearch_x_error_ref"
        <?php } ?>
        data-table="service_report"
        data-field="x_error_ref"
        data-value-separator="<?= $Page->error_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->error_ref->getPlaceHolder()) ?>"
        <?= $Page->error_ref->editAttributes() ?>>
        <?= $Page->error_ref->selectOptionListHtml("x_error_ref") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->error_ref->getErrorMessage(false) ?></div>
<?= $Page->error_ref->Lookup->getParamTag($Page, "p_x_error_ref") ?>
<?php if (!$Page->error_ref->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_reportsearch", function() {
    var options = { name: "x_error_ref", selectId: "fservice_reportsearch_x_error_ref" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_reportsearch.lists.error_ref?.lookupOptions.length) {
        options.data = { id: "x_error_ref", form: "fservice_reportsearch" };
    } else {
        options.ajax = { id: "x_error_ref", form: "fservice_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_report.fields.error_ref.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->service_type->Visible) { // service_type ?>
    <div id="r_service_type" class="row"<?= $Page->service_type->rowAttributes() ?>>
        <label for="x_service_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_service_type"><?= $Page->service_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_service_type" id="z_service_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->service_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_service_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_service_type"
        name="x_service_type"
        class="form-select ew-select<?= $Page->service_type->isInvalidClass() ?>"
        <?php if (!$Page->service_type->IsNativeSelect) { ?>
        data-select2-id="fservice_reportsearch_x_service_type"
        <?php } ?>
        data-table="service_report"
        data-field="x_service_type"
        data-value-separator="<?= $Page->service_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->service_type->getPlaceHolder()) ?>"
        <?= $Page->service_type->editAttributes() ?>>
        <?= $Page->service_type->selectOptionListHtml("x_service_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->service_type->getErrorMessage(false) ?></div>
<?= $Page->service_type->Lookup->getParamTag($Page, "p_x_service_type") ?>
<?php if (!$Page->service_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_reportsearch", function() {
    var options = { name: "x_service_type", selectId: "fservice_reportsearch_x_service_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_reportsearch.lists.service_type?.lookupOptions.length) {
        options.data = { id: "x_service_type", form: "fservice_reportsearch" };
    } else {
        options.ajax = { id: "x_service_type", form: "fservice_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_report.fields.service_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->complaint->Visible) { // complaint ?>
    <div id="r_complaint" class="row"<?= $Page->complaint->rowAttributes() ?>>
        <label for="x_complaint" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_complaint"><?= $Page->complaint->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_complaint" id="z_complaint" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->complaint->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_complaint" class="ew-search-field ew-search-field-single">
    <select
        id="x_complaint"
        name="x_complaint"
        class="form-select ew-select<?= $Page->complaint->isInvalidClass() ?>"
        <?php if (!$Page->complaint->IsNativeSelect) { ?>
        data-select2-id="fservice_reportsearch_x_complaint"
        <?php } ?>
        data-table="service_report"
        data-field="x_complaint"
        data-value-separator="<?= $Page->complaint->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->complaint->getPlaceHolder()) ?>"
        <?= $Page->complaint->editAttributes() ?>>
        <?= $Page->complaint->selectOptionListHtml("x_complaint") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->complaint->getErrorMessage(false) ?></div>
<?= $Page->complaint->Lookup->getParamTag($Page, "p_x_complaint") ?>
<?php if (!$Page->complaint->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_reportsearch", function() {
    var options = { name: "x_complaint", selectId: "fservice_reportsearch_x_complaint" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_reportsearch.lists.complaint?.lookupOptions.length) {
        options.data = { id: "x_complaint", form: "fservice_reportsearch" };
    } else {
        options.ajax = { id: "x_complaint", form: "fservice_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_report.fields.complaint.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->observation->Visible) { // observation ?>
    <div id="r_observation" class="row"<?= $Page->observation->rowAttributes() ?>>
        <label for="x_observation" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_observation"><?= $Page->observation->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_observation" id="z_observation" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->observation->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_observation" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->observation->getInputTextType() ?>" name="x_observation" id="x_observation" data-table="service_report" data-field="x_observation" value="<?= $Page->observation->EditValue ?>" maxlength="255" placeholder="<?= HtmlEncode($Page->observation->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->observation->formatPattern()) ?>"<?= $Page->observation->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->observation->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->product_replaced->Visible) { // product_replaced ?>
    <div id="r_product_replaced" class="row"<?= $Page->product_replaced->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_product_replaced"><?= $Page->product_replaced->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_product_replaced" id="z_product_replaced" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->product_replaced->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_product_replaced" class="ew-search-field ew-search-field-single">
<template id="tp_x_product_replaced">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="service_report" data-field="x_product_replaced" name="x_product_replaced" id="x_product_replaced"<?= $Page->product_replaced->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_product_replaced" class="ew-item-list"></div>
<selection-list hidden
    id="x_product_replaced[]"
    name="x_product_replaced[]"
    value="<?= HtmlEncode($Page->product_replaced->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_product_replaced"
    data-target="dsl_x_product_replaced"
    data-repeatcolumn="1"
    class="form-control<?= $Page->product_replaced->isInvalidClass() ?>"
    data-table="service_report"
    data-field="x_product_replaced"
    data-value-separator="<?= $Page->product_replaced->displayValueSeparatorAttribute() ?>"
    <?= $Page->product_replaced->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->product_replaced->getErrorMessage(false) ?></div>
<?= $Page->product_replaced->Lookup->getParamTag($Page, "p_x_product_replaced") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->consumable_replaced->Visible) { // consumable_replaced ?>
    <div id="r_consumable_replaced" class="row"<?= $Page->consumable_replaced->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_consumable_replaced"><?= $Page->consumable_replaced->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_consumable_replaced" id="z_consumable_replaced" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->consumable_replaced->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_consumable_replaced" class="ew-search-field ew-search-field-single">
<template id="tp_x_consumable_replaced">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="service_report" data-field="x_consumable_replaced" name="x_consumable_replaced" id="x_consumable_replaced"<?= $Page->consumable_replaced->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_consumable_replaced" class="ew-item-list"></div>
<selection-list hidden
    id="x_consumable_replaced[]"
    name="x_consumable_replaced[]"
    value="<?= HtmlEncode($Page->consumable_replaced->AdvancedSearch->SearchValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_consumable_replaced"
    data-target="dsl_x_consumable_replaced"
    data-repeatcolumn="1"
    class="form-control<?= $Page->consumable_replaced->isInvalidClass() ?>"
    data-table="service_report"
    data-field="x_consumable_replaced"
    data-value-separator="<?= $Page->consumable_replaced->displayValueSeparatorAttribute() ?>"
    <?= $Page->consumable_replaced->editAttributes() ?>></selection-list>
<div class="invalid-feedback"><?= $Page->consumable_replaced->getErrorMessage(false) ?></div>
<?= $Page->consumable_replaced->Lookup->getParamTag($Page, "p_x_consumable_replaced") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->work_detail->Visible) { // work_detail ?>
    <div id="r_work_detail" class="row"<?= $Page->work_detail->rowAttributes() ?>>
        <label for="x_work_detail" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_work_detail"><?= $Page->work_detail->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_work_detail" id="z_work_detail" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->work_detail->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_work_detail" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->work_detail->getInputTextType() ?>" name="x_work_detail" id="x_work_detail" data-table="service_report" data-field="x_work_detail" value="<?= $Page->work_detail->EditValue ?>" maxlength="255" placeholder="<?= HtmlEncode($Page->work_detail->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->work_detail->formatPattern()) ?>"<?= $Page->work_detail->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->work_detail->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->future_task->Visible) { // future_task ?>
    <div id="r_future_task" class="row"<?= $Page->future_task->rowAttributes() ?>>
        <label for="x_future_task" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_future_task"><?= $Page->future_task->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_future_task" id="z_future_task" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->future_task->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_future_task" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->future_task->getInputTextType() ?>" name="x_future_task" id="x_future_task" data-table="service_report" data-field="x_future_task" value="<?= $Page->future_task->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->future_task->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->future_task->formatPattern()) ?>"<?= $Page->future_task->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->future_task->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->last_status->Visible) { // last_status ?>
    <div id="r_last_status" class="row"<?= $Page->last_status->rowAttributes() ?>>
        <label for="x_last_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_last_status"><?= $Page->last_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_last_status" id="z_last_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->last_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_last_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_last_status"
        name="x_last_status"
        class="form-select ew-select<?= $Page->last_status->isInvalidClass() ?>"
        <?php if (!$Page->last_status->IsNativeSelect) { ?>
        data-select2-id="fservice_reportsearch_x_last_status"
        <?php } ?>
        data-table="service_report"
        data-field="x_last_status"
        data-value-separator="<?= $Page->last_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->last_status->getPlaceHolder()) ?>"
        <?= $Page->last_status->editAttributes() ?>>
        <?= $Page->last_status->selectOptionListHtml("x_last_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->last_status->getErrorMessage(false) ?></div>
<?= $Page->last_status->Lookup->getParamTag($Page, "p_x_last_status") ?>
<?php if (!$Page->last_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_reportsearch", function() {
    var options = { name: "x_last_status", selectId: "fservice_reportsearch_x_last_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_reportsearch.lists.last_status?.lookupOptions.length) {
        options.data = { id: "x_last_status", form: "fservice_reportsearch" };
    } else {
        options.ajax = { id: "x_last_status", form: "fservice_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_report.fields.last_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads" class="row"<?= $Page->uploads->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_uploads"><?= $Page->uploads->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_uploads" id="z_uploads" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uploads->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_uploads" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uploads->getInputTextType() ?>" name="x_uploads" id="x_uploads" data-table="service_report" data-field="x_uploads" value="<?= $Page->uploads->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->uploads->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uploads->formatPattern()) ?>"<?= $Page->uploads->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uploads->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->out_time->Visible) { // out_time ?>
    <div id="r_out_time" class="row"<?= $Page->out_time->rowAttributes() ?>>
        <label for="x_out_time" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_out_time"><?= $Page->out_time->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_out_time" id="z_out_time" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->out_time->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_out_time" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->out_time->getInputTextType() ?>" name="x_out_time" id="x_out_time" data-table="service_report" data-field="x_out_time" value="<?= $Page->out_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->out_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->out_time->formatPattern()) ?>"<?= $Page->out_time->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->out_time->getErrorMessage(false) ?></div>
<?php if (!$Page->out_time->ReadOnly && !$Page->out_time->Disabled && !isset($Page->out_time->EditAttrs["readonly"]) && !isset($Page->out_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_reportsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_reportsearch", "x_out_time", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fservice_reportsearch_x_operator"
        <?php } ?>
        data-table="service_report"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_reportsearch", function() {
    var options = { name: "x_operator", selectId: "fservice_reportsearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_reportsearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fservice_reportsearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fservice_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_report.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="service_report" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_reportsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_reportsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->a_operator->Visible) { // a_operator ?>
    <div id="r_a_operator" class="row"<?= $Page->a_operator->rowAttributes() ?>>
        <label for="x_a_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_a_operator"><?= $Page->a_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_a_operator" id="z_a_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->a_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_a_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_a_operator"
        name="x_a_operator"
        class="form-select ew-select<?= $Page->a_operator->isInvalidClass() ?>"
        <?php if (!$Page->a_operator->IsNativeSelect) { ?>
        data-select2-id="fservice_reportsearch_x_a_operator"
        <?php } ?>
        data-table="service_report"
        data-field="x_a_operator"
        data-value-separator="<?= $Page->a_operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->a_operator->getPlaceHolder()) ?>"
        <?= $Page->a_operator->editAttributes() ?>>
        <?= $Page->a_operator->selectOptionListHtml("x_a_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->a_operator->getErrorMessage(false) ?></div>
<?= $Page->a_operator->Lookup->getParamTag($Page, "p_x_a_operator") ?>
<?php if (!$Page->a_operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_reportsearch", function() {
    var options = { name: "x_a_operator", selectId: "fservice_reportsearch_x_a_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_reportsearch.lists.a_operator?.lookupOptions.length) {
        options.data = { id: "x_a_operator", form: "fservice_reportsearch" };
    } else {
        options.ajax = { id: "x_a_operator", form: "fservice_reportsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_report.fields.a_operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice->Visible) { // invoice ?>
    <div id="r_invoice" class="row"<?= $Page->invoice->rowAttributes() ?>>
        <label for="x_invoice" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_invoice"><?= $Page->invoice->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_invoice" id="z_invoice" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_invoice" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice->getInputTextType() ?>" name="x_invoice" id="x_invoice" data-table="service_report" data-field="x_invoice" value="<?= $Page->invoice->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->invoice->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice->formatPattern()) ?>"<?= $Page->invoice->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
    <div id="r_invoice_date" class="row"<?= $Page->invoice_date->rowAttributes() ?>>
        <label for="x_invoice_date" class="<?= $Page->LeftColumnClass ?>"><span id="elh_service_report_invoice_date"><?= $Page->invoice_date->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_invoice_date" id="z_invoice_date" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->invoice_date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_service_report_invoice_date" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="x_invoice_date" id="x_invoice_date" data-table="service_report" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage(false) ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_reportsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_reportsearch", "x_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fservice_reportsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fservice_reportsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fservice_reportsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("service_report");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
