<?php

namespace PHPMaker2024\fibre;

// Page object
$ServiceReportEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fservice_reportedit" id="fservice_reportedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { service_report: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fservice_reportedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fservice_reportedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["hardware_id", [fields.hardware_id.visible && fields.hardware_id.required ? ew.Validators.required(fields.hardware_id.caption) : null], fields.hardware_id.isInvalid],
            ["service_executive", [fields.service_executive.visible && fields.service_executive.required ? ew.Validators.required(fields.service_executive.caption) : null], fields.service_executive.isInvalid],
            ["current_reading", [fields.current_reading.visible && fields.current_reading.required ? ew.Validators.required(fields.current_reading.caption) : null, ew.Validators.integer], fields.current_reading.isInvalid],
            ["error_ref", [fields.error_ref.visible && fields.error_ref.required ? ew.Validators.required(fields.error_ref.caption) : null], fields.error_ref.isInvalid],
            ["service_type", [fields.service_type.visible && fields.service_type.required ? ew.Validators.required(fields.service_type.caption) : null], fields.service_type.isInvalid],
            ["complaint", [fields.complaint.visible && fields.complaint.required ? ew.Validators.required(fields.complaint.caption) : null], fields.complaint.isInvalid],
            ["observation", [fields.observation.visible && fields.observation.required ? ew.Validators.required(fields.observation.caption) : null], fields.observation.isInvalid],
            ["product_replaced", [fields.product_replaced.visible && fields.product_replaced.required ? ew.Validators.required(fields.product_replaced.caption) : null], fields.product_replaced.isInvalid],
            ["consumable_replaced", [fields.consumable_replaced.visible && fields.consumable_replaced.required ? ew.Validators.required(fields.consumable_replaced.caption) : null], fields.consumable_replaced.isInvalid],
            ["work_detail", [fields.work_detail.visible && fields.work_detail.required ? ew.Validators.required(fields.work_detail.caption) : null], fields.work_detail.isInvalid],
            ["future_task", [fields.future_task.visible && fields.future_task.required ? ew.Validators.required(fields.future_task.caption) : null], fields.future_task.isInvalid],
            ["last_status", [fields.last_status.visible && fields.last_status.required ? ew.Validators.required(fields.last_status.caption) : null], fields.last_status.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["out_time", [fields.out_time.visible && fields.out_time.required ? ew.Validators.required(fields.out_time.caption) : null, ew.Validators.datetime(fields.out_time.clientFormatPattern)], fields.out_time.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["invoice", [fields.invoice.visible && fields.invoice.required ? ew.Validators.required(fields.invoice.caption) : null], fields.invoice.isInvalid],
            ["invoice_date", [fields.invoice_date.visible && fields.invoice_date.required ? ew.Validators.required(fields.invoice_date.caption) : null, ew.Validators.datetime(fields.invoice_date.clientFormatPattern)], fields.invoice_date.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "error_ref": <?= $Page->error_ref->toClientList($Page) ?>,
            "service_type": <?= $Page->service_type->toClientList($Page) ?>,
            "product_replaced": <?= $Page->product_replaced->toClientList($Page) ?>,
            "consumable_replaced": <?= $Page->consumable_replaced->toClientList($Page) ?>,
            "last_status": <?= $Page->last_status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="service_report">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_service_report_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_service_report_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="service_report" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <label id="elh_service_report_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_id->caption() ?><?= $Page->buyer_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_service_report_buyer_id">
<span<?= $Page->buyer_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->buyer_id->getDisplayValue($Page->buyer_id->EditValue) ?></span></span>
<input type="hidden" data-table="service_report" data-field="x_buyer_id" data-hidden="1" name="x_buyer_id" id="x_buyer_id" value="<?= HtmlEncode($Page->buyer_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->hardware_id->Visible) { // hardware_id ?>
    <div id="r_hardware_id"<?= $Page->hardware_id->rowAttributes() ?>>
        <label id="elh_service_report_hardware_id" for="x_hardware_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->hardware_id->caption() ?><?= $Page->hardware_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->hardware_id->cellAttributes() ?>>
<span id="el_service_report_hardware_id">
<span<?= $Page->hardware_id->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->hardware_id->getDisplayValue($Page->hardware_id->EditValue) ?></span></span>
<input type="hidden" data-table="service_report" data-field="x_hardware_id" data-hidden="1" name="x_hardware_id" id="x_hardware_id" value="<?= HtmlEncode($Page->hardware_id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->service_executive->Visible) { // service_executive ?>
    <div id="r_service_executive"<?= $Page->service_executive->rowAttributes() ?>>
        <label id="elh_service_report_service_executive" class="<?= $Page->LeftColumnClass ?>"><?= $Page->service_executive->caption() ?><?= $Page->service_executive->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->service_executive->cellAttributes() ?>>
<span id="el_service_report_service_executive">
<span<?= $Page->service_executive->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->service_executive->getDisplayValue($Page->service_executive->EditValue) ?></span></span>
<input type="hidden" data-table="service_report" data-field="x_service_executive" data-hidden="1" name="x_service_executive" id="x_service_executive" value="<?= HtmlEncode($Page->service_executive->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->current_reading->Visible) { // current_reading ?>
    <div id="r_current_reading"<?= $Page->current_reading->rowAttributes() ?>>
        <label id="elh_service_report_current_reading" for="x_current_reading" class="<?= $Page->LeftColumnClass ?>"><?= $Page->current_reading->caption() ?><?= $Page->current_reading->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->current_reading->cellAttributes() ?>>
<span id="el_service_report_current_reading">
<input type="<?= $Page->current_reading->getInputTextType() ?>" name="x_current_reading" id="x_current_reading" data-table="service_report" data-field="x_current_reading" value="<?= $Page->current_reading->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->current_reading->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->current_reading->formatPattern()) ?>"<?= $Page->current_reading->editAttributes() ?> aria-describedby="x_current_reading_help">
<?= $Page->current_reading->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->current_reading->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->error_ref->Visible) { // error_ref ?>
    <div id="r_error_ref"<?= $Page->error_ref->rowAttributes() ?>>
        <label id="elh_service_report_error_ref" for="x_error_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->error_ref->caption() ?><?= $Page->error_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->error_ref->cellAttributes() ?>>
<span id="el_service_report_error_ref">
    <select
        id="x_error_ref"
        name="x_error_ref"
        class="form-select ew-select<?= $Page->error_ref->isInvalidClass() ?>"
        <?php if (!$Page->error_ref->IsNativeSelect) { ?>
        data-select2-id="fservice_reportedit_x_error_ref"
        <?php } ?>
        data-table="service_report"
        data-field="x_error_ref"
        data-value-separator="<?= $Page->error_ref->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->error_ref->getPlaceHolder()) ?>"
        data-ew-action="autofill"
        <?= $Page->error_ref->editAttributes() ?>>
        <?= $Page->error_ref->selectOptionListHtml("x_error_ref") ?>
    </select>
    <?= $Page->error_ref->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->error_ref->getErrorMessage() ?></div>
<?= $Page->error_ref->Lookup->getParamTag($Page, "p_x_error_ref") ?>
<?php if (!$Page->error_ref->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_reportedit", function() {
    var options = { name: "x_error_ref", selectId: "fservice_reportedit_x_error_ref" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_reportedit.lists.error_ref?.lookupOptions.length) {
        options.data = { id: "x_error_ref", form: "fservice_reportedit" };
    } else {
        options.ajax = { id: "x_error_ref", form: "fservice_reportedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_report.fields.error_ref.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->service_type->Visible) { // service_type ?>
    <div id="r_service_type"<?= $Page->service_type->rowAttributes() ?>>
        <label id="elh_service_report_service_type" for="x_service_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->service_type->caption() ?><?= $Page->service_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->service_type->cellAttributes() ?>>
<span id="el_service_report_service_type">
<div class="input-group flex-nowrap">
    <select
        id="x_service_type"
        name="x_service_type"
        class="form-select ew-select<?= $Page->service_type->isInvalidClass() ?>"
        <?php if (!$Page->service_type->IsNativeSelect) { ?>
        data-select2-id="fservice_reportedit_x_service_type"
        <?php } ?>
        data-table="service_report"
        data-field="x_service_type"
        data-value-separator="<?= $Page->service_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->service_type->getPlaceHolder()) ?>"
        <?= $Page->service_type->editAttributes() ?>>
        <?= $Page->service_type->selectOptionListHtml("x_service_type") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "service_misc") && !$Page->service_type->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_service_type" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->service_type->caption() ?>" data-title="<?= $Page->service_type->caption() ?>" data-ew-action="add-option" data-el="x_service_type" data-url="<?= GetUrl("servicemiscaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->service_type->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->service_type->getErrorMessage() ?></div>
<?= $Page->service_type->Lookup->getParamTag($Page, "p_x_service_type") ?>
<?php if (!$Page->service_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_reportedit", function() {
    var options = { name: "x_service_type", selectId: "fservice_reportedit_x_service_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_reportedit.lists.service_type?.lookupOptions.length) {
        options.data = { id: "x_service_type", form: "fservice_reportedit" };
    } else {
        options.ajax = { id: "x_service_type", form: "fservice_reportedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_report.fields.service_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->complaint->Visible) { // complaint ?>
    <div id="r_complaint"<?= $Page->complaint->rowAttributes() ?>>
        <label id="elh_service_report_complaint" for="x_complaint" class="<?= $Page->LeftColumnClass ?>"><?= $Page->complaint->caption() ?><?= $Page->complaint->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->complaint->cellAttributes() ?>>
<span id="el_service_report_complaint">
<span<?= $Page->complaint->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->complaint->getDisplayValue($Page->complaint->EditValue) ?></span></span>
<input type="hidden" data-table="service_report" data-field="x_complaint" data-hidden="1" name="x_complaint" id="x_complaint" value="<?= HtmlEncode($Page->complaint->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->observation->Visible) { // observation ?>
    <div id="r_observation"<?= $Page->observation->rowAttributes() ?>>
        <label id="elh_service_report_observation" for="x_observation" class="<?= $Page->LeftColumnClass ?>"><?= $Page->observation->caption() ?><?= $Page->observation->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->observation->cellAttributes() ?>>
<span id="el_service_report_observation">
<textarea data-table="service_report" data-field="x_observation" name="x_observation" id="x_observation" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->observation->getPlaceHolder()) ?>"<?= $Page->observation->editAttributes() ?> aria-describedby="x_observation_help"><?= $Page->observation->EditValue ?></textarea>
<?= $Page->observation->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->observation->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->product_replaced->Visible) { // product_replaced ?>
    <div id="r_product_replaced"<?= $Page->product_replaced->rowAttributes() ?>>
        <label id="elh_service_report_product_replaced" class="<?= $Page->LeftColumnClass ?>"><?= $Page->product_replaced->caption() ?><?= $Page->product_replaced->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->product_replaced->cellAttributes() ?>>
<span id="el_service_report_product_replaced">
<template id="tp_x_product_replaced">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="service_report" data-field="x_product_replaced" name="x_product_replaced" id="x_product_replaced"<?= $Page->product_replaced->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_product_replaced" class="ew-item-list"></div>
<selection-list hidden
    id="x_product_replaced[]"
    name="x_product_replaced[]"
    value="<?= HtmlEncode($Page->product_replaced->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_product_replaced"
    data-target="dsl_x_product_replaced"
    data-repeatcolumn="1"
    class="form-control<?= $Page->product_replaced->isInvalidClass() ?>"
    data-table="service_report"
    data-field="x_product_replaced"
    data-value-separator="<?= $Page->product_replaced->displayValueSeparatorAttribute() ?>"
    <?= $Page->product_replaced->editAttributes() ?>></selection-list>
<?= $Page->product_replaced->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->product_replaced->getErrorMessage() ?></div>
<?= $Page->product_replaced->Lookup->getParamTag($Page, "p_x_product_replaced") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->consumable_replaced->Visible) { // consumable_replaced ?>
    <div id="r_consumable_replaced"<?= $Page->consumable_replaced->rowAttributes() ?>>
        <label id="elh_service_report_consumable_replaced" class="<?= $Page->LeftColumnClass ?>"><?= $Page->consumable_replaced->caption() ?><?= $Page->consumable_replaced->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->consumable_replaced->cellAttributes() ?>>
<span id="el_service_report_consumable_replaced">
<template id="tp_x_consumable_replaced">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="service_report" data-field="x_consumable_replaced" name="x_consumable_replaced" id="x_consumable_replaced"<?= $Page->consumable_replaced->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_consumable_replaced" class="ew-item-list"></div>
<selection-list hidden
    id="x_consumable_replaced[]"
    name="x_consumable_replaced[]"
    value="<?= HtmlEncode($Page->consumable_replaced->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_consumable_replaced"
    data-target="dsl_x_consumable_replaced"
    data-repeatcolumn="1"
    class="form-control<?= $Page->consumable_replaced->isInvalidClass() ?>"
    data-table="service_report"
    data-field="x_consumable_replaced"
    data-value-separator="<?= $Page->consumable_replaced->displayValueSeparatorAttribute() ?>"
    <?= $Page->consumable_replaced->editAttributes() ?>></selection-list>
<?= $Page->consumable_replaced->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->consumable_replaced->getErrorMessage() ?></div>
<?= $Page->consumable_replaced->Lookup->getParamTag($Page, "p_x_consumable_replaced") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->work_detail->Visible) { // work_detail ?>
    <div id="r_work_detail"<?= $Page->work_detail->rowAttributes() ?>>
        <label id="elh_service_report_work_detail" for="x_work_detail" class="<?= $Page->LeftColumnClass ?>"><?= $Page->work_detail->caption() ?><?= $Page->work_detail->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->work_detail->cellAttributes() ?>>
<span id="el_service_report_work_detail">
<textarea data-table="service_report" data-field="x_work_detail" name="x_work_detail" id="x_work_detail" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->work_detail->getPlaceHolder()) ?>"<?= $Page->work_detail->editAttributes() ?> aria-describedby="x_work_detail_help"><?= $Page->work_detail->EditValue ?></textarea>
<?= $Page->work_detail->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->work_detail->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->future_task->Visible) { // future_task ?>
    <div id="r_future_task"<?= $Page->future_task->rowAttributes() ?>>
        <label id="elh_service_report_future_task" for="x_future_task" class="<?= $Page->LeftColumnClass ?>"><?= $Page->future_task->caption() ?><?= $Page->future_task->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->future_task->cellAttributes() ?>>
<span id="el_service_report_future_task">
<textarea data-table="service_report" data-field="x_future_task" name="x_future_task" id="x_future_task" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->future_task->getPlaceHolder()) ?>"<?= $Page->future_task->editAttributes() ?> aria-describedby="x_future_task_help"><?= $Page->future_task->EditValue ?></textarea>
<?= $Page->future_task->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->future_task->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->last_status->Visible) { // last_status ?>
    <div id="r_last_status"<?= $Page->last_status->rowAttributes() ?>>
        <label id="elh_service_report_last_status" for="x_last_status" class="<?= $Page->LeftColumnClass ?>"><?= $Page->last_status->caption() ?><?= $Page->last_status->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->last_status->cellAttributes() ?>>
<span id="el_service_report_last_status">
<div class="input-group flex-nowrap">
    <select
        id="x_last_status"
        name="x_last_status"
        class="form-select ew-select<?= $Page->last_status->isInvalidClass() ?>"
        <?php if (!$Page->last_status->IsNativeSelect) { ?>
        data-select2-id="fservice_reportedit_x_last_status"
        <?php } ?>
        data-table="service_report"
        data-field="x_last_status"
        data-value-separator="<?= $Page->last_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->last_status->getPlaceHolder()) ?>"
        <?= $Page->last_status->editAttributes() ?>>
        <?= $Page->last_status->selectOptionListHtml("x_last_status") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "service_misc") && !$Page->last_status->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_last_status" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->last_status->caption() ?>" data-title="<?= $Page->last_status->caption() ?>" data-ew-action="add-option" data-el="x_last_status" data-url="<?= GetUrl("servicemiscaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->last_status->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->last_status->getErrorMessage() ?></div>
<?= $Page->last_status->Lookup->getParamTag($Page, "p_x_last_status") ?>
<?php if (!$Page->last_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fservice_reportedit", function() {
    var options = { name: "x_last_status", selectId: "fservice_reportedit_x_last_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fservice_reportedit.lists.last_status?.lookupOptions.length) {
        options.data = { id: "x_last_status", form: "fservice_reportedit" };
    } else {
        options.ajax = { id: "x_last_status", form: "fservice_reportedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.service_report.fields.last_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_service_report_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_service_report_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="service_report"
        data-field="x_uploads"
        data-size="500"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->uploads->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="<?= (Post("fa_x_uploads") == "0") ? "0" : "1" ?>">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->out_time->Visible) { // out_time ?>
    <div id="r_out_time"<?= $Page->out_time->rowAttributes() ?>>
        <label id="elh_service_report_out_time" for="x_out_time" class="<?= $Page->LeftColumnClass ?>"><?= $Page->out_time->caption() ?><?= $Page->out_time->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->out_time->cellAttributes() ?>>
<span id="el_service_report_out_time">
<input type="<?= $Page->out_time->getInputTextType() ?>" name="x_out_time" id="x_out_time" data-table="service_report" data-field="x_out_time" value="<?= $Page->out_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->out_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->out_time->formatPattern()) ?>"<?= $Page->out_time->editAttributes() ?> aria-describedby="x_out_time_help">
<?= $Page->out_time->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->out_time->getErrorMessage() ?></div>
<?php if (!$Page->out_time->ReadOnly && !$Page->out_time->Disabled && !isset($Page->out_time->EditAttrs["readonly"]) && !isset($Page->out_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_reportedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_reportedit", "x_out_time", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->invoice->Visible) { // invoice ?>
    <div id="r_invoice"<?= $Page->invoice->rowAttributes() ?>>
        <label id="elh_service_report_invoice" for="x_invoice" class="<?= $Page->LeftColumnClass ?>"><?= $Page->invoice->caption() ?><?= $Page->invoice->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->invoice->cellAttributes() ?>>
<span id="el_service_report_invoice">
<input type="<?= $Page->invoice->getInputTextType() ?>" name="x_invoice" id="x_invoice" data-table="service_report" data-field="x_invoice" value="<?= $Page->invoice->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->invoice->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice->formatPattern()) ?>"<?= $Page->invoice->editAttributes() ?> aria-describedby="x_invoice_help">
<?= $Page->invoice->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->invoice->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->invoice_date->Visible) { // invoice_date ?>
    <div id="r_invoice_date"<?= $Page->invoice_date->rowAttributes() ?>>
        <label id="elh_service_report_invoice_date" for="x_invoice_date" class="<?= $Page->LeftColumnClass ?>"><?= $Page->invoice_date->caption() ?><?= $Page->invoice_date->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->invoice_date->cellAttributes() ?>>
<span id="el_service_report_invoice_date">
<input type="<?= $Page->invoice_date->getInputTextType() ?>" name="x_invoice_date" id="x_invoice_date" data-table="service_report" data-field="x_invoice_date" value="<?= $Page->invoice_date->EditValue ?>" placeholder="<?= HtmlEncode($Page->invoice_date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->invoice_date->formatPattern()) ?>"<?= $Page->invoice_date->editAttributes() ?> aria-describedby="x_invoice_date_help">
<?= $Page->invoice_date->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->invoice_date->getErrorMessage() ?></div>
<?php if (!$Page->invoice_date->ReadOnly && !$Page->invoice_date->Disabled && !isset($Page->invoice_date->EditAttrs["readonly"]) && !isset($Page->invoice_date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fservice_reportedit", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fservice_reportedit", "x_invoice_date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fservice_reportedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fservice_reportedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("service_report");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    		var HI = $('#x_hardware_id').val();
    		document.cookie = "HI="+HI+";path=/";
    		if (HI.length > 0)
    		{
    		$('#errorh').remove();
    		$.getJSON(window.location.origin +"/apcajaxtc?clientlastdata="+HI,function(data){
    			$("#r_hardware_id").append('<span style="color:red" id="errorh">'+data+'</span>')
    		});
    		}
    $("#elh_service_report_product_replaced").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="material_out_wbc" data-caption="Add Replaced Spares" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/materialoutwbcadd?P=3,4,8,10&O=" data-btn="SaveBtn" data-bs-original-title="Add Replaced Spares"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
    $("#elh_service_report_consumable_replaced").append('<br><button type="button" class="btn btn-default btn-sm"><span style="color:red" <a data-table="material_out_wbc" data-caption="Add Consumables" data-ew-action="modal" data-action="add" data-ajax="false" data-url="/materialoutwbcadd?P=5,6,7,9&O=" data-btn="SaveBtn" data-bs-original-title="Add  Consumables"><i class="fa-solid fa-plus ew-icon"></i></a></span></button>');
    getLocation();
});
</script>
