<?php

namespace PHPMaker2024\fibre;

// Page object
$SampleReqCartSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { sample_req_cart: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fsample_req_cartsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fsample_req_cartsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["request_by", [], fields.request_by.isInvalid],
            ["old_ref", [], fields.old_ref.isInvalid],
            ["upload", [], fields.upload.isInvalid],
            ["design", [ew.Validators.regex(/^[^,]+$/)], fields.design.isInvalid],
            ["color", [ew.Validators.regex(/^[^,]+$/)], fields.color.isInvalid],
            ["size", [ew.Validators.regex(/^[^,]+$/)], fields.size.isInvalid],
            ["quantity", [ew.Validators.integer], fields.quantity.isInvalid],
            ["comments", [], fields.comments.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["y_datetime", [ew.Validators.between], false],
            ["status", [], fields.status.isInvalid],
            ["shipping_mode", [], fields.shipping_mode.isInvalid],
            ["delivery_week", [], fields.delivery_week.isInvalid],
            ["_barcode", [], fields._barcode.isInvalid],
            ["app_status", [], fields.app_status.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "request_by": <?= $Page->request_by->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "shipping_mode": <?= $Page->shipping_mode->toClientList($Page) ?>,
            "delivery_week": <?= $Page->delivery_week->toClientList($Page) ?>,
            "app_status": <?= $Page->app_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fsample_req_cartsearch" id="fsample_req_cartsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="sample_req_cart" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->request_by->Visible) { // request_by ?>
    <div id="r_request_by" class="row"<?= $Page->request_by->rowAttributes() ?>>
        <label for="x_request_by" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_request_by"><?= $Page->request_by->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_request_by" id="z_request_by" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->request_by->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_request_by" class="ew-search-field ew-search-field-single">
    <select
        id="x_request_by"
        name="x_request_by"
        class="form-select ew-select<?= $Page->request_by->isInvalidClass() ?>"
        <?php if (!$Page->request_by->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cartsearch_x_request_by"
        <?php } ?>
        data-table="sample_req_cart"
        data-field="x_request_by"
        data-value-separator="<?= $Page->request_by->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->request_by->getPlaceHolder()) ?>"
        <?= $Page->request_by->editAttributes() ?>>
        <?= $Page->request_by->selectOptionListHtml("x_request_by") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->request_by->getErrorMessage(false) ?></div>
<?= $Page->request_by->Lookup->getParamTag($Page, "p_x_request_by") ?>
<?php if (!$Page->request_by->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cartsearch", function() {
    var options = { name: "x_request_by", selectId: "fsample_req_cartsearch_x_request_by" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cartsearch.lists.request_by?.lookupOptions.length) {
        options.data = { id: "x_request_by", form: "fsample_req_cartsearch" };
    } else {
        options.ajax = { id: "x_request_by", form: "fsample_req_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart.fields.request_by.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->old_ref->Visible) { // old_ref ?>
    <div id="r_old_ref" class="row"<?= $Page->old_ref->rowAttributes() ?>>
        <label for="x_old_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_old_ref"><?= $Page->old_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_old_ref" id="z_old_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->old_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_old_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->old_ref->getInputTextType() ?>" name="x_old_ref" id="x_old_ref" data-table="sample_req_cart" data-field="x_old_ref" value="<?= $Page->old_ref->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->old_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->old_ref->formatPattern()) ?>"<?= $Page->old_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->old_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->upload->Visible) { // upload ?>
    <div id="r_upload" class="row"<?= $Page->upload->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_upload"><?= $Page->upload->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_upload" id="z_upload" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->upload->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_upload" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->upload->getInputTextType() ?>" name="x_upload" id="x_upload" data-table="sample_req_cart" data-field="x_upload" value="<?= $Page->upload->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->upload->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->upload->formatPattern()) ?>"<?= $Page->upload->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->upload->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design" class="row"<?= $Page->design->rowAttributes() ?>>
        <label for="x_design" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_design"><?= $Page->design->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_design" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design->getInputTextType() ?>" name="x_design" id="x_design" data-table="sample_req_cart" data-field="x_design" value="<?= $Page->design->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design->formatPattern()) ?>"<?= $Page->design->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->color->Visible) { // color ?>
    <div id="r_color" class="row"<?= $Page->color->rowAttributes() ?>>
        <label for="x_color" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_color"><?= $Page->color->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_color" id="z_color" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->color->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_color" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->color->getInputTextType() ?>" name="x_color" id="x_color" data-table="sample_req_cart" data-field="x_color" value="<?= $Page->color->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->color->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->color->formatPattern()) ?>"<?= $Page->color->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->color->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size" class="row"<?= $Page->size->rowAttributes() ?>>
        <label for="x_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_size"><?= $Page->size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size" id="z_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size->getInputTextType() ?>" name="x_size" id="x_size" data-table="sample_req_cart" data-field="x_size" value="<?= $Page->size->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size->formatPattern()) ?>"<?= $Page->size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="sample_req_cart" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->comments->Visible) { // comments ?>
    <div id="r_comments" class="row"<?= $Page->comments->rowAttributes() ?>>
        <label for="x_comments" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_comments"><?= $Page->comments->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_comments" id="z_comments" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->comments->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_comments" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->comments->getInputTextType() ?>" name="x_comments" id="x_comments" data-table="sample_req_cart" data-field="x_comments" value="<?= $Page->comments->EditValue ?>" maxlength="250" placeholder="<?= HtmlEncode($Page->comments->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->comments->formatPattern()) ?>"<?= $Page->comments->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->comments->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_datetime"><?= $Page->datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_datetime" id="z_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_sample_req_cart_datetime" class="ew-search-field">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="sample_req_cart" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsample_req_cartsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fsample_req_cartsearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_sample_req_cart_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="y_datetime" id="y_datetime" data-table="sample_req_cart" data-field="x_datetime" value="<?= $Page->datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsample_req_cartsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fsample_req_cartsearch", "y_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase(">=") ?>
<input type="hidden" name="z_status" id="z_status" value="&gt;=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cartsearch_x_status"
        <?php } ?>
        data-table="sample_req_cart"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cartsearch", function() {
    var options = { name: "x_status", selectId: "fsample_req_cartsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cartsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fsample_req_cartsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fsample_req_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->shipping_mode->Visible) { // shipping_mode ?>
    <div id="r_shipping_mode" class="row"<?= $Page->shipping_mode->rowAttributes() ?>>
        <label for="x_shipping_mode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_shipping_mode"><?= $Page->shipping_mode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_shipping_mode" id="z_shipping_mode" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->shipping_mode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_shipping_mode" class="ew-search-field ew-search-field-single">
    <select
        id="x_shipping_mode"
        name="x_shipping_mode"
        class="form-select ew-select<?= $Page->shipping_mode->isInvalidClass() ?>"
        <?php if (!$Page->shipping_mode->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cartsearch_x_shipping_mode"
        <?php } ?>
        data-table="sample_req_cart"
        data-field="x_shipping_mode"
        data-value-separator="<?= $Page->shipping_mode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shipping_mode->getPlaceHolder()) ?>"
        <?= $Page->shipping_mode->editAttributes() ?>>
        <?= $Page->shipping_mode->selectOptionListHtml("x_shipping_mode") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->shipping_mode->getErrorMessage(false) ?></div>
<?php if (!$Page->shipping_mode->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cartsearch", function() {
    var options = { name: "x_shipping_mode", selectId: "fsample_req_cartsearch_x_shipping_mode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cartsearch.lists.shipping_mode?.lookupOptions.length) {
        options.data = { id: "x_shipping_mode", form: "fsample_req_cartsearch" };
    } else {
        options.ajax = { id: "x_shipping_mode", form: "fsample_req_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart.fields.shipping_mode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_week->Visible) { // delivery_week ?>
    <div id="r_delivery_week" class="row"<?= $Page->delivery_week->rowAttributes() ?>>
        <label for="x_delivery_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_delivery_week"><?= $Page->delivery_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_delivery_week" id="z_delivery_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_delivery_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_delivery_week"
        name="x_delivery_week"
        class="form-select ew-select<?= $Page->delivery_week->isInvalidClass() ?>"
        <?php if (!$Page->delivery_week->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cartsearch_x_delivery_week"
        <?php } ?>
        data-table="sample_req_cart"
        data-field="x_delivery_week"
        data-value-separator="<?= $Page->delivery_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->delivery_week->getPlaceHolder()) ?>"
        <?= $Page->delivery_week->editAttributes() ?>>
        <?= $Page->delivery_week->selectOptionListHtml("x_delivery_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->delivery_week->getErrorMessage(false) ?></div>
<?= $Page->delivery_week->Lookup->getParamTag($Page, "p_x_delivery_week") ?>
<?php if (!$Page->delivery_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cartsearch", function() {
    var options = { name: "x_delivery_week", selectId: "fsample_req_cartsearch_x_delivery_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cartsearch.lists.delivery_week?.lookupOptions.length) {
        options.data = { id: "x_delivery_week", form: "fsample_req_cartsearch" };
    } else {
        options.ajax = { id: "x_delivery_week", form: "fsample_req_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart.fields.delivery_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_barcode->Visible) { // barcode ?>
    <div id="r__barcode" class="row"<?= $Page->_barcode->rowAttributes() ?>>
        <label for="x__barcode" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart__barcode"><?= $Page->_barcode->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z__barcode" id="z__barcode" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_barcode->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart__barcode" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_barcode->getInputTextType() ?>" name="x__barcode" id="x__barcode" data-table="sample_req_cart" data-field="x__barcode" value="<?= $Page->_barcode->EditValue ?>" size="35" maxlength="65535" placeholder="<?= HtmlEncode($Page->_barcode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_barcode->formatPattern()) ?>"<?= $Page->_barcode->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_barcode->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->app_status->Visible) { // app_status ?>
    <div id="r_app_status" class="row"<?= $Page->app_status->rowAttributes() ?>>
        <label for="x_app_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_app_status"><?= $Page->app_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_app_status" id="z_app_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->app_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_app_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_app_status"
        name="x_app_status"
        class="form-select ew-select<?= $Page->app_status->isInvalidClass() ?>"
        <?php if (!$Page->app_status->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cartsearch_x_app_status"
        <?php } ?>
        data-table="sample_req_cart"
        data-field="x_app_status"
        data-value-separator="<?= $Page->app_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->app_status->getPlaceHolder()) ?>"
        <?= $Page->app_status->editAttributes() ?>>
        <?= $Page->app_status->selectOptionListHtml("x_app_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->app_status->getErrorMessage(false) ?></div>
<?= $Page->app_status->Lookup->getParamTag($Page, "p_x_app_status") ?>
<?php if (!$Page->app_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cartsearch", function() {
    var options = { name: "x_app_status", selectId: "fsample_req_cartsearch_x_app_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cartsearch.lists.app_status?.lookupOptions.length) {
        options.data = { id: "x_app_status", form: "fsample_req_cartsearch" };
    } else {
        options.ajax = { id: "x_app_status", form: "fsample_req_cartsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart.fields.app_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fsample_req_cartsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fsample_req_cartsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fsample_req_cartsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("sample_req_cart");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
