<?php

namespace PHPMaker2024\fibre;

// Page object
$SampleReqCartPreDispatchSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { sample_req_cart_pre_dispatch: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fsample_req_cart_pre_dispatchsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fsample_req_cart_pre_dispatchsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["partner_id", [ew.Validators.integer], fields.partner_id.isInvalid],
            ["old_ref", [], fields.old_ref.isInvalid],
            ["design", [], fields.design.isInvalid],
            ["color", [], fields.color.isInvalid],
            ["size", [], fields.size.isInvalid],
            ["quantity", [ew.Validators.integer], fields.quantity.isInvalid],
            ["delivery_week", [], fields.delivery_week.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["upload", [], fields.upload.isInvalid],
            ["po_remarks", [], fields.po_remarks.isInvalid],
            ["sp_remarks", [], fields.sp_remarks.isInvalid],
            ["bom", [], fields.bom.isInvalid],
            ["pd_upload", [], fields.pd_upload.isInvalid],
            ["pd_comments", [], fields.pd_comments.isInvalid],
            ["da_status", [], fields.da_status.isInvalid],
            ["pd_operator", [ew.Validators.integer], fields.pd_operator.isInvalid],
            ["pd_datetime", [ew.Validators.datetime(fields.pd_datetime.clientFormatPattern)], fields.pd_datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
            "delivery_week": <?= $Page->delivery_week->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "da_status": <?= $Page->da_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fsample_req_cart_pre_dispatchsearch" id="fsample_req_cart_pre_dispatchsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart_pre_dispatch">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="sample_req_cart_pre_dispatch" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->old_ref->Visible) { // old_ref ?>
    <div id="r_old_ref" class="row"<?= $Page->old_ref->rowAttributes() ?>>
        <label for="x_old_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_old_ref"><?= $Page->old_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_old_ref" id="z_old_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->old_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_old_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->old_ref->getInputTextType() ?>" name="x_old_ref" id="x_old_ref" data-table="sample_req_cart_pre_dispatch" data-field="x_old_ref" value="<?= $Page->old_ref->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->old_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->old_ref->formatPattern()) ?>"<?= $Page->old_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->old_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design" class="row"<?= $Page->design->rowAttributes() ?>>
        <label for="x_design" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_design"><?= $Page->design->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_design" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design->getInputTextType() ?>" name="x_design" id="x_design" data-table="sample_req_cart_pre_dispatch" data-field="x_design" value="<?= $Page->design->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design->formatPattern()) ?>"<?= $Page->design->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->color->Visible) { // color ?>
    <div id="r_color" class="row"<?= $Page->color->rowAttributes() ?>>
        <label for="x_color" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_color"><?= $Page->color->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_color" id="z_color" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->color->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_color" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->color->getInputTextType() ?>" name="x_color" id="x_color" data-table="sample_req_cart_pre_dispatch" data-field="x_color" value="<?= $Page->color->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->color->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->color->formatPattern()) ?>"<?= $Page->color->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->color->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size" class="row"<?= $Page->size->rowAttributes() ?>>
        <label for="x_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_size"><?= $Page->size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size" id="z_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size->getInputTextType() ?>" name="x_size" id="x_size" data-table="sample_req_cart_pre_dispatch" data-field="x_size" value="<?= $Page->size->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size->formatPattern()) ?>"<?= $Page->size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="sample_req_cart_pre_dispatch" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_week->Visible) { // delivery_week ?>
    <div id="r_delivery_week" class="row"<?= $Page->delivery_week->rowAttributes() ?>>
        <label for="x_delivery_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_delivery_week"><?= $Page->delivery_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_delivery_week" id="z_delivery_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_delivery_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_delivery_week"
        name="x_delivery_week"
        class="form-select ew-select<?= $Page->delivery_week->isInvalidClass() ?>"
        <?php if (!$Page->delivery_week->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cart_pre_dispatchsearch_x_delivery_week"
        <?php } ?>
        data-table="sample_req_cart_pre_dispatch"
        data-field="x_delivery_week"
        data-value-separator="<?= $Page->delivery_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->delivery_week->getPlaceHolder()) ?>"
        <?= $Page->delivery_week->editAttributes() ?>>
        <?= $Page->delivery_week->selectOptionListHtml("x_delivery_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->delivery_week->getErrorMessage(false) ?></div>
<?= $Page->delivery_week->Lookup->getParamTag($Page, "p_x_delivery_week") ?>
<?php if (!$Page->delivery_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cart_pre_dispatchsearch", function() {
    var options = { name: "x_delivery_week", selectId: "fsample_req_cart_pre_dispatchsearch_x_delivery_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cart_pre_dispatchsearch.lists.delivery_week?.lookupOptions.length) {
        options.data = { id: "x_delivery_week", form: "fsample_req_cart_pre_dispatchsearch" };
    } else {
        options.ajax = { id: "x_delivery_week", form: "fsample_req_cart_pre_dispatchsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart_pre_dispatch.fields.delivery_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cart_pre_dispatchsearch_x_status"
        <?php } ?>
        data-table="sample_req_cart_pre_dispatch"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cart_pre_dispatchsearch", function() {
    var options = { name: "x_status", selectId: "fsample_req_cart_pre_dispatchsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cart_pre_dispatchsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fsample_req_cart_pre_dispatchsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fsample_req_cart_pre_dispatchsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart_pre_dispatch.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->upload->Visible) { // upload ?>
    <div id="r_upload" class="row"<?= $Page->upload->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_upload"><?= $Page->upload->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_upload" id="z_upload" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->upload->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_upload" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->upload->getInputTextType() ?>" name="x_upload" id="x_upload" data-table="sample_req_cart_pre_dispatch" data-field="x_upload" value="<?= $Page->upload->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->upload->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->upload->formatPattern()) ?>"<?= $Page->upload->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->upload->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_remarks->Visible) { // po_remarks ?>
    <div id="r_po_remarks" class="row"<?= $Page->po_remarks->rowAttributes() ?>>
        <label for="x_po_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_po_remarks"><?= $Page->po_remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_po_remarks" id="z_po_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_po_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_remarks->getInputTextType() ?>" name="x_po_remarks" id="x_po_remarks" data-table="sample_req_cart_pre_dispatch" data-field="x_po_remarks" value="<?= $Page->po_remarks->EditValue ?>" size="30" maxlength="200" placeholder="<?= HtmlEncode($Page->po_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_remarks->formatPattern()) ?>"<?= $Page->po_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sp_remarks->Visible) { // sp_remarks ?>
    <div id="r_sp_remarks" class="row"<?= $Page->sp_remarks->rowAttributes() ?>>
        <label for="x_sp_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_sp_remarks"><?= $Page->sp_remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sp_remarks" id="z_sp_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sp_remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_sp_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sp_remarks->getInputTextType() ?>" name="x_sp_remarks" id="x_sp_remarks" data-table="sample_req_cart_pre_dispatch" data-field="x_sp_remarks" value="<?= $Page->sp_remarks->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->sp_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sp_remarks->formatPattern()) ?>"<?= $Page->sp_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sp_remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->bom->Visible) { // bom ?>
    <div id="r_bom" class="row"<?= $Page->bom->rowAttributes() ?>>
        <label for="x_bom" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_bom"><?= $Page->bom->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_bom" id="z_bom" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->bom->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_bom" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->bom->getInputTextType() ?>" name="x_bom" id="x_bom" data-table="sample_req_cart_pre_dispatch" data-field="x_bom" value="<?= $Page->bom->EditValue ?>" size="35" maxlength="1000" placeholder="<?= HtmlEncode($Page->bom->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->bom->formatPattern()) ?>"<?= $Page->bom->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->bom->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pd_upload->Visible) { // pd_upload ?>
    <div id="r_pd_upload" class="row"<?= $Page->pd_upload->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_pd_upload"><?= $Page->pd_upload->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pd_upload" id="z_pd_upload" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pd_upload->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_pd_upload" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pd_upload->getInputTextType() ?>" name="x_pd_upload" id="x_pd_upload" data-table="sample_req_cart_pre_dispatch" data-field="x_pd_upload" value="<?= $Page->pd_upload->EditValue ?>" maxlength="300" placeholder="<?= HtmlEncode($Page->pd_upload->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pd_upload->formatPattern()) ?>"<?= $Page->pd_upload->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pd_upload->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pd_comments->Visible) { // pd_comments ?>
    <div id="r_pd_comments" class="row"<?= $Page->pd_comments->rowAttributes() ?>>
        <label for="x_pd_comments" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_pd_comments"><?= $Page->pd_comments->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_pd_comments" id="z_pd_comments" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pd_comments->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_pd_comments" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pd_comments->getInputTextType() ?>" name="x_pd_comments" id="x_pd_comments" data-table="sample_req_cart_pre_dispatch" data-field="x_pd_comments" value="<?= $Page->pd_comments->EditValue ?>" size="35" maxlength="1000" placeholder="<?= HtmlEncode($Page->pd_comments->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pd_comments->formatPattern()) ?>"<?= $Page->pd_comments->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pd_comments->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->da_status->Visible) { // da_status ?>
    <div id="r_da_status" class="row"<?= $Page->da_status->rowAttributes() ?>>
        <label for="x_da_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_da_status"><?= $Page->da_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_da_status" id="z_da_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->da_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_da_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_da_status"
        name="x_da_status"
        class="form-select ew-select<?= $Page->da_status->isInvalidClass() ?>"
        <?php if (!$Page->da_status->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cart_pre_dispatchsearch_x_da_status"
        <?php } ?>
        data-table="sample_req_cart_pre_dispatch"
        data-field="x_da_status"
        data-value-separator="<?= $Page->da_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->da_status->getPlaceHolder()) ?>"
        <?= $Page->da_status->editAttributes() ?>>
        <?= $Page->da_status->selectOptionListHtml("x_da_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->da_status->getErrorMessage(false) ?></div>
<?= $Page->da_status->Lookup->getParamTag($Page, "p_x_da_status") ?>
<?php if (!$Page->da_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cart_pre_dispatchsearch", function() {
    var options = { name: "x_da_status", selectId: "fsample_req_cart_pre_dispatchsearch_x_da_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cart_pre_dispatchsearch.lists.da_status?.lookupOptions.length) {
        options.data = { id: "x_da_status", form: "fsample_req_cart_pre_dispatchsearch" };
    } else {
        options.ajax = { id: "x_da_status", form: "fsample_req_cart_pre_dispatchsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart_pre_dispatch.fields.da_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pd_operator->Visible) { // pd_operator ?>
    <div id="r_pd_operator" class="row"<?= $Page->pd_operator->rowAttributes() ?>>
        <label for="x_pd_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_pd_operator"><?= $Page->pd_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pd_operator" id="z_pd_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pd_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_pd_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pd_operator->getInputTextType() ?>" name="x_pd_operator" id="x_pd_operator" data-table="sample_req_cart_pre_dispatch" data-field="x_pd_operator" value="<?= $Page->pd_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pd_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pd_operator->formatPattern()) ?>"<?= $Page->pd_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pd_operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pd_datetime->Visible) { // pd_datetime ?>
    <div id="r_pd_datetime" class="row"<?= $Page->pd_datetime->rowAttributes() ?>>
        <label for="x_pd_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_pre_dispatch_pd_datetime"><?= $Page->pd_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pd_datetime" id="z_pd_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pd_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_pre_dispatch_pd_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->pd_datetime->getInputTextType() ?>" name="x_pd_datetime" id="x_pd_datetime" data-table="sample_req_cart_pre_dispatch" data-field="x_pd_datetime" value="<?= $Page->pd_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->pd_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pd_datetime->formatPattern()) ?>"<?= $Page->pd_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pd_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->pd_datetime->ReadOnly && !$Page->pd_datetime->Disabled && !isset($Page->pd_datetime->EditAttrs["readonly"]) && !isset($Page->pd_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsample_req_cart_pre_dispatchsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fsample_req_cart_pre_dispatchsearch", "x_pd_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fsample_req_cart_pre_dispatchsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fsample_req_cart_pre_dispatchsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fsample_req_cart_pre_dispatchsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("sample_req_cart_pre_dispatch");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
