<?php

namespace PHPMaker2024\fibre;

// Page object
$SampleReqCartPoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { sample_req_cart_po: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fsample_req_cart_posearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fsample_req_cart_posearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["upload", [], fields.upload.isInvalid],
            ["old_ref", [], fields.old_ref.isInvalid],
            ["design", [], fields.design.isInvalid],
            ["color", [], fields.color.isInvalid],
            ["size", [], fields.size.isInvalid],
            ["quantity", [ew.Validators.integer], fields.quantity.isInvalid],
            ["delivery_week", [], fields.delivery_week.isInvalid],
            ["sp_remarks", [], fields.sp_remarks.isInvalid],
            ["po_remarks", [], fields.po_remarks.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["y_status", [ew.Validators.between], false],
            ["po_operator", [ew.Validators.integer], fields.po_operator.isInvalid],
            ["po_datetime", [ew.Validators.datetime(fields.po_datetime.clientFormatPattern)], fields.po_datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "delivery_week": <?= $Page->delivery_week->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fsample_req_cart_posearch" id="fsample_req_cart_posearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart_po">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="sample_req_cart_po" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->upload->Visible) { // upload ?>
    <div id="r_upload" class="row"<?= $Page->upload->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_upload"><?= $Page->upload->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_upload" id="z_upload" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->upload->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_upload" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->upload->getInputTextType() ?>" name="x_upload" id="x_upload" data-table="sample_req_cart_po" data-field="x_upload" value="<?= $Page->upload->EditValue ?>" maxlength="500" placeholder="<?= HtmlEncode($Page->upload->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->upload->formatPattern()) ?>"<?= $Page->upload->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->upload->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->old_ref->Visible) { // old_ref ?>
    <div id="r_old_ref" class="row"<?= $Page->old_ref->rowAttributes() ?>>
        <label for="x_old_ref" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_old_ref"><?= $Page->old_ref->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_old_ref" id="z_old_ref" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->old_ref->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_old_ref" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->old_ref->getInputTextType() ?>" name="x_old_ref" id="x_old_ref" data-table="sample_req_cart_po" data-field="x_old_ref" value="<?= $Page->old_ref->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->old_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->old_ref->formatPattern()) ?>"<?= $Page->old_ref->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->old_ref->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design" class="row"<?= $Page->design->rowAttributes() ?>>
        <label for="x_design" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_design"><?= $Page->design->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_design" id="z_design" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->design->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_design" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->design->getInputTextType() ?>" name="x_design" id="x_design" data-table="sample_req_cart_po" data-field="x_design" value="<?= $Page->design->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design->formatPattern()) ?>"<?= $Page->design->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->color->Visible) { // color ?>
    <div id="r_color" class="row"<?= $Page->color->rowAttributes() ?>>
        <label for="x_color" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_color"><?= $Page->color->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_color" id="z_color" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->color->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_color" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->color->getInputTextType() ?>" name="x_color" id="x_color" data-table="sample_req_cart_po" data-field="x_color" value="<?= $Page->color->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->color->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->color->formatPattern()) ?>"<?= $Page->color->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->color->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size" class="row"<?= $Page->size->rowAttributes() ?>>
        <label for="x_size" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_size"><?= $Page->size->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_size" id="z_size" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->size->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_size" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->size->getInputTextType() ?>" name="x_size" id="x_size" data-table="sample_req_cart_po" data-field="x_size" value="<?= $Page->size->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size->formatPattern()) ?>"<?= $Page->size->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity" class="row"<?= $Page->quantity->rowAttributes() ?>>
        <label for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_quantity"><?= $Page->quantity->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_quantity" id="z_quantity" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->quantity->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_quantity" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="sample_req_cart_po" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->delivery_week->Visible) { // delivery_week ?>
    <div id="r_delivery_week" class="row"<?= $Page->delivery_week->rowAttributes() ?>>
        <label for="x_delivery_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_delivery_week"><?= $Page->delivery_week->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_delivery_week" id="z_delivery_week" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->delivery_week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_delivery_week" class="ew-search-field ew-search-field-single">
    <select
        id="x_delivery_week"
        name="x_delivery_week"
        class="form-select ew-select<?= $Page->delivery_week->isInvalidClass() ?>"
        <?php if (!$Page->delivery_week->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cart_posearch_x_delivery_week"
        <?php } ?>
        data-table="sample_req_cart_po"
        data-field="x_delivery_week"
        data-value-separator="<?= $Page->delivery_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->delivery_week->getPlaceHolder()) ?>"
        <?= $Page->delivery_week->editAttributes() ?>>
        <?= $Page->delivery_week->selectOptionListHtml("x_delivery_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->delivery_week->getErrorMessage(false) ?></div>
<?= $Page->delivery_week->Lookup->getParamTag($Page, "p_x_delivery_week") ?>
<?php if (!$Page->delivery_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cart_posearch", function() {
    var options = { name: "x_delivery_week", selectId: "fsample_req_cart_posearch_x_delivery_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cart_posearch.lists.delivery_week?.lookupOptions.length) {
        options.data = { id: "x_delivery_week", form: "fsample_req_cart_posearch" };
    } else {
        options.ajax = { id: "x_delivery_week", form: "fsample_req_cart_posearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart_po.fields.delivery_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sp_remarks->Visible) { // sp_remarks ?>
    <div id="r_sp_remarks" class="row"<?= $Page->sp_remarks->rowAttributes() ?>>
        <label for="x_sp_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_sp_remarks"><?= $Page->sp_remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sp_remarks" id="z_sp_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sp_remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_sp_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sp_remarks->getInputTextType() ?>" name="x_sp_remarks" id="x_sp_remarks" data-table="sample_req_cart_po" data-field="x_sp_remarks" value="<?= $Page->sp_remarks->EditValue ?>" size="35" maxlength="500" placeholder="<?= HtmlEncode($Page->sp_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sp_remarks->formatPattern()) ?>"<?= $Page->sp_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sp_remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_remarks->Visible) { // po_remarks ?>
    <div id="r_po_remarks" class="row"<?= $Page->po_remarks->rowAttributes() ?>>
        <label for="x_po_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_po_remarks"><?= $Page->po_remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_po_remarks" id="z_po_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_po_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_remarks->getInputTextType() ?>" name="x_po_remarks" id="x_po_remarks" data-table="sample_req_cart_po" data-field="x_po_remarks" value="<?= $Page->po_remarks->EditValue ?>" size="35" maxlength="200" placeholder="<?= HtmlEncode($Page->po_remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_remarks->formatPattern()) ?>"<?= $Page->po_remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_status"><?= $Page->status->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_status" id="z_status" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->status->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->status->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_sample_req_cart_po_status" class="ew-search-field">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cart_posearch_x_status"
        <?php } ?>
        data-table="sample_req_cart_po"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_x_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cart_posearch", function() {
    var options = { name: "x_status", selectId: "fsample_req_cart_posearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cart_posearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fsample_req_cart_posearch" };
    } else {
        options.ajax = { id: "x_status", form: "fsample_req_cart_posearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart_po.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_sample_req_cart_po_status" class="ew-search-field2 d-none">
    <select
        id="y_status"
        name="y_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cart_posearch_y_status"
        <?php } ?>
        data-table="sample_req_cart_po"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("y_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?= $Page->status->Lookup->getParamTag($Page, "p_y_status") ?>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cart_posearch", function() {
    var options = { name: "y_status", selectId: "fsample_req_cart_posearch_y_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cart_posearch.lists.status?.lookupOptions.length) {
        options.data = { id: "y_status", form: "fsample_req_cart_posearch" };
    } else {
        options.ajax = { id: "y_status", form: "fsample_req_cart_posearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart_po.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_operator->Visible) { // po_operator ?>
    <div id="r_po_operator" class="row"<?= $Page->po_operator->rowAttributes() ?>>
        <label for="x_po_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_po_operator"><?= $Page->po_operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_operator" id="z_po_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_po_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_operator->getInputTextType() ?>" name="x_po_operator" id="x_po_operator" data-table="sample_req_cart_po" data-field="x_po_operator" value="<?= $Page->po_operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_operator->formatPattern()) ?>"<?= $Page->po_operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_datetime->Visible) { // po_datetime ?>
    <div id="r_po_datetime" class="row"<?= $Page->po_datetime->rowAttributes() ?>>
        <label for="x_po_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_sample_req_cart_po_po_datetime"><?= $Page->po_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_datetime" id="z_po_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_sample_req_cart_po_po_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_datetime->getInputTextType() ?>" name="x_po_datetime" id="x_po_datetime" data-table="sample_req_cart_po" data-field="x_po_datetime" value="<?= $Page->po_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->po_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_datetime->formatPattern()) ?>"<?= $Page->po_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->po_datetime->ReadOnly && !$Page->po_datetime->Disabled && !isset($Page->po_datetime->EditAttrs["readonly"]) && !isset($Page->po_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsample_req_cart_posearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fsample_req_cart_posearch", "x_po_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fsample_req_cart_posearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fsample_req_cart_posearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fsample_req_cart_posearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("sample_req_cart_po");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
