<?php

namespace PHPMaker2024\fibre;

// Page object
$SampleReqCartAuthUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { sample_req_cart_auth: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fsample_req_cart_authupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fsample_req_cart_authupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["company_id", [fields.company_id.visible && fields.company_id.required ? ew.Validators.required(fields.company_id.caption) : null], fields.company_id.isInvalid],
            ["partner_id", [fields.partner_id.visible && fields.partner_id.required ? ew.Validators.required(fields.partner_id.caption) : null, ew.Validators.integer, ew.Validators.selected], fields.partner_id.isInvalid],
            ["sp_remarks", [fields.sp_remarks.visible && fields.sp_remarks.required ? ew.Validators.required(fields.sp_remarks.caption) : null], fields.sp_remarks.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "partner_id": <?= $Page->partner_id->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fsample_req_cart_authupdate" id="fsample_req_cart_authupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart_auth">
<?php if ($Page->isConfirm()) { // Confirm page ?>
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="confirm" id="confirm" value="confirm">
<?php } else { ?>
<input type="hidden" name="action" id="action" value="confirm">
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_sample_req_cart_authupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"<?= $Page->Disabled ?>><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->company_id->Visible && (!$Page->isConfirm() || $Page->company_id->multiUpdateSelected())) { // company_id ?>
    <div id="r_company_id"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_company_id" id="u_company_id" class="form-check-input ew-multi-select" value="1"<?= $Page->company_id->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_company_id"><?= $Page->company_id->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_company_id" id="u_company_id" value="<?= $Page->company_id->MultiUpdate ?>">
            <?= $Page->company_id->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_sample_req_cart_auth_company_id">
                    <select
                        id="x_company_id"
                        name="x_company_id"
                        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
                        <?php if (!$Page->company_id->IsNativeSelect) { ?>
                        data-select2-id="fsample_req_cart_authupdate_x_company_id"
                        <?php } ?>
                        data-table="sample_req_cart_auth"
                        data-field="x_company_id"
                        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
                        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
                        <?= $Page->company_id->editAttributes() ?>>
                        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
                    </select>
                    <?= $Page->company_id->getCustomMessage() ?>
                    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage() ?></div>
                <?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
                <?php if (!$Page->company_id->IsNativeSelect) { ?>
                <script>
                loadjs.ready("fsample_req_cart_authupdate", function() {
                    var options = { name: "x_company_id", selectId: "fsample_req_cart_authupdate_x_company_id" },
                        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
                    if (!el)
                        return;
                    options.closeOnSelect = !options.multiple;
                    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
                    if (fsample_req_cart_authupdate.lists.company_id?.lookupOptions.length) {
                        options.data = { id: "x_company_id", form: "fsample_req_cart_authupdate" };
                    } else {
                        options.ajax = { id: "x_company_id", form: "fsample_req_cart_authupdate", limit: ew.LOOKUP_PAGE_SIZE };
                    }
                    options.minimumResultsForSearch = Infinity;
                    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart_auth.fields.company_id.selectOptions);
                    ew.createSelect(options);
                });
                </script>
                <?php } ?>
                </span>
                <?php } else { ?>
                <span id="el_sample_req_cart_auth_company_id">
                <span<?= $Page->company_id->viewAttributes() ?>>
                <span class="form-control-plaintext"><?= $Page->company_id->getDisplayValue($Page->company_id->ViewValue) ?></span></span>
                <input type="hidden" data-table="sample_req_cart_auth" data-field="x_company_id" data-hidden="1" name="x_company_id" id="x_company_id" value="<?= HtmlEncode($Page->company_id->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->partner_id->Visible && (!$Page->isConfirm() || $Page->partner_id->multiUpdateSelected())) { // partner_id ?>
    <div id="r_partner_id"<?= $Page->partner_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_partner_id" id="u_partner_id" class="form-check-input ew-multi-select" value="1"<?= $Page->partner_id->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_partner_id"><?= $Page->partner_id->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_partner_id" id="u_partner_id" value="<?= $Page->partner_id->MultiUpdate ?>">
            <?= $Page->partner_id->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->partner_id->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_sample_req_cart_auth_partner_id">
                <?php
                if (IsRTL()) {
                    $Page->partner_id->EditAttrs["dir"] = "rtl";
                }
                ?>
                <span id="as_x_partner_id" class="ew-auto-suggest">
                    <input type="<?= $Page->partner_id->getInputTextType() ?>" class="form-control" name="sv_x_partner_id" id="sv_x_partner_id" value="<?= RemoveHtml($Page->partner_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->partner_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->partner_id->formatPattern()) ?>"<?= $Page->partner_id->editAttributes() ?> aria-describedby="x_partner_id_help">
                </span>
                <selection-list hidden class="form-control" data-table="sample_req_cart_auth" data-field="x_partner_id" data-input="sv_x_partner_id" data-value-separator="<?= $Page->partner_id->displayValueSeparatorAttribute() ?>" name="x_partner_id" id="x_partner_id" value="<?= HtmlEncode($Page->partner_id->CurrentValue) ?>"></selection-list>
                <?= $Page->partner_id->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->partner_id->getErrorMessage() ?></div>
                <script>
                loadjs.ready("fsample_req_cart_authupdate", function() {
                    fsample_req_cart_authupdate.createAutoSuggest(Object.assign({"id":"x_partner_id","forceSelect":true}, { lookupAllDisplayFields: <?= $Page->partner_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.sample_req_cart_auth.fields.partner_id.autoSuggestOptions));
                });
                </script>
                <?= $Page->partner_id->Lookup->getParamTag($Page, "p_x_partner_id") ?>
                </span>
                <?php } else { ?>
                <span id="el_sample_req_cart_auth_partner_id">
                <span<?= $Page->partner_id->viewAttributes() ?>>
                <?php if (!EmptyString($Page->partner_id->ViewValue) && $Page->partner_id->linkAttributes() != "") { ?>
                <a<?= $Page->partner_id->linkAttributes() ?>><span class="form-control-plaintext"><?= $Page->partner_id->getDisplayValue($Page->partner_id->ViewValue) ?></span></a>
                <?php } else { ?>
                <span class="form-control-plaintext"><?= $Page->partner_id->getDisplayValue($Page->partner_id->ViewValue) ?></span>
                <?php } ?>
                </span>
                <input type="hidden" data-table="sample_req_cart_auth" data-field="x_partner_id" data-hidden="1" name="x_partner_id" id="x_partner_id" value="<?= HtmlEncode($Page->partner_id->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sp_remarks->Visible && (!$Page->isConfirm() || $Page->sp_remarks->multiUpdateSelected())) { // sp_remarks ?>
    <div id="r_sp_remarks"<?= $Page->sp_remarks->rowAttributes() ?>>
        <label for="x_sp_remarks" class="<?= $Page->LeftColumnClass ?>">
            <?php if (!$Page->isConfirm()) { ?>
            <div class="form-check">
                <input type="checkbox" name="u_sp_remarks" id="u_sp_remarks" class="form-check-input ew-multi-select" value="1"<?= $Page->sp_remarks->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_sp_remarks"><?= $Page->sp_remarks->caption() ?></label>
            </div>
            <?php } else { ?>
            <input type="hidden" name="u_sp_remarks" id="u_sp_remarks" value="<?= $Page->sp_remarks->MultiUpdate ?>">
            <?= $Page->sp_remarks->caption() ?>
            <?php } ?>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sp_remarks->cellAttributes() ?>>
                <?php if (!$Page->isConfirm()) { ?>
                <span id="el_sample_req_cart_auth_sp_remarks">
                <textarea data-table="sample_req_cart_auth" data-field="x_sp_remarks" name="x_sp_remarks" id="x_sp_remarks" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->sp_remarks->getPlaceHolder()) ?>"<?= $Page->sp_remarks->editAttributes() ?> aria-describedby="x_sp_remarks_help"><?= $Page->sp_remarks->EditValue ?></textarea>
                <?= $Page->sp_remarks->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->sp_remarks->getErrorMessage() ?></div>
                </span>
                <?php } else { ?>
                <span id="el_sample_req_cart_auth_sp_remarks">
                <span<?= $Page->sp_remarks->viewAttributes() ?>>
                <?= $Page->sp_remarks->ViewValue ?></span>
                <input type="hidden" data-table="sample_req_cart_auth" data-field="x_sp_remarks" data-hidden="1" name="x_sp_remarks" id="x_sp_remarks" value="<?= HtmlEncode($Page->sp_remarks->FormValue) ?>">
                </span>
                <?php } ?>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<?php if (!$Page->isConfirm()) { // Confirm page ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fsample_req_cart_authupdate" data-ew-action="set-action" data-value="confirm"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fsample_req_cart_authupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fsample_req_cart_authupdate"><?= $Language->phrase("ConfirmBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="submit" form="fsample_req_cart_authupdate" data-ew-action="set-action" data-value="cancel"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("sample_req_cart_auth");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
