<?php

namespace PHPMaker2024\fibre;

// Page object
$SampleReqCartAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { sample_req_cart: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fsample_req_cartadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fsample_req_cartadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["request_by", [fields.request_by.visible && fields.request_by.required ? ew.Validators.required(fields.request_by.caption) : null], fields.request_by.isInvalid],
            ["old_ref", [fields.old_ref.visible && fields.old_ref.required ? ew.Validators.required(fields.old_ref.caption) : null], fields.old_ref.isInvalid],
            ["upload", [fields.upload.visible && fields.upload.required ? ew.Validators.fileRequired(fields.upload.caption) : null], fields.upload.isInvalid],
            ["design", [fields.design.visible && fields.design.required ? ew.Validators.required(fields.design.caption) : null, ew.Validators.regex(/^[^,]+$/)], fields.design.isInvalid],
            ["color", [fields.color.visible && fields.color.required ? ew.Validators.required(fields.color.caption) : null, ew.Validators.regex(/^[^,]+$/)], fields.color.isInvalid],
            ["size", [fields.size.visible && fields.size.required ? ew.Validators.required(fields.size.caption) : null, ew.Validators.regex(/^[^,]+$/)], fields.size.isInvalid],
            ["quantity", [fields.quantity.visible && fields.quantity.required ? ew.Validators.required(fields.quantity.caption) : null, ew.Validators.integer], fields.quantity.isInvalid],
            ["comments", [fields.comments.visible && fields.comments.required ? ew.Validators.required(fields.comments.caption) : null], fields.comments.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "request_by": <?= $Page->request_by->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fsample_req_cartadd" id="fsample_req_cartadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="sample_req_cart">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->request_by->Visible) { // request_by ?>
    <div id="r_request_by"<?= $Page->request_by->rowAttributes() ?>>
        <label id="elh_sample_req_cart_request_by" for="x_request_by" class="<?= $Page->LeftColumnClass ?>"><?= $Page->request_by->caption() ?><?= $Page->request_by->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->request_by->cellAttributes() ?>>
<span id="el_sample_req_cart_request_by">
    <select
        id="x_request_by"
        name="x_request_by"
        class="form-select ew-select<?= $Page->request_by->isInvalidClass() ?>"
        <?php if (!$Page->request_by->IsNativeSelect) { ?>
        data-select2-id="fsample_req_cartadd_x_request_by"
        <?php } ?>
        data-table="sample_req_cart"
        data-field="x_request_by"
        data-value-separator="<?= $Page->request_by->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->request_by->getPlaceHolder()) ?>"
        <?= $Page->request_by->editAttributes() ?>>
        <?= $Page->request_by->selectOptionListHtml("x_request_by") ?>
    </select>
    <?= $Page->request_by->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->request_by->getErrorMessage() ?></div>
<?= $Page->request_by->Lookup->getParamTag($Page, "p_x_request_by") ?>
<?php if (!$Page->request_by->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_req_cartadd", function() {
    var options = { name: "x_request_by", selectId: "fsample_req_cartadd_x_request_by" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_req_cartadd.lists.request_by?.lookupOptions.length) {
        options.data = { id: "x_request_by", form: "fsample_req_cartadd" };
    } else {
        options.ajax = { id: "x_request_by", form: "fsample_req_cartadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req_cart.fields.request_by.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->old_ref->Visible) { // old_ref ?>
    <div id="r_old_ref"<?= $Page->old_ref->rowAttributes() ?>>
        <label id="elh_sample_req_cart_old_ref" for="x_old_ref" class="<?= $Page->LeftColumnClass ?>"><?= $Page->old_ref->caption() ?><?= $Page->old_ref->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->old_ref->cellAttributes() ?>>
<span id="el_sample_req_cart_old_ref">
<input type="<?= $Page->old_ref->getInputTextType() ?>" name="x_old_ref" id="x_old_ref" data-table="sample_req_cart" data-field="x_old_ref" value="<?= $Page->old_ref->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->old_ref->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->old_ref->formatPattern()) ?>"<?= $Page->old_ref->editAttributes() ?> aria-describedby="x_old_ref_help">
<?= $Page->old_ref->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->old_ref->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->upload->Visible) { // upload ?>
    <div id="r_upload"<?= $Page->upload->rowAttributes() ?>>
        <label id="elh_sample_req_cart_upload" class="<?= $Page->LeftColumnClass ?>"><?= $Page->upload->caption() ?><?= $Page->upload->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->upload->cellAttributes() ?>>
<span id="el_sample_req_cart_upload">
<div id="fd_x_upload" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_upload"
        name="x_upload"
        class="form-control ew-file-input"
        title="<?= $Page->upload->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="sample_req_cart"
        data-field="x_upload"
        data-size="500"
        data-accept-file-types="<?= $Page->upload->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->upload->UploadMaxFileSize ?>"
        data-max-number-of-files="<?= $Page->upload->UploadMaxFileCount ?>"
        data-disable-image-crop="<?= $Page->upload->ImageCropper ? 0 : 1 ?>"
        multiple
        aria-describedby="x_upload_help"
        <?= ($Page->upload->ReadOnly || $Page->upload->Disabled) ? " disabled" : "" ?>
        <?= $Page->upload->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFiles") ?></div>
    <?= $Page->upload->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->upload->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_upload" id= "fn_x_upload" value="<?= $Page->upload->Upload->FileName ?>">
<input type="hidden" name="fa_x_upload" id= "fa_x_upload" value="0">
<table id="ft_x_upload" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->design->Visible) { // design ?>
    <div id="r_design"<?= $Page->design->rowAttributes() ?>>
        <label id="elh_sample_req_cart_design" for="x_design" class="<?= $Page->LeftColumnClass ?>"><?= $Page->design->caption() ?><?= $Page->design->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->design->cellAttributes() ?>>
<span id="el_sample_req_cart_design">
<input type="<?= $Page->design->getInputTextType() ?>" name="x_design" id="x_design" data-table="sample_req_cart" data-field="x_design" value="<?= $Page->design->EditValue ?>" size="30" maxlength="192" placeholder="<?= HtmlEncode($Page->design->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->design->formatPattern()) ?>"<?= $Page->design->editAttributes() ?> aria-describedby="x_design_help">
<?= $Page->design->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->design->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->color->Visible) { // color ?>
    <div id="r_color"<?= $Page->color->rowAttributes() ?>>
        <label id="elh_sample_req_cart_color" for="x_color" class="<?= $Page->LeftColumnClass ?>"><?= $Page->color->caption() ?><?= $Page->color->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->color->cellAttributes() ?>>
<span id="el_sample_req_cart_color">
<input type="<?= $Page->color->getInputTextType() ?>" name="x_color" id="x_color" data-table="sample_req_cart" data-field="x_color" value="<?= $Page->color->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->color->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->color->formatPattern()) ?>"<?= $Page->color->editAttributes() ?> aria-describedby="x_color_help">
<?= $Page->color->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->color->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->size->Visible) { // size ?>
    <div id="r_size"<?= $Page->size->rowAttributes() ?>>
        <label id="elh_sample_req_cart_size" for="x_size" class="<?= $Page->LeftColumnClass ?>"><?= $Page->size->caption() ?><?= $Page->size->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->size->cellAttributes() ?>>
<span id="el_sample_req_cart_size">
<input type="<?= $Page->size->getInputTextType() ?>" name="x_size" id="x_size" data-table="sample_req_cart" data-field="x_size" value="<?= $Page->size->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->size->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->size->formatPattern()) ?>"<?= $Page->size->editAttributes() ?> aria-describedby="x_size_help">
<?= $Page->size->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->size->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->quantity->Visible) { // quantity ?>
    <div id="r_quantity"<?= $Page->quantity->rowAttributes() ?>>
        <label id="elh_sample_req_cart_quantity" for="x_quantity" class="<?= $Page->LeftColumnClass ?>"><?= $Page->quantity->caption() ?><?= $Page->quantity->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->quantity->cellAttributes() ?>>
<span id="el_sample_req_cart_quantity">
<input type="<?= $Page->quantity->getInputTextType() ?>" name="x_quantity" id="x_quantity" data-table="sample_req_cart" data-field="x_quantity" value="<?= $Page->quantity->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->quantity->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->quantity->formatPattern()) ?>"<?= $Page->quantity->editAttributes() ?> aria-describedby="x_quantity_help">
<?= $Page->quantity->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->quantity->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->comments->Visible) { // comments ?>
    <div id="r_comments"<?= $Page->comments->rowAttributes() ?>>
        <label id="elh_sample_req_cart_comments" for="x_comments" class="<?= $Page->LeftColumnClass ?>"><?= $Page->comments->caption() ?><?= $Page->comments->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->comments->cellAttributes() ?>>
<span id="el_sample_req_cart_comments">
<textarea data-table="sample_req_cart" data-field="x_comments" name="x_comments" id="x_comments" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->comments->getPlaceHolder()) ?>"<?= $Page->comments->editAttributes() ?> aria-describedby="x_comments_help"><?= $Page->comments->EditValue ?></textarea>
<?= $Page->comments->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->comments->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fsample_req_cartadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fsample_req_cartadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("sample_req_cart");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
