<?php

namespace PHPMaker2024\fibre;

// Page object
$SampleReqAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { sample_req: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fsample_reqadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fsample_reqadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["buyer_id", [fields.buyer_id.visible && fields.buyer_id.required ? ew.Validators.required(fields.buyer_id.caption) : null], fields.buyer_id.isInvalid],
            ["sample_cart_id", [fields.sample_cart_id.visible && fields.sample_cart_id.required ? ew.Validators.required(fields.sample_cart_id.caption) : null], fields.sample_cart_id.isInvalid],
            ["purpose", [fields.purpose.visible && fields.purpose.required ? ew.Validators.required(fields.purpose.caption) : null], fields.purpose.isInvalid],
            ["label", [fields.label.visible && fields.label.required ? ew.Validators.required(fields.label.caption) : null], fields.label.isInvalid],
            ["ssd", [fields.ssd.visible && fields.ssd.required ? ew.Validators.required(fields.ssd.caption) : null, ew.Validators.datetime(fields.ssd.clientFormatPattern)], fields.ssd.isInvalid],
            ["shipping_mode", [fields.shipping_mode.visible && fields.shipping_mode.required ? ew.Validators.required(fields.shipping_mode.caption) : null], fields.shipping_mode.isInvalid],
            ["delivery_week", [fields.delivery_week.visible && fields.delivery_week.required ? ew.Validators.required(fields.delivery_week.caption) : null], fields.delivery_week.isInvalid],
            ["shipping_address", [fields.shipping_address.visible && fields.shipping_address.required ? ew.Validators.required(fields.shipping_address.caption) : null], fields.shipping_address.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "sample_cart_id": <?= $Page->sample_cart_id->toClientList($Page) ?>,
            "purpose": <?= $Page->purpose->toClientList($Page) ?>,
            "label": <?= $Page->label->toClientList($Page) ?>,
            "shipping_mode": <?= $Page->shipping_mode->toClientList($Page) ?>,
            "delivery_week": <?= $Page->delivery_week->toClientList($Page) ?>,
            "shipping_address": <?= $Page->shipping_address->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fsample_reqadd" id="fsample_reqadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="sample_req">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id"<?= $Page->buyer_id->rowAttributes() ?>>
        <label id="elh_sample_req_buyer_id" for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->buyer_id->caption() ?><?= $Page->buyer_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->buyer_id->cellAttributes() ?>>
<span id="el_sample_req_buyer_id">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-select ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        <?php if (!$Page->buyer_id->IsNativeSelect) { ?>
        data-select2-id="fsample_reqadd_x_buyer_id"
        <?php } ?>
        data-table="sample_req"
        data-field="x_buyer_id"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <?= $Page->buyer_id->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage() ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<?php if (!$Page->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_reqadd", function() {
    var options = { name: "x_buyer_id", selectId: "fsample_reqadd_x_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_reqadd.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "fsample_reqadd" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "fsample_reqadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->sample_cart_id->Visible) { // sample_cart_id ?>
    <div id="r_sample_cart_id"<?= $Page->sample_cart_id->rowAttributes() ?>>
        <label id="elh_sample_req_sample_cart_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->sample_cart_id->caption() ?><?= $Page->sample_cart_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->sample_cart_id->cellAttributes() ?>>
<span id="el_sample_req_sample_cart_id">
<template id="tp_x_sample_cart_id">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="sample_req" data-field="x_sample_cart_id" name="x_sample_cart_id" id="x_sample_cart_id"<?= $Page->sample_cart_id->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_sample_cart_id" class="ew-item-list"></div>
<selection-list hidden
    id="x_sample_cart_id[]"
    name="x_sample_cart_id[]"
    value="<?= HtmlEncode($Page->sample_cart_id->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_sample_cart_id"
    data-target="dsl_x_sample_cart_id"
    data-repeatcolumn="1"
    class="form-control<?= $Page->sample_cart_id->isInvalidClass() ?>"
    data-table="sample_req"
    data-field="x_sample_cart_id"
    data-value-separator="<?= $Page->sample_cart_id->displayValueSeparatorAttribute() ?>"
    <?= $Page->sample_cart_id->editAttributes() ?>></selection-list>
<?= $Page->sample_cart_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->sample_cart_id->getErrorMessage() ?></div>
<?php if (AllowAdd(CurrentProjectID() . "sample_req_cart") && !$Page->sample_cart_id->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_sample_cart_id" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->sample_cart_id->caption() ?>" data-title="<?= $Page->sample_cart_id->caption() ?>" data-ew-action="add-option" data-el="x_sample_cart_id[]" data-url="<?= GetUrl("samplereqcartaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
<?php } ?>
<?= $Page->sample_cart_id->Lookup->getParamTag($Page, "p_x_sample_cart_id") ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->purpose->Visible) { // purpose ?>
    <div id="r_purpose"<?= $Page->purpose->rowAttributes() ?>>
        <label id="elh_sample_req_purpose" for="x_purpose" class="<?= $Page->LeftColumnClass ?>"><?= $Page->purpose->caption() ?><?= $Page->purpose->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->purpose->cellAttributes() ?>>
<span id="el_sample_req_purpose">
<div class="input-group flex-nowrap">
    <select
        id="x_purpose"
        name="x_purpose"
        class="form-select ew-select<?= $Page->purpose->isInvalidClass() ?>"
        <?php if (!$Page->purpose->IsNativeSelect) { ?>
        data-select2-id="fsample_reqadd_x_purpose"
        <?php } ?>
        data-table="sample_req"
        data-field="x_purpose"
        data-value-separator="<?= $Page->purpose->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->purpose->getPlaceHolder()) ?>"
        <?= $Page->purpose->editAttributes() ?>>
        <?= $Page->purpose->selectOptionListHtml("x_purpose") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "sample_req_misc") && !$Page->purpose->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_purpose" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->purpose->caption() ?>" data-title="<?= $Page->purpose->caption() ?>" data-ew-action="add-option" data-el="x_purpose" data-url="<?= GetUrl("samplereqmiscaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->purpose->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->purpose->getErrorMessage() ?></div>
<?= $Page->purpose->Lookup->getParamTag($Page, "p_x_purpose") ?>
<?php if (!$Page->purpose->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_reqadd", function() {
    var options = { name: "x_purpose", selectId: "fsample_reqadd_x_purpose" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_reqadd.lists.purpose?.lookupOptions.length) {
        options.data = { id: "x_purpose", form: "fsample_reqadd" };
    } else {
        options.ajax = { id: "x_purpose", form: "fsample_reqadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req.fields.purpose.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->label->Visible) { // label ?>
    <div id="r_label"<?= $Page->label->rowAttributes() ?>>
        <label id="elh_sample_req_label" for="x_label" class="<?= $Page->LeftColumnClass ?>"><?= $Page->label->caption() ?><?= $Page->label->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->label->cellAttributes() ?>>
<span id="el_sample_req_label">
<div class="input-group flex-nowrap">
    <select
        id="x_label"
        name="x_label"
        class="form-select ew-select<?= $Page->label->isInvalidClass() ?>"
        <?php if (!$Page->label->IsNativeSelect) { ?>
        data-select2-id="fsample_reqadd_x_label"
        <?php } ?>
        data-table="sample_req"
        data-field="x_label"
        data-value-separator="<?= $Page->label->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->label->getPlaceHolder()) ?>"
        <?= $Page->label->editAttributes() ?>>
        <?= $Page->label->selectOptionListHtml("x_label") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "sample_req_misc") && !$Page->label->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_label" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->label->caption() ?>" data-title="<?= $Page->label->caption() ?>" data-ew-action="add-option" data-el="x_label" data-url="<?= GetUrl("samplereqmiscaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->label->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->label->getErrorMessage() ?></div>
<?= $Page->label->Lookup->getParamTag($Page, "p_x_label") ?>
<?php if (!$Page->label->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_reqadd", function() {
    var options = { name: "x_label", selectId: "fsample_reqadd_x_label" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_reqadd.lists.label?.lookupOptions.length) {
        options.data = { id: "x_label", form: "fsample_reqadd" };
    } else {
        options.ajax = { id: "x_label", form: "fsample_reqadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req.fields.label.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ssd->Visible) { // ssd ?>
    <div id="r_ssd"<?= $Page->ssd->rowAttributes() ?>>
        <label id="elh_sample_req_ssd" for="x_ssd" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ssd->caption() ?><?= $Page->ssd->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ssd->cellAttributes() ?>>
<span id="el_sample_req_ssd">
<input type="<?= $Page->ssd->getInputTextType() ?>" name="x_ssd" id="x_ssd" data-table="sample_req" data-field="x_ssd" value="<?= $Page->ssd->EditValue ?>" placeholder="<?= HtmlEncode($Page->ssd->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ssd->formatPattern()) ?>"<?= $Page->ssd->editAttributes() ?> aria-describedby="x_ssd_help">
<?= $Page->ssd->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ssd->getErrorMessage() ?></div>
<?php if (!$Page->ssd->ReadOnly && !$Page->ssd->Disabled && !isset($Page->ssd->EditAttrs["readonly"]) && !isset($Page->ssd->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsample_reqadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fsample_reqadd", "x_ssd", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shipping_mode->Visible) { // shipping_mode ?>
    <div id="r_shipping_mode"<?= $Page->shipping_mode->rowAttributes() ?>>
        <label id="elh_sample_req_shipping_mode" for="x_shipping_mode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shipping_mode->caption() ?><?= $Page->shipping_mode->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shipping_mode->cellAttributes() ?>>
<span id="el_sample_req_shipping_mode">
    <select
        id="x_shipping_mode"
        name="x_shipping_mode"
        class="form-select ew-select<?= $Page->shipping_mode->isInvalidClass() ?>"
        <?php if (!$Page->shipping_mode->IsNativeSelect) { ?>
        data-select2-id="fsample_reqadd_x_shipping_mode"
        <?php } ?>
        data-table="sample_req"
        data-field="x_shipping_mode"
        data-value-separator="<?= $Page->shipping_mode->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shipping_mode->getPlaceHolder()) ?>"
        <?= $Page->shipping_mode->editAttributes() ?>>
        <?= $Page->shipping_mode->selectOptionListHtml("x_shipping_mode") ?>
    </select>
    <?= $Page->shipping_mode->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->shipping_mode->getErrorMessage() ?></div>
<?php if (!$Page->shipping_mode->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_reqadd", function() {
    var options = { name: "x_shipping_mode", selectId: "fsample_reqadd_x_shipping_mode" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_reqadd.lists.shipping_mode?.lookupOptions.length) {
        options.data = { id: "x_shipping_mode", form: "fsample_reqadd" };
    } else {
        options.ajax = { id: "x_shipping_mode", form: "fsample_reqadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req.fields.shipping_mode.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->delivery_week->Visible) { // delivery_week ?>
    <div id="r_delivery_week"<?= $Page->delivery_week->rowAttributes() ?>>
        <label id="elh_sample_req_delivery_week" for="x_delivery_week" class="<?= $Page->LeftColumnClass ?>"><?= $Page->delivery_week->caption() ?><?= $Page->delivery_week->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->delivery_week->cellAttributes() ?>>
<span id="el_sample_req_delivery_week">
    <select
        id="x_delivery_week"
        name="x_delivery_week"
        class="form-select ew-select<?= $Page->delivery_week->isInvalidClass() ?>"
        <?php if (!$Page->delivery_week->IsNativeSelect) { ?>
        data-select2-id="fsample_reqadd_x_delivery_week"
        <?php } ?>
        data-table="sample_req"
        data-field="x_delivery_week"
        data-value-separator="<?= $Page->delivery_week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->delivery_week->getPlaceHolder()) ?>"
        <?= $Page->delivery_week->editAttributes() ?>>
        <?= $Page->delivery_week->selectOptionListHtml("x_delivery_week") ?>
    </select>
    <?= $Page->delivery_week->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->delivery_week->getErrorMessage() ?></div>
<?= $Page->delivery_week->Lookup->getParamTag($Page, "p_x_delivery_week") ?>
<?php if (!$Page->delivery_week->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_reqadd", function() {
    var options = { name: "x_delivery_week", selectId: "fsample_reqadd_x_delivery_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_reqadd.lists.delivery_week?.lookupOptions.length) {
        options.data = { id: "x_delivery_week", form: "fsample_reqadd" };
    } else {
        options.ajax = { id: "x_delivery_week", form: "fsample_reqadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req.fields.delivery_week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->shipping_address->Visible) { // shipping_address ?>
    <div id="r_shipping_address"<?= $Page->shipping_address->rowAttributes() ?>>
        <label id="elh_sample_req_shipping_address" for="x_shipping_address" class="<?= $Page->LeftColumnClass ?>"><?= $Page->shipping_address->caption() ?><?= $Page->shipping_address->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->shipping_address->cellAttributes() ?>>
<span id="el_sample_req_shipping_address">
<div class="input-group flex-nowrap">
    <select
        id="x_shipping_address"
        name="x_shipping_address"
        class="form-select ew-select<?= $Page->shipping_address->isInvalidClass() ?>"
        <?php if (!$Page->shipping_address->IsNativeSelect) { ?>
        data-select2-id="fsample_reqadd_x_shipping_address"
        <?php } ?>
        data-table="sample_req"
        data-field="x_shipping_address"
        data-value-separator="<?= $Page->shipping_address->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->shipping_address->getPlaceHolder()) ?>"
        <?= $Page->shipping_address->editAttributes() ?>>
        <?= $Page->shipping_address->selectOptionListHtml("x_shipping_address") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "shipping_address") && !$Page->shipping_address->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_shipping_address" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->shipping_address->caption() ?>" data-title="<?= $Page->shipping_address->caption() ?>" data-ew-action="add-option" data-el="x_shipping_address" data-url="<?= GetUrl("shippingaddressaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->shipping_address->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->shipping_address->getErrorMessage() ?></div>
<?= $Page->shipping_address->Lookup->getParamTag($Page, "p_x_shipping_address") ?>
<?php if (!$Page->shipping_address->IsNativeSelect) { ?>
<script>
loadjs.ready("fsample_reqadd", function() {
    var options = { name: "x_shipping_address", selectId: "fsample_reqadd_x_shipping_address" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsample_reqadd.lists.shipping_address?.lookupOptions.length) {
        options.data = { id: "x_shipping_address", form: "fsample_reqadd" };
    } else {
        options.ajax = { id: "x_shipping_address", form: "fsample_reqadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.sample_req.fields.shipping_address.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_sample_req_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_sample_req_remarks">
<textarea data-table="sample_req" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fsample_reqadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fsample_reqadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("sample_req");
});
</script>
<script>
loadjs.ready("load", function () {
    // Startup script
    // Write your table-specific startup script here
    // document.write("page loaded");
    		var label = getCookie('label');
    		if (label == 201)
    		{
    		$("#r_ssd").show();
    		} else {
    		$("#r_ssd").hide();
    		}
    	$("#r_shipping_address_2").hide();

    //$("#dsl_x_sample_cart_id").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_sample_cart_id" title="" data-title="Sample Selection" onclick="ew.modalDialogShow({lnk:this,btn:\'AddBtn\',url:\'samplereqcartadd\'});" data-bs-original-title="Add Sample Selection" data-backdrop="static"><i class="fa fa-plus fa-2x ew-icon"></i></button></div>');
    $("#dsl_x_sample_cart_id").append('<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_sample_cart_id" title="" data-title="Sample Selection" onclick="location.href=\'samplereqcartadd\'" data-bs-original-title="Add Sample Selection" data-backdrop="static"><i class="fa fa-plus fa-2x ew-icon"></i></button></div>');
});
</script>
