<?php

namespace PHPMaker2024\fibre;

// Page object
$SalaryExpensesSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { salary_expenses: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fsalary_expensessearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fsalary_expensessearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["employee_id", [], fields.employee_id.isInvalid],
            ["expense_type", [], fields.expense_type.isInvalid],
            ["expense_sub_type", [], fields.expense_sub_type.isInvalid],
            ["basic_salary", [ew.Validators.float], fields.basic_salary.isInvalid],
            ["ded_add", [ew.Validators.float], fields.ded_add.isInvalid],
            ["final_amount", [ew.Validators.float], fields.final_amount.isInvalid],
            ["dated", [ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["uploads", [], fields.uploads.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
            "expense_type": <?= $Page->expense_type->toClientList($Page) ?>,
            "expense_sub_type": <?= $Page->expense_sub_type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fsalary_expensessearch" id="fsalary_expensessearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="salary_expenses">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="salary_expenses" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id" class="row"<?= $Page->employee_id->rowAttributes() ?>>
        <label for="x_employee_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_employee_id"><?= $Page->employee_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_employee_id" id="z_employee_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->employee_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_employee_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_employee_id"
        name="x_employee_id"
        class="form-select ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        <?php if (!$Page->employee_id->IsNativeSelect) { ?>
        data-select2-id="fsalary_expensessearch_x_employee_id"
        <?php } ?>
        data-table="salary_expenses"
        data-field="x_employee_id"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("x_employee_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage(false) ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
<?php if (!$Page->employee_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fsalary_expensessearch", function() {
    var options = { name: "x_employee_id", selectId: "fsalary_expensessearch_x_employee_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsalary_expensessearch.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "x_employee_id", form: "fsalary_expensessearch" };
    } else {
        options.ajax = { id: "x_employee_id", form: "fsalary_expensessearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.salary_expenses.fields.employee_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->expense_type->Visible) { // expense_type ?>
    <div id="r_expense_type" class="row"<?= $Page->expense_type->rowAttributes() ?>>
        <label for="x_expense_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_expense_type"><?= $Page->expense_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_expense_type" id="z_expense_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->expense_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_expense_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_expense_type"
        name="x_expense_type"
        class="form-select ew-select<?= $Page->expense_type->isInvalidClass() ?>"
        <?php if (!$Page->expense_type->IsNativeSelect) { ?>
        data-select2-id="fsalary_expensessearch_x_expense_type"
        <?php } ?>
        data-table="salary_expenses"
        data-field="x_expense_type"
        data-value-separator="<?= $Page->expense_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->expense_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->expense_type->editAttributes() ?>>
        <?= $Page->expense_type->selectOptionListHtml("x_expense_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->expense_type->getErrorMessage(false) ?></div>
<?= $Page->expense_type->Lookup->getParamTag($Page, "p_x_expense_type") ?>
<?php if (!$Page->expense_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fsalary_expensessearch", function() {
    var options = { name: "x_expense_type", selectId: "fsalary_expensessearch_x_expense_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsalary_expensessearch.lists.expense_type?.lookupOptions.length) {
        options.data = { id: "x_expense_type", form: "fsalary_expensessearch" };
    } else {
        options.ajax = { id: "x_expense_type", form: "fsalary_expensessearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.salary_expenses.fields.expense_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->expense_sub_type->Visible) { // expense_sub_type ?>
    <div id="r_expense_sub_type" class="row"<?= $Page->expense_sub_type->rowAttributes() ?>>
        <label for="x_expense_sub_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_expense_sub_type"><?= $Page->expense_sub_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_expense_sub_type" id="z_expense_sub_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->expense_sub_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_expense_sub_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_expense_sub_type"
        name="x_expense_sub_type"
        class="form-select ew-select<?= $Page->expense_sub_type->isInvalidClass() ?>"
        <?php if (!$Page->expense_sub_type->IsNativeSelect) { ?>
        data-select2-id="fsalary_expensessearch_x_expense_sub_type"
        <?php } ?>
        data-table="salary_expenses"
        data-field="x_expense_sub_type"
        data-value-separator="<?= $Page->expense_sub_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->expense_sub_type->getPlaceHolder()) ?>"
        <?= $Page->expense_sub_type->editAttributes() ?>>
        <?= $Page->expense_sub_type->selectOptionListHtml("x_expense_sub_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->expense_sub_type->getErrorMessage(false) ?></div>
<?= $Page->expense_sub_type->Lookup->getParamTag($Page, "p_x_expense_sub_type") ?>
<?php if (!$Page->expense_sub_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fsalary_expensessearch", function() {
    var options = { name: "x_expense_sub_type", selectId: "fsalary_expensessearch_x_expense_sub_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsalary_expensessearch.lists.expense_sub_type?.lookupOptions.length) {
        options.data = { id: "x_expense_sub_type", form: "fsalary_expensessearch" };
    } else {
        options.ajax = { id: "x_expense_sub_type", form: "fsalary_expensessearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.salary_expenses.fields.expense_sub_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->basic_salary->Visible) { // basic_salary ?>
    <div id="r_basic_salary" class="row"<?= $Page->basic_salary->rowAttributes() ?>>
        <label for="x_basic_salary" class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_basic_salary"><?= $Page->basic_salary->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_basic_salary" id="z_basic_salary" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->basic_salary->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_basic_salary" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->basic_salary->getInputTextType() ?>" name="x_basic_salary" id="x_basic_salary" data-table="salary_expenses" data-field="x_basic_salary" value="<?= $Page->basic_salary->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->basic_salary->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->basic_salary->formatPattern()) ?>"<?= $Page->basic_salary->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->basic_salary->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ded_add->Visible) { // ded_add ?>
    <div id="r_ded_add" class="row"<?= $Page->ded_add->rowAttributes() ?>>
        <label for="x_ded_add" class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_ded_add"><?= $Page->ded_add->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ded_add" id="z_ded_add" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ded_add->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_ded_add" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ded_add->getInputTextType() ?>" name="x_ded_add" id="x_ded_add" data-table="salary_expenses" data-field="x_ded_add" value="<?= $Page->ded_add->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ded_add->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ded_add->formatPattern()) ?>"<?= $Page->ded_add->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ded_add->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->final_amount->Visible) { // final_amount ?>
    <div id="r_final_amount" class="row"<?= $Page->final_amount->rowAttributes() ?>>
        <label for="x_final_amount" class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_final_amount"><?= $Page->final_amount->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_final_amount" id="z_final_amount" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->final_amount->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_final_amount" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->final_amount->getInputTextType() ?>" name="x_final_amount" id="x_final_amount" data-table="salary_expenses" data-field="x_final_amount" value="<?= $Page->final_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->final_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->final_amount->formatPattern()) ?>"<?= $Page->final_amount->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->final_amount->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated" class="row"<?= $Page->dated->rowAttributes() ?>>
        <label for="x_dated" class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_dated"><?= $Page->dated->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dated" id="z_dated" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dated->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_dated" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="salary_expenses" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsalary_expensessearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fsalary_expensessearch", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="salary_expenses" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" maxlength="255" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads" class="row"<?= $Page->uploads->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_uploads"><?= $Page->uploads->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_uploads" id="z_uploads" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->uploads->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_uploads" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->uploads->getInputTextType() ?>" name="x_uploads" id="x_uploads" data-table="salary_expenses" data-field="x_uploads" value="<?= $Page->uploads->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->uploads->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->uploads->formatPattern()) ?>"<?= $Page->uploads->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->uploads->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="salary_expenses" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_salary_expenses_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_salary_expenses_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="salary_expenses" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsalary_expensessearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fsalary_expensessearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fsalary_expensessearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fsalary_expensessearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fsalary_expensessearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("salary_expenses");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
