<?php

namespace PHPMaker2024\fibre;

// Page object
$SalaryExpensesAdd = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { salary_expenses: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fsalary_expensesadd;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fsalary_expensesadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["employee_id", [fields.employee_id.visible && fields.employee_id.required ? ew.Validators.required(fields.employee_id.caption) : null], fields.employee_id.isInvalid],
            ["expense_type", [fields.expense_type.visible && fields.expense_type.required ? ew.Validators.required(fields.expense_type.caption) : null], fields.expense_type.isInvalid],
            ["expense_sub_type", [fields.expense_sub_type.visible && fields.expense_sub_type.required ? ew.Validators.required(fields.expense_sub_type.caption) : null], fields.expense_sub_type.isInvalid],
            ["basic_salary", [fields.basic_salary.visible && fields.basic_salary.required ? ew.Validators.required(fields.basic_salary.caption) : null, ew.Validators.float], fields.basic_salary.isInvalid],
            ["ded_add", [fields.ded_add.visible && fields.ded_add.required ? ew.Validators.required(fields.ded_add.caption) : null, ew.Validators.float], fields.ded_add.isInvalid],
            ["final_amount", [fields.final_amount.visible && fields.final_amount.required ? ew.Validators.required(fields.final_amount.caption) : null, ew.Validators.float], fields.final_amount.isInvalid],
            ["dated", [fields.dated.visible && fields.dated.required ? ew.Validators.required(fields.dated.caption) : null, ew.Validators.datetime(fields.dated.clientFormatPattern)], fields.dated.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["uploads", [fields.uploads.visible && fields.uploads.required ? ew.Validators.fileRequired(fields.uploads.caption) : null], fields.uploads.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "employee_id": <?= $Page->employee_id->toClientList($Page) ?>,
            "expense_type": <?= $Page->expense_type->toClientList($Page) ?>,
            "expense_sub_type": <?= $Page->expense_sub_type->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fsalary_expensesadd" id="fsalary_expensesadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="salary_expenses">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->employee_id->Visible) { // employee_id ?>
    <div id="r_employee_id"<?= $Page->employee_id->rowAttributes() ?>>
        <label id="elh_salary_expenses_employee_id" for="x_employee_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->employee_id->caption() ?><?= $Page->employee_id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->employee_id->cellAttributes() ?>>
<span id="el_salary_expenses_employee_id">
<div class="input-group flex-nowrap">
    <select
        id="x_employee_id"
        name="x_employee_id"
        class="form-select ew-select<?= $Page->employee_id->isInvalidClass() ?>"
        <?php if (!$Page->employee_id->IsNativeSelect) { ?>
        data-select2-id="fsalary_expensesadd_x_employee_id"
        <?php } ?>
        data-table="salary_expenses"
        data-field="x_employee_id"
        data-value-separator="<?= $Page->employee_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->employee_id->getPlaceHolder()) ?>"
        <?= $Page->employee_id->editAttributes() ?>>
        <?= $Page->employee_id->selectOptionListHtml("x_employee_id") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "production_employee") && !$Page->employee_id->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_employee_id" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->employee_id->caption() ?>" data-title="<?= $Page->employee_id->caption() ?>" data-ew-action="add-option" data-el="x_employee_id" data-url="<?= GetUrl("productionemployeeaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<?= $Page->employee_id->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->employee_id->getErrorMessage() ?></div>
<?= $Page->employee_id->Lookup->getParamTag($Page, "p_x_employee_id") ?>
<?php if (!$Page->employee_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fsalary_expensesadd", function() {
    var options = { name: "x_employee_id", selectId: "fsalary_expensesadd_x_employee_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsalary_expensesadd.lists.employee_id?.lookupOptions.length) {
        options.data = { id: "x_employee_id", form: "fsalary_expensesadd" };
    } else {
        options.ajax = { id: "x_employee_id", form: "fsalary_expensesadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.salary_expenses.fields.employee_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->expense_type->Visible) { // expense_type ?>
    <div id="r_expense_type"<?= $Page->expense_type->rowAttributes() ?>>
        <label id="elh_salary_expenses_expense_type" for="x_expense_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->expense_type->caption() ?><?= $Page->expense_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->expense_type->cellAttributes() ?>>
<span id="el_salary_expenses_expense_type">
    <select
        id="x_expense_type"
        name="x_expense_type"
        class="form-select ew-select<?= $Page->expense_type->isInvalidClass() ?>"
        <?php if (!$Page->expense_type->IsNativeSelect) { ?>
        data-select2-id="fsalary_expensesadd_x_expense_type"
        <?php } ?>
        data-table="salary_expenses"
        data-field="x_expense_type"
        data-value-separator="<?= $Page->expense_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->expense_type->getPlaceHolder()) ?>"
        data-ew-action="update-options"
        <?= $Page->expense_type->editAttributes() ?>>
        <?= $Page->expense_type->selectOptionListHtml("x_expense_type") ?>
    </select>
    <?= $Page->expense_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->expense_type->getErrorMessage() ?></div>
<?= $Page->expense_type->Lookup->getParamTag($Page, "p_x_expense_type") ?>
<?php if (!$Page->expense_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fsalary_expensesadd", function() {
    var options = { name: "x_expense_type", selectId: "fsalary_expensesadd_x_expense_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsalary_expensesadd.lists.expense_type?.lookupOptions.length) {
        options.data = { id: "x_expense_type", form: "fsalary_expensesadd" };
    } else {
        options.ajax = { id: "x_expense_type", form: "fsalary_expensesadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.salary_expenses.fields.expense_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->expense_sub_type->Visible) { // expense_sub_type ?>
    <div id="r_expense_sub_type"<?= $Page->expense_sub_type->rowAttributes() ?>>
        <label id="elh_salary_expenses_expense_sub_type" for="x_expense_sub_type" class="<?= $Page->LeftColumnClass ?>"><?= $Page->expense_sub_type->caption() ?><?= $Page->expense_sub_type->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->expense_sub_type->cellAttributes() ?>>
<span id="el_salary_expenses_expense_sub_type">
    <select
        id="x_expense_sub_type"
        name="x_expense_sub_type"
        class="form-select ew-select<?= $Page->expense_sub_type->isInvalidClass() ?>"
        <?php if (!$Page->expense_sub_type->IsNativeSelect) { ?>
        data-select2-id="fsalary_expensesadd_x_expense_sub_type"
        <?php } ?>
        data-table="salary_expenses"
        data-field="x_expense_sub_type"
        data-value-separator="<?= $Page->expense_sub_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->expense_sub_type->getPlaceHolder()) ?>"
        <?= $Page->expense_sub_type->editAttributes() ?>>
        <?= $Page->expense_sub_type->selectOptionListHtml("x_expense_sub_type") ?>
    </select>
    <?= $Page->expense_sub_type->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->expense_sub_type->getErrorMessage() ?></div>
<?= $Page->expense_sub_type->Lookup->getParamTag($Page, "p_x_expense_sub_type") ?>
<?php if (!$Page->expense_sub_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fsalary_expensesadd", function() {
    var options = { name: "x_expense_sub_type", selectId: "fsalary_expensesadd_x_expense_sub_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fsalary_expensesadd.lists.expense_sub_type?.lookupOptions.length) {
        options.data = { id: "x_expense_sub_type", form: "fsalary_expensesadd" };
    } else {
        options.ajax = { id: "x_expense_sub_type", form: "fsalary_expensesadd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.salary_expenses.fields.expense_sub_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->basic_salary->Visible) { // basic_salary ?>
    <div id="r_basic_salary"<?= $Page->basic_salary->rowAttributes() ?>>
        <label id="elh_salary_expenses_basic_salary" for="x_basic_salary" class="<?= $Page->LeftColumnClass ?>"><?= $Page->basic_salary->caption() ?><?= $Page->basic_salary->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->basic_salary->cellAttributes() ?>>
<span id="el_salary_expenses_basic_salary">
<input type="<?= $Page->basic_salary->getInputTextType() ?>" name="x_basic_salary" id="x_basic_salary" data-table="salary_expenses" data-field="x_basic_salary" value="<?= $Page->basic_salary->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->basic_salary->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->basic_salary->formatPattern()) ?>"<?= $Page->basic_salary->editAttributes() ?> aria-describedby="x_basic_salary_help">
<?= $Page->basic_salary->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->basic_salary->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ded_add->Visible) { // ded_add ?>
    <div id="r_ded_add"<?= $Page->ded_add->rowAttributes() ?>>
        <label id="elh_salary_expenses_ded_add" for="x_ded_add" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ded_add->caption() ?><?= $Page->ded_add->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ded_add->cellAttributes() ?>>
<span id="el_salary_expenses_ded_add">
<input type="<?= $Page->ded_add->getInputTextType() ?>" name="x_ded_add" id="x_ded_add" data-table="salary_expenses" data-field="x_ded_add" value="<?= $Page->ded_add->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->ded_add->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ded_add->formatPattern()) ?>"<?= $Page->ded_add->editAttributes() ?> aria-describedby="x_ded_add_help">
<?= $Page->ded_add->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ded_add->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->final_amount->Visible) { // final_amount ?>
    <div id="r_final_amount"<?= $Page->final_amount->rowAttributes() ?>>
        <label id="elh_salary_expenses_final_amount" for="x_final_amount" class="<?= $Page->LeftColumnClass ?>"><?= $Page->final_amount->caption() ?><?= $Page->final_amount->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->final_amount->cellAttributes() ?>>
<span id="el_salary_expenses_final_amount">
<input type="<?= $Page->final_amount->getInputTextType() ?>" name="x_final_amount" id="x_final_amount" data-table="salary_expenses" data-field="x_final_amount" value="<?= $Page->final_amount->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->final_amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->final_amount->formatPattern()) ?>"<?= $Page->final_amount->editAttributes() ?> aria-describedby="x_final_amount_help">
<?= $Page->final_amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->final_amount->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
    <div id="r_dated"<?= $Page->dated->rowAttributes() ?>>
        <label id="elh_salary_expenses_dated" for="x_dated" class="<?= $Page->LeftColumnClass ?>"><?= $Page->dated->caption() ?><?= $Page->dated->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->dated->cellAttributes() ?>>
<span id="el_salary_expenses_dated">
<input type="<?= $Page->dated->getInputTextType() ?>" name="x_dated" id="x_dated" data-table="salary_expenses" data-field="x_dated" value="<?= $Page->dated->EditValue ?>" placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dated->formatPattern()) ?>"<?= $Page->dated->editAttributes() ?> aria-describedby="x_dated_help">
<?= $Page->dated->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->dated->getErrorMessage() ?></div>
<?php if (!$Page->dated->ReadOnly && !$Page->dated->Disabled && !isset($Page->dated->EditAttrs["readonly"]) && !isset($Page->dated->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fsalary_expensesadd", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fsalary_expensesadd", "x_dated", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks"<?= $Page->remarks->rowAttributes() ?>>
        <label id="elh_salary_expenses_remarks" for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><?= $Page->remarks->caption() ?><?= $Page->remarks->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->remarks->cellAttributes() ?>>
<span id="el_salary_expenses_remarks">
<textarea data-table="salary_expenses" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="2" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>"<?= $Page->remarks->editAttributes() ?> aria-describedby="x_remarks_help"><?= $Page->remarks->EditValue ?></textarea>
<?= $Page->remarks->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->uploads->Visible) { // uploads ?>
    <div id="r_uploads"<?= $Page->uploads->rowAttributes() ?>>
        <label id="elh_salary_expenses_uploads" class="<?= $Page->LeftColumnClass ?>"><?= $Page->uploads->caption() ?><?= $Page->uploads->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->uploads->cellAttributes() ?>>
<span id="el_salary_expenses_uploads">
<div id="fd_x_uploads" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_uploads"
        name="x_uploads"
        class="form-control ew-file-input"
        title="<?= $Page->uploads->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="salary_expenses"
        data-field="x_uploads"
        data-size="255"
        data-accept-file-types="<?= $Page->uploads->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->uploads->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->uploads->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_uploads_help"
        <?= ($Page->uploads->ReadOnly || $Page->uploads->Disabled) ? " disabled" : "" ?>
        <?= $Page->uploads->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <?= $Page->uploads->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->uploads->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?= $Page->uploads->Upload->FileName ?>">
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<table id="ft_x_uploads" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fsalary_expensesadd"><?= $Language->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fsalary_expensesadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("salary_expenses");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
