<?php

namespace PHPMaker2024\fibre;

// Page object
$SStudentListSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_student_list: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fs_student_listsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_student_listsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["sr_no", [], fields.sr_no.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["fac_sec", [], fields.fac_sec.isInvalid],
            ["father_name", [], fields.father_name.isInvalid],
            ["mother_name", [], fields.mother_name.isInvalid],
            ["dob", [ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["mobile_other", [], fields.mobile_other.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["gender", [], fields.gender.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["doj", [ew.Validators.datetime(fields.doj.clientFormatPattern)], fields.doj.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["idcard_status", [ew.Validators.integer], fields.idcard_status.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["epc", [], fields.epc.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "fac_sec": <?= $Page->fac_sec->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "idcard_status": <?= $Page->idcard_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fs_student_listsearch" id="fs_student_listsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_student_list">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="s_student_list" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="s_student_list" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="254" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->sr_no->Visible) { // sr_no ?>
    <div id="r_sr_no" class="row"<?= $Page->sr_no->rowAttributes() ?>>
        <label for="x_sr_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_sr_no"><?= $Page->sr_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_sr_no" id="z_sr_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->sr_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_sr_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sr_no->getInputTextType() ?>" name="x_sr_no" id="x_sr_no" data-table="s_student_list" data-field="x_sr_no" value="<?= $Page->sr_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->sr_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sr_no->formatPattern()) ?>"<?= $Page->sr_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sr_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
    <div id="r_name" class="row"<?= $Page->name->rowAttributes() ?>>
        <label for="x_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_name"><?= $Page->name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_name" id="z_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="s_student_list" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fac_sec->Visible) { // fac_sec ?>
    <div id="r_fac_sec" class="row"<?= $Page->fac_sec->rowAttributes() ?>>
        <label for="x_fac_sec" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_fac_sec"><?= $Page->fac_sec->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_fac_sec" id="z_fac_sec" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fac_sec->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_fac_sec" class="ew-search-field ew-search-field-single">
    <select
        id="x_fac_sec[]"
        name="x_fac_sec[]"
        class="form-select ew-select<?= $Page->fac_sec->isInvalidClass() ?>"
        <?php if (!$Page->fac_sec->IsNativeSelect) { ?>
        data-select2-id="fs_student_listsearch_x_fac_sec[]"
        <?php } ?>
        data-table="s_student_list"
        data-field="x_fac_sec"
        multiple
        size="1"
        data-value-separator="<?= $Page->fac_sec->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->fac_sec->getPlaceHolder()) ?>"
        <?= $Page->fac_sec->editAttributes() ?>>
        <?= $Page->fac_sec->selectOptionListHtml("x_fac_sec[]") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->fac_sec->getErrorMessage(false) ?></div>
<?= $Page->fac_sec->Lookup->getParamTag($Page, "p_x_fac_sec") ?>
<?php if (!$Page->fac_sec->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_student_listsearch", function() {
    var options = { name: "x_fac_sec[]", selectId: "fs_student_listsearch_x_fac_sec[]" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.multiple = true;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_student_listsearch.lists.fac_sec?.lookupOptions.length) {
        options.data = { id: "x_fac_sec[]", form: "fs_student_listsearch" };
    } else {
        options.ajax = { id: "x_fac_sec[]", form: "fs_student_listsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_student_list.fields.fac_sec.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
    <div id="r_father_name" class="row"<?= $Page->father_name->rowAttributes() ?>>
        <label for="x_father_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_father_name"><?= $Page->father_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_father_name" id="z_father_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->father_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_father_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="s_student_list" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->father_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mother_name->Visible) { // mother_name ?>
    <div id="r_mother_name" class="row"<?= $Page->mother_name->rowAttributes() ?>>
        <label for="x_mother_name" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_mother_name"><?= $Page->mother_name->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mother_name" id="z_mother_name" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mother_name->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_mother_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mother_name->getInputTextType() ?>" name="x_mother_name" id="x_mother_name" data-table="s_student_list" data-field="x_mother_name" value="<?= $Page->mother_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->mother_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mother_name->formatPattern()) ?>"<?= $Page->mother_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mother_name->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
    <div id="r_dob" class="row"<?= $Page->dob->rowAttributes() ?>>
        <label for="x_dob" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_dob"><?= $Page->dob->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_dob" id="z_dob" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->dob->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_dob" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="s_student_list" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage(false) ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_student_listsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(7) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_student_listsearch", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="s_student_list" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile_other->Visible) { // mobile_other ?>
    <div id="r_mobile_other" class="row"<?= $Page->mobile_other->rowAttributes() ?>>
        <label for="x_mobile_other" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_mobile_other"><?= $Page->mobile_other->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_mobile_other" id="z_mobile_other" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile_other->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_mobile_other" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile_other->getInputTextType() ?>" name="x_mobile_other" id="x_mobile_other" data-table="s_student_list" data-field="x_mobile_other" value="<?= $Page->mobile_other->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->mobile_other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_other->formatPattern()) ?>"<?= $Page->mobile_other->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile_other->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
    <div id="r_address" class="row"<?= $Page->address->rowAttributes() ?>>
        <label for="x_address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_address"><?= $Page->address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_address" id="z_address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="s_student_list" data-field="x_address" value="<?= $Page->address->EditValue ?>" maxlength="254" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
    <div id="r_gender" class="row"<?= $Page->gender->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_gender"><?= $Page->gender->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_gender" id="z_gender" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->gender->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_gender" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->gender->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_gender" class="ew-auto-suggest">
    <input type="<?= $Page->gender->getInputTextType() ?>" class="form-control" name="sv_x_gender" id="sv_x_gender" value="<?= RemoveHtml($Page->gender->EditValue) ?>" autocomplete="off" size="30" maxlength="12" placeholder="<?= HtmlEncode($Page->gender->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->gender->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->gender->formatPattern()) ?>"<?= $Page->gender->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_student_list" data-field="x_gender" data-input="sv_x_gender" data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>" name="x_gender" id="x_gender" value="<?= HtmlEncode($Page->gender->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->gender->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fs_student_listsearch", function() {
    fs_student_listsearch.createAutoSuggest(Object.assign({"id":"x_gender","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->gender->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_student_list.fields.gender.autoSuggestOptions));
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
    <div id="r_category" class="row"<?= $Page->category->rowAttributes() ?>>
        <label for="x_category" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_category"><?= $Page->category->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("IN") ?>
<input type="hidden" name="z_category" id="z_category" value="IN">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->category->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fs_student_listsearch_x_category"
        <?php } ?>
        data-table="s_student_list"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_student_listsearch", function() {
    var options = { name: "x_category", selectId: "fs_student_listsearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_student_listsearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fs_student_listsearch" };
    } else {
        options.ajax = { id: "x_category", form: "fs_student_listsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_student_list.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->doj->Visible) { // doj ?>
    <div id="r_doj" class="row"<?= $Page->doj->rowAttributes() ?>>
        <label for="x_doj" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_doj"><?= $Page->doj->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_doj" id="z_doj" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->doj->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_doj" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->doj->getInputTextType() ?>" name="x_doj" id="x_doj" data-table="s_student_list" data-field="x_doj" value="<?= $Page->doj->EditValue ?>" placeholder="<?= HtmlEncode($Page->doj->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->doj->formatPattern()) ?>"<?= $Page->doj->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->doj->getErrorMessage(false) ?></div>
<?php if (!$Page->doj->ReadOnly && !$Page->doj->Disabled && !isset($Page->doj->EditAttrs["readonly"]) && !isset($Page->doj->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_student_listsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_student_listsearch", "x_doj", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fs_student_listsearch_x_status"
        <?php } ?>
        data-table="s_student_list"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_student_listsearch", function() {
    var options = { name: "x_status", selectId: "fs_student_listsearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_student_listsearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fs_student_listsearch" };
    } else {
        options.ajax = { id: "x_status", form: "fs_student_listsearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_student_list.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->idcard_status->Visible) { // idcard_status ?>
    <div id="r_idcard_status" class="row"<?= $Page->idcard_status->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_idcard_status"><?= $Page->idcard_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_idcard_status" id="z_idcard_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->idcard_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_idcard_status" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->idcard_status->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_idcard_status" class="ew-auto-suggest">
    <input type="<?= $Page->idcard_status->getInputTextType() ?>" class="form-control" name="sv_x_idcard_status" id="sv_x_idcard_status" value="<?= RemoveHtml($Page->idcard_status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->idcard_status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->idcard_status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->idcard_status->formatPattern()) ?>"<?= $Page->idcard_status->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_student_list" data-field="x_idcard_status" data-input="sv_x_idcard_status" data-value-separator="<?= $Page->idcard_status->displayValueSeparatorAttribute() ?>" name="x_idcard_status" id="x_idcard_status" value="<?= HtmlEncode($Page->idcard_status->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->idcard_status->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fs_student_listsearch", function() {
    fs_student_listsearch.createAutoSuggest(Object.assign({"id":"x_idcard_status","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->idcard_status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_student_list.fields.idcard_status.autoSuggestOptions));
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="s_student_list" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->epc->Visible) { // epc ?>
    <div id="r_epc" class="row"<?= $Page->epc->rowAttributes() ?>>
        <label for="x_epc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_student_list_epc"><?= $Page->epc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_epc" id="z_epc" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->epc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_student_list_epc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->epc->getInputTextType() ?>" name="x_epc" id="x_epc" data-table="s_student_list" data-field="x_epc" value="<?= $Page->epc->EditValue ?>" size="30" maxlength="5" placeholder="<?= HtmlEncode($Page->epc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->epc->formatPattern()) ?>"<?= $Page->epc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->epc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fs_student_listsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fs_student_listsearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fs_student_listsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_student_list");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
