<?php

namespace PHPMaker2024\fibre;

// Page object
$SStudentListList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_student_list: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "id": <?= $Page->id->toClientList($Page) ?>,
            "sr_no": <?= $Page->sr_no->toClientList($Page) ?>,
            "name": <?= $Page->name->toClientList($Page) ?>,
            "fac_sec": <?= $Page->fac_sec->toClientList($Page) ?>,
            "father_name": <?= $Page->father_name->toClientList($Page) ?>,
            "mother_name": <?= $Page->mother_name->toClientList($Page) ?>,
            "mobile": <?= $Page->mobile->toClientList($Page) ?>,
            "mobile_other": <?= $Page->mobile_other->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "idcard_status": <?= $Page->idcard_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fs_student_listsrch" id="fs_student_listsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fs_student_listsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_student_list: currentTable } });
var currentForm;
var fs_student_listsrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_student_listsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "id": <?= $Page->id->toClientList($Page) ?>,
            "sr_no": <?= $Page->sr_no->toClientList($Page) ?>,
            "name": <?= $Page->name->toClientList($Page) ?>,
            "fac_sec": <?= $Page->fac_sec->toClientList($Page) ?>,
            "father_name": <?= $Page->father_name->toClientList($Page) ?>,
            "mother_name": <?= $Page->mother_name->toClientList($Page) ?>,
            "mobile": <?= $Page->mobile->toClientList($Page) ?>,
            "mobile_other": <?= $Page->mobile_other->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->id->Visible) { // id ?>
<?php
if (!$Page->id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->id->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_id"
            name="x_id[]"
            class="form-control ew-select<?= $Page->id->isInvalidClass() ?>"
            data-select2-id="fs_student_listsrch_x_id"
            data-table="s_student_list"
            data-field="x_id"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->id->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->id->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->id->editAttributes() ?>>
            <?= $Page->id->selectOptionListHtml("x_id", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_student_listsrch", function() {
            var options = {
                name: "x_id",
                selectId: "fs_student_listsrch_x_id",
                ajax: { id: "x_id", form: "fs_student_listsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_student_list.fields.id.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->sr_no->Visible) { // sr_no ?>
<?php
if (!$Page->sr_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_sr_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->sr_no->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_sr_no"
            name="x_sr_no[]"
            class="form-control ew-select<?= $Page->sr_no->isInvalidClass() ?>"
            data-select2-id="fs_student_listsrch_x_sr_no"
            data-table="s_student_list"
            data-field="x_sr_no"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->sr_no->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->sr_no->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->sr_no->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->sr_no->editAttributes() ?>>
            <?= $Page->sr_no->selectOptionListHtml("x_sr_no", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->sr_no->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_student_listsrch", function() {
            var options = {
                name: "x_sr_no",
                selectId: "fs_student_listsrch_x_sr_no",
                ajax: { id: "x_sr_no", form: "fs_student_listsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_student_list.fields.sr_no.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
<?php
if (!$Page->name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->name->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_name"
            name="x_name[]"
            class="form-control ew-select<?= $Page->name->isInvalidClass() ?>"
            data-select2-id="fs_student_listsrch_x_name"
            data-table="s_student_list"
            data-field="x_name"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->name->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->name->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->name->editAttributes() ?>>
            <?= $Page->name->selectOptionListHtml("x_name", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_student_listsrch", function() {
            var options = {
                name: "x_name",
                selectId: "fs_student_listsrch_x_name",
                ajax: { id: "x_name", form: "fs_student_listsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_student_list.fields.name.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->fac_sec->Visible) { // fac_sec ?>
<?php
if (!$Page->fac_sec->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_fac_sec" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->fac_sec->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_fac_sec"
            name="x_fac_sec[]"
            class="form-control ew-select<?= $Page->fac_sec->isInvalidClass() ?>"
            data-select2-id="fs_student_listsrch_x_fac_sec"
            data-table="s_student_list"
            data-field="x_fac_sec"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->fac_sec->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->fac_sec->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->fac_sec->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->fac_sec->editAttributes() ?>>
            <?= $Page->fac_sec->selectOptionListHtml("x_fac_sec", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->fac_sec->getErrorMessage(false) ?></div>
        <?= $Page->fac_sec->Lookup->getParamTag($Page, "p_x_fac_sec") ?>
        <script>
        loadjs.ready("fs_student_listsrch", function() {
            var options = {
                name: "x_fac_sec",
                selectId: "fs_student_listsrch_x_fac_sec",
                ajax: { id: "x_fac_sec", form: "fs_student_listsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_student_list.fields.fac_sec.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
<?php
if (!$Page->father_name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_father_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->father_name->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_father_name"
            name="x_father_name[]"
            class="form-control ew-select<?= $Page->father_name->isInvalidClass() ?>"
            data-select2-id="fs_student_listsrch_x_father_name"
            data-table="s_student_list"
            data-field="x_father_name"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->father_name->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->father_name->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->father_name->editAttributes() ?>>
            <?= $Page->father_name->selectOptionListHtml("x_father_name", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->father_name->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_student_listsrch", function() {
            var options = {
                name: "x_father_name",
                selectId: "fs_student_listsrch_x_father_name",
                ajax: { id: "x_father_name", form: "fs_student_listsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_student_list.fields.father_name.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->mother_name->Visible) { // mother_name ?>
<?php
if (!$Page->mother_name->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_mother_name" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->mother_name->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_mother_name"
            name="x_mother_name[]"
            class="form-control ew-select<?= $Page->mother_name->isInvalidClass() ?>"
            data-select2-id="fs_student_listsrch_x_mother_name"
            data-table="s_student_list"
            data-field="x_mother_name"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->mother_name->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->mother_name->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->mother_name->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->mother_name->editAttributes() ?>>
            <?= $Page->mother_name->selectOptionListHtml("x_mother_name", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->mother_name->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_student_listsrch", function() {
            var options = {
                name: "x_mother_name",
                selectId: "fs_student_listsrch_x_mother_name",
                ajax: { id: "x_mother_name", form: "fs_student_listsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_student_list.fields.mother_name.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
<?php
if (!$Page->mobile->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_mobile" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->mobile->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_mobile"
            name="x_mobile[]"
            class="form-control ew-select<?= $Page->mobile->isInvalidClass() ?>"
            data-select2-id="fs_student_listsrch_x_mobile"
            data-table="s_student_list"
            data-field="x_mobile"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->mobile->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->mobile->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->mobile->editAttributes() ?>>
            <?= $Page->mobile->selectOptionListHtml("x_mobile", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_student_listsrch", function() {
            var options = {
                name: "x_mobile",
                selectId: "fs_student_listsrch_x_mobile",
                ajax: { id: "x_mobile", form: "fs_student_listsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_student_list.fields.mobile.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->mobile_other->Visible) { // mobile_other ?>
<?php
if (!$Page->mobile_other->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_mobile_other" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->mobile_other->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_mobile_other"
            name="x_mobile_other[]"
            class="form-control ew-select<?= $Page->mobile_other->isInvalidClass() ?>"
            data-select2-id="fs_student_listsrch_x_mobile_other"
            data-table="s_student_list"
            data-field="x_mobile_other"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->mobile_other->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->mobile_other->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->mobile_other->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->mobile_other->editAttributes() ?>>
            <?= $Page->mobile_other->selectOptionListHtml("x_mobile_other", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->mobile_other->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_student_listsrch", function() {
            var options = {
                name: "x_mobile_other",
                selectId: "fs_student_listsrch_x_mobile_other",
                ajax: { id: "x_mobile_other", form: "fs_student_listsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_student_list.fields.mobile_other.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
<?php
if (!$Page->status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->status->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_status"
            name="x_status[]"
            class="form-control ew-select<?= $Page->status->isInvalidClass() ?>"
            data-select2-id="fs_student_listsrch_x_status"
            data-table="s_student_list"
            data-field="x_status"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->status->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->status->editAttributes() ?>>
            <?= $Page->status->selectOptionListHtml("x_status", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_student_listsrch", function() {
            var options = {
                name: "x_status",
                selectId: "fs_student_listsrch_x_status",
                ajax: { id: "x_status", form: "fs_student_listsrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_student_list.fields.status.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fs_student_listsrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fs_student_listsrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fs_student_listsrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fs_student_listsrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fs_student_listsrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fs_student_listsrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fs_student_listsrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_student_list">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_s_student_list" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_s_student_listlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_s_student_list_id" class="s_student_list_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
        <th data-name="image" class="<?= $Page->image->headerCellClass() ?>"><div id="elh_s_student_list_image" class="s_student_list_image"><?= $Page->renderFieldHeader($Page->image) ?></div></th>
<?php } ?>
<?php if ($Page->sr_no->Visible) { // sr_no ?>
        <th data-name="sr_no" class="<?= $Page->sr_no->headerCellClass() ?>"><div id="elh_s_student_list_sr_no" class="s_student_list_sr_no"><?= $Page->renderFieldHeader($Page->sr_no) ?></div></th>
<?php } ?>
<?php if ($Page->name->Visible) { // name ?>
        <th data-name="name" class="<?= $Page->name->headerCellClass() ?>"><div id="elh_s_student_list_name" class="s_student_list_name"><?= $Page->renderFieldHeader($Page->name) ?></div></th>
<?php } ?>
<?php if ($Page->fac_sec->Visible) { // fac_sec ?>
        <th data-name="fac_sec" class="<?= $Page->fac_sec->headerCellClass() ?>"><div id="elh_s_student_list_fac_sec" class="s_student_list_fac_sec"><?= $Page->renderFieldHeader($Page->fac_sec) ?></div></th>
<?php } ?>
<?php if ($Page->father_name->Visible) { // father_name ?>
        <th data-name="father_name" class="<?= $Page->father_name->headerCellClass() ?>"><div id="elh_s_student_list_father_name" class="s_student_list_father_name"><?= $Page->renderFieldHeader($Page->father_name) ?></div></th>
<?php } ?>
<?php if ($Page->mother_name->Visible) { // mother_name ?>
        <th data-name="mother_name" class="<?= $Page->mother_name->headerCellClass() ?>"><div id="elh_s_student_list_mother_name" class="s_student_list_mother_name"><?= $Page->renderFieldHeader($Page->mother_name) ?></div></th>
<?php } ?>
<?php if ($Page->dob->Visible) { // dob ?>
        <th data-name="dob" class="<?= $Page->dob->headerCellClass() ?>"><div id="elh_s_student_list_dob" class="s_student_list_dob"><?= $Page->renderFieldHeader($Page->dob) ?></div></th>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
        <th data-name="mobile" class="<?= $Page->mobile->headerCellClass() ?>"><div id="elh_s_student_list_mobile" class="s_student_list_mobile"><?= $Page->renderFieldHeader($Page->mobile) ?></div></th>
<?php } ?>
<?php if ($Page->mobile_other->Visible) { // mobile_other ?>
        <th data-name="mobile_other" class="<?= $Page->mobile_other->headerCellClass() ?>"><div id="elh_s_student_list_mobile_other" class="s_student_list_mobile_other"><?= $Page->renderFieldHeader($Page->mobile_other) ?></div></th>
<?php } ?>
<?php if ($Page->address->Visible) { // address ?>
        <th data-name="address" class="<?= $Page->address->headerCellClass() ?>"><div id="elh_s_student_list_address" class="s_student_list_address"><?= $Page->renderFieldHeader($Page->address) ?></div></th>
<?php } ?>
<?php if ($Page->gender->Visible) { // gender ?>
        <th data-name="gender" class="<?= $Page->gender->headerCellClass() ?>"><div id="elh_s_student_list_gender" class="s_student_list_gender"><?= $Page->renderFieldHeader($Page->gender) ?></div></th>
<?php } ?>
<?php if ($Page->category->Visible) { // category ?>
        <th data-name="category" class="<?= $Page->category->headerCellClass() ?>"><div id="elh_s_student_list_category" class="s_student_list_category"><?= $Page->renderFieldHeader($Page->category) ?></div></th>
<?php } ?>
<?php if ($Page->doj->Visible) { // doj ?>
        <th data-name="doj" class="<?= $Page->doj->headerCellClass() ?>"><div id="elh_s_student_list_doj" class="s_student_list_doj"><?= $Page->renderFieldHeader($Page->doj) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_s_student_list_status" class="s_student_list_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->idcard_status->Visible) { // idcard_status ?>
        <th data-name="idcard_status" class="<?= $Page->idcard_status->headerCellClass() ?>"><div id="elh_s_student_list_idcard_status" class="s_student_list_idcard_status"><?= $Page->renderFieldHeader($Page->idcard_status) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_s_student_list_remarks" class="s_student_list_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->epc->Visible) { // epc ?>
        <th data-name="epc" class="<?= $Page->epc->headerCellClass() ?>"><div id="elh_s_student_list_epc" class="s_student_list_epc"><?= $Page->renderFieldHeader($Page->epc) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_id" class="el_s_student_list_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->image->Visible) { // image ?>
        <td data-name="image"<?= $Page->image->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_image" class="el_s_student_list_image">
<span>
<?= GetFileViewTag($Page->image, $Page->image->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->sr_no->Visible) { // sr_no ?>
        <td data-name="sr_no"<?= $Page->sr_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_sr_no" class="el_s_student_list_sr_no">
<span<?= $Page->sr_no->viewAttributes() ?>>
<?= $Page->sr_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->name->Visible) { // name ?>
        <td data-name="name"<?= $Page->name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_name" class="el_s_student_list_name">
<span<?= $Page->name->viewAttributes() ?>>
<?= $Page->name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->fac_sec->Visible) { // fac_sec ?>
        <td data-name="fac_sec"<?= $Page->fac_sec->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_fac_sec" class="el_s_student_list_fac_sec">
<span<?= $Page->fac_sec->viewAttributes() ?>>
<?= $Page->fac_sec->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->father_name->Visible) { // father_name ?>
        <td data-name="father_name"<?= $Page->father_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_father_name" class="el_s_student_list_father_name">
<span<?= $Page->father_name->viewAttributes() ?>>
<?= $Page->father_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mother_name->Visible) { // mother_name ?>
        <td data-name="mother_name"<?= $Page->mother_name->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_mother_name" class="el_s_student_list_mother_name">
<span<?= $Page->mother_name->viewAttributes() ?>>
<?= $Page->mother_name->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dob->Visible) { // dob ?>
        <td data-name="dob"<?= $Page->dob->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_dob" class="el_s_student_list_dob">
<span<?= $Page->dob->viewAttributes() ?>>
<?= $Page->dob->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile->Visible) { // mobile ?>
        <td data-name="mobile"<?= $Page->mobile->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_mobile" class="el_s_student_list_mobile">
<span<?= $Page->mobile->viewAttributes() ?>>
<?= $Page->mobile->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile_other->Visible) { // mobile_other ?>
        <td data-name="mobile_other"<?= $Page->mobile_other->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_mobile_other" class="el_s_student_list_mobile_other">
<span<?= $Page->mobile_other->viewAttributes() ?>>
<?= $Page->mobile_other->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->address->Visible) { // address ?>
        <td data-name="address"<?= $Page->address->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_address" class="el_s_student_list_address">
<span<?= $Page->address->viewAttributes() ?>>
<?= $Page->address->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->gender->Visible) { // gender ?>
        <td data-name="gender"<?= $Page->gender->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_gender" class="el_s_student_list_gender">
<span<?= $Page->gender->viewAttributes() ?>>
<?= $Page->gender->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->category->Visible) { // category ?>
        <td data-name="category"<?= $Page->category->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_category" class="el_s_student_list_category">
<span<?= $Page->category->viewAttributes() ?>>
<?= $Page->category->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->doj->Visible) { // doj ?>
        <td data-name="doj"<?= $Page->doj->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_doj" class="el_s_student_list_doj">
<span<?= $Page->doj->viewAttributes() ?>>
<?= $Page->doj->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_status" class="el_s_student_list_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->idcard_status->Visible) { // idcard_status ?>
        <td data-name="idcard_status"<?= $Page->idcard_status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_idcard_status" class="el_s_student_list_idcard_status">
<span<?= $Page->idcard_status->viewAttributes() ?>>
<?= $Page->idcard_status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_remarks" class="el_s_student_list_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->epc->Visible) { // epc ?>
        <td data-name="epc"<?= $Page->epc->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_student_list_epc" class="el_s_student_list_epc">
<span<?= $Page->epc->viewAttributes() ?>>
<?= $Page->epc->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_student_list");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
