<?php

namespace PHPMaker2024\fibre;

// Page object
$SPersonalInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_personal_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fs_personal_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_personal_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["name", [], fields.name.isInvalid],
            ["sr_no", [], fields.sr_no.isInvalid],
            ["father_name", [], fields.father_name.isInvalid],
            ["mother_name", [], fields.mother_name.isInvalid],
            ["address", [], fields.address.isInvalid],
            ["dob", [ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["m_type", [], fields.m_type.isInvalid],
            ["idcard_status", [], fields.idcard_status.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["gender", [], fields.gender.isInvalid],
            ["category", [], fields.category.isInvalid],
            ["mobile_other", [], fields.mobile_other.isInvalid],
            ["doj", [ew.Validators.datetime(fields.doj.clientFormatPattern)], fields.doj.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["updates", [], fields.updates.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "m_type": <?= $Page->m_type->toClientList($Page) ?>,
            "idcard_status": <?= $Page->idcard_status->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "gender": <?= $Page->gender->toClientList($Page) ?>,
            "category": <?= $Page->category->toClientList($Page) ?>,
            "mobile_other": <?= $Page->mobile_other->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fs_personal_infosearch" id="fs_personal_infosearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("spersonalinfolist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_personal_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_s_personal_info_id" class="s_personal_infosearch"><span id="el_s_personal_info_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="s_personal_info" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_personal_info_image" class="s_personal_infosearch"><span id="el_s_personal_info_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="s_personal_info" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="254" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_personal_info_name" class="s_personal_infosearch"><span id="el_s_personal_info_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->name->getInputTextType() ?>" name="x_name" id="x_name" data-table="s_personal_info" data-field="x_name" value="<?= $Page->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->name->formatPattern()) ?>"<?= $Page->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->name->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_personal_info_sr_no" class="s_personal_infosearch"><span id="el_s_personal_info_sr_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->sr_no->getInputTextType() ?>" name="x_sr_no" id="x_sr_no" data-table="s_personal_info" data-field="x_sr_no" value="<?= $Page->sr_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->sr_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->sr_no->formatPattern()) ?>"<?= $Page->sr_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->sr_no->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_personal_info_father_name" class="s_personal_infosearch"><span id="el_s_personal_info_father_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->father_name->getInputTextType() ?>" name="x_father_name" id="x_father_name" data-table="s_personal_info" data-field="x_father_name" value="<?= $Page->father_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->father_name->formatPattern()) ?>"<?= $Page->father_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->father_name->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_personal_info_mother_name" class="s_personal_infosearch"><span id="el_s_personal_info_mother_name" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mother_name->getInputTextType() ?>" name="x_mother_name" id="x_mother_name" data-table="s_personal_info" data-field="x_mother_name" value="<?= $Page->mother_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->mother_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mother_name->formatPattern()) ?>"<?= $Page->mother_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mother_name->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_personal_info_address" class="s_personal_infosearch"><span id="el_s_personal_info_address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->address->getInputTextType() ?>" name="x_address" id="x_address" data-table="s_personal_info" data-field="x_address" value="<?= $Page->address->EditValue ?>" maxlength="254" placeholder="<?= HtmlEncode($Page->address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->address->formatPattern()) ?>"<?= $Page->address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->address->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_personal_info_dob" class="s_personal_infosearch"><span id="el_s_personal_info_dob" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->dob->getInputTextType() ?>" name="x_dob" id="x_dob" data-table="s_personal_info" data-field="x_dob" value="<?= $Page->dob->EditValue ?>" placeholder="<?= HtmlEncode($Page->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->dob->formatPattern()) ?>"<?= $Page->dob->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->dob->getErrorMessage(false) ?></div>
<?php if (!$Page->dob->ReadOnly && !$Page->dob->Disabled && !isset($Page->dob->EditAttrs["readonly"]) && !isset($Page->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_personal_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_personal_infosearch", "x_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_personal_info_mobile" class="s_personal_infosearch"><span id="el_s_personal_info_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="s_personal_info" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_personal_info_m_type" class="s_personal_infosearch"><span id="el_s_personal_info_m_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_m_type"
        name="x_m_type"
        class="form-select ew-select<?= $Page->m_type->isInvalidClass() ?>"
        <?php if (!$Page->m_type->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infosearch_x_m_type"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_m_type"
        data-value-separator="<?= $Page->m_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_type->getPlaceHolder()) ?>"
        <?= $Page->m_type->editAttributes() ?>>
        <?= $Page->m_type->selectOptionListHtml("x_m_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_type->getErrorMessage(false) ?></div>
<?= $Page->m_type->Lookup->getParamTag($Page, "p_x_m_type") ?>
<?php if (!$Page->m_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infosearch", function() {
    var options = { name: "x_m_type", selectId: "fs_personal_infosearch_x_m_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infosearch.lists.m_type?.lookupOptions.length) {
        options.data = { id: "x_m_type", form: "fs_personal_infosearch" };
    } else {
        options.ajax = { id: "x_m_type", form: "fs_personal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.m_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_personal_info_idcard_status" class="s_personal_infosearch"><span id="el_s_personal_info_idcard_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_idcard_status"
        name="x_idcard_status"
        class="form-select ew-select<?= $Page->idcard_status->isInvalidClass() ?>"
        <?php if (!$Page->idcard_status->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infosearch_x_idcard_status"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_idcard_status"
        data-value-separator="<?= $Page->idcard_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->idcard_status->getPlaceHolder()) ?>"
        <?= $Page->idcard_status->editAttributes() ?>>
        <?= $Page->idcard_status->selectOptionListHtml("x_idcard_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->idcard_status->getErrorMessage(false) ?></div>
<?php if (!$Page->idcard_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infosearch", function() {
    var options = { name: "x_idcard_status", selectId: "fs_personal_infosearch_x_idcard_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infosearch.lists.idcard_status?.lookupOptions.length) {
        options.data = { id: "x_idcard_status", form: "fs_personal_infosearch" };
    } else {
        options.ajax = { id: "x_idcard_status", form: "fs_personal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.idcard_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_personal_info_status" class="s_personal_infosearch"><span id="el_s_personal_info_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infosearch_x_status"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infosearch", function() {
    var options = { name: "x_status", selectId: "fs_personal_infosearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infosearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fs_personal_infosearch" };
    } else {
        options.ajax = { id: "x_status", form: "fs_personal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_personal_info_gender" class="s_personal_infosearch"><span id="el_s_personal_info_gender" class="ew-search-field ew-search-field-single">
    <select
        id="x_gender"
        name="x_gender"
        class="form-select ew-select<?= $Page->gender->isInvalidClass() ?>"
        <?php if (!$Page->gender->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infosearch_x_gender"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_gender"
        data-value-separator="<?= $Page->gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->gender->getPlaceHolder()) ?>"
        <?= $Page->gender->editAttributes() ?>>
        <?= $Page->gender->selectOptionListHtml("x_gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->gender->getErrorMessage(false) ?></div>
<?php if (!$Page->gender->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infosearch", function() {
    var options = { name: "x_gender", selectId: "fs_personal_infosearch_x_gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infosearch.lists.gender?.lookupOptions.length) {
        options.data = { id: "x_gender", form: "fs_personal_infosearch" };
    } else {
        options.ajax = { id: "x_gender", form: "fs_personal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_personal_info_category" class="s_personal_infosearch"><span id="el_s_personal_info_category" class="ew-search-field ew-search-field-single">
    <select
        id="x_category"
        name="x_category"
        class="form-select ew-select<?= $Page->category->isInvalidClass() ?>"
        <?php if (!$Page->category->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infosearch_x_category"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_category"
        data-value-separator="<?= $Page->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->category->getPlaceHolder()) ?>"
        <?= $Page->category->editAttributes() ?>>
        <?= $Page->category->selectOptionListHtml("x_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->category->getErrorMessage(false) ?></div>
<?php if (!$Page->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infosearch", function() {
    var options = { name: "x_category", selectId: "fs_personal_infosearch_x_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infosearch.lists.category?.lookupOptions.length) {
        options.data = { id: "x_category", form: "fs_personal_infosearch" };
    } else {
        options.ajax = { id: "x_category", form: "fs_personal_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_personal_info_mobile_other" class="s_personal_infosearch"><span id="el_s_personal_info_mobile_other" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->mobile_other->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_mobile_other" class="ew-auto-suggest">
    <input type="<?= $Page->mobile_other->getInputTextType() ?>" class="form-control" name="sv_x_mobile_other" id="sv_x_mobile_other" value="<?= RemoveHtml($Page->mobile_other->EditValue) ?>" autocomplete="off" size="30" maxlength="96" placeholder="<?= HtmlEncode($Page->mobile_other->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->mobile_other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile_other->formatPattern()) ?>"<?= $Page->mobile_other->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_personal_info" data-field="x_mobile_other" data-input="sv_x_mobile_other" data-value-separator="<?= $Page->mobile_other->displayValueSeparatorAttribute() ?>" name="x_mobile_other" id="x_mobile_other" value="<?= HtmlEncode($Page->mobile_other->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->mobile_other->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fs_personal_infosearch", function() {
    fs_personal_infosearch.createAutoSuggest(Object.assign({"id":"x_mobile_other","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->mobile_other->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_personal_info.fields.mobile_other.autoSuggestOptions));
});
</script>
</span></template>
<template id="tpx_s_personal_info_doj" class="s_personal_infosearch"><span id="el_s_personal_info_doj" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->doj->getInputTextType() ?>" name="x_doj" id="x_doj" data-table="s_personal_info" data-field="x_doj" value="<?= $Page->doj->EditValue ?>" placeholder="<?= HtmlEncode($Page->doj->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->doj->formatPattern()) ?>"<?= $Page->doj->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->doj->getErrorMessage(false) ?></div>
<?php if (!$Page->doj->ReadOnly && !$Page->doj->Disabled && !isset($Page->doj->EditAttrs["readonly"]) && !isset($Page->doj->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_personal_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_personal_infosearch", "x_doj", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_personal_info_remarks" class="s_personal_infosearch"><span id="el_s_personal_info_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="s_personal_info" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_personal_info_operator" class="s_personal_infosearch"><span id="el_s_personal_info_operator" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->operator->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_operator" class="ew-auto-suggest">
    <input type="<?= $Page->operator->getInputTextType() ?>" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?= RemoveHtml($Page->operator->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_personal_info" data-field="x_operator" data-input="sv_x_operator" data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?= HtmlEncode($Page->operator->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fs_personal_infosearch", function() {
    fs_personal_infosearch.createAutoSuggest(Object.assign({"id":"x_operator","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->operator->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_personal_info.fields.operator.autoSuggestOptions));
});
</script>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
</span></template>
<template id="tpx_s_personal_info_datetime" class="s_personal_infosearch"><span id="el_s_personal_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="s_personal_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_personal_infosearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_personal_infosearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_personal_info_updates" class="s_personal_infosearch"><span id="el_s_personal_info_updates" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->updates->getInputTextType() ?>" name="x_updates" id="x_updates" data-table="s_personal_info" data-field="x_updates" value="<?= $Page->updates->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->updates->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->updates->formatPattern()) ?>"<?= $Page->updates->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->updates->getErrorMessage(false) ?></div>
</span></template>
<div id="s_personal_info_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "image",
                type: "string",
                label: currentTable.fields.image.caption,
                operators: currentTable.fields.image.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.image.validators),
                data: {
                    format: currentTable.fields.image.clientFormatPattern
                }
            },
            {
                id: "name",
                type: "string",
                label: currentTable.fields.name.caption,
                operators: currentTable.fields.name.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.name.validators),
                data: {
                    format: currentTable.fields.name.clientFormatPattern
                }
            },
            {
                id: "sr_no",
                type: "string",
                label: currentTable.fields.sr_no.caption,
                operators: currentTable.fields.sr_no.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.sr_no.validators),
                data: {
                    format: currentTable.fields.sr_no.clientFormatPattern
                }
            },
            {
                id: "father_name",
                type: "string",
                label: currentTable.fields.father_name.caption,
                operators: currentTable.fields.father_name.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.father_name.validators),
                data: {
                    format: currentTable.fields.father_name.clientFormatPattern
                }
            },
            {
                id: "mother_name",
                type: "string",
                label: currentTable.fields.mother_name.caption,
                operators: currentTable.fields.mother_name.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.mother_name.validators),
                data: {
                    format: currentTable.fields.mother_name.clientFormatPattern
                }
            },
            {
                id: "address",
                type: "string",
                label: currentTable.fields.address.caption,
                operators: currentTable.fields.address.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.address.validators),
                data: {
                    format: currentTable.fields.address.clientFormatPattern
                }
            },
            {
                id: "dob",
                type: "datetime",
                label: currentTable.fields.dob.caption,
                operators: currentTable.fields.dob.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.dob.validators),
                data: {
                    format: currentTable.fields.dob.clientFormatPattern
                }
            },
            {
                id: "mobile",
                type: "string",
                label: currentTable.fields.mobile.caption,
                operators: currentTable.fields.mobile.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.mobile.validators),
                data: {
                    format: currentTable.fields.mobile.clientFormatPattern
                }
            },
            {
                id: "m_type",
                type: "integer",
                label: currentTable.fields.m_type.caption,
                operators: currentTable.fields.m_type.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.m_type.validators),
                data: {
                    format: currentTable.fields.m_type.clientFormatPattern
                }
            },
            {
                id: "idcard_status",
                type: "integer",
                label: currentTable.fields.idcard_status.caption,
                operators: currentTable.fields.idcard_status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.idcard_status.validators),
                data: {
                    format: currentTable.fields.idcard_status.clientFormatPattern
                }
            },
            {
                id: "status",
                type: "integer",
                label: currentTable.fields.status.caption,
                operators: currentTable.fields.status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.status.validators),
                data: {
                    format: currentTable.fields.status.clientFormatPattern
                }
            },
            {
                id: "gender",
                type: "string",
                label: currentTable.fields.gender.caption,
                operators: currentTable.fields.gender.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.gender.validators),
                data: {
                    format: currentTable.fields.gender.clientFormatPattern
                }
            },
            {
                id: "category",
                type: "string",
                label: currentTable.fields.category.caption,
                operators: currentTable.fields.category.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.category.validators),
                data: {
                    format: currentTable.fields.category.clientFormatPattern
                }
            },
            {
                id: "mobile_other",
                type: "string",
                label: currentTable.fields.mobile_other.caption,
                operators: currentTable.fields.mobile_other.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.mobile_other.validators),
                data: {
                    format: currentTable.fields.mobile_other.clientFormatPattern
                }
            },
            {
                id: "doj",
                type: "datetime",
                label: currentTable.fields.doj.caption,
                operators: currentTable.fields.doj.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.doj.validators),
                data: {
                    format: currentTable.fields.doj.clientFormatPattern
                }
            },
            {
                id: "remarks",
                type: "string",
                label: currentTable.fields.remarks.caption,
                operators: currentTable.fields.remarks.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.remarks.validators),
                data: {
                    format: currentTable.fields.remarks.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
            {
                id: "updates",
                type: "string",
                label: currentTable.fields.updates.caption,
                operators: currentTable.fields.updates.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_personal_infosearch.fields.updates.validators),
                data: {
                    format: currentTable.fields.updates.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#s_personal_info_query_builder"),
        args = {},
        rules = ew.parseJson($("#fs_personal_infosearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fs_personal_infosearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fs_personal_infosearch" formaction="<?= HtmlEncode(GetUrl("spersonalinfolist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fs_personal_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fs_personal_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_personal_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
