<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("SPersonalInfoGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fs_personal_infogrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { s_personal_info: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fs_personal_infogrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["name", [fields.name.visible && fields.name.required ? ew.Validators.required(fields.name.caption) : null], fields.name.isInvalid],
            ["sr_no", [fields.sr_no.visible && fields.sr_no.required ? ew.Validators.required(fields.sr_no.caption) : null], fields.sr_no.isInvalid],
            ["faculty", [fields.faculty.visible && fields.faculty.required ? ew.Validators.required(fields.faculty.caption) : null], fields.faculty.isInvalid],
            ["father_name", [fields.father_name.visible && fields.father_name.required ? ew.Validators.required(fields.father_name.caption) : null], fields.father_name.isInvalid],
            ["mother_name", [fields.mother_name.visible && fields.mother_name.required ? ew.Validators.required(fields.mother_name.caption) : null], fields.mother_name.isInvalid],
            ["address", [fields.address.visible && fields.address.required ? ew.Validators.required(fields.address.caption) : null], fields.address.isInvalid],
            ["dob", [fields.dob.visible && fields.dob.required ? ew.Validators.required(fields.dob.caption) : null, ew.Validators.datetime(fields.dob.clientFormatPattern)], fields.dob.isInvalid],
            ["mobile", [fields.mobile.visible && fields.mobile.required ? ew.Validators.required(fields.mobile.caption) : null], fields.mobile.isInvalid],
            ["m_type", [fields.m_type.visible && fields.m_type.required ? ew.Validators.required(fields.m_type.caption) : null], fields.m_type.isInvalid],
            ["idcard_status", [fields.idcard_status.visible && fields.idcard_status.required ? ew.Validators.required(fields.idcard_status.caption) : null], fields.idcard_status.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null], fields.status.isInvalid],
            ["gender", [fields.gender.visible && fields.gender.required ? ew.Validators.required(fields.gender.caption) : null], fields.gender.isInvalid],
            ["category", [fields.category.visible && fields.category.required ? ew.Validators.required(fields.category.caption) : null], fields.category.isInvalid],
            ["mobile_other", [fields.mobile_other.visible && fields.mobile_other.required ? ew.Validators.required(fields.mobile_other.caption) : null], fields.mobile_other.isInvalid],
            ["doj", [fields.doj.visible && fields.doj.required ? ew.Validators.required(fields.doj.caption) : null, ew.Validators.datetime(fields.doj.clientFormatPattern)], fields.doj.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["sr_uid", [fields.sr_uid.visible && fields.sr_uid.required ? ew.Validators.required(fields.sr_uid.caption) : null, ew.Validators.integer], fields.sr_uid.isInvalid],
            ["updates", [fields.updates.visible && fields.updates.required ? ew.Validators.required(fields.updates.caption) : null], fields.updates.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["image",false],["name",false],["sr_no",false],["faculty",false],["father_name",false],["mother_name",false],["address",false],["dob",false],["mobile",false],["m_type",false],["idcard_status",false],["status",false],["gender",false],["category",false],["mobile_other",false],["doj",false],["remarks",false],["sr_uid",false],["updates",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "faculty": <?= $Grid->faculty->toClientList($Grid) ?>,
            "m_type": <?= $Grid->m_type->toClientList($Grid) ?>,
            "idcard_status": <?= $Grid->idcard_status->toClientList($Grid) ?>,
            "status": <?= $Grid->status->toClientList($Grid) ?>,
            "gender": <?= $Grid->gender->toClientList($Grid) ?>,
            "category": <?= $Grid->category->toClientList($Grid) ?>,
            "mobile_other": <?= $Grid->mobile_other->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fs_personal_infogrid" class="ew-form ew-list-form">
<div id="gmp_s_personal_info" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_s_personal_infogrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_s_personal_info_id" class="s_personal_info_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->image->Visible) { // image ?>
        <th data-name="image" class="<?= $Grid->image->headerCellClass() ?>"><div id="elh_s_personal_info_image" class="s_personal_info_image"><?= $Grid->renderFieldHeader($Grid->image) ?></div></th>
<?php } ?>
<?php if ($Grid->name->Visible) { // name ?>
        <th data-name="name" class="<?= $Grid->name->headerCellClass() ?>"><div id="elh_s_personal_info_name" class="s_personal_info_name"><?= $Grid->renderFieldHeader($Grid->name) ?></div></th>
<?php } ?>
<?php if ($Grid->sr_no->Visible) { // sr_no ?>
        <th data-name="sr_no" class="<?= $Grid->sr_no->headerCellClass() ?>"><div id="elh_s_personal_info_sr_no" class="s_personal_info_sr_no"><?= $Grid->renderFieldHeader($Grid->sr_no) ?></div></th>
<?php } ?>
<?php if ($Grid->faculty->Visible) { // faculty ?>
        <th data-name="faculty" class="<?= $Grid->faculty->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_s_personal_info_faculty" class="s_personal_info_faculty"><?= $Grid->renderFieldHeader($Grid->faculty) ?></div></th>
<?php } ?>
<?php if ($Grid->father_name->Visible) { // father_name ?>
        <th data-name="father_name" class="<?= $Grid->father_name->headerCellClass() ?>"><div id="elh_s_personal_info_father_name" class="s_personal_info_father_name"><?= $Grid->renderFieldHeader($Grid->father_name) ?></div></th>
<?php } ?>
<?php if ($Grid->mother_name->Visible) { // mother_name ?>
        <th data-name="mother_name" class="<?= $Grid->mother_name->headerCellClass() ?>"><div id="elh_s_personal_info_mother_name" class="s_personal_info_mother_name"><?= $Grid->renderFieldHeader($Grid->mother_name) ?></div></th>
<?php } ?>
<?php if ($Grid->address->Visible) { // address ?>
        <th data-name="address" class="<?= $Grid->address->headerCellClass() ?>"><div id="elh_s_personal_info_address" class="s_personal_info_address"><?= $Grid->renderFieldHeader($Grid->address) ?></div></th>
<?php } ?>
<?php if ($Grid->dob->Visible) { // dob ?>
        <th data-name="dob" class="<?= $Grid->dob->headerCellClass() ?>"><div id="elh_s_personal_info_dob" class="s_personal_info_dob"><?= $Grid->renderFieldHeader($Grid->dob) ?></div></th>
<?php } ?>
<?php if ($Grid->mobile->Visible) { // mobile ?>
        <th data-name="mobile" class="<?= $Grid->mobile->headerCellClass() ?>"><div id="elh_s_personal_info_mobile" class="s_personal_info_mobile"><?= $Grid->renderFieldHeader($Grid->mobile) ?></div></th>
<?php } ?>
<?php if ($Grid->m_type->Visible) { // m_type ?>
        <th data-name="m_type" class="<?= $Grid->m_type->headerCellClass() ?>"><div id="elh_s_personal_info_m_type" class="s_personal_info_m_type"><?= $Grid->renderFieldHeader($Grid->m_type) ?></div></th>
<?php } ?>
<?php if ($Grid->idcard_status->Visible) { // idcard_status ?>
        <th data-name="idcard_status" class="<?= $Grid->idcard_status->headerCellClass() ?>"><div id="elh_s_personal_info_idcard_status" class="s_personal_info_idcard_status"><?= $Grid->renderFieldHeader($Grid->idcard_status) ?></div></th>
<?php } ?>
<?php if ($Grid->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Grid->status->headerCellClass() ?>"><div id="elh_s_personal_info_status" class="s_personal_info_status"><?= $Grid->renderFieldHeader($Grid->status) ?></div></th>
<?php } ?>
<?php if ($Grid->gender->Visible) { // gender ?>
        <th data-name="gender" class="<?= $Grid->gender->headerCellClass() ?>"><div id="elh_s_personal_info_gender" class="s_personal_info_gender"><?= $Grid->renderFieldHeader($Grid->gender) ?></div></th>
<?php } ?>
<?php if ($Grid->category->Visible) { // category ?>
        <th data-name="category" class="<?= $Grid->category->headerCellClass() ?>"><div id="elh_s_personal_info_category" class="s_personal_info_category"><?= $Grid->renderFieldHeader($Grid->category) ?></div></th>
<?php } ?>
<?php if ($Grid->mobile_other->Visible) { // mobile_other ?>
        <th data-name="mobile_other" class="<?= $Grid->mobile_other->headerCellClass() ?>"><div id="elh_s_personal_info_mobile_other" class="s_personal_info_mobile_other"><?= $Grid->renderFieldHeader($Grid->mobile_other) ?></div></th>
<?php } ?>
<?php if ($Grid->doj->Visible) { // doj ?>
        <th data-name="doj" class="<?= $Grid->doj->headerCellClass() ?>"><div id="elh_s_personal_info_doj" class="s_personal_info_doj"><?= $Grid->renderFieldHeader($Grid->doj) ?></div></th>
<?php } ?>
<?php if ($Grid->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Grid->remarks->headerCellClass() ?>"><div id="elh_s_personal_info_remarks" class="s_personal_info_remarks"><?= $Grid->renderFieldHeader($Grid->remarks) ?></div></th>
<?php } ?>
<?php if ($Grid->sr_uid->Visible) { // sr_uid ?>
        <th data-name="sr_uid" class="<?= $Grid->sr_uid->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_s_personal_info_sr_uid" class="s_personal_info_sr_uid"><?= $Grid->renderFieldHeader($Grid->sr_uid) ?></div></th>
<?php } ?>
<?php if ($Grid->updates->Visible) { // updates ?>
        <th data-name="updates" class="<?= $Grid->updates->headerCellClass() ?>"><div id="elh_s_personal_info_updates" class="s_personal_info_updates"><?= $Grid->renderFieldHeader($Grid->updates) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_id" class="el_s_personal_info_id"></span>
<input type="hidden" data-table="s_personal_info" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_id" class="el_s_personal_info_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="s_personal_info" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_id" class="el_s_personal_info_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_id" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_id" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_id" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_id" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="s_personal_info" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->image->Visible) { // image ?>
        <td data-name="image"<?= $Grid->image->cellAttributes() ?>>
<?php if ($Grid->RowAction == "insert") { // Add record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex ?>_s_personal_info_image" class="el_s_personal_info_image">
<div id="fd_x<?= $Grid->RowIndex ?>_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_image"
        name="x<?= $Grid->RowIndex ?>_image"
        class="form-control ew-file-input"
        title="<?= $Grid->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="s_personal_info"
        data-field="x_image"
        data-size="254"
        data-accept-file-types="<?= $Grid->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->image->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->image->ReadOnly || $Grid->image->Disabled) ? " disabled" : "" ?>
        <?= $Grid->image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_image" id= "fn_x<?= $Grid->RowIndex ?>_image" value="<?= $Grid->image->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_image" id= "fa_x<?= $Grid->RowIndex ?>_image" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex ?>_s_personal_info_image" class="el_s_personal_info_image">
<div id="fd_x<?= $Grid->RowIndex ?>_image">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_image"
        name="x<?= $Grid->RowIndex ?>_image"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="s_personal_info"
        data-field="x_image"
        data-size="254"
        data-accept-file-types="<?= $Grid->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->image->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->image->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_image" id= "fn_x<?= $Grid->RowIndex ?>_image" value="<?= $Grid->image->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_image" id= "fa_x<?= $Grid->RowIndex ?>_image" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<input type="hidden" data-table="s_personal_info" data-field="x_image" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_image" id="o<?= $Grid->RowIndex ?>_image" value="<?= HtmlEncode($Grid->image->OldValue) ?>">
<?php } elseif ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_image" class="el_s_personal_info_image">
<span<?= $Grid->image->viewAttributes() ?>>
<?= GetFileViewTag($Grid->image, $Grid->image->getViewValue(), false) ?>
</span>
</span>
<?php } else  { // Edit record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_image" class="el_s_personal_info_image">
<span<?= $Grid->image->viewAttributes() ?>>
<?= GetFileViewTag($Grid->image, $Grid->image->EditValue, false) ?>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_image" data-hidden="1" data-old name="x<?= $Grid->RowIndex ?>_image" id="x<?= $Grid->RowIndex ?>_image" value="<?= HtmlEncode($Grid->image->CurrentValue) ?>">
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_image" class="el_s_personal_info_image">
<span<?= $Grid->image->viewAttributes() ?>>
<?= GetFileViewTag($Grid->image, $Grid->image->EditValue, false) ?>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_image" data-hidden="1" data-old name="x<?= $Grid->RowIndex ?>_image" id="x<?= $Grid->RowIndex ?>_image" value="<?= HtmlEncode($Grid->image->CurrentValue) ?>">
</span>
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->name->Visible) { // name ?>
        <td data-name="name"<?= $Grid->name->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_name" class="el_s_personal_info_name">
<input type="<?= $Grid->name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_name" id="x<?= $Grid->RowIndex ?>_name" data-table="s_personal_info" data-field="x_name" value="<?= $Grid->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->name->formatPattern()) ?>"<?= $Grid->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_name" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_name" id="o<?= $Grid->RowIndex ?>_name" value="<?= HtmlEncode($Grid->name->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_name" class="el_s_personal_info_name">
<input type="<?= $Grid->name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_name" id="x<?= $Grid->RowIndex ?>_name" data-table="s_personal_info" data-field="x_name" value="<?= $Grid->name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->name->formatPattern()) ?>"<?= $Grid->name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->name->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_name" class="el_s_personal_info_name">
<span<?= $Grid->name->viewAttributes() ?>>
<?= $Grid->name->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_name" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_name" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_name" value="<?= HtmlEncode($Grid->name->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_name" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_name" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_name" value="<?= HtmlEncode($Grid->name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->sr_no->Visible) { // sr_no ?>
        <td data-name="sr_no"<?= $Grid->sr_no->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_sr_no" class="el_s_personal_info_sr_no">
<input type="<?= $Grid->sr_no->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_sr_no" id="x<?= $Grid->RowIndex ?>_sr_no" data-table="s_personal_info" data-field="x_sr_no" value="<?= $Grid->sr_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->sr_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->sr_no->formatPattern()) ?>"<?= $Grid->sr_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->sr_no->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_sr_no" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_sr_no" id="o<?= $Grid->RowIndex ?>_sr_no" value="<?= HtmlEncode($Grid->sr_no->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_sr_no" class="el_s_personal_info_sr_no">
<input type="<?= $Grid->sr_no->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_sr_no" id="x<?= $Grid->RowIndex ?>_sr_no" data-table="s_personal_info" data-field="x_sr_no" value="<?= $Grid->sr_no->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Grid->sr_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->sr_no->formatPattern()) ?>"<?= $Grid->sr_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->sr_no->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_sr_no" class="el_s_personal_info_sr_no">
<span<?= $Grid->sr_no->viewAttributes() ?>>
<?= $Grid->sr_no->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_sr_no" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_sr_no" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_sr_no" value="<?= HtmlEncode($Grid->sr_no->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_sr_no" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_sr_no" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_sr_no" value="<?= HtmlEncode($Grid->sr_no->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->faculty->Visible) { // faculty ?>
        <td data-name="faculty"<?= $Grid->faculty->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_faculty" class="el_s_personal_info_faculty">
    <select
        id="x<?= $Grid->RowIndex ?>_faculty"
        name="x<?= $Grid->RowIndex ?>_faculty"
        class="form-select ew-select<?= $Grid->faculty->isInvalidClass() ?>"
        <?php if (!$Grid->faculty->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infogrid_x<?= $Grid->RowIndex ?>_faculty"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_faculty"
        data-value-separator="<?= $Grid->faculty->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->faculty->getPlaceHolder()) ?>"
        <?= $Grid->faculty->editAttributes() ?>>
        <?= $Grid->faculty->selectOptionListHtml("x{$Grid->RowIndex}_faculty") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->faculty->getErrorMessage() ?></div>
<?= $Grid->faculty->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_faculty") ?>
<?php if (!$Grid->faculty->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_faculty", selectId: "fs_personal_infogrid_x<?= $Grid->RowIndex ?>_faculty" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infogrid.lists.faculty?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_faculty", form: "fs_personal_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_faculty", form: "fs_personal_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.faculty.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_faculty" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_faculty" id="o<?= $Grid->RowIndex ?>_faculty" value="<?= HtmlEncode($Grid->faculty->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_faculty" class="el_s_personal_info_faculty">
<span<?= $Grid->faculty->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->faculty->getDisplayValue($Grid->faculty->EditValue) ?></span></span>
<input type="hidden" data-table="s_personal_info" data-field="x_faculty" data-hidden="1" name="x<?= $Grid->RowIndex ?>_faculty" id="x<?= $Grid->RowIndex ?>_faculty" value="<?= HtmlEncode($Grid->faculty->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_faculty" class="el_s_personal_info_faculty">
<span<?= $Grid->faculty->viewAttributes() ?>>
<?= $Grid->faculty->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_faculty" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_faculty" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_faculty" value="<?= HtmlEncode($Grid->faculty->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_faculty" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_faculty" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_faculty" value="<?= HtmlEncode($Grid->faculty->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->father_name->Visible) { // father_name ?>
        <td data-name="father_name"<?= $Grid->father_name->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_father_name" class="el_s_personal_info_father_name">
<input type="<?= $Grid->father_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_father_name" id="x<?= $Grid->RowIndex ?>_father_name" data-table="s_personal_info" data-field="x_father_name" value="<?= $Grid->father_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->father_name->formatPattern()) ?>"<?= $Grid->father_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->father_name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_father_name" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_father_name" id="o<?= $Grid->RowIndex ?>_father_name" value="<?= HtmlEncode($Grid->father_name->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_father_name" class="el_s_personal_info_father_name">
<input type="<?= $Grid->father_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_father_name" id="x<?= $Grid->RowIndex ?>_father_name" data-table="s_personal_info" data-field="x_father_name" value="<?= $Grid->father_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->father_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->father_name->formatPattern()) ?>"<?= $Grid->father_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->father_name->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_father_name" class="el_s_personal_info_father_name">
<span<?= $Grid->father_name->viewAttributes() ?>>
<?= $Grid->father_name->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_father_name" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_father_name" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_father_name" value="<?= HtmlEncode($Grid->father_name->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_father_name" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_father_name" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_father_name" value="<?= HtmlEncode($Grid->father_name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->mother_name->Visible) { // mother_name ?>
        <td data-name="mother_name"<?= $Grid->mother_name->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_mother_name" class="el_s_personal_info_mother_name">
<input type="<?= $Grid->mother_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_mother_name" id="x<?= $Grid->RowIndex ?>_mother_name" data-table="s_personal_info" data-field="x_mother_name" value="<?= $Grid->mother_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->mother_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->mother_name->formatPattern()) ?>"<?= $Grid->mother_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->mother_name->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_mother_name" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_mother_name" id="o<?= $Grid->RowIndex ?>_mother_name" value="<?= HtmlEncode($Grid->mother_name->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_mother_name" class="el_s_personal_info_mother_name">
<input type="<?= $Grid->mother_name->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_mother_name" id="x<?= $Grid->RowIndex ?>_mother_name" data-table="s_personal_info" data-field="x_mother_name" value="<?= $Grid->mother_name->EditValue ?>" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->mother_name->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->mother_name->formatPattern()) ?>"<?= $Grid->mother_name->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->mother_name->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_mother_name" class="el_s_personal_info_mother_name">
<span<?= $Grid->mother_name->viewAttributes() ?>>
<?= $Grid->mother_name->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_mother_name" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_mother_name" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_mother_name" value="<?= HtmlEncode($Grid->mother_name->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_mother_name" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_mother_name" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_mother_name" value="<?= HtmlEncode($Grid->mother_name->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->address->Visible) { // address ?>
        <td data-name="address"<?= $Grid->address->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_address" class="el_s_personal_info_address">
<textarea data-table="s_personal_info" data-field="x_address" name="x<?= $Grid->RowIndex ?>_address" id="x<?= $Grid->RowIndex ?>_address" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->address->getPlaceHolder()) ?>"<?= $Grid->address->editAttributes() ?>><?= $Grid->address->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->address->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_address" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_address" id="o<?= $Grid->RowIndex ?>_address" value="<?= HtmlEncode($Grid->address->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_address" class="el_s_personal_info_address">
<textarea data-table="s_personal_info" data-field="x_address" name="x<?= $Grid->RowIndex ?>_address" id="x<?= $Grid->RowIndex ?>_address" cols="35" rows="4" placeholder="<?= HtmlEncode($Grid->address->getPlaceHolder()) ?>"<?= $Grid->address->editAttributes() ?>><?= $Grid->address->EditValue ?></textarea>
<div class="invalid-feedback"><?= $Grid->address->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_address" class="el_s_personal_info_address">
<span<?= $Grid->address->viewAttributes() ?>>
<?= $Grid->address->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_address" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_address" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_address" value="<?= HtmlEncode($Grid->address->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_address" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_address" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_address" value="<?= HtmlEncode($Grid->address->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->dob->Visible) { // dob ?>
        <td data-name="dob"<?= $Grid->dob->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_dob" class="el_s_personal_info_dob">
<input type="<?= $Grid->dob->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_dob" id="x<?= $Grid->RowIndex ?>_dob" data-table="s_personal_info" data-field="x_dob" value="<?= $Grid->dob->EditValue ?>" placeholder="<?= HtmlEncode($Grid->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->dob->formatPattern()) ?>"<?= $Grid->dob->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->dob->getErrorMessage() ?></div>
<?php if (!$Grid->dob->ReadOnly && !$Grid->dob->Disabled && !isset($Grid->dob->EditAttrs["readonly"]) && !isset($Grid->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_personal_infogrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_personal_infogrid", "x<?= $Grid->RowIndex ?>_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_dob" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_dob" id="o<?= $Grid->RowIndex ?>_dob" value="<?= HtmlEncode($Grid->dob->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_dob" class="el_s_personal_info_dob">
<input type="<?= $Grid->dob->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_dob" id="x<?= $Grid->RowIndex ?>_dob" data-table="s_personal_info" data-field="x_dob" value="<?= $Grid->dob->EditValue ?>" placeholder="<?= HtmlEncode($Grid->dob->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->dob->formatPattern()) ?>"<?= $Grid->dob->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->dob->getErrorMessage() ?></div>
<?php if (!$Grid->dob->ReadOnly && !$Grid->dob->Disabled && !isset($Grid->dob->EditAttrs["readonly"]) && !isset($Grid->dob->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_personal_infogrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_personal_infogrid", "x<?= $Grid->RowIndex ?>_dob", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_dob" class="el_s_personal_info_dob">
<span<?= $Grid->dob->viewAttributes() ?>>
<?= $Grid->dob->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_dob" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_dob" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_dob" value="<?= HtmlEncode($Grid->dob->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_dob" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_dob" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_dob" value="<?= HtmlEncode($Grid->dob->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->mobile->Visible) { // mobile ?>
        <td data-name="mobile"<?= $Grid->mobile->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_mobile" class="el_s_personal_info_mobile">
<input type="<?= $Grid->mobile->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_mobile" id="x<?= $Grid->RowIndex ?>_mobile" data-table="s_personal_info" data-field="x_mobile" value="<?= $Grid->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Grid->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->mobile->formatPattern()) ?>"<?= $Grid->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->mobile->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_mobile" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_mobile" id="o<?= $Grid->RowIndex ?>_mobile" value="<?= HtmlEncode($Grid->mobile->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_mobile" class="el_s_personal_info_mobile">
<input type="<?= $Grid->mobile->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_mobile" id="x<?= $Grid->RowIndex ?>_mobile" data-table="s_personal_info" data-field="x_mobile" value="<?= $Grid->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Grid->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->mobile->formatPattern()) ?>"<?= $Grid->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->mobile->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_mobile" class="el_s_personal_info_mobile">
<span<?= $Grid->mobile->viewAttributes() ?>>
<?= $Grid->mobile->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_mobile" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_mobile" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_mobile" value="<?= HtmlEncode($Grid->mobile->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_mobile" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_mobile" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_mobile" value="<?= HtmlEncode($Grid->mobile->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->m_type->Visible) { // m_type ?>
        <td data-name="m_type"<?= $Grid->m_type->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_m_type" class="el_s_personal_info_m_type">
    <select
        id="x<?= $Grid->RowIndex ?>_m_type"
        name="x<?= $Grid->RowIndex ?>_m_type"
        class="form-select ew-select<?= $Grid->m_type->isInvalidClass() ?>"
        <?php if (!$Grid->m_type->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infogrid_x<?= $Grid->RowIndex ?>_m_type"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_m_type"
        data-value-separator="<?= $Grid->m_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->m_type->getPlaceHolder()) ?>"
        <?= $Grid->m_type->editAttributes() ?>>
        <?= $Grid->m_type->selectOptionListHtml("x{$Grid->RowIndex}_m_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->m_type->getErrorMessage() ?></div>
<?= $Grid->m_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_m_type") ?>
<?php if (!$Grid->m_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_m_type", selectId: "fs_personal_infogrid_x<?= $Grid->RowIndex ?>_m_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infogrid.lists.m_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_m_type", form: "fs_personal_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_m_type", form: "fs_personal_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.m_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_m_type" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_m_type" id="o<?= $Grid->RowIndex ?>_m_type" value="<?= HtmlEncode($Grid->m_type->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_m_type" class="el_s_personal_info_m_type">
    <select
        id="x<?= $Grid->RowIndex ?>_m_type"
        name="x<?= $Grid->RowIndex ?>_m_type"
        class="form-select ew-select<?= $Grid->m_type->isInvalidClass() ?>"
        <?php if (!$Grid->m_type->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infogrid_x<?= $Grid->RowIndex ?>_m_type"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_m_type"
        data-value-separator="<?= $Grid->m_type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->m_type->getPlaceHolder()) ?>"
        <?= $Grid->m_type->editAttributes() ?>>
        <?= $Grid->m_type->selectOptionListHtml("x{$Grid->RowIndex}_m_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->m_type->getErrorMessage() ?></div>
<?= $Grid->m_type->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_m_type") ?>
<?php if (!$Grid->m_type->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_m_type", selectId: "fs_personal_infogrid_x<?= $Grid->RowIndex ?>_m_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infogrid.lists.m_type?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_m_type", form: "fs_personal_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_m_type", form: "fs_personal_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.m_type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_m_type" class="el_s_personal_info_m_type">
<span<?= $Grid->m_type->viewAttributes() ?>>
<?= $Grid->m_type->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_m_type" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_m_type" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_m_type" value="<?= HtmlEncode($Grid->m_type->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_m_type" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_m_type" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_m_type" value="<?= HtmlEncode($Grid->m_type->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->idcard_status->Visible) { // idcard_status ?>
        <td data-name="idcard_status"<?= $Grid->idcard_status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_idcard_status" class="el_s_personal_info_idcard_status">
    <select
        id="x<?= $Grid->RowIndex ?>_idcard_status"
        name="x<?= $Grid->RowIndex ?>_idcard_status"
        class="form-select ew-select<?= $Grid->idcard_status->isInvalidClass() ?>"
        <?php if (!$Grid->idcard_status->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infogrid_x<?= $Grid->RowIndex ?>_idcard_status"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_idcard_status"
        data-value-separator="<?= $Grid->idcard_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->idcard_status->getPlaceHolder()) ?>"
        <?= $Grid->idcard_status->editAttributes() ?>>
        <?= $Grid->idcard_status->selectOptionListHtml("x{$Grid->RowIndex}_idcard_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->idcard_status->getErrorMessage() ?></div>
<?php if (!$Grid->idcard_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_idcard_status", selectId: "fs_personal_infogrid_x<?= $Grid->RowIndex ?>_idcard_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infogrid.lists.idcard_status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_idcard_status", form: "fs_personal_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_idcard_status", form: "fs_personal_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.idcard_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_idcard_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_idcard_status" id="o<?= $Grid->RowIndex ?>_idcard_status" value="<?= HtmlEncode($Grid->idcard_status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_idcard_status" class="el_s_personal_info_idcard_status">
    <select
        id="x<?= $Grid->RowIndex ?>_idcard_status"
        name="x<?= $Grid->RowIndex ?>_idcard_status"
        class="form-select ew-select<?= $Grid->idcard_status->isInvalidClass() ?>"
        <?php if (!$Grid->idcard_status->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infogrid_x<?= $Grid->RowIndex ?>_idcard_status"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_idcard_status"
        data-value-separator="<?= $Grid->idcard_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->idcard_status->getPlaceHolder()) ?>"
        <?= $Grid->idcard_status->editAttributes() ?>>
        <?= $Grid->idcard_status->selectOptionListHtml("x{$Grid->RowIndex}_idcard_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->idcard_status->getErrorMessage() ?></div>
<?php if (!$Grid->idcard_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_idcard_status", selectId: "fs_personal_infogrid_x<?= $Grid->RowIndex ?>_idcard_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infogrid.lists.idcard_status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_idcard_status", form: "fs_personal_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_idcard_status", form: "fs_personal_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.idcard_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_idcard_status" class="el_s_personal_info_idcard_status">
<span<?= $Grid->idcard_status->viewAttributes() ?>>
<?= $Grid->idcard_status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_idcard_status" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_idcard_status" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_idcard_status" value="<?= HtmlEncode($Grid->idcard_status->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_idcard_status" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_idcard_status" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_idcard_status" value="<?= HtmlEncode($Grid->idcard_status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status"<?= $Grid->status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_status" class="el_s_personal_info_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infogrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fs_personal_infogrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infogrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fs_personal_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fs_personal_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_status" id="o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_status" class="el_s_personal_info_status">
    <select
        id="x<?= $Grid->RowIndex ?>_status"
        name="x<?= $Grid->RowIndex ?>_status"
        class="form-select ew-select<?= $Grid->status->isInvalidClass() ?>"
        <?php if (!$Grid->status->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infogrid_x<?= $Grid->RowIndex ?>_status"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_status"
        data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>"
        <?= $Grid->status->editAttributes() ?>>
        <?= $Grid->status->selectOptionListHtml("x{$Grid->RowIndex}_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<?php if (!$Grid->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_status", selectId: "fs_personal_infogrid_x<?= $Grid->RowIndex ?>_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infogrid.lists.status?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_status", form: "fs_personal_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_status", form: "fs_personal_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_status" class="el_s_personal_info_status">
<span<?= $Grid->status->viewAttributes() ?>>
<?= $Grid->status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_status" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_status" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_status" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_status" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->gender->Visible) { // gender ?>
        <td data-name="gender"<?= $Grid->gender->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_gender" class="el_s_personal_info_gender">
    <select
        id="x<?= $Grid->RowIndex ?>_gender"
        name="x<?= $Grid->RowIndex ?>_gender"
        class="form-select ew-select<?= $Grid->gender->isInvalidClass() ?>"
        <?php if (!$Grid->gender->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infogrid_x<?= $Grid->RowIndex ?>_gender"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_gender"
        data-value-separator="<?= $Grid->gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->gender->getPlaceHolder()) ?>"
        <?= $Grid->gender->editAttributes() ?>>
        <?= $Grid->gender->selectOptionListHtml("x{$Grid->RowIndex}_gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->gender->getErrorMessage() ?></div>
<?php if (!$Grid->gender->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_gender", selectId: "fs_personal_infogrid_x<?= $Grid->RowIndex ?>_gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infogrid.lists.gender?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_gender", form: "fs_personal_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_gender", form: "fs_personal_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_gender" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_gender" id="o<?= $Grid->RowIndex ?>_gender" value="<?= HtmlEncode($Grid->gender->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_gender" class="el_s_personal_info_gender">
    <select
        id="x<?= $Grid->RowIndex ?>_gender"
        name="x<?= $Grid->RowIndex ?>_gender"
        class="form-select ew-select<?= $Grid->gender->isInvalidClass() ?>"
        <?php if (!$Grid->gender->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infogrid_x<?= $Grid->RowIndex ?>_gender"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_gender"
        data-value-separator="<?= $Grid->gender->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->gender->getPlaceHolder()) ?>"
        <?= $Grid->gender->editAttributes() ?>>
        <?= $Grid->gender->selectOptionListHtml("x{$Grid->RowIndex}_gender") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->gender->getErrorMessage() ?></div>
<?php if (!$Grid->gender->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_gender", selectId: "fs_personal_infogrid_x<?= $Grid->RowIndex ?>_gender" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infogrid.lists.gender?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_gender", form: "fs_personal_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_gender", form: "fs_personal_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.gender.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_gender" class="el_s_personal_info_gender">
<span<?= $Grid->gender->viewAttributes() ?>>
<?= $Grid->gender->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_gender" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_gender" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_gender" value="<?= HtmlEncode($Grid->gender->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_gender" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_gender" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_gender" value="<?= HtmlEncode($Grid->gender->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->category->Visible) { // category ?>
        <td data-name="category"<?= $Grid->category->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_category" class="el_s_personal_info_category">
    <select
        id="x<?= $Grid->RowIndex ?>_category"
        name="x<?= $Grid->RowIndex ?>_category"
        class="form-select ew-select<?= $Grid->category->isInvalidClass() ?>"
        <?php if (!$Grid->category->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infogrid_x<?= $Grid->RowIndex ?>_category"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_category"
        data-value-separator="<?= $Grid->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->category->getPlaceHolder()) ?>"
        <?= $Grid->category->editAttributes() ?>>
        <?= $Grid->category->selectOptionListHtml("x{$Grid->RowIndex}_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->category->getErrorMessage() ?></div>
<?php if (!$Grid->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_category", selectId: "fs_personal_infogrid_x<?= $Grid->RowIndex ?>_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infogrid.lists.category?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_category", form: "fs_personal_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_category", form: "fs_personal_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_category" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_category" id="o<?= $Grid->RowIndex ?>_category" value="<?= HtmlEncode($Grid->category->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_category" class="el_s_personal_info_category">
    <select
        id="x<?= $Grid->RowIndex ?>_category"
        name="x<?= $Grid->RowIndex ?>_category"
        class="form-select ew-select<?= $Grid->category->isInvalidClass() ?>"
        <?php if (!$Grid->category->IsNativeSelect) { ?>
        data-select2-id="fs_personal_infogrid_x<?= $Grid->RowIndex ?>_category"
        <?php } ?>
        data-table="s_personal_info"
        data-field="x_category"
        data-value-separator="<?= $Grid->category->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->category->getPlaceHolder()) ?>"
        <?= $Grid->category->editAttributes() ?>>
        <?= $Grid->category->selectOptionListHtml("x{$Grid->RowIndex}_category") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->category->getErrorMessage() ?></div>
<?php if (!$Grid->category->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_category", selectId: "fs_personal_infogrid_x<?= $Grid->RowIndex ?>_category" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_personal_infogrid.lists.category?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_category", form: "fs_personal_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_category", form: "fs_personal_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_personal_info.fields.category.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_category" class="el_s_personal_info_category">
<span<?= $Grid->category->viewAttributes() ?>>
<?= $Grid->category->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_category" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_category" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_category" value="<?= HtmlEncode($Grid->category->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_category" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_category" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_category" value="<?= HtmlEncode($Grid->category->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->mobile_other->Visible) { // mobile_other ?>
        <td data-name="mobile_other"<?= $Grid->mobile_other->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_mobile_other" class="el_s_personal_info_mobile_other">
<?php
if (IsRTL()) {
    $Grid->mobile_other->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_mobile_other" class="ew-auto-suggest">
    <input type="<?= $Grid->mobile_other->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_mobile_other" id="sv_x<?= $Grid->RowIndex ?>_mobile_other" value="<?= RemoveHtml($Grid->mobile_other->EditValue) ?>" autocomplete="off" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->mobile_other->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->mobile_other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->mobile_other->formatPattern()) ?>"<?= $Grid->mobile_other->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_personal_info" data-field="x_mobile_other" data-input="sv_x<?= $Grid->RowIndex ?>_mobile_other" data-value-separator="<?= $Grid->mobile_other->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_mobile_other" id="x<?= $Grid->RowIndex ?>_mobile_other" value="<?= HtmlEncode($Grid->mobile_other->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->mobile_other->getErrorMessage() ?></div>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    fs_personal_infogrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_mobile_other","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->mobile_other->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_personal_info.fields.mobile_other.autoSuggestOptions));
});
</script>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_mobile_other" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_mobile_other" id="o<?= $Grid->RowIndex ?>_mobile_other" value="<?= HtmlEncode($Grid->mobile_other->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_mobile_other" class="el_s_personal_info_mobile_other">
<?php
if (IsRTL()) {
    $Grid->mobile_other->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_mobile_other" class="ew-auto-suggest">
    <input type="<?= $Grid->mobile_other->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_mobile_other" id="sv_x<?= $Grid->RowIndex ?>_mobile_other" value="<?= RemoveHtml($Grid->mobile_other->EditValue) ?>" autocomplete="off" size="30" maxlength="96" placeholder="<?= HtmlEncode($Grid->mobile_other->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->mobile_other->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->mobile_other->formatPattern()) ?>"<?= $Grid->mobile_other->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_personal_info" data-field="x_mobile_other" data-input="sv_x<?= $Grid->RowIndex ?>_mobile_other" data-value-separator="<?= $Grid->mobile_other->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_mobile_other" id="x<?= $Grid->RowIndex ?>_mobile_other" value="<?= HtmlEncode($Grid->mobile_other->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->mobile_other->getErrorMessage() ?></div>
<script>
loadjs.ready("fs_personal_infogrid", function() {
    fs_personal_infogrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_mobile_other","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->mobile_other->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_personal_info.fields.mobile_other.autoSuggestOptions));
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_mobile_other" class="el_s_personal_info_mobile_other">
<span<?= $Grid->mobile_other->viewAttributes() ?>>
<?= $Grid->mobile_other->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_mobile_other" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_mobile_other" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_mobile_other" value="<?= HtmlEncode($Grid->mobile_other->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_mobile_other" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_mobile_other" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_mobile_other" value="<?= HtmlEncode($Grid->mobile_other->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->doj->Visible) { // doj ?>
        <td data-name="doj"<?= $Grid->doj->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_doj" class="el_s_personal_info_doj">
<input type="<?= $Grid->doj->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_doj" id="x<?= $Grid->RowIndex ?>_doj" data-table="s_personal_info" data-field="x_doj" value="<?= $Grid->doj->EditValue ?>" placeholder="<?= HtmlEncode($Grid->doj->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->doj->formatPattern()) ?>"<?= $Grid->doj->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->doj->getErrorMessage() ?></div>
<?php if (!$Grid->doj->ReadOnly && !$Grid->doj->Disabled && !isset($Grid->doj->EditAttrs["readonly"]) && !isset($Grid->doj->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_personal_infogrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_personal_infogrid", "x<?= $Grid->RowIndex ?>_doj", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_doj" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_doj" id="o<?= $Grid->RowIndex ?>_doj" value="<?= HtmlEncode($Grid->doj->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_doj" class="el_s_personal_info_doj">
<input type="<?= $Grid->doj->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_doj" id="x<?= $Grid->RowIndex ?>_doj" data-table="s_personal_info" data-field="x_doj" value="<?= $Grid->doj->EditValue ?>" placeholder="<?= HtmlEncode($Grid->doj->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->doj->formatPattern()) ?>"<?= $Grid->doj->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->doj->getErrorMessage() ?></div>
<?php if (!$Grid->doj->ReadOnly && !$Grid->doj->Disabled && !isset($Grid->doj->EditAttrs["readonly"]) && !isset($Grid->doj->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_personal_infogrid", "datetimepicker"], function () {
    let format = "<?= DateFormat(14) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_personal_infogrid", "x<?= $Grid->RowIndex ?>_doj", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_doj" class="el_s_personal_info_doj">
<span<?= $Grid->doj->viewAttributes() ?>>
<?= $Grid->doj->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_doj" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_doj" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_doj" value="<?= HtmlEncode($Grid->doj->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_doj" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_doj" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_doj" value="<?= HtmlEncode($Grid->doj->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Grid->remarks->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_remarks" class="el_s_personal_info_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="s_personal_info" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_remarks" id="o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_remarks" class="el_s_personal_info_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="s_personal_info" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_remarks" class="el_s_personal_info_remarks">
<span<?= $Grid->remarks->viewAttributes() ?>>
<?= $Grid->remarks->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_remarks" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_remarks" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_remarks" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_remarks" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->sr_uid->Visible) { // sr_uid ?>
        <td data-name="sr_uid"<?= $Grid->sr_uid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_sr_uid" class="el_s_personal_info_sr_uid">
<input type="<?= $Grid->sr_uid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_sr_uid" id="x<?= $Grid->RowIndex ?>_sr_uid" data-table="s_personal_info" data-field="x_sr_uid" value="<?= $Grid->sr_uid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->sr_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->sr_uid->formatPattern()) ?>"<?= $Grid->sr_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->sr_uid->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_sr_uid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_sr_uid" id="o<?= $Grid->RowIndex ?>_sr_uid" value="<?= HtmlEncode($Grid->sr_uid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_sr_uid" class="el_s_personal_info_sr_uid">
<input type="<?= $Grid->sr_uid->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_sr_uid" id="x<?= $Grid->RowIndex ?>_sr_uid" data-table="s_personal_info" data-field="x_sr_uid" value="<?= $Grid->sr_uid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Grid->sr_uid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->sr_uid->formatPattern()) ?>"<?= $Grid->sr_uid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->sr_uid->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_sr_uid" class="el_s_personal_info_sr_uid">
<span<?= $Grid->sr_uid->viewAttributes() ?>>
<?= $Grid->sr_uid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_sr_uid" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_sr_uid" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_sr_uid" value="<?= HtmlEncode($Grid->sr_uid->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_sr_uid" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_sr_uid" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_sr_uid" value="<?= HtmlEncode($Grid->sr_uid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->updates->Visible) { // updates ?>
        <td data-name="updates"<?= $Grid->updates->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_updates" class="el_s_personal_info_updates">
<input type="<?= $Grid->updates->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_updates" id="x<?= $Grid->RowIndex ?>_updates" data-table="s_personal_info" data-field="x_updates" value="<?= $Grid->updates->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Grid->updates->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->updates->formatPattern()) ?>"<?= $Grid->updates->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->updates->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="s_personal_info" data-field="x_updates" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_updates" id="o<?= $Grid->RowIndex ?>_updates" value="<?= HtmlEncode($Grid->updates->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_updates" class="el_s_personal_info_updates">
<input type="<?= $Grid->updates->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_updates" id="x<?= $Grid->RowIndex ?>_updates" data-table="s_personal_info" data-field="x_updates" value="<?= $Grid->updates->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Grid->updates->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->updates->formatPattern()) ?>"<?= $Grid->updates->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->updates->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_personal_info_updates" class="el_s_personal_info_updates">
<span<?= $Grid->updates->viewAttributes() ?>>
<?= $Grid->updates->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_personal_info" data-field="x_updates" data-hidden="1" name="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_updates" id="fs_personal_infogrid$x<?= $Grid->RowIndex ?>_updates" value="<?= HtmlEncode($Grid->updates->FormValue) ?>">
<input type="hidden" data-table="s_personal_info" data-field="x_updates" data-hidden="1" data-old name="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_updates" id="fs_personal_infogrid$o<?= $Grid->RowIndex ?>_updates" value="<?= HtmlEncode($Grid->updates->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fs_personal_infogrid","load"], () => fs_personal_infogrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fs_personal_infogrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_personal_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
