<?php

namespace PHPMaker2024\fibre;

// Page object
$SOmrValueList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_omr_value: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fs_omr_valuesrch" id="fs_omr_valuesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fs_omr_valuesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_omr_value: currentTable } });
var currentForm;
var fs_omr_valuesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_omr_valuesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["roll_no", [], fields.roll_no.isInvalid],
            ["test_id", [], fields.test_id.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->roll_no->Visible) { // roll_no ?>
<?php
if (!$Page->roll_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_roll_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->roll_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_roll_no" class="ew-search-caption ew-label"><?= $Page->roll_no->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_roll_no" id="z_roll_no" value="LIKE">
</div>
        </div>
        <div id="el_s_omr_value_roll_no" class="ew-search-field">
<input type="<?= $Page->roll_no->getInputTextType() ?>" name="x_roll_no" id="x_roll_no" data-table="s_omr_value" data-field="x_roll_no" value="<?= $Page->roll_no->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->roll_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->roll_no->formatPattern()) ?>"<?= $Page->roll_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->roll_no->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->test_id->Visible) { // test_id ?>
<?php
if (!$Page->test_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_test_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->test_id->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_test_id" class="ew-search-caption ew-label"><?= $Page->test_id->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_test_id" id="z_test_id" value="LIKE">
</div>
        </div>
        <div id="el_s_omr_value_test_id" class="ew-search-field">
<input type="<?= $Page->test_id->getInputTextType() ?>" name="x_test_id" id="x_test_id" data-table="s_omr_value" data-field="x_test_id" value="<?= $Page->test_id->EditValue ?>" size="30" maxlength="4" placeholder="<?= HtmlEncode($Page->test_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->test_id->formatPattern()) ?>"<?= $Page->test_id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->test_id->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fs_omr_valuesrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fs_omr_valuesrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fs_omr_valuesrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fs_omr_valuesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fs_omr_valuesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fs_omr_valuesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fs_omr_valuesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_omr_value">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_s_omr_value" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_s_omr_valuelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_s_omr_value_id" class="s_omr_value_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->roll_no->Visible) { // roll_no ?>
        <th data-name="roll_no" class="<?= $Page->roll_no->headerCellClass() ?>"><div id="elh_s_omr_value_roll_no" class="s_omr_value_roll_no"><?= $Page->renderFieldHeader($Page->roll_no) ?></div></th>
<?php } ?>
<?php if ($Page->test_id->Visible) { // test_id ?>
        <th data-name="test_id" class="<?= $Page->test_id->headerCellClass() ?>"><div id="elh_s_omr_value_test_id" class="s_omr_value_test_id"><?= $Page->renderFieldHeader($Page->test_id) ?></div></th>
<?php } ?>
<?php if ($Page->total->Visible) { // total ?>
        <th data-name="total" class="<?= $Page->total->headerCellClass() ?>"><div id="elh_s_omr_value_total" class="s_omr_value_total"><?= $Page->renderFieldHeader($Page->total) ?></div></th>
<?php } ?>
<?php if ($Page->percent->Visible) { // percent ?>
        <th data-name="percent" class="<?= $Page->percent->headerCellClass() ?>"><div id="elh_s_omr_value_percent" class="s_omr_value_percent"><?= $Page->renderFieldHeader($Page->percent) ?></div></th>
<?php } ?>
<?php if ($Page->s_1->Visible) { // s_1 ?>
        <th data-name="s_1" class="<?= $Page->s_1->headerCellClass() ?>"><div id="elh_s_omr_value_s_1" class="s_omr_value_s_1"><?= $Page->renderFieldHeader($Page->s_1) ?></div></th>
<?php } ?>
<?php if ($Page->s_2->Visible) { // s_2 ?>
        <th data-name="s_2" class="<?= $Page->s_2->headerCellClass() ?>"><div id="elh_s_omr_value_s_2" class="s_omr_value_s_2"><?= $Page->renderFieldHeader($Page->s_2) ?></div></th>
<?php } ?>
<?php if ($Page->s_3->Visible) { // s_3 ?>
        <th data-name="s_3" class="<?= $Page->s_3->headerCellClass() ?>"><div id="elh_s_omr_value_s_3" class="s_omr_value_s_3"><?= $Page->renderFieldHeader($Page->s_3) ?></div></th>
<?php } ?>
<?php if ($Page->s_4->Visible) { // s_4 ?>
        <th data-name="s_4" class="<?= $Page->s_4->headerCellClass() ?>"><div id="elh_s_omr_value_s_4" class="s_omr_value_s_4"><?= $Page->renderFieldHeader($Page->s_4) ?></div></th>
<?php } ?>
<?php if ($Page->s_5->Visible) { // s_5 ?>
        <th data-name="s_5" class="<?= $Page->s_5->headerCellClass() ?>"><div id="elh_s_omr_value_s_5" class="s_omr_value_s_5"><?= $Page->renderFieldHeader($Page->s_5) ?></div></th>
<?php } ?>
<?php if ($Page->omr_image->Visible) { // omr_image ?>
        <th data-name="omr_image" class="<?= $Page->omr_image->headerCellClass() ?>"><div id="elh_s_omr_value_omr_image" class="s_omr_value_omr_image"><?= $Page->renderFieldHeader($Page->omr_image) ?></div></th>
<?php } ?>
<?php if ($Page->_1->Visible) { // 1 ?>
        <th data-name="_1" class="<?= $Page->_1->headerCellClass() ?>"><div id="elh_s_omr_value__1" class="s_omr_value__1"><?= $Page->renderFieldHeader($Page->_1) ?></div></th>
<?php } ?>
<?php if ($Page->m_1->Visible) { // m_1 ?>
        <th data-name="m_1" class="<?= $Page->m_1->headerCellClass() ?>"><div id="elh_s_omr_value_m_1" class="s_omr_value_m_1"><?= $Page->renderFieldHeader($Page->m_1) ?></div></th>
<?php } ?>
<?php if ($Page->_2->Visible) { // 2 ?>
        <th data-name="_2" class="<?= $Page->_2->headerCellClass() ?>"><div id="elh_s_omr_value__2" class="s_omr_value__2"><?= $Page->renderFieldHeader($Page->_2) ?></div></th>
<?php } ?>
<?php if ($Page->m_2->Visible) { // m_2 ?>
        <th data-name="m_2" class="<?= $Page->m_2->headerCellClass() ?>"><div id="elh_s_omr_value_m_2" class="s_omr_value_m_2"><?= $Page->renderFieldHeader($Page->m_2) ?></div></th>
<?php } ?>
<?php if ($Page->_3->Visible) { // 3 ?>
        <th data-name="_3" class="<?= $Page->_3->headerCellClass() ?>"><div id="elh_s_omr_value__3" class="s_omr_value__3"><?= $Page->renderFieldHeader($Page->_3) ?></div></th>
<?php } ?>
<?php if ($Page->m_3->Visible) { // m_3 ?>
        <th data-name="m_3" class="<?= $Page->m_3->headerCellClass() ?>"><div id="elh_s_omr_value_m_3" class="s_omr_value_m_3"><?= $Page->renderFieldHeader($Page->m_3) ?></div></th>
<?php } ?>
<?php if ($Page->_4->Visible) { // 4 ?>
        <th data-name="_4" class="<?= $Page->_4->headerCellClass() ?>"><div id="elh_s_omr_value__4" class="s_omr_value__4"><?= $Page->renderFieldHeader($Page->_4) ?></div></th>
<?php } ?>
<?php if ($Page->m_4->Visible) { // m_4 ?>
        <th data-name="m_4" class="<?= $Page->m_4->headerCellClass() ?>"><div id="elh_s_omr_value_m_4" class="s_omr_value_m_4"><?= $Page->renderFieldHeader($Page->m_4) ?></div></th>
<?php } ?>
<?php if ($Page->_5->Visible) { // 5 ?>
        <th data-name="_5" class="<?= $Page->_5->headerCellClass() ?>"><div id="elh_s_omr_value__5" class="s_omr_value__5"><?= $Page->renderFieldHeader($Page->_5) ?></div></th>
<?php } ?>
<?php if ($Page->m_5->Visible) { // m_5 ?>
        <th data-name="m_5" class="<?= $Page->m_5->headerCellClass() ?>"><div id="elh_s_omr_value_m_5" class="s_omr_value_m_5"><?= $Page->renderFieldHeader($Page->m_5) ?></div></th>
<?php } ?>
<?php if ($Page->_6->Visible) { // 6 ?>
        <th data-name="_6" class="<?= $Page->_6->headerCellClass() ?>"><div id="elh_s_omr_value__6" class="s_omr_value__6"><?= $Page->renderFieldHeader($Page->_6) ?></div></th>
<?php } ?>
<?php if ($Page->m_6->Visible) { // m_6 ?>
        <th data-name="m_6" class="<?= $Page->m_6->headerCellClass() ?>"><div id="elh_s_omr_value_m_6" class="s_omr_value_m_6"><?= $Page->renderFieldHeader($Page->m_6) ?></div></th>
<?php } ?>
<?php if ($Page->_7->Visible) { // 7 ?>
        <th data-name="_7" class="<?= $Page->_7->headerCellClass() ?>"><div id="elh_s_omr_value__7" class="s_omr_value__7"><?= $Page->renderFieldHeader($Page->_7) ?></div></th>
<?php } ?>
<?php if ($Page->m_7->Visible) { // m_7 ?>
        <th data-name="m_7" class="<?= $Page->m_7->headerCellClass() ?>"><div id="elh_s_omr_value_m_7" class="s_omr_value_m_7"><?= $Page->renderFieldHeader($Page->m_7) ?></div></th>
<?php } ?>
<?php if ($Page->_8->Visible) { // 8 ?>
        <th data-name="_8" class="<?= $Page->_8->headerCellClass() ?>"><div id="elh_s_omr_value__8" class="s_omr_value__8"><?= $Page->renderFieldHeader($Page->_8) ?></div></th>
<?php } ?>
<?php if ($Page->m_8->Visible) { // m_8 ?>
        <th data-name="m_8" class="<?= $Page->m_8->headerCellClass() ?>"><div id="elh_s_omr_value_m_8" class="s_omr_value_m_8"><?= $Page->renderFieldHeader($Page->m_8) ?></div></th>
<?php } ?>
<?php if ($Page->_9->Visible) { // 9 ?>
        <th data-name="_9" class="<?= $Page->_9->headerCellClass() ?>"><div id="elh_s_omr_value__9" class="s_omr_value__9"><?= $Page->renderFieldHeader($Page->_9) ?></div></th>
<?php } ?>
<?php if ($Page->m_9->Visible) { // m_9 ?>
        <th data-name="m_9" class="<?= $Page->m_9->headerCellClass() ?>"><div id="elh_s_omr_value_m_9" class="s_omr_value_m_9"><?= $Page->renderFieldHeader($Page->m_9) ?></div></th>
<?php } ?>
<?php if ($Page->_10->Visible) { // 10 ?>
        <th data-name="_10" class="<?= $Page->_10->headerCellClass() ?>"><div id="elh_s_omr_value__10" class="s_omr_value__10"><?= $Page->renderFieldHeader($Page->_10) ?></div></th>
<?php } ?>
<?php if ($Page->m_10->Visible) { // m_10 ?>
        <th data-name="m_10" class="<?= $Page->m_10->headerCellClass() ?>"><div id="elh_s_omr_value_m_10" class="s_omr_value_m_10"><?= $Page->renderFieldHeader($Page->m_10) ?></div></th>
<?php } ?>
<?php if ($Page->_11->Visible) { // 11 ?>
        <th data-name="_11" class="<?= $Page->_11->headerCellClass() ?>"><div id="elh_s_omr_value__11" class="s_omr_value__11"><?= $Page->renderFieldHeader($Page->_11) ?></div></th>
<?php } ?>
<?php if ($Page->m_11->Visible) { // m_11 ?>
        <th data-name="m_11" class="<?= $Page->m_11->headerCellClass() ?>"><div id="elh_s_omr_value_m_11" class="s_omr_value_m_11"><?= $Page->renderFieldHeader($Page->m_11) ?></div></th>
<?php } ?>
<?php if ($Page->_12->Visible) { // 12 ?>
        <th data-name="_12" class="<?= $Page->_12->headerCellClass() ?>"><div id="elh_s_omr_value__12" class="s_omr_value__12"><?= $Page->renderFieldHeader($Page->_12) ?></div></th>
<?php } ?>
<?php if ($Page->m_12->Visible) { // m_12 ?>
        <th data-name="m_12" class="<?= $Page->m_12->headerCellClass() ?>"><div id="elh_s_omr_value_m_12" class="s_omr_value_m_12"><?= $Page->renderFieldHeader($Page->m_12) ?></div></th>
<?php } ?>
<?php if ($Page->_13->Visible) { // 13 ?>
        <th data-name="_13" class="<?= $Page->_13->headerCellClass() ?>"><div id="elh_s_omr_value__13" class="s_omr_value__13"><?= $Page->renderFieldHeader($Page->_13) ?></div></th>
<?php } ?>
<?php if ($Page->m_13->Visible) { // m_13 ?>
        <th data-name="m_13" class="<?= $Page->m_13->headerCellClass() ?>"><div id="elh_s_omr_value_m_13" class="s_omr_value_m_13"><?= $Page->renderFieldHeader($Page->m_13) ?></div></th>
<?php } ?>
<?php if ($Page->_14->Visible) { // 14 ?>
        <th data-name="_14" class="<?= $Page->_14->headerCellClass() ?>"><div id="elh_s_omr_value__14" class="s_omr_value__14"><?= $Page->renderFieldHeader($Page->_14) ?></div></th>
<?php } ?>
<?php if ($Page->m_14->Visible) { // m_14 ?>
        <th data-name="m_14" class="<?= $Page->m_14->headerCellClass() ?>"><div id="elh_s_omr_value_m_14" class="s_omr_value_m_14"><?= $Page->renderFieldHeader($Page->m_14) ?></div></th>
<?php } ?>
<?php if ($Page->_15->Visible) { // 15 ?>
        <th data-name="_15" class="<?= $Page->_15->headerCellClass() ?>"><div id="elh_s_omr_value__15" class="s_omr_value__15"><?= $Page->renderFieldHeader($Page->_15) ?></div></th>
<?php } ?>
<?php if ($Page->m_15->Visible) { // m_15 ?>
        <th data-name="m_15" class="<?= $Page->m_15->headerCellClass() ?>"><div id="elh_s_omr_value_m_15" class="s_omr_value_m_15"><?= $Page->renderFieldHeader($Page->m_15) ?></div></th>
<?php } ?>
<?php if ($Page->_16->Visible) { // 16 ?>
        <th data-name="_16" class="<?= $Page->_16->headerCellClass() ?>"><div id="elh_s_omr_value__16" class="s_omr_value__16"><?= $Page->renderFieldHeader($Page->_16) ?></div></th>
<?php } ?>
<?php if ($Page->m_16->Visible) { // m_16 ?>
        <th data-name="m_16" class="<?= $Page->m_16->headerCellClass() ?>"><div id="elh_s_omr_value_m_16" class="s_omr_value_m_16"><?= $Page->renderFieldHeader($Page->m_16) ?></div></th>
<?php } ?>
<?php if ($Page->_17->Visible) { // 17 ?>
        <th data-name="_17" class="<?= $Page->_17->headerCellClass() ?>"><div id="elh_s_omr_value__17" class="s_omr_value__17"><?= $Page->renderFieldHeader($Page->_17) ?></div></th>
<?php } ?>
<?php if ($Page->m_17->Visible) { // m_17 ?>
        <th data-name="m_17" class="<?= $Page->m_17->headerCellClass() ?>"><div id="elh_s_omr_value_m_17" class="s_omr_value_m_17"><?= $Page->renderFieldHeader($Page->m_17) ?></div></th>
<?php } ?>
<?php if ($Page->_18->Visible) { // 18 ?>
        <th data-name="_18" class="<?= $Page->_18->headerCellClass() ?>"><div id="elh_s_omr_value__18" class="s_omr_value__18"><?= $Page->renderFieldHeader($Page->_18) ?></div></th>
<?php } ?>
<?php if ($Page->m_18->Visible) { // m_18 ?>
        <th data-name="m_18" class="<?= $Page->m_18->headerCellClass() ?>"><div id="elh_s_omr_value_m_18" class="s_omr_value_m_18"><?= $Page->renderFieldHeader($Page->m_18) ?></div></th>
<?php } ?>
<?php if ($Page->_19->Visible) { // 19 ?>
        <th data-name="_19" class="<?= $Page->_19->headerCellClass() ?>"><div id="elh_s_omr_value__19" class="s_omr_value__19"><?= $Page->renderFieldHeader($Page->_19) ?></div></th>
<?php } ?>
<?php if ($Page->m_19->Visible) { // m_19 ?>
        <th data-name="m_19" class="<?= $Page->m_19->headerCellClass() ?>"><div id="elh_s_omr_value_m_19" class="s_omr_value_m_19"><?= $Page->renderFieldHeader($Page->m_19) ?></div></th>
<?php } ?>
<?php if ($Page->_20->Visible) { // 20 ?>
        <th data-name="_20" class="<?= $Page->_20->headerCellClass() ?>"><div id="elh_s_omr_value__20" class="s_omr_value__20"><?= $Page->renderFieldHeader($Page->_20) ?></div></th>
<?php } ?>
<?php if ($Page->m_20->Visible) { // m_20 ?>
        <th data-name="m_20" class="<?= $Page->m_20->headerCellClass() ?>"><div id="elh_s_omr_value_m_20" class="s_omr_value_m_20"><?= $Page->renderFieldHeader($Page->m_20) ?></div></th>
<?php } ?>
<?php if ($Page->_21->Visible) { // 21 ?>
        <th data-name="_21" class="<?= $Page->_21->headerCellClass() ?>"><div id="elh_s_omr_value__21" class="s_omr_value__21"><?= $Page->renderFieldHeader($Page->_21) ?></div></th>
<?php } ?>
<?php if ($Page->m_21->Visible) { // m_21 ?>
        <th data-name="m_21" class="<?= $Page->m_21->headerCellClass() ?>"><div id="elh_s_omr_value_m_21" class="s_omr_value_m_21"><?= $Page->renderFieldHeader($Page->m_21) ?></div></th>
<?php } ?>
<?php if ($Page->_22->Visible) { // 22 ?>
        <th data-name="_22" class="<?= $Page->_22->headerCellClass() ?>"><div id="elh_s_omr_value__22" class="s_omr_value__22"><?= $Page->renderFieldHeader($Page->_22) ?></div></th>
<?php } ?>
<?php if ($Page->m_22->Visible) { // m_22 ?>
        <th data-name="m_22" class="<?= $Page->m_22->headerCellClass() ?>"><div id="elh_s_omr_value_m_22" class="s_omr_value_m_22"><?= $Page->renderFieldHeader($Page->m_22) ?></div></th>
<?php } ?>
<?php if ($Page->_23->Visible) { // 23 ?>
        <th data-name="_23" class="<?= $Page->_23->headerCellClass() ?>"><div id="elh_s_omr_value__23" class="s_omr_value__23"><?= $Page->renderFieldHeader($Page->_23) ?></div></th>
<?php } ?>
<?php if ($Page->m_23->Visible) { // m_23 ?>
        <th data-name="m_23" class="<?= $Page->m_23->headerCellClass() ?>"><div id="elh_s_omr_value_m_23" class="s_omr_value_m_23"><?= $Page->renderFieldHeader($Page->m_23) ?></div></th>
<?php } ?>
<?php if ($Page->_24->Visible) { // 24 ?>
        <th data-name="_24" class="<?= $Page->_24->headerCellClass() ?>"><div id="elh_s_omr_value__24" class="s_omr_value__24"><?= $Page->renderFieldHeader($Page->_24) ?></div></th>
<?php } ?>
<?php if ($Page->m_24->Visible) { // m_24 ?>
        <th data-name="m_24" class="<?= $Page->m_24->headerCellClass() ?>"><div id="elh_s_omr_value_m_24" class="s_omr_value_m_24"><?= $Page->renderFieldHeader($Page->m_24) ?></div></th>
<?php } ?>
<?php if ($Page->_25->Visible) { // 25 ?>
        <th data-name="_25" class="<?= $Page->_25->headerCellClass() ?>"><div id="elh_s_omr_value__25" class="s_omr_value__25"><?= $Page->renderFieldHeader($Page->_25) ?></div></th>
<?php } ?>
<?php if ($Page->m_25->Visible) { // m_25 ?>
        <th data-name="m_25" class="<?= $Page->m_25->headerCellClass() ?>"><div id="elh_s_omr_value_m_25" class="s_omr_value_m_25"><?= $Page->renderFieldHeader($Page->m_25) ?></div></th>
<?php } ?>
<?php if ($Page->_26->Visible) { // 26 ?>
        <th data-name="_26" class="<?= $Page->_26->headerCellClass() ?>"><div id="elh_s_omr_value__26" class="s_omr_value__26"><?= $Page->renderFieldHeader($Page->_26) ?></div></th>
<?php } ?>
<?php if ($Page->m_26->Visible) { // m_26 ?>
        <th data-name="m_26" class="<?= $Page->m_26->headerCellClass() ?>"><div id="elh_s_omr_value_m_26" class="s_omr_value_m_26"><?= $Page->renderFieldHeader($Page->m_26) ?></div></th>
<?php } ?>
<?php if ($Page->_27->Visible) { // 27 ?>
        <th data-name="_27" class="<?= $Page->_27->headerCellClass() ?>"><div id="elh_s_omr_value__27" class="s_omr_value__27"><?= $Page->renderFieldHeader($Page->_27) ?></div></th>
<?php } ?>
<?php if ($Page->m_27->Visible) { // m_27 ?>
        <th data-name="m_27" class="<?= $Page->m_27->headerCellClass() ?>"><div id="elh_s_omr_value_m_27" class="s_omr_value_m_27"><?= $Page->renderFieldHeader($Page->m_27) ?></div></th>
<?php } ?>
<?php if ($Page->_28->Visible) { // 28 ?>
        <th data-name="_28" class="<?= $Page->_28->headerCellClass() ?>"><div id="elh_s_omr_value__28" class="s_omr_value__28"><?= $Page->renderFieldHeader($Page->_28) ?></div></th>
<?php } ?>
<?php if ($Page->m_28->Visible) { // m_28 ?>
        <th data-name="m_28" class="<?= $Page->m_28->headerCellClass() ?>"><div id="elh_s_omr_value_m_28" class="s_omr_value_m_28"><?= $Page->renderFieldHeader($Page->m_28) ?></div></th>
<?php } ?>
<?php if ($Page->_29->Visible) { // 29 ?>
        <th data-name="_29" class="<?= $Page->_29->headerCellClass() ?>"><div id="elh_s_omr_value__29" class="s_omr_value__29"><?= $Page->renderFieldHeader($Page->_29) ?></div></th>
<?php } ?>
<?php if ($Page->m_29->Visible) { // m_29 ?>
        <th data-name="m_29" class="<?= $Page->m_29->headerCellClass() ?>"><div id="elh_s_omr_value_m_29" class="s_omr_value_m_29"><?= $Page->renderFieldHeader($Page->m_29) ?></div></th>
<?php } ?>
<?php if ($Page->_30->Visible) { // 30 ?>
        <th data-name="_30" class="<?= $Page->_30->headerCellClass() ?>"><div id="elh_s_omr_value__30" class="s_omr_value__30"><?= $Page->renderFieldHeader($Page->_30) ?></div></th>
<?php } ?>
<?php if ($Page->m_30->Visible) { // m_30 ?>
        <th data-name="m_30" class="<?= $Page->m_30->headerCellClass() ?>"><div id="elh_s_omr_value_m_30" class="s_omr_value_m_30"><?= $Page->renderFieldHeader($Page->m_30) ?></div></th>
<?php } ?>
<?php if ($Page->_31->Visible) { // 31 ?>
        <th data-name="_31" class="<?= $Page->_31->headerCellClass() ?>"><div id="elh_s_omr_value__31" class="s_omr_value__31"><?= $Page->renderFieldHeader($Page->_31) ?></div></th>
<?php } ?>
<?php if ($Page->m_31->Visible) { // m_31 ?>
        <th data-name="m_31" class="<?= $Page->m_31->headerCellClass() ?>"><div id="elh_s_omr_value_m_31" class="s_omr_value_m_31"><?= $Page->renderFieldHeader($Page->m_31) ?></div></th>
<?php } ?>
<?php if ($Page->_32->Visible) { // 32 ?>
        <th data-name="_32" class="<?= $Page->_32->headerCellClass() ?>"><div id="elh_s_omr_value__32" class="s_omr_value__32"><?= $Page->renderFieldHeader($Page->_32) ?></div></th>
<?php } ?>
<?php if ($Page->m_32->Visible) { // m_32 ?>
        <th data-name="m_32" class="<?= $Page->m_32->headerCellClass() ?>"><div id="elh_s_omr_value_m_32" class="s_omr_value_m_32"><?= $Page->renderFieldHeader($Page->m_32) ?></div></th>
<?php } ?>
<?php if ($Page->_33->Visible) { // 33 ?>
        <th data-name="_33" class="<?= $Page->_33->headerCellClass() ?>"><div id="elh_s_omr_value__33" class="s_omr_value__33"><?= $Page->renderFieldHeader($Page->_33) ?></div></th>
<?php } ?>
<?php if ($Page->m_33->Visible) { // m_33 ?>
        <th data-name="m_33" class="<?= $Page->m_33->headerCellClass() ?>"><div id="elh_s_omr_value_m_33" class="s_omr_value_m_33"><?= $Page->renderFieldHeader($Page->m_33) ?></div></th>
<?php } ?>
<?php if ($Page->_34->Visible) { // 34 ?>
        <th data-name="_34" class="<?= $Page->_34->headerCellClass() ?>"><div id="elh_s_omr_value__34" class="s_omr_value__34"><?= $Page->renderFieldHeader($Page->_34) ?></div></th>
<?php } ?>
<?php if ($Page->m_34->Visible) { // m_34 ?>
        <th data-name="m_34" class="<?= $Page->m_34->headerCellClass() ?>"><div id="elh_s_omr_value_m_34" class="s_omr_value_m_34"><?= $Page->renderFieldHeader($Page->m_34) ?></div></th>
<?php } ?>
<?php if ($Page->_35->Visible) { // 35 ?>
        <th data-name="_35" class="<?= $Page->_35->headerCellClass() ?>"><div id="elh_s_omr_value__35" class="s_omr_value__35"><?= $Page->renderFieldHeader($Page->_35) ?></div></th>
<?php } ?>
<?php if ($Page->m_35->Visible) { // m_35 ?>
        <th data-name="m_35" class="<?= $Page->m_35->headerCellClass() ?>"><div id="elh_s_omr_value_m_35" class="s_omr_value_m_35"><?= $Page->renderFieldHeader($Page->m_35) ?></div></th>
<?php } ?>
<?php if ($Page->_36->Visible) { // 36 ?>
        <th data-name="_36" class="<?= $Page->_36->headerCellClass() ?>"><div id="elh_s_omr_value__36" class="s_omr_value__36"><?= $Page->renderFieldHeader($Page->_36) ?></div></th>
<?php } ?>
<?php if ($Page->m_36->Visible) { // m_36 ?>
        <th data-name="m_36" class="<?= $Page->m_36->headerCellClass() ?>"><div id="elh_s_omr_value_m_36" class="s_omr_value_m_36"><?= $Page->renderFieldHeader($Page->m_36) ?></div></th>
<?php } ?>
<?php if ($Page->_37->Visible) { // 37 ?>
        <th data-name="_37" class="<?= $Page->_37->headerCellClass() ?>"><div id="elh_s_omr_value__37" class="s_omr_value__37"><?= $Page->renderFieldHeader($Page->_37) ?></div></th>
<?php } ?>
<?php if ($Page->m_37->Visible) { // m_37 ?>
        <th data-name="m_37" class="<?= $Page->m_37->headerCellClass() ?>"><div id="elh_s_omr_value_m_37" class="s_omr_value_m_37"><?= $Page->renderFieldHeader($Page->m_37) ?></div></th>
<?php } ?>
<?php if ($Page->_38->Visible) { // 38 ?>
        <th data-name="_38" class="<?= $Page->_38->headerCellClass() ?>"><div id="elh_s_omr_value__38" class="s_omr_value__38"><?= $Page->renderFieldHeader($Page->_38) ?></div></th>
<?php } ?>
<?php if ($Page->m_38->Visible) { // m_38 ?>
        <th data-name="m_38" class="<?= $Page->m_38->headerCellClass() ?>"><div id="elh_s_omr_value_m_38" class="s_omr_value_m_38"><?= $Page->renderFieldHeader($Page->m_38) ?></div></th>
<?php } ?>
<?php if ($Page->_39->Visible) { // 39 ?>
        <th data-name="_39" class="<?= $Page->_39->headerCellClass() ?>"><div id="elh_s_omr_value__39" class="s_omr_value__39"><?= $Page->renderFieldHeader($Page->_39) ?></div></th>
<?php } ?>
<?php if ($Page->m_39->Visible) { // m_39 ?>
        <th data-name="m_39" class="<?= $Page->m_39->headerCellClass() ?>"><div id="elh_s_omr_value_m_39" class="s_omr_value_m_39"><?= $Page->renderFieldHeader($Page->m_39) ?></div></th>
<?php } ?>
<?php if ($Page->_40->Visible) { // 40 ?>
        <th data-name="_40" class="<?= $Page->_40->headerCellClass() ?>"><div id="elh_s_omr_value__40" class="s_omr_value__40"><?= $Page->renderFieldHeader($Page->_40) ?></div></th>
<?php } ?>
<?php if ($Page->m_40->Visible) { // m_40 ?>
        <th data-name="m_40" class="<?= $Page->m_40->headerCellClass() ?>"><div id="elh_s_omr_value_m_40" class="s_omr_value_m_40"><?= $Page->renderFieldHeader($Page->m_40) ?></div></th>
<?php } ?>
<?php if ($Page->_41->Visible) { // 41 ?>
        <th data-name="_41" class="<?= $Page->_41->headerCellClass() ?>"><div id="elh_s_omr_value__41" class="s_omr_value__41"><?= $Page->renderFieldHeader($Page->_41) ?></div></th>
<?php } ?>
<?php if ($Page->m_41->Visible) { // m_41 ?>
        <th data-name="m_41" class="<?= $Page->m_41->headerCellClass() ?>"><div id="elh_s_omr_value_m_41" class="s_omr_value_m_41"><?= $Page->renderFieldHeader($Page->m_41) ?></div></th>
<?php } ?>
<?php if ($Page->_42->Visible) { // 42 ?>
        <th data-name="_42" class="<?= $Page->_42->headerCellClass() ?>"><div id="elh_s_omr_value__42" class="s_omr_value__42"><?= $Page->renderFieldHeader($Page->_42) ?></div></th>
<?php } ?>
<?php if ($Page->m_42->Visible) { // m_42 ?>
        <th data-name="m_42" class="<?= $Page->m_42->headerCellClass() ?>"><div id="elh_s_omr_value_m_42" class="s_omr_value_m_42"><?= $Page->renderFieldHeader($Page->m_42) ?></div></th>
<?php } ?>
<?php if ($Page->_43->Visible) { // 43 ?>
        <th data-name="_43" class="<?= $Page->_43->headerCellClass() ?>"><div id="elh_s_omr_value__43" class="s_omr_value__43"><?= $Page->renderFieldHeader($Page->_43) ?></div></th>
<?php } ?>
<?php if ($Page->m_43->Visible) { // m_43 ?>
        <th data-name="m_43" class="<?= $Page->m_43->headerCellClass() ?>"><div id="elh_s_omr_value_m_43" class="s_omr_value_m_43"><?= $Page->renderFieldHeader($Page->m_43) ?></div></th>
<?php } ?>
<?php if ($Page->_44->Visible) { // 44 ?>
        <th data-name="_44" class="<?= $Page->_44->headerCellClass() ?>"><div id="elh_s_omr_value__44" class="s_omr_value__44"><?= $Page->renderFieldHeader($Page->_44) ?></div></th>
<?php } ?>
<?php if ($Page->m_44->Visible) { // m_44 ?>
        <th data-name="m_44" class="<?= $Page->m_44->headerCellClass() ?>"><div id="elh_s_omr_value_m_44" class="s_omr_value_m_44"><?= $Page->renderFieldHeader($Page->m_44) ?></div></th>
<?php } ?>
<?php if ($Page->_45->Visible) { // 45 ?>
        <th data-name="_45" class="<?= $Page->_45->headerCellClass() ?>"><div id="elh_s_omr_value__45" class="s_omr_value__45"><?= $Page->renderFieldHeader($Page->_45) ?></div></th>
<?php } ?>
<?php if ($Page->m_45->Visible) { // m_45 ?>
        <th data-name="m_45" class="<?= $Page->m_45->headerCellClass() ?>"><div id="elh_s_omr_value_m_45" class="s_omr_value_m_45"><?= $Page->renderFieldHeader($Page->m_45) ?></div></th>
<?php } ?>
<?php if ($Page->_46->Visible) { // 46 ?>
        <th data-name="_46" class="<?= $Page->_46->headerCellClass() ?>"><div id="elh_s_omr_value__46" class="s_omr_value__46"><?= $Page->renderFieldHeader($Page->_46) ?></div></th>
<?php } ?>
<?php if ($Page->m_46->Visible) { // m_46 ?>
        <th data-name="m_46" class="<?= $Page->m_46->headerCellClass() ?>"><div id="elh_s_omr_value_m_46" class="s_omr_value_m_46"><?= $Page->renderFieldHeader($Page->m_46) ?></div></th>
<?php } ?>
<?php if ($Page->_47->Visible) { // 47 ?>
        <th data-name="_47" class="<?= $Page->_47->headerCellClass() ?>"><div id="elh_s_omr_value__47" class="s_omr_value__47"><?= $Page->renderFieldHeader($Page->_47) ?></div></th>
<?php } ?>
<?php if ($Page->m_47->Visible) { // m_47 ?>
        <th data-name="m_47" class="<?= $Page->m_47->headerCellClass() ?>"><div id="elh_s_omr_value_m_47" class="s_omr_value_m_47"><?= $Page->renderFieldHeader($Page->m_47) ?></div></th>
<?php } ?>
<?php if ($Page->_48->Visible) { // 48 ?>
        <th data-name="_48" class="<?= $Page->_48->headerCellClass() ?>"><div id="elh_s_omr_value__48" class="s_omr_value__48"><?= $Page->renderFieldHeader($Page->_48) ?></div></th>
<?php } ?>
<?php if ($Page->m_48->Visible) { // m_48 ?>
        <th data-name="m_48" class="<?= $Page->m_48->headerCellClass() ?>"><div id="elh_s_omr_value_m_48" class="s_omr_value_m_48"><?= $Page->renderFieldHeader($Page->m_48) ?></div></th>
<?php } ?>
<?php if ($Page->_49->Visible) { // 49 ?>
        <th data-name="_49" class="<?= $Page->_49->headerCellClass() ?>"><div id="elh_s_omr_value__49" class="s_omr_value__49"><?= $Page->renderFieldHeader($Page->_49) ?></div></th>
<?php } ?>
<?php if ($Page->m_49->Visible) { // m_49 ?>
        <th data-name="m_49" class="<?= $Page->m_49->headerCellClass() ?>"><div id="elh_s_omr_value_m_49" class="s_omr_value_m_49"><?= $Page->renderFieldHeader($Page->m_49) ?></div></th>
<?php } ?>
<?php if ($Page->_50->Visible) { // 50 ?>
        <th data-name="_50" class="<?= $Page->_50->headerCellClass() ?>"><div id="elh_s_omr_value__50" class="s_omr_value__50"><?= $Page->renderFieldHeader($Page->_50) ?></div></th>
<?php } ?>
<?php if ($Page->m_50->Visible) { // m_50 ?>
        <th data-name="m_50" class="<?= $Page->m_50->headerCellClass() ?>"><div id="elh_s_omr_value_m_50" class="s_omr_value_m_50"><?= $Page->renderFieldHeader($Page->m_50) ?></div></th>
<?php } ?>
<?php if ($Page->_51->Visible) { // 51 ?>
        <th data-name="_51" class="<?= $Page->_51->headerCellClass() ?>"><div id="elh_s_omr_value__51" class="s_omr_value__51"><?= $Page->renderFieldHeader($Page->_51) ?></div></th>
<?php } ?>
<?php if ($Page->m_51->Visible) { // m_51 ?>
        <th data-name="m_51" class="<?= $Page->m_51->headerCellClass() ?>"><div id="elh_s_omr_value_m_51" class="s_omr_value_m_51"><?= $Page->renderFieldHeader($Page->m_51) ?></div></th>
<?php } ?>
<?php if ($Page->_52->Visible) { // 52 ?>
        <th data-name="_52" class="<?= $Page->_52->headerCellClass() ?>"><div id="elh_s_omr_value__52" class="s_omr_value__52"><?= $Page->renderFieldHeader($Page->_52) ?></div></th>
<?php } ?>
<?php if ($Page->m_52->Visible) { // m_52 ?>
        <th data-name="m_52" class="<?= $Page->m_52->headerCellClass() ?>"><div id="elh_s_omr_value_m_52" class="s_omr_value_m_52"><?= $Page->renderFieldHeader($Page->m_52) ?></div></th>
<?php } ?>
<?php if ($Page->_53->Visible) { // 53 ?>
        <th data-name="_53" class="<?= $Page->_53->headerCellClass() ?>"><div id="elh_s_omr_value__53" class="s_omr_value__53"><?= $Page->renderFieldHeader($Page->_53) ?></div></th>
<?php } ?>
<?php if ($Page->m_53->Visible) { // m_53 ?>
        <th data-name="m_53" class="<?= $Page->m_53->headerCellClass() ?>"><div id="elh_s_omr_value_m_53" class="s_omr_value_m_53"><?= $Page->renderFieldHeader($Page->m_53) ?></div></th>
<?php } ?>
<?php if ($Page->_54->Visible) { // 54 ?>
        <th data-name="_54" class="<?= $Page->_54->headerCellClass() ?>"><div id="elh_s_omr_value__54" class="s_omr_value__54"><?= $Page->renderFieldHeader($Page->_54) ?></div></th>
<?php } ?>
<?php if ($Page->m_54->Visible) { // m_54 ?>
        <th data-name="m_54" class="<?= $Page->m_54->headerCellClass() ?>"><div id="elh_s_omr_value_m_54" class="s_omr_value_m_54"><?= $Page->renderFieldHeader($Page->m_54) ?></div></th>
<?php } ?>
<?php if ($Page->_55->Visible) { // 55 ?>
        <th data-name="_55" class="<?= $Page->_55->headerCellClass() ?>"><div id="elh_s_omr_value__55" class="s_omr_value__55"><?= $Page->renderFieldHeader($Page->_55) ?></div></th>
<?php } ?>
<?php if ($Page->m_55->Visible) { // m_55 ?>
        <th data-name="m_55" class="<?= $Page->m_55->headerCellClass() ?>"><div id="elh_s_omr_value_m_55" class="s_omr_value_m_55"><?= $Page->renderFieldHeader($Page->m_55) ?></div></th>
<?php } ?>
<?php if ($Page->_56->Visible) { // 56 ?>
        <th data-name="_56" class="<?= $Page->_56->headerCellClass() ?>"><div id="elh_s_omr_value__56" class="s_omr_value__56"><?= $Page->renderFieldHeader($Page->_56) ?></div></th>
<?php } ?>
<?php if ($Page->m_56->Visible) { // m_56 ?>
        <th data-name="m_56" class="<?= $Page->m_56->headerCellClass() ?>"><div id="elh_s_omr_value_m_56" class="s_omr_value_m_56"><?= $Page->renderFieldHeader($Page->m_56) ?></div></th>
<?php } ?>
<?php if ($Page->_57->Visible) { // 57 ?>
        <th data-name="_57" class="<?= $Page->_57->headerCellClass() ?>"><div id="elh_s_omr_value__57" class="s_omr_value__57"><?= $Page->renderFieldHeader($Page->_57) ?></div></th>
<?php } ?>
<?php if ($Page->m_57->Visible) { // m_57 ?>
        <th data-name="m_57" class="<?= $Page->m_57->headerCellClass() ?>"><div id="elh_s_omr_value_m_57" class="s_omr_value_m_57"><?= $Page->renderFieldHeader($Page->m_57) ?></div></th>
<?php } ?>
<?php if ($Page->_58->Visible) { // 58 ?>
        <th data-name="_58" class="<?= $Page->_58->headerCellClass() ?>"><div id="elh_s_omr_value__58" class="s_omr_value__58"><?= $Page->renderFieldHeader($Page->_58) ?></div></th>
<?php } ?>
<?php if ($Page->m_58->Visible) { // m_58 ?>
        <th data-name="m_58" class="<?= $Page->m_58->headerCellClass() ?>"><div id="elh_s_omr_value_m_58" class="s_omr_value_m_58"><?= $Page->renderFieldHeader($Page->m_58) ?></div></th>
<?php } ?>
<?php if ($Page->_59->Visible) { // 59 ?>
        <th data-name="_59" class="<?= $Page->_59->headerCellClass() ?>"><div id="elh_s_omr_value__59" class="s_omr_value__59"><?= $Page->renderFieldHeader($Page->_59) ?></div></th>
<?php } ?>
<?php if ($Page->m_59->Visible) { // m_59 ?>
        <th data-name="m_59" class="<?= $Page->m_59->headerCellClass() ?>"><div id="elh_s_omr_value_m_59" class="s_omr_value_m_59"><?= $Page->renderFieldHeader($Page->m_59) ?></div></th>
<?php } ?>
<?php if ($Page->_60->Visible) { // 60 ?>
        <th data-name="_60" class="<?= $Page->_60->headerCellClass() ?>"><div id="elh_s_omr_value__60" class="s_omr_value__60"><?= $Page->renderFieldHeader($Page->_60) ?></div></th>
<?php } ?>
<?php if ($Page->m_60->Visible) { // m_60 ?>
        <th data-name="m_60" class="<?= $Page->m_60->headerCellClass() ?>"><div id="elh_s_omr_value_m_60" class="s_omr_value_m_60"><?= $Page->renderFieldHeader($Page->m_60) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_id" class="el_s_omr_value_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->roll_no->Visible) { // roll_no ?>
        <td data-name="roll_no"<?= $Page->roll_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_roll_no" class="el_s_omr_value_roll_no">
<span<?= $Page->roll_no->viewAttributes() ?>>
<?= $Page->roll_no->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->test_id->Visible) { // test_id ?>
        <td data-name="test_id"<?= $Page->test_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_test_id" class="el_s_omr_value_test_id">
<span<?= $Page->test_id->viewAttributes() ?>>
<?= $Page->test_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->total->Visible) { // total ?>
        <td data-name="total"<?= $Page->total->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_total" class="el_s_omr_value_total">
<span<?= $Page->total->viewAttributes() ?>>
<?= $Page->total->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->percent->Visible) { // percent ?>
        <td data-name="percent"<?= $Page->percent->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_percent" class="el_s_omr_value_percent">
<span<?= $Page->percent->viewAttributes() ?>>
<?= $Page->percent->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_1->Visible) { // s_1 ?>
        <td data-name="s_1"<?= $Page->s_1->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_s_1" class="el_s_omr_value_s_1">
<span<?= $Page->s_1->viewAttributes() ?>>
<?= $Page->s_1->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_2->Visible) { // s_2 ?>
        <td data-name="s_2"<?= $Page->s_2->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_s_2" class="el_s_omr_value_s_2">
<span<?= $Page->s_2->viewAttributes() ?>>
<?= $Page->s_2->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_3->Visible) { // s_3 ?>
        <td data-name="s_3"<?= $Page->s_3->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_s_3" class="el_s_omr_value_s_3">
<span<?= $Page->s_3->viewAttributes() ?>>
<?= $Page->s_3->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_4->Visible) { // s_4 ?>
        <td data-name="s_4"<?= $Page->s_4->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_s_4" class="el_s_omr_value_s_4">
<span<?= $Page->s_4->viewAttributes() ?>>
<?= $Page->s_4->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_5->Visible) { // s_5 ?>
        <td data-name="s_5"<?= $Page->s_5->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_s_5" class="el_s_omr_value_s_5">
<span<?= $Page->s_5->viewAttributes() ?>>
<?= $Page->s_5->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->omr_image->Visible) { // omr_image ?>
        <td data-name="omr_image"<?= $Page->omr_image->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_omr_image" class="el_s_omr_value_omr_image">
<span>
<?= GetFileViewTag($Page->omr_image, $Page->omr_image->getViewValue(), false) ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_1->Visible) { // 1 ?>
        <td data-name="_1"<?= $Page->_1->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__1" class="el_s_omr_value__1">
<span<?= $Page->_1->viewAttributes() ?>>
<?= $Page->_1->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_1->Visible) { // m_1 ?>
        <td data-name="m_1"<?= $Page->m_1->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_1" class="el_s_omr_value_m_1">
<span<?= $Page->m_1->viewAttributes() ?>>
<?= $Page->m_1->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_2->Visible) { // 2 ?>
        <td data-name="_2"<?= $Page->_2->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__2" class="el_s_omr_value__2">
<span<?= $Page->_2->viewAttributes() ?>>
<?= $Page->_2->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_2->Visible) { // m_2 ?>
        <td data-name="m_2"<?= $Page->m_2->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_2" class="el_s_omr_value_m_2">
<span<?= $Page->m_2->viewAttributes() ?>>
<?= $Page->m_2->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_3->Visible) { // 3 ?>
        <td data-name="_3"<?= $Page->_3->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__3" class="el_s_omr_value__3">
<span<?= $Page->_3->viewAttributes() ?>>
<?= $Page->_3->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_3->Visible) { // m_3 ?>
        <td data-name="m_3"<?= $Page->m_3->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_3" class="el_s_omr_value_m_3">
<span<?= $Page->m_3->viewAttributes() ?>>
<?= $Page->m_3->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_4->Visible) { // 4 ?>
        <td data-name="_4"<?= $Page->_4->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__4" class="el_s_omr_value__4">
<span<?= $Page->_4->viewAttributes() ?>>
<?= $Page->_4->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_4->Visible) { // m_4 ?>
        <td data-name="m_4"<?= $Page->m_4->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_4" class="el_s_omr_value_m_4">
<span<?= $Page->m_4->viewAttributes() ?>>
<?= $Page->m_4->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_5->Visible) { // 5 ?>
        <td data-name="_5"<?= $Page->_5->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__5" class="el_s_omr_value__5">
<span<?= $Page->_5->viewAttributes() ?>>
<?= $Page->_5->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_5->Visible) { // m_5 ?>
        <td data-name="m_5"<?= $Page->m_5->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_5" class="el_s_omr_value_m_5">
<span<?= $Page->m_5->viewAttributes() ?>>
<?= $Page->m_5->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_6->Visible) { // 6 ?>
        <td data-name="_6"<?= $Page->_6->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__6" class="el_s_omr_value__6">
<span<?= $Page->_6->viewAttributes() ?>>
<?= $Page->_6->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_6->Visible) { // m_6 ?>
        <td data-name="m_6"<?= $Page->m_6->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_6" class="el_s_omr_value_m_6">
<span<?= $Page->m_6->viewAttributes() ?>>
<?= $Page->m_6->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_7->Visible) { // 7 ?>
        <td data-name="_7"<?= $Page->_7->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__7" class="el_s_omr_value__7">
<span<?= $Page->_7->viewAttributes() ?>>
<?= $Page->_7->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_7->Visible) { // m_7 ?>
        <td data-name="m_7"<?= $Page->m_7->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_7" class="el_s_omr_value_m_7">
<span<?= $Page->m_7->viewAttributes() ?>>
<?= $Page->m_7->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_8->Visible) { // 8 ?>
        <td data-name="_8"<?= $Page->_8->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__8" class="el_s_omr_value__8">
<span<?= $Page->_8->viewAttributes() ?>>
<?= $Page->_8->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_8->Visible) { // m_8 ?>
        <td data-name="m_8"<?= $Page->m_8->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_8" class="el_s_omr_value_m_8">
<span<?= $Page->m_8->viewAttributes() ?>>
<?= $Page->m_8->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_9->Visible) { // 9 ?>
        <td data-name="_9"<?= $Page->_9->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__9" class="el_s_omr_value__9">
<span<?= $Page->_9->viewAttributes() ?>>
<?= $Page->_9->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_9->Visible) { // m_9 ?>
        <td data-name="m_9"<?= $Page->m_9->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_9" class="el_s_omr_value_m_9">
<span<?= $Page->m_9->viewAttributes() ?>>
<?= $Page->m_9->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_10->Visible) { // 10 ?>
        <td data-name="_10"<?= $Page->_10->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__10" class="el_s_omr_value__10">
<span<?= $Page->_10->viewAttributes() ?>>
<?= $Page->_10->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_10->Visible) { // m_10 ?>
        <td data-name="m_10"<?= $Page->m_10->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_10" class="el_s_omr_value_m_10">
<span<?= $Page->m_10->viewAttributes() ?>>
<?= $Page->m_10->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_11->Visible) { // 11 ?>
        <td data-name="_11"<?= $Page->_11->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__11" class="el_s_omr_value__11">
<span<?= $Page->_11->viewAttributes() ?>>
<?= $Page->_11->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_11->Visible) { // m_11 ?>
        <td data-name="m_11"<?= $Page->m_11->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_11" class="el_s_omr_value_m_11">
<span<?= $Page->m_11->viewAttributes() ?>>
<?= $Page->m_11->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_12->Visible) { // 12 ?>
        <td data-name="_12"<?= $Page->_12->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__12" class="el_s_omr_value__12">
<span<?= $Page->_12->viewAttributes() ?>>
<?= $Page->_12->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_12->Visible) { // m_12 ?>
        <td data-name="m_12"<?= $Page->m_12->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_12" class="el_s_omr_value_m_12">
<span<?= $Page->m_12->viewAttributes() ?>>
<?= $Page->m_12->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_13->Visible) { // 13 ?>
        <td data-name="_13"<?= $Page->_13->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__13" class="el_s_omr_value__13">
<span<?= $Page->_13->viewAttributes() ?>>
<?= $Page->_13->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_13->Visible) { // m_13 ?>
        <td data-name="m_13"<?= $Page->m_13->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_13" class="el_s_omr_value_m_13">
<span<?= $Page->m_13->viewAttributes() ?>>
<?= $Page->m_13->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_14->Visible) { // 14 ?>
        <td data-name="_14"<?= $Page->_14->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__14" class="el_s_omr_value__14">
<span<?= $Page->_14->viewAttributes() ?>>
<?= $Page->_14->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_14->Visible) { // m_14 ?>
        <td data-name="m_14"<?= $Page->m_14->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_14" class="el_s_omr_value_m_14">
<span<?= $Page->m_14->viewAttributes() ?>>
<?= $Page->m_14->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_15->Visible) { // 15 ?>
        <td data-name="_15"<?= $Page->_15->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__15" class="el_s_omr_value__15">
<span<?= $Page->_15->viewAttributes() ?>>
<?= $Page->_15->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_15->Visible) { // m_15 ?>
        <td data-name="m_15"<?= $Page->m_15->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_15" class="el_s_omr_value_m_15">
<span<?= $Page->m_15->viewAttributes() ?>>
<?= $Page->m_15->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_16->Visible) { // 16 ?>
        <td data-name="_16"<?= $Page->_16->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__16" class="el_s_omr_value__16">
<span<?= $Page->_16->viewAttributes() ?>>
<?= $Page->_16->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_16->Visible) { // m_16 ?>
        <td data-name="m_16"<?= $Page->m_16->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_16" class="el_s_omr_value_m_16">
<span<?= $Page->m_16->viewAttributes() ?>>
<?= $Page->m_16->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_17->Visible) { // 17 ?>
        <td data-name="_17"<?= $Page->_17->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__17" class="el_s_omr_value__17">
<span<?= $Page->_17->viewAttributes() ?>>
<?= $Page->_17->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_17->Visible) { // m_17 ?>
        <td data-name="m_17"<?= $Page->m_17->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_17" class="el_s_omr_value_m_17">
<span<?= $Page->m_17->viewAttributes() ?>>
<?= $Page->m_17->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_18->Visible) { // 18 ?>
        <td data-name="_18"<?= $Page->_18->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__18" class="el_s_omr_value__18">
<span<?= $Page->_18->viewAttributes() ?>>
<?= $Page->_18->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_18->Visible) { // m_18 ?>
        <td data-name="m_18"<?= $Page->m_18->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_18" class="el_s_omr_value_m_18">
<span<?= $Page->m_18->viewAttributes() ?>>
<?= $Page->m_18->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_19->Visible) { // 19 ?>
        <td data-name="_19"<?= $Page->_19->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__19" class="el_s_omr_value__19">
<span<?= $Page->_19->viewAttributes() ?>>
<?= $Page->_19->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_19->Visible) { // m_19 ?>
        <td data-name="m_19"<?= $Page->m_19->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_19" class="el_s_omr_value_m_19">
<span<?= $Page->m_19->viewAttributes() ?>>
<?= $Page->m_19->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_20->Visible) { // 20 ?>
        <td data-name="_20"<?= $Page->_20->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__20" class="el_s_omr_value__20">
<span<?= $Page->_20->viewAttributes() ?>>
<?= $Page->_20->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_20->Visible) { // m_20 ?>
        <td data-name="m_20"<?= $Page->m_20->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_20" class="el_s_omr_value_m_20">
<span<?= $Page->m_20->viewAttributes() ?>>
<?= $Page->m_20->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_21->Visible) { // 21 ?>
        <td data-name="_21"<?= $Page->_21->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__21" class="el_s_omr_value__21">
<span<?= $Page->_21->viewAttributes() ?>>
<?= $Page->_21->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_21->Visible) { // m_21 ?>
        <td data-name="m_21"<?= $Page->m_21->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_21" class="el_s_omr_value_m_21">
<span<?= $Page->m_21->viewAttributes() ?>>
<?= $Page->m_21->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_22->Visible) { // 22 ?>
        <td data-name="_22"<?= $Page->_22->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__22" class="el_s_omr_value__22">
<span<?= $Page->_22->viewAttributes() ?>>
<?= $Page->_22->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_22->Visible) { // m_22 ?>
        <td data-name="m_22"<?= $Page->m_22->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_22" class="el_s_omr_value_m_22">
<span<?= $Page->m_22->viewAttributes() ?>>
<?= $Page->m_22->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_23->Visible) { // 23 ?>
        <td data-name="_23"<?= $Page->_23->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__23" class="el_s_omr_value__23">
<span<?= $Page->_23->viewAttributes() ?>>
<?= $Page->_23->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_23->Visible) { // m_23 ?>
        <td data-name="m_23"<?= $Page->m_23->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_23" class="el_s_omr_value_m_23">
<span<?= $Page->m_23->viewAttributes() ?>>
<?= $Page->m_23->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_24->Visible) { // 24 ?>
        <td data-name="_24"<?= $Page->_24->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__24" class="el_s_omr_value__24">
<span<?= $Page->_24->viewAttributes() ?>>
<?= $Page->_24->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_24->Visible) { // m_24 ?>
        <td data-name="m_24"<?= $Page->m_24->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_24" class="el_s_omr_value_m_24">
<span<?= $Page->m_24->viewAttributes() ?>>
<?= $Page->m_24->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_25->Visible) { // 25 ?>
        <td data-name="_25"<?= $Page->_25->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__25" class="el_s_omr_value__25">
<span<?= $Page->_25->viewAttributes() ?>>
<?= $Page->_25->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_25->Visible) { // m_25 ?>
        <td data-name="m_25"<?= $Page->m_25->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_25" class="el_s_omr_value_m_25">
<span<?= $Page->m_25->viewAttributes() ?>>
<?= $Page->m_25->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_26->Visible) { // 26 ?>
        <td data-name="_26"<?= $Page->_26->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__26" class="el_s_omr_value__26">
<span<?= $Page->_26->viewAttributes() ?>>
<?= $Page->_26->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_26->Visible) { // m_26 ?>
        <td data-name="m_26"<?= $Page->m_26->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_26" class="el_s_omr_value_m_26">
<span<?= $Page->m_26->viewAttributes() ?>>
<?= $Page->m_26->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_27->Visible) { // 27 ?>
        <td data-name="_27"<?= $Page->_27->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__27" class="el_s_omr_value__27">
<span<?= $Page->_27->viewAttributes() ?>>
<?= $Page->_27->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_27->Visible) { // m_27 ?>
        <td data-name="m_27"<?= $Page->m_27->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_27" class="el_s_omr_value_m_27">
<span<?= $Page->m_27->viewAttributes() ?>>
<?= $Page->m_27->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_28->Visible) { // 28 ?>
        <td data-name="_28"<?= $Page->_28->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__28" class="el_s_omr_value__28">
<span<?= $Page->_28->viewAttributes() ?>>
<?= $Page->_28->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_28->Visible) { // m_28 ?>
        <td data-name="m_28"<?= $Page->m_28->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_28" class="el_s_omr_value_m_28">
<span<?= $Page->m_28->viewAttributes() ?>>
<?= $Page->m_28->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_29->Visible) { // 29 ?>
        <td data-name="_29"<?= $Page->_29->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__29" class="el_s_omr_value__29">
<span<?= $Page->_29->viewAttributes() ?>>
<?= $Page->_29->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_29->Visible) { // m_29 ?>
        <td data-name="m_29"<?= $Page->m_29->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_29" class="el_s_omr_value_m_29">
<span<?= $Page->m_29->viewAttributes() ?>>
<?= $Page->m_29->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_30->Visible) { // 30 ?>
        <td data-name="_30"<?= $Page->_30->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__30" class="el_s_omr_value__30">
<span<?= $Page->_30->viewAttributes() ?>>
<?= $Page->_30->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_30->Visible) { // m_30 ?>
        <td data-name="m_30"<?= $Page->m_30->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_30" class="el_s_omr_value_m_30">
<span<?= $Page->m_30->viewAttributes() ?>>
<?= $Page->m_30->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_31->Visible) { // 31 ?>
        <td data-name="_31"<?= $Page->_31->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__31" class="el_s_omr_value__31">
<span<?= $Page->_31->viewAttributes() ?>>
<?= $Page->_31->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_31->Visible) { // m_31 ?>
        <td data-name="m_31"<?= $Page->m_31->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_31" class="el_s_omr_value_m_31">
<span<?= $Page->m_31->viewAttributes() ?>>
<?= $Page->m_31->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_32->Visible) { // 32 ?>
        <td data-name="_32"<?= $Page->_32->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__32" class="el_s_omr_value__32">
<span<?= $Page->_32->viewAttributes() ?>>
<?= $Page->_32->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_32->Visible) { // m_32 ?>
        <td data-name="m_32"<?= $Page->m_32->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_32" class="el_s_omr_value_m_32">
<span<?= $Page->m_32->viewAttributes() ?>>
<?= $Page->m_32->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_33->Visible) { // 33 ?>
        <td data-name="_33"<?= $Page->_33->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__33" class="el_s_omr_value__33">
<span<?= $Page->_33->viewAttributes() ?>>
<?= $Page->_33->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_33->Visible) { // m_33 ?>
        <td data-name="m_33"<?= $Page->m_33->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_33" class="el_s_omr_value_m_33">
<span<?= $Page->m_33->viewAttributes() ?>>
<?= $Page->m_33->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_34->Visible) { // 34 ?>
        <td data-name="_34"<?= $Page->_34->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__34" class="el_s_omr_value__34">
<span<?= $Page->_34->viewAttributes() ?>>
<?= $Page->_34->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_34->Visible) { // m_34 ?>
        <td data-name="m_34"<?= $Page->m_34->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_34" class="el_s_omr_value_m_34">
<span<?= $Page->m_34->viewAttributes() ?>>
<?= $Page->m_34->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_35->Visible) { // 35 ?>
        <td data-name="_35"<?= $Page->_35->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__35" class="el_s_omr_value__35">
<span<?= $Page->_35->viewAttributes() ?>>
<?= $Page->_35->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_35->Visible) { // m_35 ?>
        <td data-name="m_35"<?= $Page->m_35->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_35" class="el_s_omr_value_m_35">
<span<?= $Page->m_35->viewAttributes() ?>>
<?= $Page->m_35->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_36->Visible) { // 36 ?>
        <td data-name="_36"<?= $Page->_36->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__36" class="el_s_omr_value__36">
<span<?= $Page->_36->viewAttributes() ?>>
<?= $Page->_36->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_36->Visible) { // m_36 ?>
        <td data-name="m_36"<?= $Page->m_36->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_36" class="el_s_omr_value_m_36">
<span<?= $Page->m_36->viewAttributes() ?>>
<?= $Page->m_36->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_37->Visible) { // 37 ?>
        <td data-name="_37"<?= $Page->_37->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__37" class="el_s_omr_value__37">
<span<?= $Page->_37->viewAttributes() ?>>
<?= $Page->_37->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_37->Visible) { // m_37 ?>
        <td data-name="m_37"<?= $Page->m_37->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_37" class="el_s_omr_value_m_37">
<span<?= $Page->m_37->viewAttributes() ?>>
<?= $Page->m_37->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_38->Visible) { // 38 ?>
        <td data-name="_38"<?= $Page->_38->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__38" class="el_s_omr_value__38">
<span<?= $Page->_38->viewAttributes() ?>>
<?= $Page->_38->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_38->Visible) { // m_38 ?>
        <td data-name="m_38"<?= $Page->m_38->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_38" class="el_s_omr_value_m_38">
<span<?= $Page->m_38->viewAttributes() ?>>
<?= $Page->m_38->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_39->Visible) { // 39 ?>
        <td data-name="_39"<?= $Page->_39->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__39" class="el_s_omr_value__39">
<span<?= $Page->_39->viewAttributes() ?>>
<?= $Page->_39->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_39->Visible) { // m_39 ?>
        <td data-name="m_39"<?= $Page->m_39->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_39" class="el_s_omr_value_m_39">
<span<?= $Page->m_39->viewAttributes() ?>>
<?= $Page->m_39->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_40->Visible) { // 40 ?>
        <td data-name="_40"<?= $Page->_40->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__40" class="el_s_omr_value__40">
<span<?= $Page->_40->viewAttributes() ?>>
<?= $Page->_40->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_40->Visible) { // m_40 ?>
        <td data-name="m_40"<?= $Page->m_40->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_40" class="el_s_omr_value_m_40">
<span<?= $Page->m_40->viewAttributes() ?>>
<?= $Page->m_40->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_41->Visible) { // 41 ?>
        <td data-name="_41"<?= $Page->_41->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__41" class="el_s_omr_value__41">
<span<?= $Page->_41->viewAttributes() ?>>
<?= $Page->_41->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_41->Visible) { // m_41 ?>
        <td data-name="m_41"<?= $Page->m_41->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_41" class="el_s_omr_value_m_41">
<span<?= $Page->m_41->viewAttributes() ?>>
<?= $Page->m_41->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_42->Visible) { // 42 ?>
        <td data-name="_42"<?= $Page->_42->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__42" class="el_s_omr_value__42">
<span<?= $Page->_42->viewAttributes() ?>>
<?= $Page->_42->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_42->Visible) { // m_42 ?>
        <td data-name="m_42"<?= $Page->m_42->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_42" class="el_s_omr_value_m_42">
<span<?= $Page->m_42->viewAttributes() ?>>
<?= $Page->m_42->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_43->Visible) { // 43 ?>
        <td data-name="_43"<?= $Page->_43->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__43" class="el_s_omr_value__43">
<span<?= $Page->_43->viewAttributes() ?>>
<?= $Page->_43->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_43->Visible) { // m_43 ?>
        <td data-name="m_43"<?= $Page->m_43->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_43" class="el_s_omr_value_m_43">
<span<?= $Page->m_43->viewAttributes() ?>>
<?= $Page->m_43->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_44->Visible) { // 44 ?>
        <td data-name="_44"<?= $Page->_44->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__44" class="el_s_omr_value__44">
<span<?= $Page->_44->viewAttributes() ?>>
<?= $Page->_44->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_44->Visible) { // m_44 ?>
        <td data-name="m_44"<?= $Page->m_44->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_44" class="el_s_omr_value_m_44">
<span<?= $Page->m_44->viewAttributes() ?>>
<?= $Page->m_44->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_45->Visible) { // 45 ?>
        <td data-name="_45"<?= $Page->_45->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__45" class="el_s_omr_value__45">
<span<?= $Page->_45->viewAttributes() ?>>
<?= $Page->_45->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_45->Visible) { // m_45 ?>
        <td data-name="m_45"<?= $Page->m_45->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_45" class="el_s_omr_value_m_45">
<span<?= $Page->m_45->viewAttributes() ?>>
<?= $Page->m_45->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_46->Visible) { // 46 ?>
        <td data-name="_46"<?= $Page->_46->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__46" class="el_s_omr_value__46">
<span<?= $Page->_46->viewAttributes() ?>>
<?= $Page->_46->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_46->Visible) { // m_46 ?>
        <td data-name="m_46"<?= $Page->m_46->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_46" class="el_s_omr_value_m_46">
<span<?= $Page->m_46->viewAttributes() ?>>
<?= $Page->m_46->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_47->Visible) { // 47 ?>
        <td data-name="_47"<?= $Page->_47->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__47" class="el_s_omr_value__47">
<span<?= $Page->_47->viewAttributes() ?>>
<?= $Page->_47->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_47->Visible) { // m_47 ?>
        <td data-name="m_47"<?= $Page->m_47->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_47" class="el_s_omr_value_m_47">
<span<?= $Page->m_47->viewAttributes() ?>>
<?= $Page->m_47->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_48->Visible) { // 48 ?>
        <td data-name="_48"<?= $Page->_48->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__48" class="el_s_omr_value__48">
<span<?= $Page->_48->viewAttributes() ?>>
<?= $Page->_48->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_48->Visible) { // m_48 ?>
        <td data-name="m_48"<?= $Page->m_48->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_48" class="el_s_omr_value_m_48">
<span<?= $Page->m_48->viewAttributes() ?>>
<?= $Page->m_48->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_49->Visible) { // 49 ?>
        <td data-name="_49"<?= $Page->_49->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__49" class="el_s_omr_value__49">
<span<?= $Page->_49->viewAttributes() ?>>
<?= $Page->_49->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_49->Visible) { // m_49 ?>
        <td data-name="m_49"<?= $Page->m_49->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_49" class="el_s_omr_value_m_49">
<span<?= $Page->m_49->viewAttributes() ?>>
<?= $Page->m_49->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_50->Visible) { // 50 ?>
        <td data-name="_50"<?= $Page->_50->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__50" class="el_s_omr_value__50">
<span<?= $Page->_50->viewAttributes() ?>>
<?= $Page->_50->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_50->Visible) { // m_50 ?>
        <td data-name="m_50"<?= $Page->m_50->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_50" class="el_s_omr_value_m_50">
<span<?= $Page->m_50->viewAttributes() ?>>
<?= $Page->m_50->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_51->Visible) { // 51 ?>
        <td data-name="_51"<?= $Page->_51->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__51" class="el_s_omr_value__51">
<span<?= $Page->_51->viewAttributes() ?>>
<?= $Page->_51->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_51->Visible) { // m_51 ?>
        <td data-name="m_51"<?= $Page->m_51->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_51" class="el_s_omr_value_m_51">
<span<?= $Page->m_51->viewAttributes() ?>>
<?= $Page->m_51->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_52->Visible) { // 52 ?>
        <td data-name="_52"<?= $Page->_52->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__52" class="el_s_omr_value__52">
<span<?= $Page->_52->viewAttributes() ?>>
<?= $Page->_52->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_52->Visible) { // m_52 ?>
        <td data-name="m_52"<?= $Page->m_52->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_52" class="el_s_omr_value_m_52">
<span<?= $Page->m_52->viewAttributes() ?>>
<?= $Page->m_52->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_53->Visible) { // 53 ?>
        <td data-name="_53"<?= $Page->_53->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__53" class="el_s_omr_value__53">
<span<?= $Page->_53->viewAttributes() ?>>
<?= $Page->_53->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_53->Visible) { // m_53 ?>
        <td data-name="m_53"<?= $Page->m_53->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_53" class="el_s_omr_value_m_53">
<span<?= $Page->m_53->viewAttributes() ?>>
<?= $Page->m_53->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_54->Visible) { // 54 ?>
        <td data-name="_54"<?= $Page->_54->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__54" class="el_s_omr_value__54">
<span<?= $Page->_54->viewAttributes() ?>>
<?= $Page->_54->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_54->Visible) { // m_54 ?>
        <td data-name="m_54"<?= $Page->m_54->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_54" class="el_s_omr_value_m_54">
<span<?= $Page->m_54->viewAttributes() ?>>
<?= $Page->m_54->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_55->Visible) { // 55 ?>
        <td data-name="_55"<?= $Page->_55->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__55" class="el_s_omr_value__55">
<span<?= $Page->_55->viewAttributes() ?>>
<?= $Page->_55->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_55->Visible) { // m_55 ?>
        <td data-name="m_55"<?= $Page->m_55->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_55" class="el_s_omr_value_m_55">
<span<?= $Page->m_55->viewAttributes() ?>>
<?= $Page->m_55->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_56->Visible) { // 56 ?>
        <td data-name="_56"<?= $Page->_56->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__56" class="el_s_omr_value__56">
<span<?= $Page->_56->viewAttributes() ?>>
<?= $Page->_56->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_56->Visible) { // m_56 ?>
        <td data-name="m_56"<?= $Page->m_56->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_56" class="el_s_omr_value_m_56">
<span<?= $Page->m_56->viewAttributes() ?>>
<?= $Page->m_56->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_57->Visible) { // 57 ?>
        <td data-name="_57"<?= $Page->_57->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__57" class="el_s_omr_value__57">
<span<?= $Page->_57->viewAttributes() ?>>
<?= $Page->_57->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_57->Visible) { // m_57 ?>
        <td data-name="m_57"<?= $Page->m_57->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_57" class="el_s_omr_value_m_57">
<span<?= $Page->m_57->viewAttributes() ?>>
<?= $Page->m_57->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_58->Visible) { // 58 ?>
        <td data-name="_58"<?= $Page->_58->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__58" class="el_s_omr_value__58">
<span<?= $Page->_58->viewAttributes() ?>>
<?= $Page->_58->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_58->Visible) { // m_58 ?>
        <td data-name="m_58"<?= $Page->m_58->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_58" class="el_s_omr_value_m_58">
<span<?= $Page->m_58->viewAttributes() ?>>
<?= $Page->m_58->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_59->Visible) { // 59 ?>
        <td data-name="_59"<?= $Page->_59->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__59" class="el_s_omr_value__59">
<span<?= $Page->_59->viewAttributes() ?>>
<?= $Page->_59->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_59->Visible) { // m_59 ?>
        <td data-name="m_59"<?= $Page->m_59->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_59" class="el_s_omr_value_m_59">
<span<?= $Page->m_59->viewAttributes() ?>>
<?= $Page->m_59->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->_60->Visible) { // 60 ?>
        <td data-name="_60"<?= $Page->_60->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value__60" class="el_s_omr_value__60">
<span<?= $Page->_60->viewAttributes() ?>>
<?= $Page->_60->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_60->Visible) { // m_60 ?>
        <td data-name="m_60"<?= $Page->m_60->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_omr_value_m_60" class="el_s_omr_value_m_60">
<span<?= $Page->m_60->viewAttributes() ?>>
<?= $Page->m_60->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_omr_value");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
