<?php

namespace PHPMaker2024\fibre;

// Page object
$SInoutTimeEdit = &$Page;
?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="edit">
<form name="fs_inout_timeedit" id="fs_inout_timeedit" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_inout_time: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var fs_inout_timeedit;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fs_inout_timeedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["week_day", [fields.week_day.visible && fields.week_day.required ? ew.Validators.required(fields.week_day.caption) : null], fields.week_day.isInvalid],
            ["in_time", [fields.in_time.visible && fields.in_time.required ? ew.Validators.required(fields.in_time.caption) : null, ew.Validators.time(fields.in_time.clientFormatPattern)], fields.in_time.isInvalid],
            ["out_time", [fields.out_time.visible && fields.out_time.required ? ew.Validators.required(fields.out_time.caption) : null, ew.Validators.time(fields.out_time.clientFormatPattern)], fields.out_time.isInvalid],
            ["faculty", [fields.faculty.visible && fields.faculty.required ? ew.Validators.required(fields.faculty.caption) : null], fields.faculty.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "week_day": <?= $Page->week_day->toClientList($Page) ?>,
            "faculty": <?= $Page->faculty->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_inout_time">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->OldKeyName ?>" value="<?= $Page->OldKey ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id"<?= $Page->id->rowAttributes() ?>>
        <label id="elh_s_inout_time_id" class="<?= $Page->LeftColumnClass ?>"><?= $Page->id->caption() ?><?= $Page->id->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->id->cellAttributes() ?>>
<span id="el_s_inout_time_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="s_inout_time" data-field="x_id" data-hidden="1" name="x_id" id="x_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->week_day->Visible) { // week_day ?>
    <div id="r_week_day"<?= $Page->week_day->rowAttributes() ?>>
        <label id="elh_s_inout_time_week_day" class="<?= $Page->LeftColumnClass ?>"><?= $Page->week_day->caption() ?><?= $Page->week_day->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->week_day->cellAttributes() ?>>
<span id="el_s_inout_time_week_day">
<template id="tp_x_week_day">
    <div class="form-check">
        <input type="checkbox" class="form-check-input" data-table="s_inout_time" data-field="x_week_day" name="x_week_day" id="x_week_day"<?= $Page->week_day->editAttributes() ?>>
        <label class="form-check-label"></label>
    </div>
</template>
<div id="dsl_x_week_day" class="ew-item-list"></div>
<selection-list hidden
    id="x_week_day[]"
    name="x_week_day[]"
    value="<?= HtmlEncode($Page->week_day->CurrentValue) ?>"
    data-type="select-multiple"
    data-template="tp_x_week_day"
    data-target="dsl_x_week_day"
    data-repeatcolumn="5"
    class="form-control<?= $Page->week_day->isInvalidClass() ?>"
    data-table="s_inout_time"
    data-field="x_week_day"
    data-value-separator="<?= $Page->week_day->displayValueSeparatorAttribute() ?>"
    <?= $Page->week_day->editAttributes() ?>></selection-list>
<?= $Page->week_day->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->week_day->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->in_time->Visible) { // in_time ?>
    <div id="r_in_time"<?= $Page->in_time->rowAttributes() ?>>
        <label id="elh_s_inout_time_in_time" for="x_in_time" class="<?= $Page->LeftColumnClass ?>"><?= $Page->in_time->caption() ?><?= $Page->in_time->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->in_time->cellAttributes() ?>>
<span id="el_s_inout_time_in_time">
<input type="<?= $Page->in_time->getInputTextType() ?>" name="x_in_time" id="x_in_time" data-table="s_inout_time" data-field="x_in_time" value="<?= $Page->in_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->in_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->in_time->formatPattern()) ?>"<?= $Page->in_time->editAttributes() ?> aria-describedby="x_in_time_help">
<?= $Page->in_time->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->in_time->getErrorMessage() ?></div>
<?php if (!$Page->in_time->ReadOnly && !$Page->in_time->Disabled && !isset($Page->in_time->EditAttrs["readonly"]) && !isset($Page->in_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_inout_timeedit", "timepicker"], () => ew.createTimePicker("fs_inout_timeedit", "x_in_time", Object.assign({"step":15}, { timeFormat: "<?= DateFormat(4) ?>" }, undefined)));
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->out_time->Visible) { // out_time ?>
    <div id="r_out_time"<?= $Page->out_time->rowAttributes() ?>>
        <label id="elh_s_inout_time_out_time" for="x_out_time" class="<?= $Page->LeftColumnClass ?>"><?= $Page->out_time->caption() ?><?= $Page->out_time->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->out_time->cellAttributes() ?>>
<span id="el_s_inout_time_out_time">
<input type="<?= $Page->out_time->getInputTextType() ?>" name="x_out_time" id="x_out_time" data-table="s_inout_time" data-field="x_out_time" value="<?= $Page->out_time->EditValue ?>" placeholder="<?= HtmlEncode($Page->out_time->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->out_time->formatPattern()) ?>"<?= $Page->out_time->editAttributes() ?> aria-describedby="x_out_time_help">
<?= $Page->out_time->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->out_time->getErrorMessage() ?></div>
<?php if (!$Page->out_time->ReadOnly && !$Page->out_time->Disabled && !isset($Page->out_time->EditAttrs["readonly"]) && !isset($Page->out_time->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_inout_timeedit", "timepicker"], () => ew.createTimePicker("fs_inout_timeedit", "x_out_time", Object.assign({"step":15}, { timeFormat: "<?= DateFormat(4) ?>" }, undefined)));
</script>
<?php } ?>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->faculty->Visible) { // faculty ?>
    <div id="r_faculty"<?= $Page->faculty->rowAttributes() ?>>
        <label id="elh_s_inout_time_faculty" for="x_faculty" class="<?= $Page->LeftColumnClass ?>"><?= $Page->faculty->caption() ?><?= $Page->faculty->Required ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->faculty->cellAttributes() ?>>
<span id="el_s_inout_time_faculty">
    <select
        id="x_faculty[]"
        name="x_faculty[]"
        class="form-control ew-select<?= $Page->faculty->isInvalidClass() ?>"
        data-select2-id="fs_inout_timeedit_x_faculty[]"
        data-table="s_inout_time"
        data-field="x_faculty"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->faculty->caption())) ?>"
        data-modal-lookup="true"
        multiple
        size="1"
        data-value-separator="<?= $Page->faculty->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>"
        <?= $Page->faculty->editAttributes() ?>>
        <?= $Page->faculty->selectOptionListHtml("x_faculty[]") ?>
    </select>
    <?= $Page->faculty->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->faculty->getErrorMessage() ?></div>
<?= $Page->faculty->Lookup->getParamTag($Page, "p_x_faculty") ?>
<script>
loadjs.ready("fs_inout_timeedit", function() {
    var options = { name: "x_faculty[]", selectId: "fs_inout_timeedit_x_faculty[]" };
    options.multiple = true;
    if (fs_inout_timeedit.lists.faculty?.lookupOptions.length) {
        options.data = { id: "x_faculty[]", form: "fs_inout_timeedit" };
    } else {
        options.ajax = { id: "x_faculty[]", form: "fs_inout_timeedit", limit: 5 };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.s_inout_time.fields.faculty.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fs_inout_timeedit"><?= $Language->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= $Language->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fs_inout_timeedit" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_inout_time");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
