<?php

namespace PHPMaker2024\fibre;

// Page object
$SFacultySearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_faculty: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fs_facultysearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_facultysearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["type", [], fields.type.isInvalid],
            ["faculty", [], fields.faculty.isInvalid],
            ["section", [], fields.section.isInvalid],
            ["fac_sec", [], fields.fac_sec.isInvalid],
            ["__session", [], fields.__session.isInvalid],
            ["status", [], fields.status.isInvalid],
            ["operator", [], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["_sort", [ew.Validators.float], fields._sort.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "type": <?= $Page->type->toClientList($Page) ?>,
            "__session": <?= $Page->__session->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
            "operator": <?= $Page->operator->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fs_facultysearch" id="fs_facultysearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_faculty">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_faculty_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_faculty_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="s_faculty" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->type->Visible) { // type ?>
    <div id="r_type" class="row"<?= $Page->type->rowAttributes() ?>>
        <label for="x_type" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_faculty_type"><?= $Page->type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_type" id="z_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_faculty_type" class="ew-search-field ew-search-field-single">
    <select
        id="x_type"
        name="x_type"
        class="form-select ew-select<?= $Page->type->isInvalidClass() ?>"
        <?php if (!$Page->type->IsNativeSelect) { ?>
        data-select2-id="fs_facultysearch_x_type"
        <?php } ?>
        data-table="s_faculty"
        data-field="x_type"
        data-value-separator="<?= $Page->type->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->type->getPlaceHolder()) ?>"
        <?= $Page->type->editAttributes() ?>>
        <?= $Page->type->selectOptionListHtml("x_type") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->type->getErrorMessage(false) ?></div>
<?php if (!$Page->type->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_facultysearch", function() {
    var options = { name: "x_type", selectId: "fs_facultysearch_x_type" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_facultysearch.lists.type?.lookupOptions.length) {
        options.data = { id: "x_type", form: "fs_facultysearch" };
    } else {
        options.ajax = { id: "x_type", form: "fs_facultysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_faculty.fields.type.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->faculty->Visible) { // faculty ?>
    <div id="r_faculty" class="row"<?= $Page->faculty->rowAttributes() ?>>
        <label for="x_faculty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_faculty_faculty"><?= $Page->faculty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_faculty" id="z_faculty" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->faculty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_faculty_faculty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->faculty->getInputTextType() ?>" name="x_faculty" id="x_faculty" data-table="s_faculty" data-field="x_faculty" value="<?= $Page->faculty->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->faculty->formatPattern()) ?>"<?= $Page->faculty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->faculty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->section->Visible) { // section ?>
    <div id="r_section" class="row"<?= $Page->section->rowAttributes() ?>>
        <label for="x_section" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_faculty_section"><?= $Page->section->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_section" id="z_section" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->section->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_faculty_section" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->section->getInputTextType() ?>" name="x_section" id="x_section" data-table="s_faculty" data-field="x_section" value="<?= $Page->section->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->section->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->section->formatPattern()) ?>"<?= $Page->section->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->section->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->fac_sec->Visible) { // fac_sec ?>
    <div id="r_fac_sec" class="row"<?= $Page->fac_sec->rowAttributes() ?>>
        <label for="x_fac_sec" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_faculty_fac_sec"><?= $Page->fac_sec->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_fac_sec" id="z_fac_sec" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->fac_sec->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_faculty_fac_sec" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->fac_sec->getInputTextType() ?>" name="x_fac_sec" id="x_fac_sec" data-table="s_faculty" data-field="x_fac_sec" value="<?= $Page->fac_sec->EditValue ?>" size="30" maxlength="24" placeholder="<?= HtmlEncode($Page->fac_sec->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->fac_sec->formatPattern()) ?>"<?= $Page->fac_sec->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->fac_sec->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->__session->Visible) { // session ?>
    <div id="r___session" class="row"<?= $Page->__session->rowAttributes() ?>>
        <label for="x___session" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_faculty___session"><?= $Page->__session->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z___session" id="z___session" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->__session->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_faculty___session" class="ew-search-field ew-search-field-single">
    <select
        id="x___session"
        name="x___session"
        class="form-select ew-select<?= $Page->__session->isInvalidClass() ?>"
        <?php if (!$Page->__session->IsNativeSelect) { ?>
        data-select2-id="fs_facultysearch_x___session"
        <?php } ?>
        data-table="s_faculty"
        data-field="x___session"
        data-value-separator="<?= $Page->__session->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->__session->getPlaceHolder()) ?>"
        <?= $Page->__session->editAttributes() ?>>
        <?= $Page->__session->selectOptionListHtml("x___session") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->__session->getErrorMessage(false) ?></div>
<?= $Page->__session->Lookup->getParamTag($Page, "p_x___session") ?>
<?php if (!$Page->__session->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_facultysearch", function() {
    var options = { name: "x___session", selectId: "fs_facultysearch_x___session" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_facultysearch.lists.__session?.lookupOptions.length) {
        options.data = { id: "x___session", form: "fs_facultysearch" };
    } else {
        options.ajax = { id: "x___session", form: "fs_facultysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_faculty.fields.__session.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label for="x_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_faculty_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_faculty_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_status"
        name="x_status"
        class="form-select ew-select<?= $Page->status->isInvalidClass() ?>"
        <?php if (!$Page->status->IsNativeSelect) { ?>
        data-select2-id="fs_facultysearch_x_status"
        <?php } ?>
        data-table="s_faculty"
        data-field="x_status"
        data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>"
        <?= $Page->status->editAttributes() ?>>
        <?= $Page->status->selectOptionListHtml("x_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<?php if (!$Page->status->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_facultysearch", function() {
    var options = { name: "x_status", selectId: "fs_facultysearch_x_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_facultysearch.lists.status?.lookupOptions.length) {
        options.data = { id: "x_status", form: "fs_facultysearch" };
    } else {
        options.ajax = { id: "x_status", form: "fs_facultysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_faculty.fields.status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_faculty_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_faculty_operator" class="ew-search-field ew-search-field-single">
    <select
        id="x_operator"
        name="x_operator"
        class="form-select ew-select<?= $Page->operator->isInvalidClass() ?>"
        <?php if (!$Page->operator->IsNativeSelect) { ?>
        data-select2-id="fs_facultysearch_x_operator"
        <?php } ?>
        data-table="s_faculty"
        data-field="x_operator"
        data-value-separator="<?= $Page->operator->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>"
        <?= $Page->operator->editAttributes() ?>>
        <?= $Page->operator->selectOptionListHtml("x_operator") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
<?= $Page->operator->Lookup->getParamTag($Page, "p_x_operator") ?>
<?php if (!$Page->operator->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_facultysearch", function() {
    var options = { name: "x_operator", selectId: "fs_facultysearch_x_operator" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_facultysearch.lists.operator?.lookupOptions.length) {
        options.data = { id: "x_operator", form: "fs_facultysearch" };
    } else {
        options.ajax = { id: "x_operator", form: "fs_facultysearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_faculty.fields.operator.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_faculty_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_faculty_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="s_faculty" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_facultysearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_facultysearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->_sort->Visible) { // sort ?>
    <div id="r__sort" class="row"<?= $Page->_sort->rowAttributes() ?>>
        <label for="x__sort" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_faculty__sort"><?= $Page->_sort->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z__sort" id="z__sort" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->_sort->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_faculty__sort" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->_sort->getInputTextType() ?>" name="x__sort" id="x__sort" data-table="s_faculty" data-field="x__sort" value="<?= $Page->_sort->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->_sort->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_sort->formatPattern()) ?>"<?= $Page->_sort->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->_sort->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fs_facultysearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fs_facultysearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fs_facultysearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_faculty");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
