<?php

namespace PHPMaker2024\fibre;

// Page object
$SEpcDataSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_epc_data: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fs_epc_datasearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_epc_datasearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["inout_datetime", [ew.Validators.datetime(fields.inout_datetime.clientFormatPattern)], fields.inout_datetime.isInvalid],
            ["y_inout_datetime", [ew.Validators.between], false],
            ["in_out", [], fields.in_out.isInvalid],
            ["unit_id", [], fields.unit_id.isInvalid],
            ["s_pid", [], fields.s_pid.isInvalid],
            ["faculty", [], fields.faculty.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["m_type", [ew.Validators.integer], fields.m_type.isInvalid],
            ["m_status", [], fields.m_status.isInvalid],
            ["m_datetime", [ew.Validators.datetime(fields.m_datetime.clientFormatPattern)], fields.m_datetime.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["remarks", [], fields.remarks.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "unit_id": <?= $Page->unit_id->toClientList($Page) ?>,
            "s_pid": <?= $Page->s_pid->toClientList($Page) ?>,
            "faculty": <?= $Page->faculty->toClientList($Page) ?>,
            "m_type": <?= $Page->m_type->toClientList($Page) ?>,
            "m_status": <?= $Page->m_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fs_epc_datasearch" id="fs_epc_datasearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_epc_data">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="s_epc_data" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->inout_datetime->Visible) { // inout_datetime ?>
    <div id="r_inout_datetime" class="row"<?= $Page->inout_datetime->rowAttributes() ?>>
        <label for="x_inout_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_inout_datetime"><?= $Page->inout_datetime->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->inout_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_inout_datetime" id="z_inout_datetime" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->inout_datetime->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->inout_datetime->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_s_epc_data_inout_datetime" class="ew-search-field">
<input type="<?= $Page->inout_datetime->getInputTextType() ?>" name="x_inout_datetime" id="x_inout_datetime" data-table="s_epc_data" data-field="x_inout_datetime" value="<?= $Page->inout_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->inout_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->inout_datetime->formatPattern()) ?>"<?= $Page->inout_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->inout_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->inout_datetime->ReadOnly && !$Page->inout_datetime->Disabled && !isset($Page->inout_datetime->EditAttrs["readonly"]) && !isset($Page->inout_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_epc_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_epc_datasearch", "x_inout_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_s_epc_data_inout_datetime" class="ew-search-field2 d-none">
<input type="<?= $Page->inout_datetime->getInputTextType() ?>" name="y_inout_datetime" id="y_inout_datetime" data-table="s_epc_data" data-field="x_inout_datetime" value="<?= $Page->inout_datetime->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->inout_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->inout_datetime->formatPattern()) ?>"<?= $Page->inout_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->inout_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->inout_datetime->ReadOnly && !$Page->inout_datetime->Disabled && !isset($Page->inout_datetime->EditAttrs["readonly"]) && !isset($Page->inout_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_epc_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_epc_datasearch", "y_inout_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->in_out->Visible) { // in_out ?>
    <div id="r_in_out" class="row"<?= $Page->in_out->rowAttributes() ?>>
        <label for="x_in_out" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_in_out"><?= $Page->in_out->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_in_out" id="z_in_out" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->in_out->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_in_out" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->in_out->getInputTextType() ?>" name="x_in_out" id="x_in_out" data-table="s_epc_data" data-field="x_in_out" value="<?= $Page->in_out->EditValue ?>" size="30" maxlength="6" placeholder="<?= HtmlEncode($Page->in_out->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->in_out->formatPattern()) ?>"<?= $Page->in_out->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->in_out->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unit_id->Visible) { // unit_id ?>
    <div id="r_unit_id" class="row"<?= $Page->unit_id->rowAttributes() ?>>
        <label for="x_unit_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_unit_id"><?= $Page->unit_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unit_id" id="z_unit_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unit_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_unit_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit_id"
        name="x_unit_id"
        class="form-select ew-select<?= $Page->unit_id->isInvalidClass() ?>"
        <?php if (!$Page->unit_id->IsNativeSelect) { ?>
        data-select2-id="fs_epc_datasearch_x_unit_id"
        <?php } ?>
        data-table="s_epc_data"
        data-field="x_unit_id"
        data-value-separator="<?= $Page->unit_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit_id->getPlaceHolder()) ?>"
        <?= $Page->unit_id->editAttributes() ?>>
        <?= $Page->unit_id->selectOptionListHtml("x_unit_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit_id->getErrorMessage(false) ?></div>
<?php if (!$Page->unit_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_epc_datasearch", function() {
    var options = { name: "x_unit_id", selectId: "fs_epc_datasearch_x_unit_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_epc_datasearch.lists.unit_id?.lookupOptions.length) {
        options.data = { id: "x_unit_id", form: "fs_epc_datasearch" };
    } else {
        options.ajax = { id: "x_unit_id", form: "fs_epc_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_epc_data.fields.unit_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_pid->Visible) { // s_pid ?>
    <div id="r_s_pid" class="row"<?= $Page->s_pid->rowAttributes() ?>>
        <label for="x_s_pid" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_s_pid"><?= $Page->s_pid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_s_pid" id="z_s_pid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_pid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_s_pid" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_pid"
        name="x_s_pid"
        class="form-control ew-select<?= $Page->s_pid->isInvalidClass() ?>"
        data-select2-id="fs_epc_datasearch_x_s_pid"
        data-table="s_epc_data"
        data-field="x_s_pid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->s_pid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->s_pid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_pid->getPlaceHolder()) ?>"
        <?= $Page->s_pid->editAttributes() ?>>
        <?= $Page->s_pid->selectOptionListHtml("x_s_pid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_pid->getErrorMessage(false) ?></div>
<?= $Page->s_pid->Lookup->getParamTag($Page, "p_x_s_pid") ?>
<script>
loadjs.ready("fs_epc_datasearch", function() {
    var options = { name: "x_s_pid", selectId: "fs_epc_datasearch_x_s_pid" };
    if (fs_epc_datasearch.lists.s_pid?.lookupOptions.length) {
        options.data = { id: "x_s_pid", form: "fs_epc_datasearch" };
    } else {
        options.ajax = { id: "x_s_pid", form: "fs_epc_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.s_epc_data.fields.s_pid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->faculty->Visible) { // faculty ?>
    <div id="r_faculty" class="row"<?= $Page->faculty->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_faculty"><?= $Page->faculty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_faculty" id="z_faculty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->faculty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_faculty" class="ew-search-field ew-search-field-single">
    <select
        id="x_faculty"
        name="x_faculty"
        class="form-control ew-select<?= $Page->faculty->isInvalidClass() ?>"
        data-select2-id="fs_epc_datasearch_x_faculty"
        data-table="s_epc_data"
        data-field="x_faculty"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->faculty->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->faculty->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>"
        <?= $Page->faculty->editAttributes() ?>>
        <?= $Page->faculty->selectOptionListHtml("x_faculty") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->faculty->getErrorMessage(false) ?></div>
<?= $Page->faculty->Lookup->getParamTag($Page, "p_x_faculty") ?>
<script>
loadjs.ready("fs_epc_datasearch", function() {
    var options = { name: "x_faculty", selectId: "fs_epc_datasearch_x_faculty" };
    if (fs_epc_datasearch.lists.faculty?.lookupOptions.length) {
        options.data = { id: "x_faculty", form: "fs_epc_datasearch" };
    } else {
        options.ajax = { id: "x_faculty", form: "fs_epc_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.s_epc_data.fields.faculty.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
    <div id="r_mobile" class="row"<?= $Page->mobile->rowAttributes() ?>>
        <label for="x_mobile" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_mobile"><?= $Page->mobile->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_mobile" id="z_mobile" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mobile->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="s_epc_data" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->m_type->Visible) { // m_type ?>
    <div id="r_m_type" class="row"<?= $Page->m_type->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_m_type"><?= $Page->m_type->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_m_type" id="z_m_type" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->m_type->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_m_type" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->m_type->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_m_type" class="ew-auto-suggest">
    <input type="<?= $Page->m_type->getInputTextType() ?>" class="form-control" name="sv_x_m_type" id="sv_x_m_type" value="<?= RemoveHtml($Page->m_type->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->m_type->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->m_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->m_type->formatPattern()) ?>"<?= $Page->m_type->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_epc_data" data-field="x_m_type" data-input="sv_x_m_type" data-value-separator="<?= $Page->m_type->displayValueSeparatorAttribute() ?>" name="x_m_type" id="x_m_type" value="<?= HtmlEncode($Page->m_type->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->m_type->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fs_epc_datasearch", function() {
    fs_epc_datasearch.createAutoSuggest(Object.assign({"id":"x_m_type","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->m_type->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_epc_data.fields.m_type.autoSuggestOptions));
});
</script>
<?= $Page->m_type->Lookup->getParamTag($Page, "p_x_m_type") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->m_status->Visible) { // m_status ?>
    <div id="r_m_status" class="row"<?= $Page->m_status->rowAttributes() ?>>
        <label for="x_m_status" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_m_status"><?= $Page->m_status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_m_status" id="z_m_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->m_status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_m_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_m_status"
        name="x_m_status"
        class="form-select ew-select<?= $Page->m_status->isInvalidClass() ?>"
        <?php if (!$Page->m_status->IsNativeSelect) { ?>
        data-select2-id="fs_epc_datasearch_x_m_status"
        <?php } ?>
        data-table="s_epc_data"
        data-field="x_m_status"
        data-value-separator="<?= $Page->m_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_status->getPlaceHolder()) ?>"
        <?= $Page->m_status->editAttributes() ?>>
        <?= $Page->m_status->selectOptionListHtml("x_m_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_status->getErrorMessage(false) ?></div>
<?php if (!$Page->m_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_epc_datasearch", function() {
    var options = { name: "x_m_status", selectId: "fs_epc_datasearch_x_m_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_epc_datasearch.lists.m_status?.lookupOptions.length) {
        options.data = { id: "x_m_status", form: "fs_epc_datasearch" };
    } else {
        options.ajax = { id: "x_m_status", form: "fs_epc_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_epc_data.fields.m_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->m_datetime->Visible) { // m_datetime ?>
    <div id="r_m_datetime" class="row"<?= $Page->m_datetime->rowAttributes() ?>>
        <label for="x_m_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_m_datetime"><?= $Page->m_datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_m_datetime" id="z_m_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->m_datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_m_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->m_datetime->getInputTextType() ?>" name="x_m_datetime" id="x_m_datetime" data-table="s_epc_data" data-field="x_m_datetime" value="<?= $Page->m_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->m_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->m_datetime->formatPattern()) ?>"<?= $Page->m_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->m_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->m_datetime->ReadOnly && !$Page->m_datetime->Disabled && !isset($Page->m_datetime->EditAttrs["readonly"]) && !isset($Page->m_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_epc_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_epc_datasearch", "x_m_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="s_epc_data" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="s_epc_data" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_epc_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_epc_datasearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_epc_data_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_epc_data_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="s_epc_data" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fs_epc_datasearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fs_epc_datasearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fs_epc_datasearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_epc_data");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
