<?php

namespace PHPMaker2024\fibre;

// Page object
$SEpcDataSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_epc_data: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fs_epc_datasearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_epc_datasearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["inout_datetime", [ew.Validators.datetime(fields.inout_datetime.clientFormatPattern)], fields.inout_datetime.isInvalid],
            ["y_inout_datetime", [ew.Validators.between], false],
            ["in_out", [], fields.in_out.isInvalid],
            ["unit_id", [], fields.unit_id.isInvalid],
            ["s_pid", [], fields.s_pid.isInvalid],
            ["faculty", [], fields.faculty.isInvalid],
            ["mobile", [], fields.mobile.isInvalid],
            ["m_type", [ew.Validators.integer], fields.m_type.isInvalid],
            ["m_status", [], fields.m_status.isInvalid],
            ["m_datetime", [ew.Validators.datetime(fields.m_datetime.clientFormatPattern)], fields.m_datetime.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.datetime(fields.datetime.clientFormatPattern)], fields.datetime.isInvalid],
            ["remarks", [], fields.remarks.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "unit_id": <?= $Page->unit_id->toClientList($Page) ?>,
            "s_pid": <?= $Page->s_pid->toClientList($Page) ?>,
            "faculty": <?= $Page->faculty->toClientList($Page) ?>,
            "m_type": <?= $Page->m_type->toClientList($Page) ?>,
            "m_status": <?= $Page->m_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fs_epc_datasearch" id="fs_epc_datasearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("sepcdatalist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_epc_data">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_s_epc_data_id" class="s_epc_datasearch"><span id="el_s_epc_data_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="s_epc_data" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_epc_data_inout_datetime" class="s_epc_datasearch"><span id="el_s_epc_data_inout_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->inout_datetime->getInputTextType() ?>" name="x_inout_datetime" id="x_inout_datetime" data-table="s_epc_data" data-field="x_inout_datetime" value="<?= $Page->inout_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->inout_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->inout_datetime->formatPattern()) ?>"<?= $Page->inout_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->inout_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->inout_datetime->ReadOnly && !$Page->inout_datetime->Disabled && !isset($Page->inout_datetime->EditAttrs["readonly"]) && !isset($Page->inout_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_epc_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_epc_datasearch", "x_inout_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_epc_data_in_out" class="s_epc_datasearch"><span id="el_s_epc_data_in_out" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->in_out->getInputTextType() ?>" name="x_in_out" id="x_in_out" data-table="s_epc_data" data-field="x_in_out" value="<?= $Page->in_out->EditValue ?>" size="30" maxlength="6" placeholder="<?= HtmlEncode($Page->in_out->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->in_out->formatPattern()) ?>"<?= $Page->in_out->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->in_out->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_epc_data_unit_id" class="s_epc_datasearch"><span id="el_s_epc_data_unit_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit_id"
        name="x_unit_id"
        class="form-select ew-select<?= $Page->unit_id->isInvalidClass() ?>"
        <?php if (!$Page->unit_id->IsNativeSelect) { ?>
        data-select2-id="fs_epc_datasearch_x_unit_id"
        <?php } ?>
        data-table="s_epc_data"
        data-field="x_unit_id"
        data-value-separator="<?= $Page->unit_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit_id->getPlaceHolder()) ?>"
        <?= $Page->unit_id->editAttributes() ?>>
        <?= $Page->unit_id->selectOptionListHtml("x_unit_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit_id->getErrorMessage(false) ?></div>
<?php if (!$Page->unit_id->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_epc_datasearch", function() {
    var options = { name: "x_unit_id", selectId: "fs_epc_datasearch_x_unit_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_epc_datasearch.lists.unit_id?.lookupOptions.length) {
        options.data = { id: "x_unit_id", form: "fs_epc_datasearch" };
    } else {
        options.ajax = { id: "x_unit_id", form: "fs_epc_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_epc_data.fields.unit_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_epc_data_s_pid" class="s_epc_datasearch"><span id="el_s_epc_data_s_pid" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_pid"
        name="x_s_pid"
        class="form-control ew-select<?= $Page->s_pid->isInvalidClass() ?>"
        data-select2-id="fs_epc_datasearch_x_s_pid"
        data-table="s_epc_data"
        data-field="x_s_pid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->s_pid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->s_pid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_pid->getPlaceHolder()) ?>"
        <?= $Page->s_pid->editAttributes() ?>>
        <?= $Page->s_pid->selectOptionListHtml("x_s_pid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_pid->getErrorMessage(false) ?></div>
<?= $Page->s_pid->Lookup->getParamTag($Page, "p_x_s_pid") ?>
<script>
loadjs.ready("fs_epc_datasearch", function() {
    var options = { name: "x_s_pid", selectId: "fs_epc_datasearch_x_s_pid" };
    if (fs_epc_datasearch.lists.s_pid?.lookupOptions.length) {
        options.data = { id: "x_s_pid", form: "fs_epc_datasearch" };
    } else {
        options.ajax = { id: "x_s_pid", form: "fs_epc_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.s_epc_data.fields.s_pid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_s_epc_data_faculty" class="s_epc_datasearch"><span id="el_s_epc_data_faculty" class="ew-search-field ew-search-field-single">
    <select
        id="x_faculty"
        name="x_faculty"
        class="form-control ew-select<?= $Page->faculty->isInvalidClass() ?>"
        data-select2-id="fs_epc_datasearch_x_faculty"
        data-table="s_epc_data"
        data-field="x_faculty"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->faculty->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->faculty->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>"
        <?= $Page->faculty->editAttributes() ?>>
        <?= $Page->faculty->selectOptionListHtml("x_faculty") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->faculty->getErrorMessage(false) ?></div>
<?= $Page->faculty->Lookup->getParamTag($Page, "p_x_faculty") ?>
<script>
loadjs.ready("fs_epc_datasearch", function() {
    var options = { name: "x_faculty", selectId: "fs_epc_datasearch_x_faculty" };
    if (fs_epc_datasearch.lists.faculty?.lookupOptions.length) {
        options.data = { id: "x_faculty", form: "fs_epc_datasearch" };
    } else {
        options.ajax = { id: "x_faculty", form: "fs_epc_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.s_epc_data.fields.faculty.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_s_epc_data_mobile" class="s_epc_datasearch"><span id="el_s_epc_data_mobile" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mobile->getInputTextType() ?>" name="x_mobile" id="x_mobile" data-table="s_epc_data" data-field="x_mobile" value="<?= $Page->mobile->EditValue ?>" size="30" maxlength="10" placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mobile->formatPattern()) ?>"<?= $Page->mobile->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_epc_data_m_type" class="s_epc_datasearch"><span id="el_s_epc_data_m_type" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->m_type->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_m_type" class="ew-auto-suggest">
    <input type="<?= $Page->m_type->getInputTextType() ?>" class="form-control" name="sv_x_m_type" id="sv_x_m_type" value="<?= RemoveHtml($Page->m_type->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->m_type->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->m_type->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->m_type->formatPattern()) ?>"<?= $Page->m_type->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_epc_data" data-field="x_m_type" data-input="sv_x_m_type" data-value-separator="<?= $Page->m_type->displayValueSeparatorAttribute() ?>" name="x_m_type" id="x_m_type" value="<?= HtmlEncode($Page->m_type->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->m_type->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fs_epc_datasearch", function() {
    fs_epc_datasearch.createAutoSuggest(Object.assign({"id":"x_m_type","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->m_type->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_epc_data.fields.m_type.autoSuggestOptions));
});
</script>
<?= $Page->m_type->Lookup->getParamTag($Page, "p_x_m_type") ?>
</span></template>
<template id="tpx_s_epc_data_m_status" class="s_epc_datasearch"><span id="el_s_epc_data_m_status" class="ew-search-field ew-search-field-single">
    <select
        id="x_m_status"
        name="x_m_status"
        class="form-select ew-select<?= $Page->m_status->isInvalidClass() ?>"
        <?php if (!$Page->m_status->IsNativeSelect) { ?>
        data-select2-id="fs_epc_datasearch_x_m_status"
        <?php } ?>
        data-table="s_epc_data"
        data-field="x_m_status"
        data-value-separator="<?= $Page->m_status->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->m_status->getPlaceHolder()) ?>"
        <?= $Page->m_status->editAttributes() ?>>
        <?= $Page->m_status->selectOptionListHtml("x_m_status") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->m_status->getErrorMessage(false) ?></div>
<?php if (!$Page->m_status->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_epc_datasearch", function() {
    var options = { name: "x_m_status", selectId: "fs_epc_datasearch_x_m_status" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_epc_datasearch.lists.m_status?.lookupOptions.length) {
        options.data = { id: "x_m_status", form: "fs_epc_datasearch" };
    } else {
        options.ajax = { id: "x_m_status", form: "fs_epc_datasearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_epc_data.fields.m_status.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_epc_data_m_datetime" class="s_epc_datasearch"><span id="el_s_epc_data_m_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->m_datetime->getInputTextType() ?>" name="x_m_datetime" id="x_m_datetime" data-table="s_epc_data" data-field="x_m_datetime" value="<?= $Page->m_datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->m_datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->m_datetime->formatPattern()) ?>"<?= $Page->m_datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->m_datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->m_datetime->ReadOnly && !$Page->m_datetime->Disabled && !isset($Page->m_datetime->EditAttrs["readonly"]) && !isset($Page->m_datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_epc_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(111) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_epc_datasearch", "x_m_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_epc_data_operator" class="s_epc_datasearch"><span id="el_s_epc_data_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="s_epc_data" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_epc_data_datetime" class="s_epc_datasearch"><span id="el_s_epc_data_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="s_epc_data" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
<?php if (!$Page->datetime->ReadOnly && !$Page->datetime->Disabled && !isset($Page->datetime->EditAttrs["readonly"]) && !isset($Page->datetime->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fs_epc_datasearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(0) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    clock: !!format.match(/h/i) || !!format.match(/m/) || !!format.match(/s/i),
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fs_epc_datasearch", "x_datetime", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false},"inputGroup":false}, options));
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_epc_data_remarks" class="s_epc_datasearch"><span id="el_s_epc_data_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="s_epc_data" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="500" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span></template>
<div id="s_epc_data_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "inout_datetime",
                type: "datetime",
                label: currentTable.fields.inout_datetime.caption,
                operators: currentTable.fields.inout_datetime.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.inout_datetime.validators),
                data: {
                    format: currentTable.fields.inout_datetime.clientFormatPattern
                }
            },
            {
                id: "in_out",
                type: "string",
                label: currentTable.fields.in_out.caption,
                operators: currentTable.fields.in_out.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.in_out.validators),
                data: {
                    format: currentTable.fields.in_out.clientFormatPattern
                }
            },
            {
                id: "unit_id",
                type: "integer",
                label: currentTable.fields.unit_id.caption,
                operators: currentTable.fields.unit_id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.unit_id.validators),
                data: {
                    format: currentTable.fields.unit_id.clientFormatPattern
                }
            },
            {
                id: "s_pid",
                type: "string",
                label: currentTable.fields.s_pid.caption,
                operators: currentTable.fields.s_pid.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.s_pid.validators),
                data: {
                    format: currentTable.fields.s_pid.clientFormatPattern
                }
            },
            {
                id: "faculty",
                type: "integer",
                label: currentTable.fields.faculty.caption,
                operators: currentTable.fields.faculty.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.faculty.validators),
                data: {
                    format: currentTable.fields.faculty.clientFormatPattern
                }
            },
            {
                id: "mobile",
                type: "string",
                label: currentTable.fields.mobile.caption,
                operators: currentTable.fields.mobile.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.mobile.validators),
                data: {
                    format: currentTable.fields.mobile.clientFormatPattern
                }
            },
            {
                id: "m_type",
                type: "integer",
                label: currentTable.fields.m_type.caption,
                operators: currentTable.fields.m_type.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.m_type.validators),
                data: {
                    format: currentTable.fields.m_type.clientFormatPattern
                }
            },
            {
                id: "m_status",
                type: "integer",
                label: currentTable.fields.m_status.caption,
                operators: currentTable.fields.m_status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.m_status.validators),
                data: {
                    format: currentTable.fields.m_status.clientFormatPattern
                }
            },
            {
                id: "m_datetime",
                type: "datetime",
                label: currentTable.fields.m_datetime.caption,
                operators: currentTable.fields.m_datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.m_datetime.validators),
                data: {
                    format: currentTable.fields.m_datetime.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
            {
                id: "remarks",
                type: "string",
                label: currentTable.fields.remarks.caption,
                operators: currentTable.fields.remarks.clientSearchOperators,
                default_operator: "contains",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_epc_datasearch.fields.remarks.validators),
                data: {
                    format: currentTable.fields.remarks.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#s_epc_data_query_builder"),
        args = {},
        rules = ew.parseJson($("#fs_epc_datasearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fs_epc_datasearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fs_epc_datasearch" formaction="<?= HtmlEncode(GetUrl("sepcdatalist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fs_epc_datasearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fs_epc_datasearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_epc_data");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
