<?php

namespace PHPMaker2024\fibre;

// Page object
$SEpcDataList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_epc_data: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "in_out": <?= $Page->in_out->toClientList($Page) ?>,
            "unit_id": <?= $Page->unit_id->toClientList($Page) ?>,
            "s_pid": <?= $Page->s_pid->toClientList($Page) ?>,
            "faculty": <?= $Page->faculty->toClientList($Page) ?>,
            "mobile": <?= $Page->mobile->toClientList($Page) ?>,
            "m_type": <?= $Page->m_type->toClientList($Page) ?>,
            "m_status": <?= $Page->m_status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fs_epc_datasrch" id="fs_epc_datasrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fs_epc_datasrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_epc_data: currentTable } });
var currentForm;
var fs_epc_datasrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_epc_datasrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "in_out": <?= $Page->in_out->toClientList($Page) ?>,
            "unit_id": <?= $Page->unit_id->toClientList($Page) ?>,
            "s_pid": <?= $Page->s_pid->toClientList($Page) ?>,
            "faculty": <?= $Page->faculty->toClientList($Page) ?>,
            "mobile": <?= $Page->mobile->toClientList($Page) ?>,
            "m_type": <?= $Page->m_type->toClientList($Page) ?>,
            "m_status": <?= $Page->m_status->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->in_out->Visible) { // in_out ?>
<?php
if (!$Page->in_out->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_in_out" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->in_out->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_in_out"
            name="x_in_out[]"
            class="form-control ew-select<?= $Page->in_out->isInvalidClass() ?>"
            data-select2-id="fs_epc_datasrch_x_in_out"
            data-table="s_epc_data"
            data-field="x_in_out"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->in_out->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->in_out->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->in_out->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->in_out->editAttributes() ?>>
            <?= $Page->in_out->selectOptionListHtml("x_in_out", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->in_out->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_epc_datasrch", function() {
            var options = {
                name: "x_in_out",
                selectId: "fs_epc_datasrch_x_in_out",
                ajax: { id: "x_in_out", form: "fs_epc_datasrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_epc_data.fields.in_out.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->unit_id->Visible) { // unit_id ?>
<?php
if (!$Page->unit_id->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_unit_id" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->unit_id->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_unit_id"
            name="x_unit_id[]"
            class="form-control ew-select<?= $Page->unit_id->isInvalidClass() ?>"
            data-select2-id="fs_epc_datasrch_x_unit_id"
            data-table="s_epc_data"
            data-field="x_unit_id"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->unit_id->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->unit_id->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->unit_id->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->unit_id->editAttributes() ?>>
            <?= $Page->unit_id->selectOptionListHtml("x_unit_id", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->unit_id->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_epc_datasrch", function() {
            var options = {
                name: "x_unit_id",
                selectId: "fs_epc_datasrch_x_unit_id",
                ajax: { id: "x_unit_id", form: "fs_epc_datasrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_epc_data.fields.unit_id.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->s_pid->Visible) { // s_pid ?>
<?php
if (!$Page->s_pid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_s_pid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->s_pid->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_s_pid"
            name="x_s_pid[]"
            class="form-control ew-select<?= $Page->s_pid->isInvalidClass() ?>"
            data-select2-id="fs_epc_datasrch_x_s_pid"
            data-table="s_epc_data"
            data-field="x_s_pid"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->s_pid->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->s_pid->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->s_pid->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->s_pid->editAttributes() ?>>
            <?= $Page->s_pid->selectOptionListHtml("x_s_pid", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->s_pid->getErrorMessage(false) ?></div>
        <?= $Page->s_pid->Lookup->getParamTag($Page, "p_x_s_pid") ?>
        <script>
        loadjs.ready("fs_epc_datasrch", function() {
            var options = {
                name: "x_s_pid",
                selectId: "fs_epc_datasrch_x_s_pid",
                ajax: { id: "x_s_pid", form: "fs_epc_datasrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_epc_data.fields.s_pid.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->faculty->Visible) { // faculty ?>
<?php
if (!$Page->faculty->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_faculty" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->faculty->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_faculty"
            name="x_faculty[]"
            class="form-control ew-select<?= $Page->faculty->isInvalidClass() ?>"
            data-select2-id="fs_epc_datasrch_x_faculty"
            data-table="s_epc_data"
            data-field="x_faculty"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->faculty->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->faculty->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->faculty->editAttributes() ?>>
            <?= $Page->faculty->selectOptionListHtml("x_faculty", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->faculty->getErrorMessage(false) ?></div>
        <?= $Page->faculty->Lookup->getParamTag($Page, "p_x_faculty") ?>
        <script>
        loadjs.ready("fs_epc_datasrch", function() {
            var options = {
                name: "x_faculty",
                selectId: "fs_epc_datasrch_x_faculty",
                ajax: { id: "x_faculty", form: "fs_epc_datasrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_epc_data.fields.faculty.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
<?php
if (!$Page->mobile->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_mobile" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->mobile->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_mobile"
            name="x_mobile[]"
            class="form-control ew-select<?= $Page->mobile->isInvalidClass() ?>"
            data-select2-id="fs_epc_datasrch_x_mobile"
            data-table="s_epc_data"
            data-field="x_mobile"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->mobile->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->mobile->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->mobile->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->mobile->editAttributes() ?>>
            <?= $Page->mobile->selectOptionListHtml("x_mobile", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->mobile->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_epc_datasrch", function() {
            var options = {
                name: "x_mobile",
                selectId: "fs_epc_datasrch_x_mobile",
                ajax: { id: "x_mobile", form: "fs_epc_datasrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_epc_data.fields.mobile.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->m_type->Visible) { // m_type ?>
<?php
if (!$Page->m_type->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_m_type" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->m_type->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_m_type"
            name="x_m_type[]"
            class="form-control ew-select<?= $Page->m_type->isInvalidClass() ?>"
            data-select2-id="fs_epc_datasrch_x_m_type"
            data-table="s_epc_data"
            data-field="x_m_type"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->m_type->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->m_type->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->m_type->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->m_type->editAttributes() ?>>
            <?= $Page->m_type->selectOptionListHtml("x_m_type", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->m_type->getErrorMessage(false) ?></div>
        <?= $Page->m_type->Lookup->getParamTag($Page, "p_x_m_type") ?>
        <script>
        loadjs.ready("fs_epc_datasrch", function() {
            var options = {
                name: "x_m_type",
                selectId: "fs_epc_datasrch_x_m_type",
                ajax: { id: "x_m_type", form: "fs_epc_datasrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_epc_data.fields.m_type.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->m_status->Visible) { // m_status ?>
<?php
if (!$Page->m_status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_m_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->m_status->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_m_status"
            name="x_m_status[]"
            class="form-control ew-select<?= $Page->m_status->isInvalidClass() ?>"
            data-select2-id="fs_epc_datasrch_x_m_status"
            data-table="s_epc_data"
            data-field="x_m_status"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->m_status->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->m_status->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->m_status->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->m_status->editAttributes() ?>>
            <?= $Page->m_status->selectOptionListHtml("x_m_status", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->m_status->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_epc_datasrch", function() {
            var options = {
                name: "x_m_status",
                selectId: "fs_epc_datasrch_x_m_status",
                ajax: { id: "x_m_status", form: "fs_epc_datasrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_epc_data.fields.m_status.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fs_epc_datasrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fs_epc_datasrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fs_epc_datasrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fs_epc_datasrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fs_epc_datasrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fs_epc_datasrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fs_epc_datasrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_epc_data">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_s_epc_data" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_s_epc_datalist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_s_epc_data_id" class="s_epc_data_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->inout_datetime->Visible) { // inout_datetime ?>
        <th data-name="inout_datetime" class="<?= $Page->inout_datetime->headerCellClass() ?>"><div id="elh_s_epc_data_inout_datetime" class="s_epc_data_inout_datetime"><?= $Page->renderFieldHeader($Page->inout_datetime) ?></div></th>
<?php } ?>
<?php if ($Page->in_out->Visible) { // in_out ?>
        <th data-name="in_out" class="<?= $Page->in_out->headerCellClass() ?>"><div id="elh_s_epc_data_in_out" class="s_epc_data_in_out"><?= $Page->renderFieldHeader($Page->in_out) ?></div></th>
<?php } ?>
<?php if ($Page->unit_id->Visible) { // unit_id ?>
        <th data-name="unit_id" class="<?= $Page->unit_id->headerCellClass() ?>"><div id="elh_s_epc_data_unit_id" class="s_epc_data_unit_id"><?= $Page->renderFieldHeader($Page->unit_id) ?></div></th>
<?php } ?>
<?php if ($Page->s_pid->Visible) { // s_pid ?>
        <th data-name="s_pid" class="<?= $Page->s_pid->headerCellClass() ?>"><div id="elh_s_epc_data_s_pid" class="s_epc_data_s_pid"><?= $Page->renderFieldHeader($Page->s_pid) ?></div></th>
<?php } ?>
<?php if ($Page->faculty->Visible) { // faculty ?>
        <th data-name="faculty" class="<?= $Page->faculty->headerCellClass() ?>"><div id="elh_s_epc_data_faculty" class="s_epc_data_faculty"><?= $Page->renderFieldHeader($Page->faculty) ?></div></th>
<?php } ?>
<?php if ($Page->mobile->Visible) { // mobile ?>
        <th data-name="mobile" class="<?= $Page->mobile->headerCellClass() ?>"><div id="elh_s_epc_data_mobile" class="s_epc_data_mobile"><?= $Page->renderFieldHeader($Page->mobile) ?></div></th>
<?php } ?>
<?php if ($Page->m_type->Visible) { // m_type ?>
        <th data-name="m_type" class="<?= $Page->m_type->headerCellClass() ?>"><div id="elh_s_epc_data_m_type" class="s_epc_data_m_type"><?= $Page->renderFieldHeader($Page->m_type) ?></div></th>
<?php } ?>
<?php if ($Page->m_status->Visible) { // m_status ?>
        <th data-name="m_status" class="<?= $Page->m_status->headerCellClass() ?>"><div id="elh_s_epc_data_m_status" class="s_epc_data_m_status"><?= $Page->renderFieldHeader($Page->m_status) ?></div></th>
<?php } ?>
<?php if ($Page->m_datetime->Visible) { // m_datetime ?>
        <th data-name="m_datetime" class="<?= $Page->m_datetime->headerCellClass() ?>"><div id="elh_s_epc_data_m_datetime" class="s_epc_data_m_datetime"><?= $Page->renderFieldHeader($Page->m_datetime) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_s_epc_data_operator" class="s_epc_data_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_s_epc_data_datetime" class="s_epc_data_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_id" class="el_s_epc_data_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->inout_datetime->Visible) { // inout_datetime ?>
        <td data-name="inout_datetime"<?= $Page->inout_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_inout_datetime" class="el_s_epc_data_inout_datetime">
<span<?= $Page->inout_datetime->viewAttributes() ?>>
<?= $Page->inout_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->in_out->Visible) { // in_out ?>
        <td data-name="in_out"<?= $Page->in_out->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_in_out" class="el_s_epc_data_in_out">
<span<?= $Page->in_out->viewAttributes() ?>>
<?= $Page->in_out->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->unit_id->Visible) { // unit_id ?>
        <td data-name="unit_id"<?= $Page->unit_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_unit_id" class="el_s_epc_data_unit_id">
<span<?= $Page->unit_id->viewAttributes() ?>>
<?= $Page->unit_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_pid->Visible) { // s_pid ?>
        <td data-name="s_pid"<?= $Page->s_pid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_s_pid" class="el_s_epc_data_s_pid">
<span<?= $Page->s_pid->viewAttributes() ?>>
<?= $Page->s_pid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->faculty->Visible) { // faculty ?>
        <td data-name="faculty"<?= $Page->faculty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_faculty" class="el_s_epc_data_faculty">
<span<?= $Page->faculty->viewAttributes() ?>>
<?= $Page->faculty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mobile->Visible) { // mobile ?>
        <td data-name="mobile"<?= $Page->mobile->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_mobile" class="el_s_epc_data_mobile">
<span<?= $Page->mobile->viewAttributes() ?>>
<?= $Page->mobile->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_type->Visible) { // m_type ?>
        <td data-name="m_type"<?= $Page->m_type->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_m_type" class="el_s_epc_data_m_type">
<span<?= $Page->m_type->viewAttributes() ?>>
<?= $Page->m_type->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_status->Visible) { // m_status ?>
        <td data-name="m_status"<?= $Page->m_status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_m_status" class="el_s_epc_data_m_status">
<span<?= $Page->m_status->viewAttributes() ?>>
<?= $Page->m_status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->m_datetime->Visible) { // m_datetime ?>
        <td data-name="m_datetime"<?= $Page->m_datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_m_datetime" class="el_s_epc_data_m_datetime">
<span<?= $Page->m_datetime->viewAttributes() ?>>
<?= $Page->m_datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_operator" class="el_s_epc_data_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_epc_data_datetime" class="el_s_epc_data_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_epc_data");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
