<?php

namespace PHPMaker2024\fibre;

// Page object
$SAttendanceInfoList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_attendance_info: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Dynamic selection lists
        .setLists({
            "s_pid": <?= $Page->s_pid->toClientList($Page) ?>,
            "faculty": <?= $Page->faculty->toClientList($Page) ?>,
            "dated": <?= $Page->dated->toClientList($Page) ?>,
            "in_out_in": <?= $Page->in_out_in->toClientList($Page) ?>,
            "in_m_status": <?= $Page->in_m_status->toClientList($Page) ?>,
            "in_unit": <?= $Page->in_unit->toClientList($Page) ?>,
            "in_out_out": <?= $Page->in_out_out->toClientList($Page) ?>,
            "out_m_status": <?= $Page->out_m_status->toClientList($Page) ?>,
            "out_unit": <?= $Page->out_unit->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fs_attendance_infosrch" id="fs_attendance_infosrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fs_attendance_infosrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_attendance_info: currentTable } });
var currentForm;
var fs_attendance_infosrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_attendance_infosrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "s_pid": <?= $Page->s_pid->toClientList($Page) ?>,
            "faculty": <?= $Page->faculty->toClientList($Page) ?>,
            "dated": <?= $Page->dated->toClientList($Page) ?>,
            "in_out_in": <?= $Page->in_out_in->toClientList($Page) ?>,
            "in_m_status": <?= $Page->in_m_status->toClientList($Page) ?>,
            "in_unit": <?= $Page->in_unit->toClientList($Page) ?>,
            "in_out_out": <?= $Page->in_out_out->toClientList($Page) ?>,
            "out_m_status": <?= $Page->out_m_status->toClientList($Page) ?>,
            "out_unit": <?= $Page->out_unit->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->s_pid->Visible) { // s_pid ?>
<?php
if (!$Page->s_pid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_s_pid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->s_pid->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_s_pid"
            name="x_s_pid[]"
            class="form-control ew-select<?= $Page->s_pid->isInvalidClass() ?>"
            data-select2-id="fs_attendance_infosrch_x_s_pid"
            data-table="s_attendance_info"
            data-field="x_s_pid"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->s_pid->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->s_pid->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->s_pid->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->s_pid->editAttributes() ?>>
            <?= $Page->s_pid->selectOptionListHtml("x_s_pid", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->s_pid->getErrorMessage(false) ?></div>
        <?= $Page->s_pid->Lookup->getParamTag($Page, "p_x_s_pid") ?>
        <script>
        loadjs.ready("fs_attendance_infosrch", function() {
            var options = {
                name: "x_s_pid",
                selectId: "fs_attendance_infosrch_x_s_pid",
                ajax: { id: "x_s_pid", form: "fs_attendance_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_attendance_info.fields.s_pid.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->faculty->Visible) { // faculty ?>
<?php
if (!$Page->faculty->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_faculty" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->faculty->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_faculty"
            name="x_faculty[]"
            class="form-control ew-select<?= $Page->faculty->isInvalidClass() ?>"
            data-select2-id="fs_attendance_infosrch_x_faculty"
            data-table="s_attendance_info"
            data-field="x_faculty"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->faculty->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->faculty->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->faculty->editAttributes() ?>>
            <?= $Page->faculty->selectOptionListHtml("x_faculty", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->faculty->getErrorMessage(false) ?></div>
        <?= $Page->faculty->Lookup->getParamTag($Page, "p_x_faculty") ?>
        <script>
        loadjs.ready("fs_attendance_infosrch", function() {
            var options = {
                name: "x_faculty",
                selectId: "fs_attendance_infosrch_x_faculty",
                ajax: { id: "x_faculty", form: "fs_attendance_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_attendance_info.fields.faculty.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
<?php
if (!$Page->dated->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_dated" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->dated->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_dated"
            name="x_dated[]"
            class="form-control ew-select<?= $Page->dated->isInvalidClass() ?>"
            data-select2-id="fs_attendance_infosrch_x_dated"
            data-table="s_attendance_info"
            data-field="x_dated"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->dated->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->dated->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->dated->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->dated->editAttributes() ?>>
            <?= $Page->dated->selectOptionListHtml("x_dated", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->dated->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_attendance_infosrch", function() {
            var options = {
                name: "x_dated",
                selectId: "fs_attendance_infosrch_x_dated",
                ajax: { id: "x_dated", form: "fs_attendance_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_attendance_info.fields.dated.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->in_out_in->Visible) { // in_out_in ?>
<?php
if (!$Page->in_out_in->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_in_out_in" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->in_out_in->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_in_out_in"
            name="x_in_out_in[]"
            class="form-control ew-select<?= $Page->in_out_in->isInvalidClass() ?>"
            data-select2-id="fs_attendance_infosrch_x_in_out_in"
            data-table="s_attendance_info"
            data-field="x_in_out_in"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->in_out_in->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->in_out_in->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->in_out_in->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->in_out_in->editAttributes() ?>>
            <?= $Page->in_out_in->selectOptionListHtml("x_in_out_in", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->in_out_in->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_attendance_infosrch", function() {
            var options = {
                name: "x_in_out_in",
                selectId: "fs_attendance_infosrch_x_in_out_in",
                ajax: { id: "x_in_out_in", form: "fs_attendance_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_attendance_info.fields.in_out_in.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->in_m_status->Visible) { // in_m_status ?>
<?php
if (!$Page->in_m_status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_in_m_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->in_m_status->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_in_m_status"
            name="x_in_m_status[]"
            class="form-control ew-select<?= $Page->in_m_status->isInvalidClass() ?>"
            data-select2-id="fs_attendance_infosrch_x_in_m_status"
            data-table="s_attendance_info"
            data-field="x_in_m_status"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->in_m_status->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->in_m_status->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->in_m_status->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->in_m_status->editAttributes() ?>>
            <?= $Page->in_m_status->selectOptionListHtml("x_in_m_status", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->in_m_status->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_attendance_infosrch", function() {
            var options = {
                name: "x_in_m_status",
                selectId: "fs_attendance_infosrch_x_in_m_status",
                ajax: { id: "x_in_m_status", form: "fs_attendance_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_attendance_info.fields.in_m_status.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->in_unit->Visible) { // in_unit ?>
<?php
if (!$Page->in_unit->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_in_unit" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->in_unit->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_in_unit"
            name="x_in_unit[]"
            class="form-control ew-select<?= $Page->in_unit->isInvalidClass() ?>"
            data-select2-id="fs_attendance_infosrch_x_in_unit"
            data-table="s_attendance_info"
            data-field="x_in_unit"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->in_unit->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->in_unit->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->in_unit->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->in_unit->editAttributes() ?>>
            <?= $Page->in_unit->selectOptionListHtml("x_in_unit", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->in_unit->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_attendance_infosrch", function() {
            var options = {
                name: "x_in_unit",
                selectId: "fs_attendance_infosrch_x_in_unit",
                ajax: { id: "x_in_unit", form: "fs_attendance_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_attendance_info.fields.in_unit.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->in_out_out->Visible) { // in_out_out ?>
<?php
if (!$Page->in_out_out->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_in_out_out" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->in_out_out->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_in_out_out"
            name="x_in_out_out[]"
            class="form-control ew-select<?= $Page->in_out_out->isInvalidClass() ?>"
            data-select2-id="fs_attendance_infosrch_x_in_out_out"
            data-table="s_attendance_info"
            data-field="x_in_out_out"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->in_out_out->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->in_out_out->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->in_out_out->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->in_out_out->editAttributes() ?>>
            <?= $Page->in_out_out->selectOptionListHtml("x_in_out_out", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->in_out_out->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_attendance_infosrch", function() {
            var options = {
                name: "x_in_out_out",
                selectId: "fs_attendance_infosrch_x_in_out_out",
                ajax: { id: "x_in_out_out", form: "fs_attendance_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_attendance_info.fields.in_out_out.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->out_m_status->Visible) { // out_m_status ?>
<?php
if (!$Page->out_m_status->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_out_m_status" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->out_m_status->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_out_m_status"
            name="x_out_m_status[]"
            class="form-control ew-select<?= $Page->out_m_status->isInvalidClass() ?>"
            data-select2-id="fs_attendance_infosrch_x_out_m_status"
            data-table="s_attendance_info"
            data-field="x_out_m_status"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->out_m_status->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->out_m_status->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->out_m_status->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->out_m_status->editAttributes() ?>>
            <?= $Page->out_m_status->selectOptionListHtml("x_out_m_status", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->out_m_status->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_attendance_infosrch", function() {
            var options = {
                name: "x_out_m_status",
                selectId: "fs_attendance_infosrch_x_out_m_status",
                ajax: { id: "x_out_m_status", form: "fs_attendance_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_attendance_info.fields.out_m_status.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->out_unit->Visible) { // out_unit ?>
<?php
if (!$Page->out_unit->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_out_unit" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->out_unit->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_out_unit"
            name="x_out_unit[]"
            class="form-control ew-select<?= $Page->out_unit->isInvalidClass() ?>"
            data-select2-id="fs_attendance_infosrch_x_out_unit"
            data-table="s_attendance_info"
            data-field="x_out_unit"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->out_unit->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->out_unit->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->out_unit->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->out_unit->editAttributes() ?>>
            <?= $Page->out_unit->selectOptionListHtml("x_out_unit", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->out_unit->getErrorMessage(false) ?></div>
        <script>
        loadjs.ready("fs_attendance_infosrch", function() {
            var options = {
                name: "x_out_unit",
                selectId: "fs_attendance_infosrch_x_out_unit",
                ajax: { id: "x_out_unit", form: "fs_attendance_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_attendance_info.fields.out_unit.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fs_attendance_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fs_attendance_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fs_attendance_infosrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fs_attendance_infosrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fs_attendance_infosrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fs_attendance_infosrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fs_attendance_infosrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_attendance_info">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_s_attendance_info" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_s_attendance_infolist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_s_attendance_info_id" class="s_attendance_info_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->s_pid->Visible) { // s_pid ?>
        <th data-name="s_pid" class="<?= $Page->s_pid->headerCellClass() ?>"><div id="elh_s_attendance_info_s_pid" class="s_attendance_info_s_pid"><?= $Page->renderFieldHeader($Page->s_pid) ?></div></th>
<?php } ?>
<?php if ($Page->faculty->Visible) { // faculty ?>
        <th data-name="faculty" class="<?= $Page->faculty->headerCellClass() ?>"><div id="elh_s_attendance_info_faculty" class="s_attendance_info_faculty"><?= $Page->renderFieldHeader($Page->faculty) ?></div></th>
<?php } ?>
<?php if ($Page->dated->Visible) { // dated ?>
        <th data-name="dated" class="<?= $Page->dated->headerCellClass() ?>"><div id="elh_s_attendance_info_dated" class="s_attendance_info_dated"><?= $Page->renderFieldHeader($Page->dated) ?></div></th>
<?php } ?>
<?php if ($Page->in_time->Visible) { // in_time ?>
        <th data-name="in_time" class="<?= $Page->in_time->headerCellClass() ?>"><div id="elh_s_attendance_info_in_time" class="s_attendance_info_in_time"><?= $Page->renderFieldHeader($Page->in_time) ?></div></th>
<?php } ?>
<?php if ($Page->in_out_in->Visible) { // in_out_in ?>
        <th data-name="in_out_in" class="<?= $Page->in_out_in->headerCellClass() ?>"><div id="elh_s_attendance_info_in_out_in" class="s_attendance_info_in_out_in"><?= $Page->renderFieldHeader($Page->in_out_in) ?></div></th>
<?php } ?>
<?php if ($Page->in_m_status->Visible) { // in_m_status ?>
        <th data-name="in_m_status" class="<?= $Page->in_m_status->headerCellClass() ?>"><div id="elh_s_attendance_info_in_m_status" class="s_attendance_info_in_m_status"><?= $Page->renderFieldHeader($Page->in_m_status) ?></div></th>
<?php } ?>
<?php if ($Page->in_unit->Visible) { // in_unit ?>
        <th data-name="in_unit" class="<?= $Page->in_unit->headerCellClass() ?>"><div id="elh_s_attendance_info_in_unit" class="s_attendance_info_in_unit"><?= $Page->renderFieldHeader($Page->in_unit) ?></div></th>
<?php } ?>
<?php if ($Page->out_time->Visible) { // out_time ?>
        <th data-name="out_time" class="<?= $Page->out_time->headerCellClass() ?>"><div id="elh_s_attendance_info_out_time" class="s_attendance_info_out_time"><?= $Page->renderFieldHeader($Page->out_time) ?></div></th>
<?php } ?>
<?php if ($Page->in_out_out->Visible) { // in_out_out ?>
        <th data-name="in_out_out" class="<?= $Page->in_out_out->headerCellClass() ?>"><div id="elh_s_attendance_info_in_out_out" class="s_attendance_info_in_out_out"><?= $Page->renderFieldHeader($Page->in_out_out) ?></div></th>
<?php } ?>
<?php if ($Page->out_m_status->Visible) { // out_m_status ?>
        <th data-name="out_m_status" class="<?= $Page->out_m_status->headerCellClass() ?>"><div id="elh_s_attendance_info_out_m_status" class="s_attendance_info_out_m_status"><?= $Page->renderFieldHeader($Page->out_m_status) ?></div></th>
<?php } ?>
<?php if ($Page->out_unit->Visible) { // out_unit ?>
        <th data-name="out_unit" class="<?= $Page->out_unit->headerCellClass() ?>"><div id="elh_s_attendance_info_out_unit" class="s_attendance_info_out_unit"><?= $Page->renderFieldHeader($Page->out_unit) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_id" class="el_s_attendance_info_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->s_pid->Visible) { // s_pid ?>
        <td data-name="s_pid"<?= $Page->s_pid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_s_pid" class="el_s_attendance_info_s_pid">
<span<?= $Page->s_pid->viewAttributes() ?>>
<?= $Page->s_pid->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->faculty->Visible) { // faculty ?>
        <td data-name="faculty"<?= $Page->faculty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_faculty" class="el_s_attendance_info_faculty">
<span<?= $Page->faculty->viewAttributes() ?>>
<?= $Page->faculty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->dated->Visible) { // dated ?>
        <td data-name="dated"<?= $Page->dated->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_dated" class="el_s_attendance_info_dated">
<span<?= $Page->dated->viewAttributes() ?>>
<?= $Page->dated->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->in_time->Visible) { // in_time ?>
        <td data-name="in_time"<?= $Page->in_time->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_in_time" class="el_s_attendance_info_in_time">
<span<?= $Page->in_time->viewAttributes() ?>>
<?= $Page->in_time->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->in_out_in->Visible) { // in_out_in ?>
        <td data-name="in_out_in"<?= $Page->in_out_in->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_in_out_in" class="el_s_attendance_info_in_out_in">
<span<?= $Page->in_out_in->viewAttributes() ?>>
<?= $Page->in_out_in->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->in_m_status->Visible) { // in_m_status ?>
        <td data-name="in_m_status"<?= $Page->in_m_status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_in_m_status" class="el_s_attendance_info_in_m_status">
<span<?= $Page->in_m_status->viewAttributes() ?>>
<?= $Page->in_m_status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->in_unit->Visible) { // in_unit ?>
        <td data-name="in_unit"<?= $Page->in_unit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_in_unit" class="el_s_attendance_info_in_unit">
<span<?= $Page->in_unit->viewAttributes() ?>>
<?= $Page->in_unit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->out_time->Visible) { // out_time ?>
        <td data-name="out_time"<?= $Page->out_time->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_out_time" class="el_s_attendance_info_out_time">
<span<?= $Page->out_time->viewAttributes() ?>>
<?= $Page->out_time->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->in_out_out->Visible) { // in_out_out ?>
        <td data-name="in_out_out"<?= $Page->in_out_out->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_in_out_out" class="el_s_attendance_info_in_out_out">
<span<?= $Page->in_out_out->viewAttributes() ?>>
<?= $Page->in_out_out->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->out_m_status->Visible) { // out_m_status ?>
        <td data-name="out_m_status"<?= $Page->out_m_status->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_out_m_status" class="el_s_attendance_info_out_m_status">
<span<?= $Page->out_m_status->viewAttributes() ?>>
<?= $Page->out_m_status->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->out_unit->Visible) { // out_unit ?>
        <td data-name="out_unit"<?= $Page->out_unit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_attendance_info_out_unit" class="el_s_attendance_info_out_unit">
<span<?= $Page->out_unit->viewAttributes() ?>>
<?= $Page->out_unit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_attendance_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
