<?php

namespace PHPMaker2024\fibre;

// Page object
$SAttendance = &$Page;
?>
<?php
$Page->showMessage();
?>
<?php
//s_attendance
$User_Site = User_Site();
($User_Site == 0) ? $faculty_filter = "" : $faculty_filter = " and FIND_IN_SET(`id`, '$User_Site')";
$faculties = ExecuteRows("SELECT `id`, `fac_sec` FROM `s_faculty` WHERE (`type` = 0 AND `status` = 1 $faculty_filter) order by `sort`");
$selected_faculty = $_GET['faculty'] ?? CurrentUserID();
$action = $_GET['action'] ?? 'CS';

if ($action == 'AB') {
    $result = ExecuteRows("SELECT `s_personal_info`.`id`, `s_personal_info`.`name`, (SELECT ifnull((SELECT `in_out` from `s_epc_live` WHERE `s_pid` = `s_personal_info`.`id` and `in_out` != 'NA' order by `id` desc limit 1), 'NULL')) as `in_out`
        FROM `s_personal_info`
        WHERE `s_personal_info`.`faculty` = $selected_faculty and (SELECT ifnull((SELECT `in_out` from `s_epc_live` WHERE `s_pid` = `s_personal_info`.`id` and `in_out` != 'NA' order by `id` desc limit 1), 'NULL') IN ('AB'))");
} elseif ($action == 'PR') {
     $result = ExecuteRows("SELECT `s_personal_info`.`id`, `s_personal_info`.`name`, (SELECT ifnull((SELECT `in_out` from `s_epc_live` WHERE `s_pid` = `s_personal_info`.`id` and `in_out` != 'NA' order by `id` desc limit 1), 'NULL')) as `in_out`
        FROM `s_personal_info`
        WHERE `s_personal_info`.`faculty` = $selected_faculty and (SELECT ifnull((SELECT `in_out` from `s_epc_live` WHERE `s_pid` = `s_personal_info`.`id` and `in_out` != 'NA' order by `id` desc limit 1), 'NULL') IN ('IN', 'PR'))");

} else {
    $result = ExecuteRows("SELECT `s_personal_info`.`id`, `s_personal_info`.`name`, (SELECT ifnull((SELECT `in_out` from `s_epc_live` WHERE `s_pid` = `s_personal_info`.`id` and `in_out` != 'NA' order by `id` desc limit 1), 'NULL')) as `in_out`
        FROM `s_personal_info`
        WHERE `s_personal_info`.`faculty` = $selected_faculty");
}
?>

<!-- UI Filters -->
<div style="justify-content: space-between; align-items: center; margin-bottom: 20px; max-width: 800px; margin-inline: auto;">
    <h2 style="margin: 0;">Attendance Form</h2><br>
    <div style="display: flex; gap: 10px;">
        <select id="facultySelect" class="filter-btn" onchange="handleFacultyChange()">
            <option value="101">Select Faculty</option>
            <?php foreach ($faculties as $faculty): ?>
                <option value="<?= $faculty['id'] ?>" <?= ($faculty['id'] == $selected_faculty ? 'selected' : '') ?>>
                    <?= htmlspecialchars($faculty['fac_sec']) ?>
                </option>
            <?php endforeach; ?>
        </select>
        <select id="actionSelect" class="filter-btn" onchange="handleActionChange()">
            <option value="PR" <?= ($action == "PR" ? "selected" : "") ?>>List Attendees</option>
            <option value="AB" <?= ($action == "AB" ? "selected" : "") ?>>List Absentees</option>
            <option value="CS" <?= ($action == "CS" ? "selected" : "") ?>>Update Status</option>
        </select>
    </div>
</div>

<!-- Save button on top -->
<?php if ($action == 'CS'): ?>
<div style="text-align:center; margin-bottom: 10px;">
    <button type="button" onclick="saveAllChanges()" class="save-all-btn">Save All Changes</button>
</div>
<?php endif; ?>

<!-- Attendance Table -->
<form id="attendanceForm">
    <table>
        <thead>
            <tr>
                <th style="width:40%">Student Name</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($result as $row):
                $id = $row['id'];
                $status = $row['in_out'] ?? '';
                if ($status == "NULL") 
                    $name = '<span style="color:orange">' . $row['name'] . ' (' . $status . ')</span>';
                elseif ($status == "AB") 
                    $name = '<span style="color:Red">' . $row['name'] . ' (' . $status . ')</span>';
                else
                    $name = '<span style="color:Green">' . $row['name'] . ' (' . $status . ')</span>';
           ?>
            <tr>
                <td><?= ($name) ?></td>
                <td>
                    <input type="hidden" name="status[<?= $id ?>]" id="status-<?= $id ?>" value="">
                    <?php if ($action == 'PR'): ?>
                        <button type="button" onclick="markStatus(<?= $id ?>, 'PR')" id="sp<?= $id ?>" class="attendance-btn present-btn">Present</button>
                    <?php elseif ($action == 'AB'): ?>
                        <button type="button" onclick="markStatus(<?= $id ?>, 'AB')" id="sa<?= $id ?>" class="attendance-btn absent-btn">Absent</button>
                    <?php else: ?>
                        <button type="button" onclick="markStatus(<?= $id ?>, 'PR')" id="sp<?= $id ?>" class="attendance-btn present-btn <?= ($status === 'PR' || $status === 'IN' || $status === 'OUT') ? 'disabled-btn' : '' ?>">Present</button>
                        <button type="button" onclick="markStatus(<?= $id ?>, 'AB')" id="sa<?= $id ?>" class="attendance-btn absent-btn <?= ($status === 'AB') ? 'disabled-btn' : '' ?>">Absent</button>
                    <?php endif; ?>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</form>

<!-- Save button on bottom -->
<?php if ($action == 'CS'): ?>
<div style="text-align:center; margin-bottom: 10px;">
    <button type="button" onclick="saveAllChanges()" class="save-all-btn">Save All Changes</button>
</div>
<?php endif; ?>

<!-- JavaScript -->
<script>
    var changes = {};

    function markStatus(id, status) {
        $("#status-" + id).val(status);
        changes[id] = status;

        if (status === "PR") {
            $("#sp" + id).removeClass("disabled-btn");
            $("#sa" + id).hide();
        } else if (status === "AB") {
            $("#sa" + id).removeClass("disabled-btn");
            $("#sp" + id).hide();
        }
    }

    function saveAllChanges() {
        if (Object.keys(changes).length === 0) {
            alert("No changes to save.");
            return;
        }

        // Prepare only changed values
        const data = { save_attendance: 1, updates: changes };

        $.ajax({
            url: "apcajaxs",
            type: "POST",
            data: data,
            dataType: "json",
            success: function(response) {
                if (response.success) {
                    alert("Attendance saved successfully.");
                    location.reload();
                } else {
                    alert("Error: " + response.message);
                }
            },
            error: function(xhr, status, error) {
                alert("AJAX error: " + error);
            }
        });
    }
    function handleActionChange() {
    const selected = document.getElementById("actionSelect").value;
    const faculty = document.getElementById("facultySelect").value;
    if (selected) {
        window.location.href = "sattendance?action=" + selected + "&faculty=" + faculty;
    }
}

     function handleFacultyChange() {
    const action = document.getElementById("actionSelect").value;
    const faculty = document.getElementById("facultySelect").value;
    if (faculty) {
        window.location.href = "sattendance?action=" + action + "&faculty=" + faculty;
    }
}
</script>

<!-- Styles -->
<style>
    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: #f9f9f9;
    }

    h2 {
        color: #2c3e50;
        font-weight: 600;
    }

    table {
        width: 100%;
        background: white;
        border-radius: 8px;
        border-collapse: collapse;
        box-shadow: 0 2px 15px rgba(0,0,0,0.1);
        max-width: 800px;
        margin: 0 auto;
    }

    th {
        background-color: #3498db;
        color: white;
        padding: 3px 4px;
        text-transform: uppercase;
        font-size: 0.9em;
    }

    td {
        padding: 6px 8px;
        border-bottom: 1px solid #e0e0e0;
    }

    tr:hover {
        background-color: #f5f5f5;
    }

    .attendance-btn {
        padding: 2px 4px;
        margin: 0 5px;
        border: none;
        border-radius: 4px;
        font-weight: 500;
        cursor: pointer;
        transition: all 0.3s ease;
        min-width: 50px;
    }

    .present-btn {
        background-color: #2ecc71;
        color: white;
    }

    .present-btn:hover {
        background-color: #27ae60;
    }

    .absent-btn {
        background-color: #e74c3c;
        color: white;
    }

    .absent-btn:hover {
        background-color: #c0392b;
    }

    .disabled-btn {
        opacity: 0.5;
        background-color: grey;
        pointer-events: none;
    }

    .filter-btn {
        padding: 4px 7px;
        background-color: #34495e;
        color: white;
        border: none;
        border-radius: 2px;
        font-size: 0.9em;
        cursor: pointer;
        transition: background-color 0.3s;
    }

    .filter-btn:hover {
        background-color: #2c3e50;
    }

    .save-all-btn {
        padding: 5px 10px;
        background-color: #2980b9;
        color: white;
        border: none;
        border-radius: 6px;
        font-size: 1em;
        font-weight: bold;
        cursor: pointer;
        margin: 5px auto;
        display: inline-block;
    }

    .save-all-btn:hover {
        background-color: #1c5980;
    }

    @media (max-width: 600px) {
        .attendance-btn {
            padding: 3px 5px;
            font-size: 0.85em;
        }

        th, td {
            padding: 4px 5px;
        }

        .filter-btn {
            padding: 6px 10px;
            font-size: 0.85em;
        }

        .save-all-btn {
            width: 100%;
            font-size: 0.9em;
        }
    }
</style>
?>
<?= GetDebugMessage() ?>
