<?php

namespace PHPMaker2024\fibre;

// Page object
$SAdmissionInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_admission_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fs_admission_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_admission_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["s_pid", [], fields.s_pid.isInvalid],
            ["faculty", [], fields.faculty.isInvalid],
            ["admission_year", [], fields.admission_year.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["status", [ew.Validators.integer], fields.status.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.integer], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "s_pid": <?= $Page->s_pid->toClientList($Page) ?>,
            "faculty": <?= $Page->faculty->toClientList($Page) ?>,
            "admission_year": <?= $Page->admission_year->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fs_admission_infosearch" id="fs_admission_infosearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_admission_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_admission_info_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_id" id="z_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_admission_info_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="s_admission_info" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->s_pid->Visible) { // s_pid ?>
    <div id="r_s_pid" class="row"<?= $Page->s_pid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_admission_info_s_pid"><?= $Page->s_pid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_s_pid" id="z_s_pid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->s_pid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_admission_info_s_pid" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_pid"
        name="x_s_pid"
        class="form-control ew-select<?= $Page->s_pid->isInvalidClass() ?>"
        data-select2-id="fs_admission_infosearch_x_s_pid"
        data-table="s_admission_info"
        data-field="x_s_pid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->s_pid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->s_pid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_pid->getPlaceHolder()) ?>"
        <?= $Page->s_pid->editAttributes() ?>>
        <?= $Page->s_pid->selectOptionListHtml("x_s_pid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_pid->getErrorMessage(false) ?></div>
<?= $Page->s_pid->Lookup->getParamTag($Page, "p_x_s_pid") ?>
<script>
loadjs.ready("fs_admission_infosearch", function() {
    var options = { name: "x_s_pid", selectId: "fs_admission_infosearch_x_s_pid" };
    if (fs_admission_infosearch.lists.s_pid?.lookupOptions.length) {
        options.data = { id: "x_s_pid", form: "fs_admission_infosearch" };
    } else {
        options.ajax = { id: "x_s_pid", form: "fs_admission_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.s_admission_info.fields.s_pid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->faculty->Visible) { // faculty ?>
    <div id="r_faculty" class="row"<?= $Page->faculty->rowAttributes() ?>>
        <label for="x_faculty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_admission_info_faculty"><?= $Page->faculty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_faculty" id="z_faculty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->faculty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_admission_info_faculty" class="ew-search-field">
    <select
        id="x_faculty"
        name="x_faculty"
        class="form-select ew-select<?= $Page->faculty->isInvalidClass() ?>"
        <?php if (!$Page->faculty->IsNativeSelect) { ?>
        data-select2-id="fs_admission_infosearch_x_faculty"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_faculty"
        data-value-separator="<?= $Page->faculty->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>"
        <?= $Page->faculty->editAttributes() ?>>
        <?= $Page->faculty->selectOptionListHtml("x_faculty") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->faculty->getErrorMessage(false) ?></div>
<?= $Page->faculty->Lookup->getParamTag($Page, "p_x_faculty") ?>
<?php if (!$Page->faculty->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_admission_infosearch", function() {
    var options = { name: "x_faculty", selectId: "fs_admission_infosearch_x_faculty" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_admission_infosearch.lists.faculty?.lookupOptions.length) {
        options.data = { id: "x_faculty", form: "fs_admission_infosearch" };
    } else {
        options.ajax = { id: "x_faculty", form: "fs_admission_infosearch", limit: 5 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.faculty.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-cond">
<div class="form-check"><input class="form-check-input" type="radio" id="v_faculty_1" name="v_faculty" value="AND"<?= ($Page->faculty->AdvancedSearch->SearchCondition != "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_faculty_1"><?= $Language->phrase("AND") ?></label></div>
<div class="form-check"><input class="form-check-input" type="radio" id="v_faculty_2" name="v_faculty" value="OR"<?= ($Page->faculty->AdvancedSearch->SearchCondition == "OR") ? " checked" : "" ?>><label class="form-check-label" for="v_faculty_2"><?= $Language->phrase("OR") ?></label></div></span>
                    <span class="ew-search-operator2">
<?= $Language->phrase("=") ?>
<input type="hidden" name="w_faculty" id="w_faculty" value="=">
</span>
                    <span id="el2_s_admission_info_faculty" class="ew-search-field2">
    <select
        id="y_faculty"
        name="y_faculty"
        class="form-select ew-select<?= $Page->faculty->isInvalidClass() ?>"
        <?php if (!$Page->faculty->IsNativeSelect) { ?>
        data-select2-id="fs_admission_infosearch_y_faculty"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_faculty"
        data-value-separator="<?= $Page->faculty->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>"
        <?= $Page->faculty->editAttributes() ?>>
        <?= $Page->faculty->selectOptionListHtml("y_faculty") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->faculty->getErrorMessage(false) ?></div>
<?= $Page->faculty->Lookup->getParamTag($Page, "p_y_faculty") ?>
<?php if (!$Page->faculty->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_admission_infosearch", function() {
    var options = { name: "y_faculty", selectId: "fs_admission_infosearch_y_faculty" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_admission_infosearch.lists.faculty?.lookupOptions.length) {
        options.data = { id: "y_faculty", form: "fs_admission_infosearch" };
    } else {
        options.ajax = { id: "y_faculty", form: "fs_admission_infosearch", limit: 5 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.faculty.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->admission_year->Visible) { // admission_year ?>
    <div id="r_admission_year" class="row"<?= $Page->admission_year->rowAttributes() ?>>
        <label for="x_admission_year" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_admission_info_admission_year"><?= $Page->admission_year->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_admission_year" id="z_admission_year" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->admission_year->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_admission_info_admission_year" class="ew-search-field ew-search-field-single">
    <select
        id="x_admission_year"
        name="x_admission_year"
        class="form-select ew-select<?= $Page->admission_year->isInvalidClass() ?>"
        <?php if (!$Page->admission_year->IsNativeSelect) { ?>
        data-select2-id="fs_admission_infosearch_x_admission_year"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_admission_year"
        data-value-separator="<?= $Page->admission_year->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->admission_year->getPlaceHolder()) ?>"
        <?= $Page->admission_year->editAttributes() ?>>
        <?= $Page->admission_year->selectOptionListHtml("x_admission_year") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->admission_year->getErrorMessage(false) ?></div>
<?php if (!$Page->admission_year->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_admission_infosearch", function() {
    var options = { name: "x_admission_year", selectId: "fs_admission_infosearch_x_admission_year" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_admission_infosearch.lists.admission_year?.lookupOptions.length) {
        options.data = { id: "x_admission_year", form: "fs_admission_infosearch" };
    } else {
        options.ajax = { id: "x_admission_year", form: "fs_admission_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.admission_year.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
    <div id="r_image" class="row"<?= $Page->image->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_admission_info_image"><?= $Page->image->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_image" id="z_image" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->image->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_admission_info_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="s_admission_info" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
    <div id="r_remarks" class="row"<?= $Page->remarks->rowAttributes() ?>>
        <label for="x_remarks" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_admission_info_remarks"><?= $Page->remarks->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_remarks" id="z_remarks" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->remarks->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_admission_info_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="s_admission_info" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
    <div id="r_status" class="row"<?= $Page->status->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_admission_info_status"><?= $Page->status->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_status" id="z_status" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->status->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_admission_info_status" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->status->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_status" class="ew-auto-suggest">
    <input type="<?= $Page->status->getInputTextType() ?>" class="form-control" name="sv_x_status" id="sv_x_status" value="<?= RemoveHtml($Page->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_admission_info" data-field="x_status" data-input="sv_x_status" data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fs_admission_infosearch", function() {
    fs_admission_infosearch.createAutoSuggest(Object.assign({"id":"x_status","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_admission_info.fields.status.autoSuggestOptions));
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
    <div id="r_operator" class="row"<?= $Page->operator->rowAttributes() ?>>
        <label for="x_operator" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_admission_info_operator"><?= $Page->operator->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_operator" id="z_operator" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->operator->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_admission_info_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="s_admission_info" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
    <div id="r_datetime" class="row"<?= $Page->datetime->rowAttributes() ?>>
        <label for="x_datetime" class="<?= $Page->LeftColumnClass ?>"><span id="elh_s_admission_info_datetime"><?= $Page->datetime->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_datetime" id="z_datetime" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->datetime->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_s_admission_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="s_admission_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fs_admission_infosearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fs_admission_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fs_admission_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_admission_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
