<?php

namespace PHPMaker2024\fibre;

// Page object
$SAdmissionInfoSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_admission_info: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fs_admission_infosearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_admission_infosearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [ew.Validators.integer], fields.id.isInvalid],
            ["s_pid", [], fields.s_pid.isInvalid],
            ["faculty", [], fields.faculty.isInvalid],
            ["admission_year", [], fields.admission_year.isInvalid],
            ["image", [], fields.image.isInvalid],
            ["remarks", [], fields.remarks.isInvalid],
            ["status", [ew.Validators.integer], fields.status.isInvalid],
            ["operator", [ew.Validators.integer], fields.operator.isInvalid],
            ["datetime", [ew.Validators.integer], fields.datetime.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setQueryBuilderLists({
            "s_pid": <?= $Page->s_pid->toClientList($Page) ?>,
            "faculty": <?= $Page->faculty->toClientList($Page) ?>,
            "admission_year": <?= $Page->admission_year->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fs_admission_infosearch" id="fs_admission_infosearch" class="<?= $Page->FormClassName ?>" action="<?= HtmlEncode(GetUrl("sadmissioninfolist")) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_admission_info">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<input type="hidden" name="rules" value="<?= HtmlEncode($Page->getSessionRules()) ?>">
<template id="tpx_s_admission_info_id" class="s_admission_infosearch"><span id="el_s_admission_info_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="s_admission_info" data-field="x_id" value="<?= $Page->id->EditValue ?>" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_admission_info_s_pid" class="s_admission_infosearch"><span id="el_s_admission_info_s_pid" class="ew-search-field ew-search-field-single">
    <select
        id="x_s_pid"
        name="x_s_pid"
        class="form-control ew-select<?= $Page->s_pid->isInvalidClass() ?>"
        data-select2-id="fs_admission_infosearch_x_s_pid"
        data-table="s_admission_info"
        data-field="x_s_pid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->s_pid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->s_pid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_pid->getPlaceHolder()) ?>"
        <?= $Page->s_pid->editAttributes() ?>>
        <?= $Page->s_pid->selectOptionListHtml("x_s_pid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->s_pid->getErrorMessage(false) ?></div>
<?= $Page->s_pid->Lookup->getParamTag($Page, "p_x_s_pid") ?>
<script>
loadjs.ready("fs_admission_infosearch", function() {
    var options = { name: "x_s_pid", selectId: "fs_admission_infosearch_x_s_pid" };
    if (fs_admission_infosearch.lists.s_pid?.lookupOptions.length) {
        options.data = { id: "x_s_pid", form: "fs_admission_infosearch" };
    } else {
        options.ajax = { id: "x_s_pid", form: "fs_admission_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.s_admission_info.fields.s_pid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span></template>
<template id="tpx_s_admission_info_faculty" class="s_admission_infosearch"><span id="el_s_admission_info_faculty" class="ew-search-field ew-search-field-single">
    <select
        id="x_faculty"
        name="x_faculty"
        class="form-select ew-select<?= $Page->faculty->isInvalidClass() ?>"
        <?php if (!$Page->faculty->IsNativeSelect) { ?>
        data-select2-id="fs_admission_infosearch_x_faculty"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_faculty"
        data-value-separator="<?= $Page->faculty->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>"
        <?= $Page->faculty->editAttributes() ?>>
        <?= $Page->faculty->selectOptionListHtml("x_faculty") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->faculty->getErrorMessage(false) ?></div>
<?= $Page->faculty->Lookup->getParamTag($Page, "p_x_faculty") ?>
<?php if (!$Page->faculty->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_admission_infosearch", function() {
    var options = { name: "x_faculty", selectId: "fs_admission_infosearch_x_faculty" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_admission_infosearch.lists.faculty?.lookupOptions.length) {
        options.data = { id: "x_faculty", form: "fs_admission_infosearch" };
    } else {
        options.ajax = { id: "x_faculty", form: "fs_admission_infosearch", limit: 5 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.faculty.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_admission_info_admission_year" class="s_admission_infosearch"><span id="el_s_admission_info_admission_year" class="ew-search-field ew-search-field-single">
    <select
        id="x_admission_year"
        name="x_admission_year"
        class="form-select ew-select<?= $Page->admission_year->isInvalidClass() ?>"
        <?php if (!$Page->admission_year->IsNativeSelect) { ?>
        data-select2-id="fs_admission_infosearch_x_admission_year"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_admission_year"
        data-value-separator="<?= $Page->admission_year->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->admission_year->getPlaceHolder()) ?>"
        <?= $Page->admission_year->editAttributes() ?>>
        <?= $Page->admission_year->selectOptionListHtml("x_admission_year") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->admission_year->getErrorMessage(false) ?></div>
<?php if (!$Page->admission_year->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_admission_infosearch", function() {
    var options = { name: "x_admission_year", selectId: "fs_admission_infosearch_x_admission_year" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_admission_infosearch.lists.admission_year?.lookupOptions.length) {
        options.data = { id: "x_admission_year", form: "fs_admission_infosearch" };
    } else {
        options.ajax = { id: "x_admission_year", form: "fs_admission_infosearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.admission_year.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
<template id="tpx_s_admission_info_image" class="s_admission_infosearch"><span id="el_s_admission_info_image" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->image->getInputTextType() ?>" name="x_image" id="x_image" data-table="s_admission_info" data-field="x_image" value="<?= $Page->image->EditValue ?>" size="30" maxlength="250" placeholder="<?= HtmlEncode($Page->image->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->image->formatPattern()) ?>"<?= $Page->image->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->image->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_admission_info_remarks" class="s_admission_infosearch"><span id="el_s_admission_info_remarks" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x_remarks" id="x_remarks" data-table="s_admission_info" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_admission_info_status" class="s_admission_infosearch"><span id="el_s_admission_info_status" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->status->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_status" class="ew-auto-suggest">
    <input type="<?= $Page->status->getInputTextType() ?>" class="form-control" name="sv_x_status" id="sv_x_status" value="<?= RemoveHtml($Page->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_admission_info" data-field="x_status" data-input="sv_x_status" data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>" name="x_status" id="x_status" value="<?= HtmlEncode($Page->status->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage(false) ?></div>
<script>
loadjs.ready("fs_admission_infosearch", function() {
    fs_admission_infosearch.createAutoSuggest(Object.assign({"id":"x_status","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_admission_info.fields.status.autoSuggestOptions));
});
</script>
</span></template>
<template id="tpx_s_admission_info_operator" class="s_admission_infosearch"><span id="el_s_admission_info_operator" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->operator->getInputTextType() ?>" name="x_operator" id="x_operator" data-table="s_admission_info" data-field="x_operator" value="<?= $Page->operator->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->operator->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->operator->formatPattern()) ?>"<?= $Page->operator->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->operator->getErrorMessage(false) ?></div>
</span></template>
<template id="tpx_s_admission_info_datetime" class="s_admission_infosearch"><span id="el_s_admission_info_datetime" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->datetime->getInputTextType() ?>" name="x_datetime" id="x_datetime" data-table="s_admission_info" data-field="x_datetime" value="<?= $Page->datetime->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->datetime->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->datetime->formatPattern()) ?>"<?= $Page->datetime->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->datetime->getErrorMessage(false) ?></div>
</span></template>
<div id="s_admission_info_query_builder" class="query-builder mb-3"></div>
<div class="btn-group mb-3 query-btn-group"></div>
<button type="button" id="btn-view-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("View", true)) ?>"><i class="fa-solid fa-eye ew-icon"></i></button>
<button type="button" id="btn-clear-rules" class="btn btn-primary d-none disabled" title="<?= HtmlEncode($Language->phrase("Clear", true)) ?>"><i class="fa-solid fa-xmark ew-icon"></i></button>
<script>
// Filter builder
loadjs.ready(["wrapper", "head"], () => {
    let filters = [
            {
                id: "id",
                type: "integer",
                label: currentTable.fields.id.caption,
                operators: currentTable.fields.id.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fs_admission_infosearch.fields.id.validators),
                data: {
                    format: currentTable.fields.id.clientFormatPattern
                }
            },
            {
                id: "s_pid",
                type: "integer",
                label: currentTable.fields.s_pid.caption,
                operators: currentTable.fields.s_pid.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_admission_infosearch.fields.s_pid.validators),
                data: {
                    format: currentTable.fields.s_pid.clientFormatPattern
                }
            },
            {
                id: "faculty",
                type: "integer",
                label: currentTable.fields.faculty.caption,
                operators: currentTable.fields.faculty.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_admission_infosearch.fields.faculty.validators),
                data: {
                    format: currentTable.fields.faculty.clientFormatPattern
                }
            },
            {
                id: "admission_year",
                type: "integer",
                label: currentTable.fields.admission_year.caption,
                operators: currentTable.fields.admission_year.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_admission_infosearch.fields.admission_year.validators),
                data: {
                    format: currentTable.fields.admission_year.clientFormatPattern
                }
            },
            {
                id: "image",
                type: "string",
                label: currentTable.fields.image.caption,
                operators: currentTable.fields.image.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                validation: ew.getQueryBuilderFilterValidation(fs_admission_infosearch.fields.image.validators),
                data: {
                    format: currentTable.fields.image.clientFormatPattern
                }
            },
            {
                id: "remarks",
                type: "string",
                label: currentTable.fields.remarks.caption,
                operators: currentTable.fields.remarks.clientSearchOperators,
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_admission_infosearch.fields.remarks.validators),
                data: {
                    format: currentTable.fields.remarks.clientFormatPattern
                }
            },
            {
                id: "status",
                type: "integer",
                label: currentTable.fields.status.caption,
                operators: currentTable.fields.status.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                valueSetter: ew.getQueryBuilderValueSetter(),
                validation: ew.getQueryBuilderFilterValidation(fs_admission_infosearch.fields.status.validators),
                data: {
                    format: currentTable.fields.status.clientFormatPattern
                }
            },
            {
                id: "operator",
                type: "integer",
                label: currentTable.fields.operator.caption,
                operators: currentTable.fields.operator.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_admission_infosearch.fields.operator.validators),
                data: {
                    format: currentTable.fields.operator.clientFormatPattern
                }
            },
            {
                id: "datetime",
                type: "datetime",
                label: currentTable.fields.datetime.caption,
                operators: currentTable.fields.datetime.clientSearchOperators,
                default_operator: "equal",
                input: ew.getQueryBuilderFilterInput(),
                value_separator: ew.IN_OPERATOR_VALUE_SEPARATOR,
                validation: ew.getQueryBuilderFilterValidation(fs_admission_infosearch.fields.datetime.validators),
                data: {
                    format: currentTable.fields.datetime.clientFormatPattern
                }
            },
        ],
        $ = jQuery,
        $qb = $("#s_admission_info_query_builder"),
        args = {},
        rules = ew.parseJson($("#fs_admission_infosearch input[name=rules]").val()),
        queryBuilderOptions = Object.assign({}, ew.queryBuilderOptions),
        allowViewRules = queryBuilderOptions.allowViewRules,
        allowClearRules = queryBuilderOptions.allowClearRules,
        hasRules = group => Array.isArray(group?.rules) && group.rules.length > 0,
        getRules = () => $qb.queryBuilder("getRules", { skip_empty: true }),
        getSql = () => $qb.queryBuilder("getSQL", false, false, rules)?.sql;
    delete queryBuilderOptions.allowViewRules;
    delete queryBuilderOptions.allowClearRules;
    args.options = ew.deepAssign({
        plugins: Object.assign({}, ew.queryBuilderPlugins),
        lang: ew.language.phrase("querybuilderjs"),
        select_placeholder: ew.language.phrase("PleaseSelect"),
        inputs_separator: `<div class="d-inline-flex ms-2 me-2">${ew.language.phrase("AND")}</div>`, // For "between"
        filters,
        rules
    }, queryBuilderOptions);
    $qb.trigger("querybuilder", [args]);
    $qb.queryBuilder(args.options).on("rulesChanged.queryBuilder", () => {
        let rules = getRules();
        !ew.DEBUG || console.log(rules, getSql());
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").toggleClass("disabled", !rules);
    }).on("afterCreateRuleInput.queryBuilder", function(e, rule) {
        let select = rule.$el.find(".rule-value-container").find("selection-list, select")[0];
        if (select) { // Selection list
            let id = select.dataset.field.replace("^x_", ""),
                form = ew.forms.get(select);
            form.updateList(select, undefined, undefined, true); // Update immediately
        }
    });
    $("#fs_admission_infosearch").on("beforesubmit", function () {
        this.rules.value = JSON.stringify(getRules());
    });
    $("#btn-reset").toggleClass("d-none", false).on("click", () => {
        hasRules(rules) ? $qb.queryBuilder("setRules", rules) : $qb.queryBuilder("reset");
        return false;
    });
    $("#btn-action").toggleClass("d-none", false);
    if (allowClearRules) {
        $("#btn-clear-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => $qb.queryBuilder("reset"));
    }
    if (allowViewRules) {
        $("#btn-view-rules").appendTo(".query-btn-group").removeClass("d-none").on("click", () => {
            let rules = getRules();
            if (hasRules(rules)) {
                let sql = getSql();
                ew.alert(sql ? '<pre class="text-start fs-6">' + sql + '</pre>' : '', "dark");
                !ew.DEBUG || console.log(rules, sql);
            } else {
                ew.alert(ew.language.phrase("EmptyLabel"));
            }
        });
    }
    $(".query-btn-group").toggleClass(".mb-3", $(".query-btn-group").find(".btn:not(.d-none)").length);
    if (hasRules(rules)) { // Enable buttons if rules exist initially
        $("#btn-reset, #btn-action, #btn-clear-rules, #btn-view-rules").removeClass("disabled");
    }
});
</script>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn d-none disabled" name="btn-action" id="btn-action" type="submit" form="fs_admission_infosearch" formaction="<?= HtmlEncode(GetUrl("sadmissioninfolist")) ?>" data-ajax="<?= $Page->UseAjaxActions ? "true" : "false" ?>"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fs_admission_infosearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn d-none disabled" name="btn-reset" id="btn-reset" type="button" form="fs_admission_infosearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_admission_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
