<?php

namespace PHPMaker2024\fibre;

// Page object
$SAdmissionInfoList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_admission_info: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["s_pid", [fields.s_pid.visible && fields.s_pid.required ? ew.Validators.required(fields.s_pid.caption) : null], fields.s_pid.isInvalid],
            ["faculty", [fields.faculty.visible && fields.faculty.required ? ew.Validators.required(fields.faculty.caption) : null], fields.faculty.isInvalid],
            ["admission_year", [fields.admission_year.visible && fields.admission_year.required ? ew.Validators.required(fields.admission_year.caption) : null], fields.admission_year.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null, ew.Validators.integer], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "s_pid": <?= $Page->s_pid->toClientList($Page) ?>,
            "faculty": <?= $Page->faculty->toClientList($Page) ?>,
            "admission_year": <?= $Page->admission_year->toClientList($Page) ?>,
            "status": <?= $Page->status->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if (!$Page->isExport() || Config("EXPORT_MASTER_RECORD") && $Page->isExport("print")) { ?>
<?php
if ($Page->DbMasterFilter != "" && $Page->getCurrentMasterTable() == "s_student_list") {
    if ($Page->MasterRecordExists) {
        include_once "views/SStudentListMaster.php";
    }
}
?>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fs_admission_infosrch" id="fs_admission_infosrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fs_admission_infosrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { s_admission_info: currentTable } });
var currentForm;
var fs_admission_infosrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fs_admission_infosrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "s_pid": <?= $Page->s_pid->toClientList($Page) ?>,
            "faculty": <?= $Page->faculty->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->s_pid->Visible) { // s_pid ?>
<?php
if (!$Page->s_pid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_s_pid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->s_pid->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_s_pid"
            name="x_s_pid[]"
            class="form-control ew-select<?= $Page->s_pid->isInvalidClass() ?>"
            data-select2-id="fs_admission_infosrch_x_s_pid"
            data-table="s_admission_info"
            data-field="x_s_pid"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->s_pid->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->s_pid->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->s_pid->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->s_pid->editAttributes() ?>>
            <?= $Page->s_pid->selectOptionListHtml("x_s_pid", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->s_pid->getErrorMessage(false) ?></div>
        <?= $Page->s_pid->Lookup->getParamTag($Page, "p_x_s_pid") ?>
        <script>
        loadjs.ready("fs_admission_infosrch", function() {
            var options = {
                name: "x_s_pid",
                selectId: "fs_admission_infosrch_x_s_pid",
                ajax: { id: "x_s_pid", form: "fs_admission_infosrch", limit: ew.FILTER_PAGE_SIZE, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_admission_info.fields.s_pid.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->faculty->Visible) { // faculty ?>
<?php
if (!$Page->faculty->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_faculty" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->faculty->UseFilter ? " ew-filter-field" : "" ?>">
        <select
            id="x_faculty"
            name="x_faculty[]"
            class="form-control ew-select<?= $Page->faculty->isInvalidClass() ?>"
            data-select2-id="fs_admission_infosrch_x_faculty"
            data-table="s_admission_info"
            data-field="x_faculty"
            data-caption="<?= HtmlEncode(RemoveHtml($Page->faculty->caption())) ?>"
            data-filter="true"
            multiple
            size="1"
            data-value-separator="<?= $Page->faculty->displayValueSeparatorAttribute() ?>"
            data-placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>"
            data-ew-action="update-options"
            <?= $Page->faculty->editAttributes() ?>>
            <?= $Page->faculty->selectOptionListHtml("x_faculty", true) ?>
        </select>
        <div class="invalid-feedback"><?= $Page->faculty->getErrorMessage(false) ?></div>
        <?= $Page->faculty->Lookup->getParamTag($Page, "p_x_faculty") ?>
        <script>
        loadjs.ready("fs_admission_infosrch", function() {
            var options = {
                name: "x_faculty",
                selectId: "fs_admission_infosrch_x_faculty",
                ajax: { id: "x_faculty", form: "fs_admission_infosrch", limit: 5, data: { ajax: "filter" } }
            };
            options = Object.assign({}, ew.filterOptions, options, ew.vars.tables.s_admission_info.fields.faculty.filterOptions);
            ew.createFilter(options);
        });
        </script>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="fs_admission_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="fs_admission_infosrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="fs_admission_infosrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fs_admission_infosrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fs_admission_infosrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fs_admission_infosrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fs_admission_infosrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="s_admission_info">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<?php if ($Page->getCurrentMasterTable() == "s_student_list" && $Page->CurrentAction) { ?>
<input type="hidden" name="<?= Config("TABLE_SHOW_MASTER") ?>" value="s_student_list">
<input type="hidden" name="fk_id" value="<?= HtmlEncode($Page->s_pid->getSessionValue()) ?>">
<?php } ?>
<div id="gmp_s_admission_info" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_s_admission_infolist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_s_admission_info_id" class="s_admission_info_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->s_pid->Visible) { // s_pid ?>
        <th data-name="s_pid" class="<?= $Page->s_pid->headerCellClass() ?>"><div id="elh_s_admission_info_s_pid" class="s_admission_info_s_pid"><?= $Page->renderFieldHeader($Page->s_pid) ?></div></th>
<?php } ?>
<?php if ($Page->faculty->Visible) { // faculty ?>
        <th data-name="faculty" class="<?= $Page->faculty->headerCellClass() ?>"><div id="elh_s_admission_info_faculty" class="s_admission_info_faculty"><?= $Page->renderFieldHeader($Page->faculty) ?></div></th>
<?php } ?>
<?php if ($Page->admission_year->Visible) { // admission_year ?>
        <th data-name="admission_year" class="<?= $Page->admission_year->headerCellClass() ?>"><div id="elh_s_admission_info_admission_year" class="s_admission_info_admission_year"><?= $Page->renderFieldHeader($Page->admission_year) ?></div></th>
<?php } ?>
<?php if ($Page->image->Visible) { // image ?>
        <th data-name="image" class="<?= $Page->image->headerCellClass() ?>"><div id="elh_s_admission_info_image" class="s_admission_info_image"><?= $Page->renderFieldHeader($Page->image) ?></div></th>
<?php } ?>
<?php if ($Page->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Page->remarks->headerCellClass() ?>"><div id="elh_s_admission_info_remarks" class="s_admission_info_remarks"><?= $Page->renderFieldHeader($Page->remarks) ?></div></th>
<?php } ?>
<?php if ($Page->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Page->status->headerCellClass() ?>"><div id="elh_s_admission_info_status" class="s_admission_info_status"><?= $Page->renderFieldHeader($Page->status) ?></div></th>
<?php } ?>
<?php if ($Page->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Page->operator->headerCellClass() ?>"><div id="elh_s_admission_info_operator" class="s_admission_info_operator"><?= $Page->renderFieldHeader($Page->operator) ?></div></th>
<?php } ?>
<?php if ($Page->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Page->datetime->headerCellClass() ?>"><div id="elh_s_admission_info_datetime" class="s_admission_info_datetime"><?= $Page->renderFieldHeader($Page->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Page->RowAction != "delete" &&
            $Page->RowAction != "insertdelete" &&
            !($Page->RowAction == "insert" && $Page->isConfirm() && $Page->emptyRow()) &&
            $Page->RowAction != "hide"
        ) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_id" class="el_s_admission_info_id"></span>
<input type="hidden" data-table="s_admission_info" data-field="x_id" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_id" id="o<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_id" class="el_s_admission_info_id">
<span<?= $Page->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Page->id->getDisplayValue($Page->id->EditValue))) ?>"></span>
<input type="hidden" data-table="s_admission_info" data-field="x_id" data-hidden="1" name="x<?= $Page->RowIndex ?>_id" id="x<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_id" class="el_s_admission_info_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="s_admission_info" data-field="x_id" data-hidden="1" name="x<?= $Page->RowIndex ?>_id" id="x<?= $Page->RowIndex ?>_id" value="<?= HtmlEncode($Page->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Page->s_pid->Visible) { // s_pid ?>
        <td data-name="s_pid"<?= $Page->s_pid->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<?php if ($Page->s_pid->getSessionValue() != "") { ?>
<span<?= $Page->s_pid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->s_pid->getDisplayValue($Page->s_pid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_s_pid" name="x<?= $Page->RowIndex ?>_s_pid" value="<?= HtmlEncode($Page->s_pid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_s_pid" class="el_s_admission_info_s_pid">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Page->RowIndex ?>_s_pid"
        name="x<?= $Page->RowIndex ?>_s_pid"
        class="form-control ew-select<?= $Page->s_pid->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_s_pid"
        data-table="s_admission_info"
        data-field="x_s_pid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->s_pid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->s_pid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_pid->getPlaceHolder()) ?>"
        <?= $Page->s_pid->editAttributes() ?>>
        <?= $Page->s_pid->selectOptionListHtml("x{$Page->RowIndex}_s_pid") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "s_personal_info") && !$Page->s_pid->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Page->RowIndex ?>_s_pid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->s_pid->caption() ?>" data-title="<?= $Page->s_pid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Page->RowIndex ?>_s_pid" data-url="<?= GetUrl("spersonalinfoaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Page->s_pid->getErrorMessage() ?></div>
<?= $Page->s_pid->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_s_pid") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_s_pid", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_s_pid" };
    if (<?= $Page->FormName ?>.lists.s_pid?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_s_pid", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_s_pid", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.s_admission_info.fields.s_pid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="s_admission_info" data-field="x_s_pid" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_s_pid" id="o<?= $Page->RowIndex ?>_s_pid" value="<?= HtmlEncode($Page->s_pid->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Page->s_pid->getSessionValue() != "") { ?>
<span<?= $Page->s_pid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Page->s_pid->getDisplayValue($Page->s_pid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Page->RowIndex ?>_s_pid" name="x<?= $Page->RowIndex ?>_s_pid" value="<?= HtmlEncode($Page->s_pid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_s_pid" class="el_s_admission_info_s_pid">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Page->RowIndex ?>_s_pid"
        name="x<?= $Page->RowIndex ?>_s_pid"
        class="form-control ew-select<?= $Page->s_pid->isInvalidClass() ?>"
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_s_pid"
        data-table="s_admission_info"
        data-field="x_s_pid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->s_pid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->s_pid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->s_pid->getPlaceHolder()) ?>"
        <?= $Page->s_pid->editAttributes() ?>>
        <?= $Page->s_pid->selectOptionListHtml("x{$Page->RowIndex}_s_pid") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "s_personal_info") && !$Page->s_pid->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Page->RowIndex ?>_s_pid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Page->s_pid->caption() ?>" data-title="<?= $Page->s_pid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Page->RowIndex ?>_s_pid" data-url="<?= GetUrl("spersonalinfoaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Page->s_pid->getErrorMessage() ?></div>
<?= $Page->s_pid->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_s_pid") ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_s_pid", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_s_pid" };
    if (<?= $Page->FormName ?>.lists.s_pid?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_s_pid", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_s_pid", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.s_admission_info.fields.s_pid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_s_pid" class="el_s_admission_info_s_pid">
<span<?= $Page->s_pid->viewAttributes() ?>>
<?= $Page->s_pid->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->faculty->Visible) { // faculty ?>
        <td data-name="faculty"<?= $Page->faculty->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_faculty" class="el_s_admission_info_faculty">
    <select
        id="x<?= $Page->RowIndex ?>_faculty"
        name="x<?= $Page->RowIndex ?>_faculty"
        class="form-select ew-select<?= $Page->faculty->isInvalidClass() ?>"
        <?php if (!$Page->faculty->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_faculty"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_faculty"
        data-value-separator="<?= $Page->faculty->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>"
        <?= $Page->faculty->editAttributes() ?>>
        <?= $Page->faculty->selectOptionListHtml("x{$Page->RowIndex}_faculty") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->faculty->getErrorMessage() ?></div>
<?= $Page->faculty->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_faculty") ?>
<?php if (!$Page->faculty->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_faculty", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_faculty" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.faculty?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_faculty", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_faculty", form: "<?= $Page->FormName ?>", limit: 5 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.faculty.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_admission_info" data-field="x_faculty" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_faculty" id="o<?= $Page->RowIndex ?>_faculty" value="<?= HtmlEncode($Page->faculty->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_faculty" class="el_s_admission_info_faculty">
    <select
        id="x<?= $Page->RowIndex ?>_faculty"
        name="x<?= $Page->RowIndex ?>_faculty"
        class="form-select ew-select<?= $Page->faculty->isInvalidClass() ?>"
        <?php if (!$Page->faculty->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_faculty"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_faculty"
        data-value-separator="<?= $Page->faculty->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->faculty->getPlaceHolder()) ?>"
        <?= $Page->faculty->editAttributes() ?>>
        <?= $Page->faculty->selectOptionListHtml("x{$Page->RowIndex}_faculty") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->faculty->getErrorMessage() ?></div>
<?= $Page->faculty->Lookup->getParamTag($Page, "p_x" . $Page->RowIndex . "_faculty") ?>
<?php if (!$Page->faculty->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_faculty", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_faculty" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.faculty?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_faculty", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_faculty", form: "<?= $Page->FormName ?>", limit: 5 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.faculty.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_faculty" class="el_s_admission_info_faculty">
<span<?= $Page->faculty->viewAttributes() ?>>
<?= $Page->faculty->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->admission_year->Visible) { // admission_year ?>
        <td data-name="admission_year"<?= $Page->admission_year->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_admission_year" class="el_s_admission_info_admission_year">
    <select
        id="x<?= $Page->RowIndex ?>_admission_year"
        name="x<?= $Page->RowIndex ?>_admission_year"
        class="form-select ew-select<?= $Page->admission_year->isInvalidClass() ?>"
        <?php if (!$Page->admission_year->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_admission_year"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_admission_year"
        data-value-separator="<?= $Page->admission_year->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->admission_year->getPlaceHolder()) ?>"
        <?= $Page->admission_year->editAttributes() ?>>
        <?= $Page->admission_year->selectOptionListHtml("x{$Page->RowIndex}_admission_year") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->admission_year->getErrorMessage() ?></div>
<?php if (!$Page->admission_year->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_admission_year", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_admission_year" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.admission_year?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_admission_year", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_admission_year", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.admission_year.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_admission_info" data-field="x_admission_year" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_admission_year" id="o<?= $Page->RowIndex ?>_admission_year" value="<?= HtmlEncode($Page->admission_year->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_admission_year" class="el_s_admission_info_admission_year">
    <select
        id="x<?= $Page->RowIndex ?>_admission_year"
        name="x<?= $Page->RowIndex ?>_admission_year"
        class="form-select ew-select<?= $Page->admission_year->isInvalidClass() ?>"
        <?php if (!$Page->admission_year->IsNativeSelect) { ?>
        data-select2-id="<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_admission_year"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_admission_year"
        data-value-separator="<?= $Page->admission_year->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->admission_year->getPlaceHolder()) ?>"
        <?= $Page->admission_year->editAttributes() ?>>
        <?= $Page->admission_year->selectOptionListHtml("x{$Page->RowIndex}_admission_year") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->admission_year->getErrorMessage() ?></div>
<?php if (!$Page->admission_year->IsNativeSelect) { ?>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    var options = { name: "x<?= $Page->RowIndex ?>_admission_year", selectId: "<?= $Page->FormName ?>_x<?= $Page->RowIndex ?>_admission_year" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (<?= $Page->FormName ?>.lists.admission_year?.lookupOptions.length) {
        options.data = { id: "x<?= $Page->RowIndex ?>_admission_year", form: "<?= $Page->FormName ?>" };
    } else {
        options.ajax = { id: "x<?= $Page->RowIndex ?>_admission_year", form: "<?= $Page->FormName ?>", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.admission_year.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_admission_year" class="el_s_admission_info_admission_year">
<span<?= $Page->admission_year->viewAttributes() ?>>
<?= $Page->admission_year->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->image->Visible) { // image ?>
        <td data-name="image"<?= $Page->image->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_image" class="el_s_admission_info_image">
<div id="fd_x<?= $Page->RowIndex ?>_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Page->RowIndex ?>_image"
        name="x<?= $Page->RowIndex ?>_image"
        class="form-control ew-file-input"
        title="<?= $Page->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="s_admission_info"
        data-field="x_image"
        data-size="250"
        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
        <?= ($Page->image->ReadOnly || $Page->image->Disabled) ? " disabled" : "" ?>
        <?= $Page->image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Page->RowIndex ?>_image" id= "fn_x<?= $Page->RowIndex ?>_image" value="<?= $Page->image->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Page->RowIndex ?>_image" id= "fa_x<?= $Page->RowIndex ?>_image" value="0">
<table id="ft_x<?= $Page->RowIndex ?>_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<input type="hidden" data-table="s_admission_info" data-field="x_image" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_image" id="o<?= $Page->RowIndex ?>_image" value="<?= HtmlEncode($Page->image->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_image" class="el_s_admission_info_image">
<div id="fd_x<?= $Page->RowIndex ?>_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Page->RowIndex ?>_image"
        name="x<?= $Page->RowIndex ?>_image"
        class="form-control ew-file-input"
        title="<?= $Page->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="s_admission_info"
        data-field="x_image"
        data-size="250"
        data-accept-file-types="<?= $Page->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->image->ImageCropper ? 0 : 1 ?>"
        <?= ($Page->image->ReadOnly || $Page->image->Disabled) ? " disabled" : "" ?>
        <?= $Page->image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Page->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Page->RowIndex ?>_image" id= "fn_x<?= $Page->RowIndex ?>_image" value="<?= $Page->image->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Page->RowIndex ?>_image" id= "fa_x<?= $Page->RowIndex ?>_image" value="<?= (Post("fa_x<?= $Page->RowIndex ?>_image") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Page->RowIndex ?>_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_image" class="el_s_admission_info_image">
<span>
<?= GetFileViewTag($Page->image, $Page->image->getViewValue(), false) ?>
</span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Page->remarks->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_remarks" class="el_s_admission_info_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_remarks" id="x<?= $Page->RowIndex ?>_remarks" data-table="s_admission_info" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="s_admission_info" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_remarks" id="o<?= $Page->RowIndex ?>_remarks" value="<?= HtmlEncode($Page->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_remarks" class="el_s_admission_info_remarks">
<input type="<?= $Page->remarks->getInputTextType() ?>" name="x<?= $Page->RowIndex ?>_remarks" id="x<?= $Page->RowIndex ?>_remarks" data-table="s_admission_info" data-field="x_remarks" value="<?= $Page->remarks->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Page->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->remarks->formatPattern()) ?>"<?= $Page->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_remarks" class="el_s_admission_info_remarks">
<span<?= $Page->remarks->viewAttributes() ?>>
<?= $Page->remarks->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->status->Visible) { // status ?>
        <td data-name="status"<?= $Page->status->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_status" class="el_s_admission_info_status">
<?php
if (IsRTL()) {
    $Page->status->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_status" class="ew-auto-suggest">
    <input type="<?= $Page->status->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_status" id="sv_x<?= $Page->RowIndex ?>_status" value="<?= RemoveHtml($Page->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_admission_info" data-field="x_status" data-input="sv_x<?= $Page->RowIndex ?>_status" data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_status" id="x<?= $Page->RowIndex ?>_status" value="<?= HtmlEncode($Page->status->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_status","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_admission_info.fields.status.autoSuggestOptions));
});
</script>
</span>
<input type="hidden" data-table="s_admission_info" data-field="x_status" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_status" id="o<?= $Page->RowIndex ?>_status" value="<?= HtmlEncode($Page->status->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_status" class="el_s_admission_info_status">
<?php
if (IsRTL()) {
    $Page->status->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Page->RowIndex ?>_status" class="ew-auto-suggest">
    <input type="<?= $Page->status->getInputTextType() ?>" class="form-control" name="sv_x<?= $Page->RowIndex ?>_status" id="sv_x<?= $Page->RowIndex ?>_status" value="<?= RemoveHtml($Page->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->status->formatPattern()) ?>"<?= $Page->status->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_admission_info" data-field="x_status" data-input="sv_x<?= $Page->RowIndex ?>_status" data-value-separator="<?= $Page->status->displayValueSeparatorAttribute() ?>" name="x<?= $Page->RowIndex ?>_status" id="x<?= $Page->RowIndex ?>_status" value="<?= HtmlEncode($Page->status->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->status->getErrorMessage() ?></div>
<script>
loadjs.ready("<?= $Page->FormName ?>", function() {
    <?= $Page->FormName ?>.createAutoSuggest(Object.assign({"id":"x<?= $Page->RowIndex ?>_status","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_admission_info.fields.status.autoSuggestOptions));
});
</script>
</span>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_status" class="el_s_admission_info_status">
<span<?= $Page->status->viewAttributes() ?>>
<?= $Page->status->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Page->operator->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="s_admission_info" data-field="x_operator" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_operator" id="o<?= $Page->RowIndex ?>_operator" value="<?= HtmlEncode($Page->operator->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_operator" class="el_s_admission_info_operator">
<span<?= $Page->operator->viewAttributes() ?>>
<?= $Page->operator->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Page->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Page->datetime->cellAttributes() ?>>
<?php if ($Page->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="s_admission_info" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Page->RowIndex ?>_datetime" id="o<?= $Page->RowIndex ?>_datetime" value="<?= HtmlEncode($Page->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Page->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Page->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_s_admission_info_datetime" class="el_s_admission_info_datetime">
<span<?= $Page->datetime->viewAttributes() ?>>
<?= $Page->datetime->getViewValue() ?></span>
</span>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php if ($Page->RowType == RowType::ADD || $Page->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Page->RowIndex ?>">
loadjs.ready(["<?= $Page->FormName ?>","load"], () => <?= $Page->FormName ?>.updateLists(<?= $Page->RowIndex ?><?= $Page->isAdd() || $Page->isEdit() || $Page->isCopy() || $Page->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if ($Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<?php if ($Page->isGridEdit()) { ?>
<input type="hidden" name="action" id="action" value="gridupdate">
<?php } elseif ($Page->isMultiEdit()) { ?>
<input type="hidden" name="action" id="action" value="multiupdate">
<?php } ?>
<input type="hidden" name="<?= $Page->FormKeyCountName ?>" id="<?= $Page->FormKeyCountName ?>" value="<?= $Page->KeyCount ?>">
<?= $Page->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_admission_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
