<?php

namespace PHPMaker2024\fibre;

// Set up and run Grid object
$Grid = Container("SAdmissionInfoGrid");
$Grid->run();
?>
<?php if (!$Grid->isExport()) { ?>
<script>
var fs_admission_infogrid;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let currentTable = <?= JsonEncode($Grid->toClientVar()) ?>;
    ew.deepAssign(ew.vars, { tables: { s_admission_info: currentTable } });
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fs_admission_infogrid")
        .setPageId("grid")
        .setFormKeyCountName("<?= $Grid->FormKeyCountName ?>")

        // Add fields
        .setFields([
            ["id", [fields.id.visible && fields.id.required ? ew.Validators.required(fields.id.caption) : null], fields.id.isInvalid],
            ["s_pid", [fields.s_pid.visible && fields.s_pid.required ? ew.Validators.required(fields.s_pid.caption) : null], fields.s_pid.isInvalid],
            ["faculty", [fields.faculty.visible && fields.faculty.required ? ew.Validators.required(fields.faculty.caption) : null], fields.faculty.isInvalid],
            ["admission_year", [fields.admission_year.visible && fields.admission_year.required ? ew.Validators.required(fields.admission_year.caption) : null], fields.admission_year.isInvalid],
            ["image", [fields.image.visible && fields.image.required ? ew.Validators.fileRequired(fields.image.caption) : null], fields.image.isInvalid],
            ["remarks", [fields.remarks.visible && fields.remarks.required ? ew.Validators.required(fields.remarks.caption) : null], fields.remarks.isInvalid],
            ["status", [fields.status.visible && fields.status.required ? ew.Validators.required(fields.status.caption) : null, ew.Validators.integer], fields.status.isInvalid],
            ["operator", [fields.operator.visible && fields.operator.required ? ew.Validators.required(fields.operator.caption) : null], fields.operator.isInvalid],
            ["datetime", [fields.datetime.visible && fields.datetime.required ? ew.Validators.required(fields.datetime.caption) : null], fields.datetime.isInvalid]
        ])

        // Check empty row
        .setEmptyRow(
            function (rowIndex) {
                let fobj = this.getForm(),
                    fields = [["s_pid",false],["faculty",false],["admission_year",false],["image",false],["remarks",false],["status",false]];
                if (fields.some(field => ew.valueChanged(fobj, rowIndex, ...field)))
                    return false;
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "s_pid": <?= $Grid->s_pid->toClientList($Grid) ?>,
            "faculty": <?= $Grid->faculty->toClientList($Grid) ?>,
            "admission_year": <?= $Grid->admission_year->toClientList($Grid) ?>,
            "status": <?= $Grid->status->toClientList($Grid) ?>,
        })
        .build();
    window[form.id] = form;
    loadjs.done(form.id);
});
</script>
<?php } ?>
<main class="list">
<div id="ew-header-options">
<?php $Grid->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Grid->TotalRecords > 0 || $Grid->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Grid->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Grid->TableGridClass ?>">
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-header ew-grid-upper-panel">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
<div id="fs_admission_infogrid" class="ew-form ew-list-form">
<div id="gmp_s_admission_info" class="card-body ew-grid-middle-panel <?= $Grid->TableContainerClass ?>" style="<?= $Grid->TableContainerStyle ?>">
<table id="tbl_s_admission_infogrid" class="<?= $Grid->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Grid->RowType = RowType::HEADER;

// Render list options
$Grid->renderListOptions();

// Render list options (header, left)
$Grid->ListOptions->render("header", "left");
?>
<?php if ($Grid->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Grid->id->headerCellClass() ?>"><div id="elh_s_admission_info_id" class="s_admission_info_id"><?= $Grid->renderFieldHeader($Grid->id) ?></div></th>
<?php } ?>
<?php if ($Grid->s_pid->Visible) { // s_pid ?>
        <th data-name="s_pid" class="<?= $Grid->s_pid->headerCellClass() ?>"><div id="elh_s_admission_info_s_pid" class="s_admission_info_s_pid"><?= $Grid->renderFieldHeader($Grid->s_pid) ?></div></th>
<?php } ?>
<?php if ($Grid->faculty->Visible) { // faculty ?>
        <th data-name="faculty" class="<?= $Grid->faculty->headerCellClass() ?>"><div id="elh_s_admission_info_faculty" class="s_admission_info_faculty"><?= $Grid->renderFieldHeader($Grid->faculty) ?></div></th>
<?php } ?>
<?php if ($Grid->admission_year->Visible) { // admission_year ?>
        <th data-name="admission_year" class="<?= $Grid->admission_year->headerCellClass() ?>"><div id="elh_s_admission_info_admission_year" class="s_admission_info_admission_year"><?= $Grid->renderFieldHeader($Grid->admission_year) ?></div></th>
<?php } ?>
<?php if ($Grid->image->Visible) { // image ?>
        <th data-name="image" class="<?= $Grid->image->headerCellClass() ?>"><div id="elh_s_admission_info_image" class="s_admission_info_image"><?= $Grid->renderFieldHeader($Grid->image) ?></div></th>
<?php } ?>
<?php if ($Grid->remarks->Visible) { // remarks ?>
        <th data-name="remarks" class="<?= $Grid->remarks->headerCellClass() ?>"><div id="elh_s_admission_info_remarks" class="s_admission_info_remarks"><?= $Grid->renderFieldHeader($Grid->remarks) ?></div></th>
<?php } ?>
<?php if ($Grid->status->Visible) { // status ?>
        <th data-name="status" class="<?= $Grid->status->headerCellClass() ?>"><div id="elh_s_admission_info_status" class="s_admission_info_status"><?= $Grid->renderFieldHeader($Grid->status) ?></div></th>
<?php } ?>
<?php if ($Grid->operator->Visible) { // operator ?>
        <th data-name="operator" class="<?= $Grid->operator->headerCellClass() ?>"><div id="elh_s_admission_info_operator" class="s_admission_info_operator"><?= $Grid->renderFieldHeader($Grid->operator) ?></div></th>
<?php } ?>
<?php if ($Grid->datetime->Visible) { // datetime ?>
        <th data-name="datetime" class="<?= $Grid->datetime->headerCellClass() ?>"><div id="elh_s_admission_info_datetime" class="s_admission_info_datetime"><?= $Grid->renderFieldHeader($Grid->datetime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Grid->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Grid->getPageNumber() ?>">
<?php
$Grid->setupGrid();
while ($Grid->RecordCount < $Grid->StopRecord || $Grid->RowIndex === '$rowindex$') {
    if (
        $Grid->CurrentRow !== false &&
        $Grid->RowIndex !== '$rowindex$' &&
        (!$Grid->isGridAdd() || $Grid->CurrentMode == "copy") &&
        (!(($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0))
    ) {
        $Grid->fetch();
    }
    $Grid->RecordCount++;
    if ($Grid->RecordCount >= $Grid->StartRecord) {
        $Grid->setupRow();

        // Skip 1) delete row / empty row for confirm page, 2) hidden row
        if (
            $Grid->RowAction != "delete" &&
            $Grid->RowAction != "insertdelete" &&
            !($Grid->RowAction == "insert" && $Grid->isConfirm() && $Grid->emptyRow()) &&
            $Grid->RowAction != "hide"
        ) {
?>
    <tr <?= $Grid->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Grid->ListOptions->render("body", "left", $Grid->RowCount);
?>
    <?php if ($Grid->id->Visible) { // id ?>
        <td data-name="id"<?= $Grid->id->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_id" class="el_s_admission_info_id"></span>
<input type="hidden" data-table="s_admission_info" data-field="x_id" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_id" id="o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_id" class="el_s_admission_info_id">
<span<?= $Grid->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= HtmlEncode(RemoveHtml($Grid->id->getDisplayValue($Grid->id->EditValue))) ?>"></span>
<input type="hidden" data-table="s_admission_info" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_id" class="el_s_admission_info_id">
<span<?= $Grid->id->viewAttributes() ?>>
<?= $Grid->id->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_admission_info" data-field="x_id" data-hidden="1" name="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_id" id="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->FormValue) ?>">
<input type="hidden" data-table="s_admission_info" data-field="x_id" data-hidden="1" data-old name="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_id" id="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } else { ?>
            <input type="hidden" data-table="s_admission_info" data-field="x_id" data-hidden="1" name="x<?= $Grid->RowIndex ?>_id" id="x<?= $Grid->RowIndex ?>_id" value="<?= HtmlEncode($Grid->id->CurrentValue) ?>">
    <?php } ?>
    <?php if ($Grid->s_pid->Visible) { // s_pid ?>
        <td data-name="s_pid"<?= $Grid->s_pid->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<?php if ($Grid->s_pid->getSessionValue() != "") { ?>
<span<?= $Grid->s_pid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->s_pid->getDisplayValue($Grid->s_pid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_s_pid" name="x<?= $Grid->RowIndex ?>_s_pid" value="<?= HtmlEncode($Grid->s_pid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_s_pid" class="el_s_admission_info_s_pid">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_s_pid"
        name="x<?= $Grid->RowIndex ?>_s_pid"
        class="form-control ew-select<?= $Grid->s_pid->isInvalidClass() ?>"
        data-select2-id="fs_admission_infogrid_x<?= $Grid->RowIndex ?>_s_pid"
        data-table="s_admission_info"
        data-field="x_s_pid"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->s_pid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->s_pid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_pid->getPlaceHolder()) ?>"
        <?= $Grid->s_pid->editAttributes() ?>>
        <?= $Grid->s_pid->selectOptionListHtml("x{$Grid->RowIndex}_s_pid") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "s_personal_info") && !$Grid->s_pid->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_s_pid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->s_pid->caption() ?>" data-title="<?= $Grid->s_pid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_s_pid" data-url="<?= GetUrl("spersonalinfoaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->s_pid->getErrorMessage() ?></div>
<?= $Grid->s_pid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_pid") ?>
<script>
loadjs.ready("fs_admission_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_pid", selectId: "fs_admission_infogrid_x<?= $Grid->RowIndex ?>_s_pid" };
    if (fs_admission_infogrid.lists.s_pid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_pid", form: "fs_admission_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_pid", form: "fs_admission_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.s_admission_info.fields.s_pid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<input type="hidden" data-table="s_admission_info" data-field="x_s_pid" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_s_pid" id="o<?= $Grid->RowIndex ?>_s_pid" value="<?= HtmlEncode($Grid->s_pid->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php if ($Grid->s_pid->getSessionValue() != "") { ?>
<span<?= $Grid->s_pid->viewAttributes() ?>>
<span class="form-control-plaintext"><?= $Grid->s_pid->getDisplayValue($Grid->s_pid->ViewValue) ?></span></span>
<input type="hidden" id="x<?= $Grid->RowIndex ?>_s_pid" name="x<?= $Grid->RowIndex ?>_s_pid" value="<?= HtmlEncode($Grid->s_pid->CurrentValue) ?>" data-hidden="1">
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_s_pid" class="el_s_admission_info_s_pid">
<div class="input-group flex-nowrap">
    <select
        id="x<?= $Grid->RowIndex ?>_s_pid"
        name="x<?= $Grid->RowIndex ?>_s_pid"
        class="form-control ew-select<?= $Grid->s_pid->isInvalidClass() ?>"
        data-select2-id="fs_admission_infogrid_x<?= $Grid->RowIndex ?>_s_pid"
        data-table="s_admission_info"
        data-field="x_s_pid"
        data-caption="<?= HtmlEncode(RemoveHtml($Grid->s_pid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Grid->s_pid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->s_pid->getPlaceHolder()) ?>"
        <?= $Grid->s_pid->editAttributes() ?>>
        <?= $Grid->s_pid->selectOptionListHtml("x{$Grid->RowIndex}_s_pid") ?>
    </select>
    <?php if (AllowAdd(CurrentProjectID() . "s_personal_info") && !$Grid->s_pid->ReadOnly) { ?>
    <button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x<?= $Grid->RowIndex ?>_s_pid" title="<?= HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $Grid->s_pid->caption() ?>" data-title="<?= $Grid->s_pid->caption() ?>" data-ew-action="add-option" data-el="x<?= $Grid->RowIndex ?>_s_pid" data-url="<?= GetUrl("spersonalinfoaddopt") ?>"><i class="fa-solid fa-plus ew-icon"></i></button>
    <?php } ?>
</div>
<div class="invalid-feedback"><?= $Grid->s_pid->getErrorMessage() ?></div>
<?= $Grid->s_pid->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_s_pid") ?>
<script>
loadjs.ready("fs_admission_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_s_pid", selectId: "fs_admission_infogrid_x<?= $Grid->RowIndex ?>_s_pid" };
    if (fs_admission_infogrid.lists.s_pid?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_s_pid", form: "fs_admission_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_s_pid", form: "fs_admission_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.s_admission_info.fields.s_pid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
<?php } ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_s_pid" class="el_s_admission_info_s_pid">
<span<?= $Grid->s_pid->viewAttributes() ?>>
<?= $Grid->s_pid->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_admission_info" data-field="x_s_pid" data-hidden="1" name="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_s_pid" id="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_s_pid" value="<?= HtmlEncode($Grid->s_pid->FormValue) ?>">
<input type="hidden" data-table="s_admission_info" data-field="x_s_pid" data-hidden="1" data-old name="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_s_pid" id="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_s_pid" value="<?= HtmlEncode($Grid->s_pid->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->faculty->Visible) { // faculty ?>
        <td data-name="faculty"<?= $Grid->faculty->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_faculty" class="el_s_admission_info_faculty">
    <select
        id="x<?= $Grid->RowIndex ?>_faculty"
        name="x<?= $Grid->RowIndex ?>_faculty"
        class="form-select ew-select<?= $Grid->faculty->isInvalidClass() ?>"
        <?php if (!$Grid->faculty->IsNativeSelect) { ?>
        data-select2-id="fs_admission_infogrid_x<?= $Grid->RowIndex ?>_faculty"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_faculty"
        data-value-separator="<?= $Grid->faculty->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->faculty->getPlaceHolder()) ?>"
        <?= $Grid->faculty->editAttributes() ?>>
        <?= $Grid->faculty->selectOptionListHtml("x{$Grid->RowIndex}_faculty") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->faculty->getErrorMessage() ?></div>
<?= $Grid->faculty->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_faculty") ?>
<?php if (!$Grid->faculty->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_admission_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_faculty", selectId: "fs_admission_infogrid_x<?= $Grid->RowIndex ?>_faculty" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_admission_infogrid.lists.faculty?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_faculty", form: "fs_admission_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_faculty", form: "fs_admission_infogrid", limit: 5 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.faculty.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_admission_info" data-field="x_faculty" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_faculty" id="o<?= $Grid->RowIndex ?>_faculty" value="<?= HtmlEncode($Grid->faculty->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_faculty" class="el_s_admission_info_faculty">
    <select
        id="x<?= $Grid->RowIndex ?>_faculty"
        name="x<?= $Grid->RowIndex ?>_faculty"
        class="form-select ew-select<?= $Grid->faculty->isInvalidClass() ?>"
        <?php if (!$Grid->faculty->IsNativeSelect) { ?>
        data-select2-id="fs_admission_infogrid_x<?= $Grid->RowIndex ?>_faculty"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_faculty"
        data-value-separator="<?= $Grid->faculty->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->faculty->getPlaceHolder()) ?>"
        <?= $Grid->faculty->editAttributes() ?>>
        <?= $Grid->faculty->selectOptionListHtml("x{$Grid->RowIndex}_faculty") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->faculty->getErrorMessage() ?></div>
<?= $Grid->faculty->Lookup->getParamTag($Grid, "p_x" . $Grid->RowIndex . "_faculty") ?>
<?php if (!$Grid->faculty->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_admission_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_faculty", selectId: "fs_admission_infogrid_x<?= $Grid->RowIndex ?>_faculty" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_admission_infogrid.lists.faculty?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_faculty", form: "fs_admission_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_faculty", form: "fs_admission_infogrid", limit: 5 };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.faculty.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_faculty" class="el_s_admission_info_faculty">
<span<?= $Grid->faculty->viewAttributes() ?>>
<?= $Grid->faculty->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_admission_info" data-field="x_faculty" data-hidden="1" name="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_faculty" id="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_faculty" value="<?= HtmlEncode($Grid->faculty->FormValue) ?>">
<input type="hidden" data-table="s_admission_info" data-field="x_faculty" data-hidden="1" data-old name="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_faculty" id="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_faculty" value="<?= HtmlEncode($Grid->faculty->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->admission_year->Visible) { // admission_year ?>
        <td data-name="admission_year"<?= $Grid->admission_year->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_admission_year" class="el_s_admission_info_admission_year">
    <select
        id="x<?= $Grid->RowIndex ?>_admission_year"
        name="x<?= $Grid->RowIndex ?>_admission_year"
        class="form-select ew-select<?= $Grid->admission_year->isInvalidClass() ?>"
        <?php if (!$Grid->admission_year->IsNativeSelect) { ?>
        data-select2-id="fs_admission_infogrid_x<?= $Grid->RowIndex ?>_admission_year"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_admission_year"
        data-value-separator="<?= $Grid->admission_year->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->admission_year->getPlaceHolder()) ?>"
        <?= $Grid->admission_year->editAttributes() ?>>
        <?= $Grid->admission_year->selectOptionListHtml("x{$Grid->RowIndex}_admission_year") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->admission_year->getErrorMessage() ?></div>
<?php if (!$Grid->admission_year->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_admission_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_admission_year", selectId: "fs_admission_infogrid_x<?= $Grid->RowIndex ?>_admission_year" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_admission_infogrid.lists.admission_year?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_admission_year", form: "fs_admission_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_admission_year", form: "fs_admission_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.admission_year.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<input type="hidden" data-table="s_admission_info" data-field="x_admission_year" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_admission_year" id="o<?= $Grid->RowIndex ?>_admission_year" value="<?= HtmlEncode($Grid->admission_year->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_admission_year" class="el_s_admission_info_admission_year">
    <select
        id="x<?= $Grid->RowIndex ?>_admission_year"
        name="x<?= $Grid->RowIndex ?>_admission_year"
        class="form-select ew-select<?= $Grid->admission_year->isInvalidClass() ?>"
        <?php if (!$Grid->admission_year->IsNativeSelect) { ?>
        data-select2-id="fs_admission_infogrid_x<?= $Grid->RowIndex ?>_admission_year"
        <?php } ?>
        data-table="s_admission_info"
        data-field="x_admission_year"
        data-value-separator="<?= $Grid->admission_year->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Grid->admission_year->getPlaceHolder()) ?>"
        <?= $Grid->admission_year->editAttributes() ?>>
        <?= $Grid->admission_year->selectOptionListHtml("x{$Grid->RowIndex}_admission_year") ?>
    </select>
    <div class="invalid-feedback"><?= $Grid->admission_year->getErrorMessage() ?></div>
<?php if (!$Grid->admission_year->IsNativeSelect) { ?>
<script>
loadjs.ready("fs_admission_infogrid", function() {
    var options = { name: "x<?= $Grid->RowIndex ?>_admission_year", selectId: "fs_admission_infogrid_x<?= $Grid->RowIndex ?>_admission_year" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fs_admission_infogrid.lists.admission_year?.lookupOptions.length) {
        options.data = { id: "x<?= $Grid->RowIndex ?>_admission_year", form: "fs_admission_infogrid" };
    } else {
        options.ajax = { id: "x<?= $Grid->RowIndex ?>_admission_year", form: "fs_admission_infogrid", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.s_admission_info.fields.admission_year.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_admission_year" class="el_s_admission_info_admission_year">
<span<?= $Grid->admission_year->viewAttributes() ?>>
<?= $Grid->admission_year->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_admission_info" data-field="x_admission_year" data-hidden="1" name="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_admission_year" id="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_admission_year" value="<?= HtmlEncode($Grid->admission_year->FormValue) ?>">
<input type="hidden" data-table="s_admission_info" data-field="x_admission_year" data-hidden="1" data-old name="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_admission_year" id="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_admission_year" value="<?= HtmlEncode($Grid->admission_year->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->image->Visible) { // image ?>
        <td data-name="image"<?= $Grid->image->cellAttributes() ?>>
<?php if ($Grid->RowAction == "insert") { // Add record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex ?>_s_admission_info_image" class="el_s_admission_info_image">
<div id="fd_x<?= $Grid->RowIndex ?>_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_image"
        name="x<?= $Grid->RowIndex ?>_image"
        class="form-control ew-file-input"
        title="<?= $Grid->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="s_admission_info"
        data-field="x_image"
        data-size="250"
        data-accept-file-types="<?= $Grid->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->image->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->image->ReadOnly || $Grid->image->Disabled) ? " disabled" : "" ?>
        <?= $Grid->image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_image" id= "fn_x<?= $Grid->RowIndex ?>_image" value="<?= $Grid->image->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_image" id= "fa_x<?= $Grid->RowIndex ?>_image" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex ?>_s_admission_info_image" class="el_s_admission_info_image">
<div id="fd_x<?= $Grid->RowIndex ?>_image">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_image"
        name="x<?= $Grid->RowIndex ?>_image"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="s_admission_info"
        data-field="x_image"
        data-size="250"
        data-accept-file-types="<?= $Grid->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->image->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->image->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_image" id= "fn_x<?= $Grid->RowIndex ?>_image" value="<?= $Grid->image->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_image" id= "fa_x<?= $Grid->RowIndex ?>_image" value="0">
<table id="ft_x<?= $Grid->RowIndex ?>_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<input type="hidden" data-table="s_admission_info" data-field="x_image" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_image" id="o<?= $Grid->RowIndex ?>_image" value="<?= HtmlEncode($Grid->image->OldValue) ?>">
<?php } elseif ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_image" class="el_s_admission_info_image">
<span>
<?= GetFileViewTag($Grid->image, $Grid->image->getViewValue(), false) ?>
</span>
</span>
<?php } else  { // Edit record ?>
<?php if (!$Grid->isConfirm()) { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_image" class="el_s_admission_info_image">
<div id="fd_x<?= $Grid->RowIndex ?>_image" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_image"
        name="x<?= $Grid->RowIndex ?>_image"
        class="form-control ew-file-input"
        title="<?= $Grid->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="s_admission_info"
        data-field="x_image"
        data-size="250"
        data-accept-file-types="<?= $Grid->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->image->ImageCropper ? 0 : 1 ?>"
        <?= ($Grid->image->ReadOnly || $Grid->image->Disabled) ? " disabled" : "" ?>
        <?= $Grid->image->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= $Language->phrase("ChooseFile") ?></div>
    <div class="invalid-feedback"><?= $Grid->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_image" id= "fn_x<?= $Grid->RowIndex ?>_image" value="<?= $Grid->image->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_image" id= "fa_x<?= $Grid->RowIndex ?>_image" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_image") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } else { ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_image" class="el_s_admission_info_image">
<div id="fd_x<?= $Grid->RowIndex ?>_image">
    <input
        type="file"
        id="x<?= $Grid->RowIndex ?>_image"
        name="x<?= $Grid->RowIndex ?>_image"
        class="form-control ew-file-input d-none"
        title="<?= $Grid->image->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="s_admission_info"
        data-field="x_image"
        data-size="250"
        data-accept-file-types="<?= $Grid->image->acceptFileTypes() ?>"
        data-max-file-size="<?= $Grid->image->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Grid->image->ImageCropper ? 0 : 1 ?>"
        <?= $Grid->image->editAttributes() ?>
    >
    <div class="invalid-feedback"><?= $Grid->image->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x<?= $Grid->RowIndex ?>_image" id= "fn_x<?= $Grid->RowIndex ?>_image" value="<?= $Grid->image->Upload->FileName ?>">
<input type="hidden" name="fa_x<?= $Grid->RowIndex ?>_image" id= "fa_x<?= $Grid->RowIndex ?>_image" value="<?= (Post("fa_x<?= $Grid->RowIndex ?>_image") == "0") ? "0" : "1" ?>">
<table id="ft_x<?= $Grid->RowIndex ?>_image" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->remarks->Visible) { // remarks ?>
        <td data-name="remarks"<?= $Grid->remarks->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_remarks" class="el_s_admission_info_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="s_admission_info" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<input type="hidden" data-table="s_admission_info" data-field="x_remarks" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_remarks" id="o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_remarks" class="el_s_admission_info_remarks">
<input type="<?= $Grid->remarks->getInputTextType() ?>" name="x<?= $Grid->RowIndex ?>_remarks" id="x<?= $Grid->RowIndex ?>_remarks" data-table="s_admission_info" data-field="x_remarks" value="<?= $Grid->remarks->EditValue ?>" size="30" maxlength="65535" placeholder="<?= HtmlEncode($Grid->remarks->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->remarks->formatPattern()) ?>"<?= $Grid->remarks->editAttributes() ?>>
<div class="invalid-feedback"><?= $Grid->remarks->getErrorMessage() ?></div>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_remarks" class="el_s_admission_info_remarks">
<span<?= $Grid->remarks->viewAttributes() ?>>
<?= $Grid->remarks->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_admission_info" data-field="x_remarks" data-hidden="1" name="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_remarks" id="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->FormValue) ?>">
<input type="hidden" data-table="s_admission_info" data-field="x_remarks" data-hidden="1" data-old name="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_remarks" id="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_remarks" value="<?= HtmlEncode($Grid->remarks->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->status->Visible) { // status ?>
        <td data-name="status"<?= $Grid->status->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_status" class="el_s_admission_info_status">
<?php
if (IsRTL()) {
    $Grid->status->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_status" class="ew-auto-suggest">
    <input type="<?= $Grid->status->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_status" id="sv_x<?= $Grid->RowIndex ?>_status" value="<?= RemoveHtml($Grid->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->status->formatPattern()) ?>"<?= $Grid->status->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_admission_info" data-field="x_status" data-input="sv_x<?= $Grid->RowIndex ?>_status" data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_status" id="x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<script>
loadjs.ready("fs_admission_infogrid", function() {
    fs_admission_infogrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_status","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_admission_info.fields.status.autoSuggestOptions));
});
</script>
</span>
<input type="hidden" data-table="s_admission_info" data-field="x_status" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_status" id="o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_status" class="el_s_admission_info_status">
<?php
if (IsRTL()) {
    $Grid->status->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x<?= $Grid->RowIndex ?>_status" class="ew-auto-suggest">
    <input type="<?= $Grid->status->getInputTextType() ?>" class="form-control" name="sv_x<?= $Grid->RowIndex ?>_status" id="sv_x<?= $Grid->RowIndex ?>_status" value="<?= RemoveHtml($Grid->status->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Grid->status->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Grid->status->formatPattern()) ?>"<?= $Grid->status->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="s_admission_info" data-field="x_status" data-input="sv_x<?= $Grid->RowIndex ?>_status" data-value-separator="<?= $Grid->status->displayValueSeparatorAttribute() ?>" name="x<?= $Grid->RowIndex ?>_status" id="x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->CurrentValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Grid->status->getErrorMessage() ?></div>
<script>
loadjs.ready("fs_admission_infogrid", function() {
    fs_admission_infogrid.createAutoSuggest(Object.assign({"id":"x<?= $Grid->RowIndex ?>_status","forceSelect":false}, { lookupAllDisplayFields: <?= $Grid->status->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.s_admission_info.fields.status.autoSuggestOptions));
});
</script>
</span>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_status" class="el_s_admission_info_status">
<span<?= $Grid->status->viewAttributes() ?>>
<?= $Grid->status->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_admission_info" data-field="x_status" data-hidden="1" name="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_status" id="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->FormValue) ?>">
<input type="hidden" data-table="s_admission_info" data-field="x_status" data-hidden="1" data-old name="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_status" id="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_status" value="<?= HtmlEncode($Grid->status->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->operator->Visible) { // operator ?>
        <td data-name="operator"<?= $Grid->operator->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="s_admission_info" data-field="x_operator" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_operator" id="o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_operator" class="el_s_admission_info_operator">
<span<?= $Grid->operator->viewAttributes() ?>>
<?= $Grid->operator->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_admission_info" data-field="x_operator" data-hidden="1" name="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_operator" id="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->FormValue) ?>">
<input type="hidden" data-table="s_admission_info" data-field="x_operator" data-hidden="1" data-old name="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_operator" id="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_operator" value="<?= HtmlEncode($Grid->operator->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
    <?php if ($Grid->datetime->Visible) { // datetime ?>
        <td data-name="datetime"<?= $Grid->datetime->cellAttributes() ?>>
<?php if ($Grid->RowType == RowType::ADD) { // Add record ?>
<input type="hidden" data-table="s_admission_info" data-field="x_datetime" data-hidden="1" data-old name="o<?= $Grid->RowIndex ?>_datetime" id="o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php if ($Grid->RowType == RowType::EDIT) { // Edit record ?>
<?php } ?>
<?php if ($Grid->RowType == RowType::VIEW) { // View record ?>
<span id="el<?= $Grid->RowIndex == '$rowindex$' ? '$rowindex$' : $Grid->RowCount ?>_s_admission_info_datetime" class="el_s_admission_info_datetime">
<span<?= $Grid->datetime->viewAttributes() ?>>
<?= $Grid->datetime->getViewValue() ?></span>
</span>
<?php if ($Grid->isConfirm()) { ?>
<input type="hidden" data-table="s_admission_info" data-field="x_datetime" data-hidden="1" name="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_datetime" id="fs_admission_infogrid$x<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->FormValue) ?>">
<input type="hidden" data-table="s_admission_info" data-field="x_datetime" data-hidden="1" data-old name="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_datetime" id="fs_admission_infogrid$o<?= $Grid->RowIndex ?>_datetime" value="<?= HtmlEncode($Grid->datetime->OldValue) ?>">
<?php } ?>
<?php } ?>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Grid->ListOptions->render("body", "right", $Grid->RowCount);
?>
    </tr>
<?php if ($Grid->RowType == RowType::ADD || $Grid->RowType == RowType::EDIT) { ?>
<script data-rowindex="<?= $Grid->RowIndex ?>">
loadjs.ready(["fs_admission_infogrid","load"], () => fs_admission_infogrid.updateLists(<?= $Grid->RowIndex ?><?= $Grid->isAdd() || $Grid->isEdit() || $Grid->isCopy() || $Grid->RowIndex === '$rowindex$' ? ", true" : "" ?>));
</script>
<?php } ?>
<?php
    }
    } // End delete row checking

    // Reset for template row
    if ($Grid->RowIndex === '$rowindex$') {
        $Grid->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Grid->isCopy() || $Grid->isAdd()) && $Grid->RowIndex == 0) {
        $Grid->RowIndex = 1;
    }
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php if ($Grid->CurrentMode == "add" || $Grid->CurrentMode == "copy") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
<?php if ($Grid->CurrentMode == "edit") { ?>
<input type="hidden" name="<?= $Grid->FormKeyCountName ?>" id="<?= $Grid->FormKeyCountName ?>" value="<?= $Grid->KeyCount ?>">
<?= $Grid->MultiSelectKey ?>
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if ($Grid->CurrentMode == "") { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
<input type="hidden" name="detailpage" value="fs_admission_infogrid">
</div><!-- /.ew-list-form -->
<?php
// Close result set
$Grid->Recordset?->free();
?>
<?php if ($Grid->ShowOtherOptions) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php $Grid->OtherOptions->render("body", "bottom") ?>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Grid->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Grid->FooterOptions?->render("body") ?>
</div>
</main>
<?php if (!$Grid->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("s_admission_info");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
