<?php

namespace PHPMaker2024\fibre;

// Page object
$RequiredMaterialOverallTableSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { required_material_overall_table: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var frequired_material_overall_tablesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("frequired_material_overall_tablesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["id", [], fields.id.isInvalid],
            ["pending", [ew.Validators.float], fields.pending.isInvalid],
            ["y_pending", [ew.Validators.between], false],
            ["req_material_grp", [], fields.req_material_grp.isInvalid],
            ["req_material_product", [], fields.req_material_product.isInvalid],
            ["req_material_rid", [ew.Validators.integer], fields.req_material_rid.isInvalid],
            ["req_material_packing", [], fields.req_material_packing.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["y_batch_no", [ew.Validators.between], false],
            ["unit", [], fields.unit.isInvalid],
            ["mil", [ew.Validators.float], fields.mil.isInvalid],
            ["req_material_qty", [ew.Validators.float], fields.req_material_qty.isInvalid],
            ["po_s_pending", [ew.Validators.float], fields.po_s_pending.isInvalid],
            ["po_pending_wbc", [ew.Validators.float], fields.po_pending_wbc.isInvalid],
            ["not_loomcard", [ew.Validators.float], fields.not_loomcard.isInvalid],
            ["stock", [ew.Validators.float], fields.stock.isInvalid],
            ["company_id", [], fields.company_id.isInvalid],
            ["last_supplier_id", [], fields.last_supplier_id.isInvalid],
            ["internal_external", [], fields.internal_external.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "req_material_grp": <?= $Page->req_material_grp->toClientList($Page) ?>,
            "req_material_product": <?= $Page->req_material_product->toClientList($Page) ?>,
            "req_material_rid": <?= $Page->req_material_rid->toClientList($Page) ?>,
            "req_material_packing": <?= $Page->req_material_packing->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "company_id": <?= $Page->company_id->toClientList($Page) ?>,
            "last_supplier_id": <?= $Page->last_supplier_id->toClientList($Page) ?>,
            "internal_external": <?= $Page->internal_external->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="frequired_material_overall_tablesearch" id="frequired_material_overall_tablesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="required_material_overall_table">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->id->Visible) { // id ?>
    <div id="r_id" class="row"<?= $Page->id->rowAttributes() ?>>
        <label for="x_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_id"><?= $Page->id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_id" id="z_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_id" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->id->getInputTextType() ?>" name="x_id" id="x_id" data-table="required_material_overall_table" data-field="x_id" value="<?= $Page->id->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->id->formatPattern()) ?>"<?= $Page->id->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->id->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pending->Visible) { // pending ?>
    <div id="r_pending" class="row"<?= $Page->pending->rowAttributes() ?>>
        <label for="x_pending" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_pending"><?= $Page->pending->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pending->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_pending" id="z_pending" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pending->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pending->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_required_material_overall_table_pending" class="ew-search-field">
<input type="<?= $Page->pending->getInputTextType() ?>" name="x_pending" id="x_pending" data-table="required_material_overall_table" data-field="x_pending" value="<?= $Page->pending->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending->formatPattern()) ?>"<?= $Page->pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_required_material_overall_table_pending" class="ew-search-field2 d-none">
<input type="<?= $Page->pending->getInputTextType() ?>" name="y_pending" id="y_pending" data-table="required_material_overall_table" data-field="x_pending" value="<?= $Page->pending->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending->formatPattern()) ?>"<?= $Page->pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_product->Visible) { // req_material_product ?>
    <div id="r_req_material_product" class="row"<?= $Page->req_material_product->rowAttributes() ?>>
        <label for="x_req_material_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_req_material_product"><?= $Page->req_material_product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_product" id="z_req_material_product" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_req_material_product" class="ew-search-field ew-search-field-single">
    <select
        id="x_req_material_product"
        name="x_req_material_product"
        class="form-select ew-select<?= $Page->req_material_product->isInvalidClass() ?>"
        <?php if (!$Page->req_material_product->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesearch_x_req_material_product"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_req_material_product"
        data-value-separator="<?= $Page->req_material_product->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_product->getPlaceHolder()) ?>"
        <?= $Page->req_material_product->editAttributes() ?>>
        <?= $Page->req_material_product->selectOptionListHtml("x_req_material_product") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_product->getErrorMessage(false) ?></div>
<?= $Page->req_material_product->Lookup->getParamTag($Page, "p_x_req_material_product") ?>
<?php if (!$Page->req_material_product->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesearch", function() {
    var options = { name: "x_req_material_product", selectId: "frequired_material_overall_tablesearch_x_req_material_product" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesearch.lists.req_material_product?.lookupOptions.length) {
        options.data = { id: "x_req_material_product", form: "frequired_material_overall_tablesearch" };
    } else {
        options.ajax = { id: "x_req_material_product", form: "frequired_material_overall_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.req_material_product.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
    <div id="r_req_material_rid" class="row"<?= $Page->req_material_rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_req_material_rid"><?= $Page->req_material_rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_req_material_rid" class="ew-search-field ew-search-field-single">
    <select
        id="x_req_material_rid"
        name="x_req_material_rid"
        class="form-control ew-select<?= $Page->req_material_rid->isInvalidClass() ?>"
        data-select2-id="frequired_material_overall_tablesearch_x_req_material_rid"
        data-table="required_material_overall_table"
        data-field="x_req_material_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->req_material_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->req_material_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_rid->getPlaceHolder()) ?>"
        <?= $Page->req_material_rid->editAttributes() ?>>
        <?= $Page->req_material_rid->selectOptionListHtml("x_req_material_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_rid->getErrorMessage(false) ?></div>
<?= $Page->req_material_rid->Lookup->getParamTag($Page, "p_x_req_material_rid") ?>
<script>
loadjs.ready("frequired_material_overall_tablesearch", function() {
    var options = { name: "x_req_material_rid", selectId: "frequired_material_overall_tablesearch_x_req_material_rid" };
    if (frequired_material_overall_tablesearch.lists.req_material_rid?.lookupOptions.length) {
        options.data = { id: "x_req_material_rid", form: "frequired_material_overall_tablesearch" };
    } else {
        options.ajax = { id: "x_req_material_rid", form: "frequired_material_overall_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.required_material_overall_table.fields.req_material_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
    <div id="r_req_material_packing" class="row"<?= $Page->req_material_packing->rowAttributes() ?>>
        <label for="x_req_material_packing" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_req_material_packing"><?= $Page->req_material_packing->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_packing->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_req_material_packing" class="ew-search-field ew-search-field-single">
    <select
        id="x_req_material_packing"
        name="x_req_material_packing"
        class="form-select ew-select<?= $Page->req_material_packing->isInvalidClass() ?>"
        <?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesearch_x_req_material_packing"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_req_material_packing"
        data-value-separator="<?= $Page->req_material_packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_packing->getPlaceHolder()) ?>"
        <?= $Page->req_material_packing->editAttributes() ?>>
        <?= $Page->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_packing->getErrorMessage(false) ?></div>
<?= $Page->req_material_packing->Lookup->getParamTag($Page, "p_x_req_material_packing") ?>
<?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesearch", function() {
    var options = { name: "x_req_material_packing", selectId: "frequired_material_overall_tablesearch_x_req_material_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesearch.lists.req_material_packing?.lookupOptions.length) {
        options.data = { id: "x_req_material_packing", form: "frequired_material_overall_tablesearch" };
    } else {
        options.ajax = { id: "x_req_material_packing", form: "frequired_material_overall_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.req_material_packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_batch_no"><?= $Page->batch_no->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_batch_no" id="z_batch_no" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->batch_no->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->batch_no->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_required_material_overall_table_batch_no" class="ew-search-field">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesearch_x_batch_no"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesearch", function() {
    var options = { name: "x_batch_no", selectId: "frequired_material_overall_tablesearch_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "frequired_material_overall_tablesearch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "frequired_material_overall_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_required_material_overall_table_batch_no" class="ew-search-field2 d-none">
    <select
        id="y_batch_no"
        name="y_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesearch_y_batch_no"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("y_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_y_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesearch", function() {
    var options = { name: "y_batch_no", selectId: "frequired_material_overall_tablesearch_y_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesearch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "y_batch_no", form: "frequired_material_overall_tablesearch" };
    } else {
        options.ajax = { id: "y_batch_no", form: "frequired_material_overall_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit" class="row"<?= $Page->unit->rowAttributes() ?>>
        <label for="x_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_unit"><?= $Page->unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_unit" id="z_unit" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesearch_x_unit"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage(false) ?></div>
<?= $Page->unit->Lookup->getParamTag($Page, "p_x_unit") ?>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesearch", function() {
    var options = { name: "x_unit", selectId: "frequired_material_overall_tablesearch_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesearch.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "frequired_material_overall_tablesearch" };
    } else {
        options.ajax = { id: "x_unit", form: "frequired_material_overall_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->mil->Visible) { // mil ?>
    <div id="r_mil" class="row"<?= $Page->mil->rowAttributes() ?>>
        <label for="x_mil" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_mil"><?= $Page->mil->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_mil" id="z_mil" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->mil->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_mil" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->mil->getInputTextType() ?>" name="x_mil" id="x_mil" data-table="required_material_overall_table" data-field="x_mil" value="<?= $Page->mil->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->mil->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->mil->formatPattern()) ?>"<?= $Page->mil->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->mil->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
    <div id="r_req_material_qty" class="row"<?= $Page->req_material_qty->rowAttributes() ?>>
        <label for="x_req_material_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_req_material_qty"><?= $Page->req_material_qty->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_qty" id="z_req_material_qty" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_req_material_qty" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->req_material_qty->getInputTextType() ?>" name="x_req_material_qty" id="x_req_material_qty" data-table="required_material_overall_table" data-field="x_req_material_qty" value="<?= $Page->req_material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_qty->formatPattern()) ?>"<?= $Page->req_material_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->req_material_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_s_pending->Visible) { // po_s_pending ?>
    <div id="r_po_s_pending" class="row"<?= $Page->po_s_pending->rowAttributes() ?>>
        <label for="x_po_s_pending" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_po_s_pending"><?= $Page->po_s_pending->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_s_pending" id="z_po_s_pending" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_s_pending->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_po_s_pending" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_s_pending->getInputTextType() ?>" name="x_po_s_pending" id="x_po_s_pending" data-table="required_material_overall_table" data-field="x_po_s_pending" value="<?= $Page->po_s_pending->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_s_pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_s_pending->formatPattern()) ?>"<?= $Page->po_s_pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_s_pending->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po_pending_wbc->Visible) { // po_pending_wbc ?>
    <div id="r_po_pending_wbc" class="row"<?= $Page->po_pending_wbc->rowAttributes() ?>>
        <label for="x_po_pending_wbc" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_po_pending_wbc"><?= $Page->po_pending_wbc->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_po_pending_wbc" id="z_po_pending_wbc" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po_pending_wbc->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_po_pending_wbc" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->po_pending_wbc->getInputTextType() ?>" name="x_po_pending_wbc" id="x_po_pending_wbc" data-table="required_material_overall_table" data-field="x_po_pending_wbc" value="<?= $Page->po_pending_wbc->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po_pending_wbc->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po_pending_wbc->formatPattern()) ?>"<?= $Page->po_pending_wbc->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po_pending_wbc->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->not_loomcard->Visible) { // not_loomcard ?>
    <div id="r_not_loomcard" class="row"<?= $Page->not_loomcard->rowAttributes() ?>>
        <label for="x_not_loomcard" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_not_loomcard"><?= $Page->not_loomcard->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_not_loomcard" id="z_not_loomcard" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->not_loomcard->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_not_loomcard" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->not_loomcard->getInputTextType() ?>" name="x_not_loomcard" id="x_not_loomcard" data-table="required_material_overall_table" data-field="x_not_loomcard" value="<?= $Page->not_loomcard->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->not_loomcard->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->not_loomcard->formatPattern()) ?>"<?= $Page->not_loomcard->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->not_loomcard->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->stock->Visible) { // stock ?>
    <div id="r_stock" class="row"<?= $Page->stock->rowAttributes() ?>>
        <label for="x_stock" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_stock"><?= $Page->stock->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_stock" id="z_stock" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->stock->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_stock" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->stock->getInputTextType() ?>" name="x_stock" id="x_stock" data-table="required_material_overall_table" data-field="x_stock" value="<?= $Page->stock->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->stock->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->stock->formatPattern()) ?>"<?= $Page->stock->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->stock->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
    <div id="r_company_id" class="row"<?= $Page->company_id->rowAttributes() ?>>
        <label for="x_company_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_company_id"><?= $Page->company_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_company_id" id="z_company_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->company_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_company_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_company_id"
        name="x_company_id"
        class="form-select ew-select<?= $Page->company_id->isInvalidClass() ?>"
        <?php if (!$Page->company_id->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesearch_x_company_id"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_company_id"
        data-value-separator="<?= $Page->company_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->company_id->getPlaceHolder()) ?>"
        <?= $Page->company_id->editAttributes() ?>>
        <?= $Page->company_id->selectOptionListHtml("x_company_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->company_id->getErrorMessage(false) ?></div>
<?= $Page->company_id->Lookup->getParamTag($Page, "p_x_company_id") ?>
<?php if (!$Page->company_id->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesearch", function() {
    var options = { name: "x_company_id", selectId: "frequired_material_overall_tablesearch_x_company_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesearch.lists.company_id?.lookupOptions.length) {
        options.data = { id: "x_company_id", form: "frequired_material_overall_tablesearch" };
    } else {
        options.ajax = { id: "x_company_id", form: "frequired_material_overall_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.company_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->last_supplier_id->Visible) { // last_supplier_id ?>
    <div id="r_last_supplier_id" class="row"<?= $Page->last_supplier_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_last_supplier_id"><?= $Page->last_supplier_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_last_supplier_id" id="z_last_supplier_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->last_supplier_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_last_supplier_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->last_supplier_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_last_supplier_id" class="ew-auto-suggest">
    <input type="<?= $Page->last_supplier_id->getInputTextType() ?>" class="form-control" name="sv_x_last_supplier_id" id="sv_x_last_supplier_id" value="<?= RemoveHtml($Page->last_supplier_id->EditValue) ?>" autocomplete="off" placeholder="<?= HtmlEncode($Page->last_supplier_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->last_supplier_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->last_supplier_id->formatPattern()) ?>"<?= $Page->last_supplier_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="required_material_overall_table" data-field="x_last_supplier_id" data-input="sv_x_last_supplier_id" data-value-separator="<?= $Page->last_supplier_id->displayValueSeparatorAttribute() ?>" name="x_last_supplier_id" id="x_last_supplier_id" value="<?= HtmlEncode($Page->last_supplier_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->last_supplier_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("frequired_material_overall_tablesearch", function() {
    frequired_material_overall_tablesearch.createAutoSuggest(Object.assign({"id":"x_last_supplier_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->last_supplier_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.required_material_overall_table.fields.last_supplier_id.autoSuggestOptions));
});
</script>
<?= $Page->last_supplier_id->Lookup->getParamTag($Page, "p_x_last_supplier_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->internal_external->Visible) { // internal_external ?>
    <div id="r_internal_external" class="row"<?= $Page->internal_external->rowAttributes() ?>>
        <label for="x_internal_external" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_overall_table_internal_external"><?= $Page->internal_external->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_internal_external" id="z_internal_external" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->internal_external->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_overall_table_internal_external" class="ew-search-field ew-search-field-single">
    <select
        id="x_internal_external"
        name="x_internal_external"
        class="form-select ew-select<?= $Page->internal_external->isInvalidClass() ?>"
        <?php if (!$Page->internal_external->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesearch_x_internal_external"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_internal_external"
        data-value-separator="<?= $Page->internal_external->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->internal_external->getPlaceHolder()) ?>"
        <?= $Page->internal_external->editAttributes() ?>>
        <?= $Page->internal_external->selectOptionListHtml("x_internal_external") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->internal_external->getErrorMessage(false) ?></div>
<?php if (!$Page->internal_external->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesearch", function() {
    var options = { name: "x_internal_external", selectId: "frequired_material_overall_tablesearch_x_internal_external" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesearch.lists.internal_external?.lookupOptions.length) {
        options.data = { id: "x_internal_external", form: "frequired_material_overall_tablesearch" };
    } else {
        options.ajax = { id: "x_internal_external", form: "frequired_material_overall_tablesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.internal_external.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="frequired_material_overall_tablesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="frequired_material_overall_tablesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="frequired_material_overall_tablesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("required_material_overall_table");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
