<?php

namespace PHPMaker2024\fibre;

// Page object
$RequiredMaterialOverallTableList = &$Page;
?>
<?php if (!$Page->isExport()) { ?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { required_material_overall_table: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->FormKeyCountName ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
ew.PREVIEW_SELECTOR ??= ".ew-preview-btn";
ew.PREVIEW_TYPE ??= "row";
ew.PREVIEW_NAV_STYLE ??= "tabs"; // tabs/pills/underline
ew.PREVIEW_MODAL_CLASS ??= "modal modal-fullscreen-sm-down";
ew.PREVIEW_ROW ??= true;
ew.PREVIEW_SINGLE_ROW ??= false;
ew.PREVIEW || ew.ready("head", ew.PATH_BASE + "js/preview.min.js?v=24.15.0", "preview");
</script>
<script>
window.Tabulator || loadjs([
    ew.PATH_BASE + "js/tabulator.min.js?v=24.15.0",
    ew.PATH_BASE + "css/<?= CssFile("tabulator_bootstrap5.css", false) ?>?v=24.15.0"
], "import");
</script>
<script>
loadjs.ready("head", function () {
    // Client script
    // Write your client script here, no need to add script tags.
    window.CreateOrder = function()
    {
    	  $('.ew-list-other-options').hide();
    	  var CAID =[];
    	  $("#tbl_required_material_overall_tablelist tbody input[type='checkbox']:checked").each(function(){
    	  		 CAID.push($(this).val());	  		 
    	  });
    	  if(CAID.length>0)
    	  {
    	  	$.getJSON(window.location.origin +"/apcajaxes?cmo=" + CAID,function(data) {
    	  	location.href='requiredmaterialoveralltablelist?MRDALL=7fa7';
    	  	});
    	  }
    	  else
    	  {
    	  	ew.alert("Please Select atleast a row to Update");
    	  	$('.ew-list-other-options').show();
    	  }
    }
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0 && $Page->ExportOptions->visible()) { ?>
<?php $Page->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->ImportOptions->visible()) { ?>
<?php $Page->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($Page->SearchOptions->visible()) { ?>
<?php $Page->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($Page->FilterOptions->visible()) { ?>
<?php $Page->FilterOptions->render("body") ?>
<?php } ?>
</div>
<?php } ?>
<?php if ($Page->ShowCurrentFilter) { ?>
<?php $Page->showFilterList() ?>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="frequired_material_overall_tablesrch" id="frequired_material_overall_tablesrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="frequired_material_overall_tablesrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { required_material_overall_table: currentTable } });
var currentForm;
var frequired_material_overall_tablesrch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("frequired_material_overall_tablesrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["pending", [ew.Validators.float], fields.pending.isInvalid],
            ["y_pending", [ew.Validators.between], false],
            ["req_material_grp", [], fields.req_material_grp.isInvalid],
            ["req_material_rid", [ew.Validators.integer], fields.req_material_rid.isInvalid],
            ["req_material_packing", [], fields.req_material_packing.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["y_batch_no", [ew.Validators.between], false],
            ["internal_external", [], fields.internal_external.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "req_material_grp": <?= $Page->req_material_grp->toClientList($Page) ?>,
            "req_material_rid": <?= $Page->req_material_rid->toClientList($Page) ?>,
            "req_material_packing": <?= $Page->req_material_packing->toClientList($Page) ?>,
            "batch_no": <?= $Page->batch_no->toClientList($Page) ?>,
            "internal_external": <?= $Page->internal_external->toClientList($Page) ?>,
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)

        // Init search panel as collapsed
        .setInitSearchPanel(true)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    loadjs.done(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if ($Security->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0<?= ($Page->SearchFieldsPerRow > 0) ? " row-cols-sm-" . $Page->SearchFieldsPerRow : "" ?>">
<?php
// Render search row
$Page->RowType = RowType::SEARCH;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->pending->Visible) { // pending ?>
<?php
if (!$Page->pending->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_pending" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->pending->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_pending" class="ew-search-caption ew-label"><?= $Page->pending->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_pending" id="z_pending" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->pending->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->pending->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_required_material_overall_table_pending" class="ew-search-field">
<input type="<?= $Page->pending->getInputTextType() ?>" name="x_pending" id="x_pending" data-table="required_material_overall_table" data-field="x_pending" value="<?= $Page->pending->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending->formatPattern()) ?>"<?= $Page->pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending->getErrorMessage(false) ?></div>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_required_material_overall_table_pending" class="ew-search-field2 d-none">
<input type="<?= $Page->pending->getInputTextType() ?>" name="y_pending" id="y_pending" data-table="required_material_overall_table" data-field="x_pending" value="<?= $Page->pending->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->pending->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pending->formatPattern()) ?>"<?= $Page->pending->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->pending->getErrorMessage(false) ?></div>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->req_material_grp->Visible) { // req_material_grp ?>
<?php
if (!$Page->req_material_grp->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_req_material_grp" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->req_material_grp->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_req_material_grp" class="ew-search-caption ew-label"><?= $Page->req_material_grp->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_grp" id="z_req_material_grp" value="=">
</div>
        </div>
        <div id="el_required_material_overall_table_req_material_grp" class="ew-search-field">
    <select
        id="x_req_material_grp"
        name="x_req_material_grp"
        class="form-select ew-select<?= $Page->req_material_grp->isInvalidClass() ?>"
        <?php if (!$Page->req_material_grp->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesrch_x_req_material_grp"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_req_material_grp"
        data-value-separator="<?= $Page->req_material_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_grp->getPlaceHolder()) ?>"
        <?= $Page->req_material_grp->editAttributes() ?>>
        <?= $Page->req_material_grp->selectOptionListHtml("x_req_material_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_grp->getErrorMessage(false) ?></div>
<?= $Page->req_material_grp->Lookup->getParamTag($Page, "p_x_req_material_grp") ?>
<?php if (!$Page->req_material_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesrch", function() {
    var options = { name: "x_req_material_grp", selectId: "frequired_material_overall_tablesrch_x_req_material_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesrch.lists.req_material_grp?.lookupOptions.length) {
        options.data = { id: "x_req_material_grp", form: "frequired_material_overall_tablesrch" };
    } else {
        options.ajax = { id: "x_req_material_grp", form: "frequired_material_overall_tablesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.req_material_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
<?php
if (!$Page->req_material_rid->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_req_material_rid" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->req_material_rid->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label class="ew-search-caption ew-label"><?= $Page->req_material_rid->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="=">
</div>
        </div>
        <div id="el_required_material_overall_table_req_material_rid" class="ew-search-field">
    <select
        id="x_req_material_rid"
        name="x_req_material_rid"
        class="form-control ew-select<?= $Page->req_material_rid->isInvalidClass() ?>"
        data-select2-id="frequired_material_overall_tablesrch_x_req_material_rid"
        data-table="required_material_overall_table"
        data-field="x_req_material_rid"
        data-caption="<?= HtmlEncode(RemoveHtml($Page->req_material_rid->caption())) ?>"
        data-modal-lookup="true"
        data-value-separator="<?= $Page->req_material_rid->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_rid->getPlaceHolder()) ?>"
        <?= $Page->req_material_rid->editAttributes() ?>>
        <?= $Page->req_material_rid->selectOptionListHtml("x_req_material_rid") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_rid->getErrorMessage(false) ?></div>
<?= $Page->req_material_rid->Lookup->getParamTag($Page, "p_x_req_material_rid") ?>
<script>
loadjs.ready("frequired_material_overall_tablesrch", function() {
    var options = { name: "x_req_material_rid", selectId: "frequired_material_overall_tablesrch_x_req_material_rid" };
    if (frequired_material_overall_tablesrch.lists.req_material_rid?.lookupOptions.length) {
        options.data = { id: "x_req_material_rid", form: "frequired_material_overall_tablesrch" };
    } else {
        options.ajax = { id: "x_req_material_rid", form: "frequired_material_overall_tablesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options = Object.assign({}, ew.modalLookupOptions, options, ew.vars.tables.required_material_overall_table.fields.req_material_rid.modalLookupOptions);
    ew.createModalLookup(options);
});
</script>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
<?php
if (!$Page->req_material_packing->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_req_material_packing" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->req_material_packing->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_req_material_packing" class="ew-search-caption ew-label"><?= $Page->req_material_packing->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="=">
</div>
        </div>
        <div id="el_required_material_overall_table_req_material_packing" class="ew-search-field">
    <select
        id="x_req_material_packing"
        name="x_req_material_packing"
        class="form-select ew-select<?= $Page->req_material_packing->isInvalidClass() ?>"
        <?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesrch_x_req_material_packing"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_req_material_packing"
        data-value-separator="<?= $Page->req_material_packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_packing->getPlaceHolder()) ?>"
        <?= $Page->req_material_packing->editAttributes() ?>>
        <?= $Page->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_packing->getErrorMessage(false) ?></div>
<?= $Page->req_material_packing->Lookup->getParamTag($Page, "p_x_req_material_packing") ?>
<?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesrch", function() {
    var options = { name: "x_req_material_packing", selectId: "frequired_material_overall_tablesrch_x_req_material_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesrch.lists.req_material_packing?.lookupOptions.length) {
        options.data = { id: "x_req_material_packing", form: "frequired_material_overall_tablesrch" };
    } else {
        options.ajax = { id: "x_req_material_packing", form: "frequired_material_overall_tablesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.req_material_packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
<?php
if (!$Page->batch_no->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_batch_no" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->batch_no->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_batch_no" class="ew-search-caption ew-label"><?= $Page->batch_no->caption() ?></label>
            <div class="ew-search-operator">
<select name="z_batch_no" id="z_batch_no" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->batch_no->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->batch_no->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</div>
        </div>
        <div id="el_required_material_overall_table_batch_no" class="ew-search-field">
    <select
        id="x_batch_no"
        name="x_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesrch_x_batch_no"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("x_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_x_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesrch", function() {
    var options = { name: "x_batch_no", selectId: "frequired_material_overall_tablesrch_x_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesrch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "x_batch_no", form: "frequired_material_overall_tablesrch" };
    } else {
        options.ajax = { id: "x_batch_no", form: "frequired_material_overall_tablesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
            <div class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></div>
        </div><!-- /.ew-search-field -->
        <div id="el2_required_material_overall_table_batch_no" class="ew-search-field2 d-none">
    <select
        id="y_batch_no"
        name="y_batch_no"
        class="form-select ew-select<?= $Page->batch_no->isInvalidClass() ?>"
        <?php if (!$Page->batch_no->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesrch_y_batch_no"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_batch_no"
        data-value-separator="<?= $Page->batch_no->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>"
        <?= $Page->batch_no->editAttributes() ?>>
        <?= $Page->batch_no->selectOptionListHtml("y_batch_no") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
<?= $Page->batch_no->Lookup->getParamTag($Page, "p_y_batch_no") ?>
<?php if (!$Page->batch_no->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesrch", function() {
    var options = { name: "y_batch_no", selectId: "frequired_material_overall_tablesrch_y_batch_no" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesrch.lists.batch_no?.lookupOptions.length) {
        options.data = { id: "y_batch_no", form: "frequired_material_overall_tablesrch" };
    } else {
        options.ajax = { id: "y_batch_no", form: "frequired_material_overall_tablesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.batch_no.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->internal_external->Visible) { // internal_external ?>
<?php
if (!$Page->internal_external->UseFilter) {
    $Page->SearchColumnCount++;
}
?>
    <div id="xs_internal_external" class="col-sm-auto d-sm-flex align-items-start mb-3 px-0 pe-sm-2<?= $Page->internal_external->UseFilter ? " ew-filter-field" : "" ?>">
        <div class="d-flex my-1 my-sm-0">
            <label for="x_internal_external" class="ew-search-caption ew-label"><?= $Page->internal_external->caption() ?></label>
            <div class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_internal_external" id="z_internal_external" value="=">
</div>
        </div>
        <div id="el_required_material_overall_table_internal_external" class="ew-search-field">
    <select
        id="x_internal_external"
        name="x_internal_external"
        class="form-select ew-select<?= $Page->internal_external->isInvalidClass() ?>"
        <?php if (!$Page->internal_external->IsNativeSelect) { ?>
        data-select2-id="frequired_material_overall_tablesrch_x_internal_external"
        <?php } ?>
        data-table="required_material_overall_table"
        data-field="x_internal_external"
        data-value-separator="<?= $Page->internal_external->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->internal_external->getPlaceHolder()) ?>"
        <?= $Page->internal_external->editAttributes() ?>>
        <?= $Page->internal_external->selectOptionListHtml("x_internal_external") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->internal_external->getErrorMessage(false) ?></div>
<?php if (!$Page->internal_external->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_overall_tablesrch", function() {
    var options = { name: "x_internal_external", selectId: "frequired_material_overall_tablesrch_x_internal_external" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_overall_tablesrch.lists.internal_external?.lookupOptions.length) {
        options.data = { id: "x_internal_external", form: "frequired_material_overall_tablesrch" };
    } else {
        options.ajax = { id: "x_internal_external", form: "frequired_material_overall_tablesrch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_overall_table.fields.internal_external.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</div>
        <div class="d-flex my-1 my-sm-0">
        </div><!-- /.ew-search-field -->
    </div><!-- /.col-sm-auto -->
<?php } ?>
<?php if ($Page->SearchColumnCount > 0) { ?>
   <div class="col-sm-auto mb-3">
       <button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?= $Language->phrase("SearchBtn") ?></button>
   </div>
<?php } ?>
</div><!-- /.row -->
<!-- template for quick search in navbar -->
<script id="navbar-basic-search" type="text/html" class="ew-js-template" data-name="search" data-seq="10" data-data="menu" data-target="#ew-navbar-end" data-method="prependTo">
    <li class="nav-item navbar-basic-search">
        <a class="nav-link" data-widget="navbar-search" href="#" role="button">
            <i class="fa-solid fa-magnifying-glass"></i>
        </a>
        <div class="navbar-search-block">
            <div class="ew-basic-search input-group input-group-sm">
                <input type="text" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control form-control-navbar ew-basic-search-keyword" form="frequired_material_overall_tablesrch" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode($Language->phrase("Search")) ?>" aria-label="<?= HtmlEncode($Language->phrase("Search")) ?>">
                <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="form-control-navbar ew-basic-search-type" form="frequired_material_overall_tablesrch" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
                <button class="btn btn-navbar" form="frequired_material_overall_tablesrch" type="submit">
                    <i class="fa-solid fa-magnifying-glass"></i>
                </button>
                <button type="button" data-bs-toggle="dropdown" class="btn btn-navbar dropdown-toggle" aria-haspopup="true" aria-expanded="false">
                    <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
                </button>
                <div class="dropdown-menu dropdown-menu-end">
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="frequired_material_overall_tablesrch" data-ew-action="search-type"><?= $Language->phrase("QuickSearchAuto") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="frequired_material_overall_tablesrch" data-ew-action="search-type" data-search-type="="><?= $Language->phrase("QuickSearchExact") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="frequired_material_overall_tablesrch" data-ew-action="search-type" data-search-type="AND"><?= $Language->phrase("QuickSearchAll") ?></button>
                    <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="frequired_material_overall_tablesrch" data-ew-action="search-type" data-search-type="OR"><?= $Language->phrase("QuickSearchAny") ?></button>
                </div>
                <button class="btn btn-navbar" type="button" data-widget="navbar-search">
                    <i class="fa-solid fa-xmark"></i>
                </button>
            </div>
        </div>
    </li>
</script>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php if (!$Page->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
</div>
<?php } ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $Page->PageAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="required_material_overall_table">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_required_material_overall_table" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>" style="<?= $Page->TableContainerStyle ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_required_material_overall_tablelist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->id->Visible) { // id ?>
        <th data-name="id" class="<?= $Page->id->headerCellClass() ?>"><div id="elh_required_material_overall_table_id" class="required_material_overall_table_id"><?= $Page->renderFieldHeader($Page->id) ?></div></th>
<?php } ?>
<?php if ($Page->pending->Visible) { // pending ?>
        <th data-name="pending" class="<?= $Page->pending->headerCellClass() ?>"><div id="elh_required_material_overall_table_pending" class="required_material_overall_table_pending"><?= $Page->renderFieldHeader($Page->pending) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_grp->Visible) { // req_material_grp ?>
        <th data-name="req_material_grp" class="<?= $Page->req_material_grp->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_required_material_overall_table_req_material_grp" class="required_material_overall_table_req_material_grp"><?= $Page->renderFieldHeader($Page->req_material_grp) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_product->Visible) { // req_material_product ?>
        <th data-name="req_material_product" class="<?= $Page->req_material_product->headerCellClass() ?>"><div id="elh_required_material_overall_table_req_material_product" class="required_material_overall_table_req_material_product"><?= $Page->renderFieldHeader($Page->req_material_product) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <th data-name="req_material_rid" class="<?= $Page->req_material_rid->headerCellClass() ?>"><div id="elh_required_material_overall_table_req_material_rid" class="required_material_overall_table_req_material_rid"><?= $Page->renderFieldHeader($Page->req_material_rid) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <th data-name="req_material_packing" class="<?= $Page->req_material_packing->headerCellClass() ?>"><div id="elh_required_material_overall_table_req_material_packing" class="required_material_overall_table_req_material_packing"><?= $Page->renderFieldHeader($Page->req_material_packing) ?></div></th>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
        <th data-name="batch_no" class="<?= $Page->batch_no->headerCellClass() ?>"><div id="elh_required_material_overall_table_batch_no" class="required_material_overall_table_batch_no"><?= $Page->renderFieldHeader($Page->batch_no) ?></div></th>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
        <th data-name="unit" class="<?= $Page->unit->headerCellClass() ?>"><div id="elh_required_material_overall_table_unit" class="required_material_overall_table_unit"><?= $Page->renderFieldHeader($Page->unit) ?></div></th>
<?php } ?>
<?php if ($Page->mil->Visible) { // mil ?>
        <th data-name="mil" class="<?= $Page->mil->headerCellClass() ?>"><div id="elh_required_material_overall_table_mil" class="required_material_overall_table_mil"><?= $Page->renderFieldHeader($Page->mil) ?></div></th>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <th data-name="req_material_qty" class="<?= $Page->req_material_qty->headerCellClass() ?>"><div id="elh_required_material_overall_table_req_material_qty" class="required_material_overall_table_req_material_qty"><?= $Page->renderFieldHeader($Page->req_material_qty) ?></div></th>
<?php } ?>
<?php if ($Page->po_s_pending->Visible) { // po_s_pending ?>
        <th data-name="po_s_pending" class="<?= $Page->po_s_pending->headerCellClass() ?>"><div id="elh_required_material_overall_table_po_s_pending" class="required_material_overall_table_po_s_pending"><?= $Page->renderFieldHeader($Page->po_s_pending) ?></div></th>
<?php } ?>
<?php if ($Page->po_pending_wbc->Visible) { // po_pending_wbc ?>
        <th data-name="po_pending_wbc" class="<?= $Page->po_pending_wbc->headerCellClass() ?>"><div id="elh_required_material_overall_table_po_pending_wbc" class="required_material_overall_table_po_pending_wbc"><?= $Page->renderFieldHeader($Page->po_pending_wbc) ?></div></th>
<?php } ?>
<?php if ($Page->not_loomcard->Visible) { // not_loomcard ?>
        <th data-name="not_loomcard" class="<?= $Page->not_loomcard->headerCellClass() ?>"><div id="elh_required_material_overall_table_not_loomcard" class="required_material_overall_table_not_loomcard"><?= $Page->renderFieldHeader($Page->not_loomcard) ?></div></th>
<?php } ?>
<?php if ($Page->stock->Visible) { // stock ?>
        <th data-name="stock" class="<?= $Page->stock->headerCellClass() ?>"><div id="elh_required_material_overall_table_stock" class="required_material_overall_table_stock"><?= $Page->renderFieldHeader($Page->stock) ?></div></th>
<?php } ?>
<?php if ($Page->company_id->Visible) { // company_id ?>
        <th data-name="company_id" class="<?= $Page->company_id->headerCellClass() ?>"><div id="elh_required_material_overall_table_company_id" class="required_material_overall_table_company_id"><?= $Page->renderFieldHeader($Page->company_id) ?></div></th>
<?php } ?>
<?php if ($Page->last_supplier_id->Visible) { // last_supplier_id ?>
        <th data-name="last_supplier_id" class="<?= $Page->last_supplier_id->headerCellClass() ?>"><div id="elh_required_material_overall_table_last_supplier_id" class="required_material_overall_table_last_supplier_id"><?= $Page->renderFieldHeader($Page->last_supplier_id) ?></div></th>
<?php } ?>
<?php if ($Page->internal_external->Visible) { // internal_external ?>
        <th data-name="internal_external" class="<?= $Page->internal_external->headerCellClass() ?>"><div id="elh_required_material_overall_table_internal_external" class="required_material_overall_table_internal_external"><?= $Page->renderFieldHeader($Page->internal_external) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
$Page->setupGrid();
while ($Page->RecordCount < $Page->StopRecord || $Page->RowIndex === '$rowindex$') {
    if (
        $Page->CurrentRow !== false &&
        $Page->RowIndex !== '$rowindex$' &&
        (!$Page->isGridAdd() || $Page->CurrentMode == "copy") &&
        (!(($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0))
    ) {
        $Page->fetch();
    }
    $Page->RecordCount++;
    if ($Page->RecordCount >= $Page->StartRecord) {
        $Page->setupRow();
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id"<?= $Page->id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_id" class="el_required_material_overall_table_id">
<span<?= $Page->id->viewAttributes() ?>>
<?= $Page->id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->pending->Visible) { // pending ?>
        <td data-name="pending"<?= $Page->pending->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_pending" class="el_required_material_overall_table_pending">
<span<?= $Page->pending->viewAttributes() ?>>
<?= $Page->pending->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_grp->Visible) { // req_material_grp ?>
        <td data-name="req_material_grp"<?= $Page->req_material_grp->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_req_material_grp" class="el_required_material_overall_table_req_material_grp">
<span<?= $Page->req_material_grp->viewAttributes() ?>>
<?= $Page->req_material_grp->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_product->Visible) { // req_material_product ?>
        <td data-name="req_material_product"<?= $Page->req_material_product->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_req_material_product" class="el_required_material_overall_table_req_material_product">
<span<?= $Page->req_material_product->viewAttributes() ?>>
<?= $Page->req_material_product->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <td data-name="req_material_rid"<?= $Page->req_material_rid->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_req_material_rid" class="el_required_material_overall_table_req_material_rid">
<span<?= $Page->req_material_rid->viewAttributes() ?>>
<?php if (!EmptyString($Page->req_material_rid->getViewValue()) && $Page->req_material_rid->linkAttributes() != "") { ?>
<a<?= $Page->req_material_rid->linkAttributes() ?>><?= $Page->req_material_rid->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->req_material_rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <td data-name="req_material_packing"<?= $Page->req_material_packing->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_req_material_packing" class="el_required_material_overall_table_req_material_packing">
<span<?= $Page->req_material_packing->viewAttributes() ?>>
<?php if (!EmptyString($Page->req_material_packing->getViewValue()) && $Page->req_material_packing->linkAttributes() != "") { ?>
<a<?= $Page->req_material_packing->linkAttributes() ?>><?= $Page->req_material_packing->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->req_material_packing->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no"<?= $Page->batch_no->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_batch_no" class="el_required_material_overall_table_batch_no">
<span<?= $Page->batch_no->viewAttributes() ?>>
<?php if (!EmptyString($Page->batch_no->getViewValue()) && $Page->batch_no->linkAttributes() != "") { ?>
<a<?= $Page->batch_no->linkAttributes() ?>><?= $Page->batch_no->getViewValue() ?></a>
<?php } else { ?>
<?= $Page->batch_no->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->unit->Visible) { // unit ?>
        <td data-name="unit"<?= $Page->unit->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_unit" class="el_required_material_overall_table_unit">
<span<?= $Page->unit->viewAttributes() ?>>
<?= $Page->unit->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->mil->Visible) { // mil ?>
        <td data-name="mil"<?= $Page->mil->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_mil" class="el_required_material_overall_table_mil">
<span<?= $Page->mil->viewAttributes() ?>>
<?= $Page->mil->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <td data-name="req_material_qty"<?= $Page->req_material_qty->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_req_material_qty" class="el_required_material_overall_table_req_material_qty">
<span<?= $Page->req_material_qty->viewAttributes() ?>>
<?= $Page->req_material_qty->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_s_pending->Visible) { // po_s_pending ?>
        <td data-name="po_s_pending"<?= $Page->po_s_pending->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_po_s_pending" class="el_required_material_overall_table_po_s_pending">
<span<?= $Page->po_s_pending->viewAttributes() ?>>
<?= $Page->po_s_pending->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->po_pending_wbc->Visible) { // po_pending_wbc ?>
        <td data-name="po_pending_wbc"<?= $Page->po_pending_wbc->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_po_pending_wbc" class="el_required_material_overall_table_po_pending_wbc">
<span<?= $Page->po_pending_wbc->viewAttributes() ?>>
<?= $Page->po_pending_wbc->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->not_loomcard->Visible) { // not_loomcard ?>
        <td data-name="not_loomcard"<?= $Page->not_loomcard->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_not_loomcard" class="el_required_material_overall_table_not_loomcard">
<span<?= $Page->not_loomcard->viewAttributes() ?>>
<?= $Page->not_loomcard->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->stock->Visible) { // stock ?>
        <td data-name="stock"<?= $Page->stock->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_stock" class="el_required_material_overall_table_stock">
<span<?= $Page->stock->viewAttributes() ?>>
<?= $Page->stock->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id"<?= $Page->company_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_company_id" class="el_required_material_overall_table_company_id">
<span<?= $Page->company_id->viewAttributes() ?>>
<?= $Page->company_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->last_supplier_id->Visible) { // last_supplier_id ?>
        <td data-name="last_supplier_id"<?= $Page->last_supplier_id->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_last_supplier_id" class="el_required_material_overall_table_last_supplier_id">
<span<?= $Page->last_supplier_id->viewAttributes() ?>>
<?= $Page->last_supplier_id->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->internal_external->Visible) { // internal_external ?>
        <td data-name="internal_external"<?= $Page->internal_external->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_required_material_overall_table_internal_external" class="el_required_material_overall_table_internal_external">
<span<?= $Page->internal_external->viewAttributes() ?>>
<?= $Page->internal_external->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
    }

    // Reset for template row
    if ($Page->RowIndex === '$rowindex$') {
        $Page->RowIndex = 0;
    }
    // Reset inline add/copy row
    if (($Page->isCopy() || $Page->isAdd()) && $Page->RowIndex == 0) {
        $Page->RowIndex = 1;
    }
}
?>
</tbody>
<?php
// Render aggregate row
$Page->RowType = RowType::AGGREGATE;
$Page->resetAttributes();
$Page->renderRow();
?>
<?php if ($Page->TotalRecords > 0 && !$Page->isGridAdd() && !$Page->isGridEdit() && !$Page->isMultiEdit()) { ?>
<tfoot><!-- Table footer -->
    <tr class="ew-table-footer">
<?php
// Render list options
$Page->renderListOptions();

// Render list options (footer, left)
$Page->ListOptions->render("footer", "left");
?>
    <?php if ($Page->id->Visible) { // id ?>
        <td data-name="id" class="<?= $Page->id->footerCellClass() ?>"><span id="elf_required_material_overall_table_id" class="required_material_overall_table_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->pending->Visible) { // pending ?>
        <td data-name="pending" class="<?= $Page->pending->footerCellClass() ?>"><span id="elf_required_material_overall_table_pending" class="required_material_overall_table_pending">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->pending->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_grp->Visible) { // req_material_grp ?>
        <td data-name="req_material_grp" class="<?= $Page->req_material_grp->footerCellClass() ?>"><span id="elf_required_material_overall_table_req_material_grp" class="required_material_overall_table_req_material_grp">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_product->Visible) { // req_material_product ?>
        <td data-name="req_material_product" class="<?= $Page->req_material_product->footerCellClass() ?>"><span id="elf_required_material_overall_table_req_material_product" class="required_material_overall_table_req_material_product">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
        <td data-name="req_material_rid" class="<?= $Page->req_material_rid->footerCellClass() ?>"><span id="elf_required_material_overall_table_req_material_rid" class="required_material_overall_table_req_material_rid">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
        <td data-name="req_material_packing" class="<?= $Page->req_material_packing->footerCellClass() ?>"><span id="elf_required_material_overall_table_req_material_packing" class="required_material_overall_table_req_material_packing">
        </span></td>
    <?php } ?>
    <?php if ($Page->batch_no->Visible) { // batch_no ?>
        <td data-name="batch_no" class="<?= $Page->batch_no->footerCellClass() ?>"><span id="elf_required_material_overall_table_batch_no" class="required_material_overall_table_batch_no">
        </span></td>
    <?php } ?>
    <?php if ($Page->unit->Visible) { // unit ?>
        <td data-name="unit" class="<?= $Page->unit->footerCellClass() ?>"><span id="elf_required_material_overall_table_unit" class="required_material_overall_table_unit">
        </span></td>
    <?php } ?>
    <?php if ($Page->mil->Visible) { // mil ?>
        <td data-name="mil" class="<?= $Page->mil->footerCellClass() ?>"><span id="elf_required_material_overall_table_mil" class="required_material_overall_table_mil">
        </span></td>
    <?php } ?>
    <?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
        <td data-name="req_material_qty" class="<?= $Page->req_material_qty->footerCellClass() ?>"><span id="elf_required_material_overall_table_req_material_qty" class="required_material_overall_table_req_material_qty">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->req_material_qty->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->po_s_pending->Visible) { // po_s_pending ?>
        <td data-name="po_s_pending" class="<?= $Page->po_s_pending->footerCellClass() ?>"><span id="elf_required_material_overall_table_po_s_pending" class="required_material_overall_table_po_s_pending">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->po_s_pending->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->po_pending_wbc->Visible) { // po_pending_wbc ?>
        <td data-name="po_pending_wbc" class="<?= $Page->po_pending_wbc->footerCellClass() ?>"><span id="elf_required_material_overall_table_po_pending_wbc" class="required_material_overall_table_po_pending_wbc">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->po_pending_wbc->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->not_loomcard->Visible) { // not_loomcard ?>
        <td data-name="not_loomcard" class="<?= $Page->not_loomcard->footerCellClass() ?>"><span id="elf_required_material_overall_table_not_loomcard" class="required_material_overall_table_not_loomcard">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->not_loomcard->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->stock->Visible) { // stock ?>
        <td data-name="stock" class="<?= $Page->stock->footerCellClass() ?>"><span id="elf_required_material_overall_table_stock" class="required_material_overall_table_stock">
        <span class="ew-aggregate"><?= $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
        <?= $Page->stock->ViewValue ?></span>
        </span></td>
    <?php } ?>
    <?php if ($Page->company_id->Visible) { // company_id ?>
        <td data-name="company_id" class="<?= $Page->company_id->footerCellClass() ?>"><span id="elf_required_material_overall_table_company_id" class="required_material_overall_table_company_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->last_supplier_id->Visible) { // last_supplier_id ?>
        <td data-name="last_supplier_id" class="<?= $Page->last_supplier_id->footerCellClass() ?>"><span id="elf_required_material_overall_table_last_supplier_id" class="required_material_overall_table_last_supplier_id">
        </span></td>
    <?php } ?>
    <?php if ($Page->internal_external->Visible) { // internal_external ?>
        <td data-name="internal_external" class="<?= $Page->internal_external->footerCellClass() ?>"><span id="elf_required_material_overall_table_internal_external" class="required_material_overall_table_internal_external">
        </span></td>
    <?php } ?>
<?php
// Render list options (footer, right)
$Page->ListOptions->render("footer", "right");
?>
    </tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php
// Close result set
$Page->Recordset?->free();
?>
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$Page->isGridAdd() && !($Page->isGridEdit() && $Page->ModalGridEdit) && !$Page->isMultiEdit()) { ?>
<?= $Page->Pager->render() ?>
<?php } ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<?php if (!$Page->isExport()) { ?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("required_material_overall_table");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
<?php } ?>
