<?php

namespace PHPMaker2024\fibre;

// Page object
$RequiredMaterialCompiledLiveSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { required_material_compiled_live: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var frequired_material_compiled_livesearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("frequired_material_compiled_livesearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["week", [], fields.week.isInvalid],
            ["y_week", [ew.Validators.between], false],
            ["weaving_works", [], fields.weaving_works.isInvalid],
            ["po", [ew.Validators.integer], fields.po.isInvalid],
            ["y_po", [ew.Validators.between], false],
            ["buyer_id", [], fields.buyer_id.isInvalid],
            ["req_material_sgrp", [], fields.req_material_sgrp.isInvalid],
            ["req_material_product", [], fields.req_material_product.isInvalid],
            ["req_material_rid", [], fields.req_material_rid.isInvalid],
            ["req_material_packing", [], fields.req_material_packing.isInvalid],
            ["req_material_qty", [ew.Validators.float], fields.req_material_qty.isInvalid],
            ["y_req_material_qty", [ew.Validators.between], false],
            ["stock", [ew.Validators.float], fields.stock.isInvalid],
            ["unit", [], fields.unit.isInvalid],
            ["batch_no", [], fields.batch_no.isInvalid],
            ["req_batch_no", [], fields.req_batch_no.isInvalid],
            ["pp_id", [ew.Validators.integer], fields.pp_id.isInvalid],
            ["level", [ew.Validators.integer], fields.level.isInvalid],
            ["req_material_grp", [], fields.req_material_grp.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "week": <?= $Page->week->toClientList($Page) ?>,
            "weaving_works": <?= $Page->weaving_works->toClientList($Page) ?>,
            "buyer_id": <?= $Page->buyer_id->toClientList($Page) ?>,
            "req_material_sgrp": <?= $Page->req_material_sgrp->toClientList($Page) ?>,
            "req_material_product": <?= $Page->req_material_product->toClientList($Page) ?>,
            "req_material_rid": <?= $Page->req_material_rid->toClientList($Page) ?>,
            "req_material_packing": <?= $Page->req_material_packing->toClientList($Page) ?>,
            "unit": <?= $Page->unit->toClientList($Page) ?>,
            "pp_id": <?= $Page->pp_id->toClientList($Page) ?>,
            "req_material_grp": <?= $Page->req_material_grp->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="frequired_material_compiled_livesearch" id="frequired_material_compiled_livesearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="required_material_compiled_live">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->week->Visible) { // week ?>
    <div id="r_week" class="row"<?= $Page->week->rowAttributes() ?>>
        <label for="x_week" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_week"><?= $Page->week->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->week->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_week" id="z_week" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->week->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->week->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_required_material_compiled_live_week" class="ew-search-field">
    <select
        id="x_week"
        name="x_week"
        class="form-select ew-select<?= $Page->week->isInvalidClass() ?>"
        <?php if (!$Page->week->IsNativeSelect) { ?>
        data-select2-id="frequired_material_compiled_livesearch_x_week"
        <?php } ?>
        data-table="required_material_compiled_live"
        data-field="x_week"
        data-value-separator="<?= $Page->week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->week->getPlaceHolder()) ?>"
        <?= $Page->week->editAttributes() ?>>
        <?= $Page->week->selectOptionListHtml("x_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->week->getErrorMessage(false) ?></div>
<?= $Page->week->Lookup->getParamTag($Page, "p_x_week") ?>
<?php if (!$Page->week->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_compiled_livesearch", function() {
    var options = { name: "x_week", selectId: "frequired_material_compiled_livesearch_x_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_compiled_livesearch.lists.week?.lookupOptions.length) {
        options.data = { id: "x_week", form: "frequired_material_compiled_livesearch" };
    } else {
        options.ajax = { id: "x_week", form: "frequired_material_compiled_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_compiled_live.fields.week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_required_material_compiled_live_week" class="ew-search-field2 d-none">
    <select
        id="y_week"
        name="y_week"
        class="form-select ew-select<?= $Page->week->isInvalidClass() ?>"
        <?php if (!$Page->week->IsNativeSelect) { ?>
        data-select2-id="frequired_material_compiled_livesearch_y_week"
        <?php } ?>
        data-table="required_material_compiled_live"
        data-field="x_week"
        data-value-separator="<?= $Page->week->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->week->getPlaceHolder()) ?>"
        <?= $Page->week->editAttributes() ?>>
        <?= $Page->week->selectOptionListHtml("y_week") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->week->getErrorMessage(false) ?></div>
<?= $Page->week->Lookup->getParamTag($Page, "p_y_week") ?>
<?php if (!$Page->week->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_compiled_livesearch", function() {
    var options = { name: "y_week", selectId: "frequired_material_compiled_livesearch_y_week" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_compiled_livesearch.lists.week?.lookupOptions.length) {
        options.data = { id: "y_week", form: "frequired_material_compiled_livesearch" };
    } else {
        options.ajax = { id: "y_week", form: "frequired_material_compiled_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_compiled_live.fields.week.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->weaving_works->Visible) { // weaving_works ?>
    <div id="r_weaving_works" class="row"<?= $Page->weaving_works->rowAttributes() ?>>
        <label for="x_weaving_works" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_weaving_works"><?= $Page->weaving_works->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_weaving_works" id="z_weaving_works" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->weaving_works->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_weaving_works" class="ew-search-field ew-search-field-single">
    <select
        id="x_weaving_works"
        name="x_weaving_works"
        class="form-select ew-select<?= $Page->weaving_works->isInvalidClass() ?>"
        <?php if (!$Page->weaving_works->IsNativeSelect) { ?>
        data-select2-id="frequired_material_compiled_livesearch_x_weaving_works"
        <?php } ?>
        data-table="required_material_compiled_live"
        data-field="x_weaving_works"
        data-value-separator="<?= $Page->weaving_works->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->weaving_works->getPlaceHolder()) ?>"
        <?= $Page->weaving_works->editAttributes() ?>>
        <?= $Page->weaving_works->selectOptionListHtml("x_weaving_works") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->weaving_works->getErrorMessage(false) ?></div>
<?= $Page->weaving_works->Lookup->getParamTag($Page, "p_x_weaving_works") ?>
<?php if (!$Page->weaving_works->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_compiled_livesearch", function() {
    var options = { name: "x_weaving_works", selectId: "frequired_material_compiled_livesearch_x_weaving_works" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_compiled_livesearch.lists.weaving_works?.lookupOptions.length) {
        options.data = { id: "x_weaving_works", form: "frequired_material_compiled_livesearch" };
    } else {
        options.ajax = { id: "x_weaving_works", form: "frequired_material_compiled_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_compiled_live.fields.weaving_works.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->po->Visible) { // po ?>
    <div id="r_po" class="row"<?= $Page->po->rowAttributes() ?>>
        <label for="x_po" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_po"><?= $Page->po->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->po->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_po" id="z_po" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->po->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->po->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_required_material_compiled_live_po" class="ew-search-field">
<input type="<?= $Page->po->getInputTextType() ?>" name="x_po" id="x_po" data-table="required_material_compiled_live" data-field="x_po" value="<?= $Page->po->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_required_material_compiled_live_po" class="ew-search-field2 d-none">
<input type="<?= $Page->po->getInputTextType() ?>" name="y_po" id="y_po" data-table="required_material_compiled_live" data-field="x_po" value="<?= $Page->po->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->po->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->po->formatPattern()) ?>"<?= $Page->po->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->po->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->buyer_id->Visible) { // buyer_id ?>
    <div id="r_buyer_id" class="row"<?= $Page->buyer_id->rowAttributes() ?>>
        <label for="x_buyer_id" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_buyer_id"><?= $Page->buyer_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_buyer_id" id="z_buyer_id" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->buyer_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_buyer_id" class="ew-search-field ew-search-field-single">
    <select
        id="x_buyer_id"
        name="x_buyer_id"
        class="form-select ew-select<?= $Page->buyer_id->isInvalidClass() ?>"
        <?php if (!$Page->buyer_id->IsNativeSelect) { ?>
        data-select2-id="frequired_material_compiled_livesearch_x_buyer_id"
        <?php } ?>
        data-table="required_material_compiled_live"
        data-field="x_buyer_id"
        data-value-separator="<?= $Page->buyer_id->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->buyer_id->getPlaceHolder()) ?>"
        <?= $Page->buyer_id->editAttributes() ?>>
        <?= $Page->buyer_id->selectOptionListHtml("x_buyer_id") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->buyer_id->getErrorMessage(false) ?></div>
<?= $Page->buyer_id->Lookup->getParamTag($Page, "p_x_buyer_id") ?>
<?php if (!$Page->buyer_id->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_compiled_livesearch", function() {
    var options = { name: "x_buyer_id", selectId: "frequired_material_compiled_livesearch_x_buyer_id" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_compiled_livesearch.lists.buyer_id?.lookupOptions.length) {
        options.data = { id: "x_buyer_id", form: "frequired_material_compiled_livesearch" };
    } else {
        options.ajax = { id: "x_buyer_id", form: "frequired_material_compiled_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_compiled_live.fields.buyer_id.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_sgrp->Visible) { // req_material_sgrp ?>
    <div id="r_req_material_sgrp" class="row"<?= $Page->req_material_sgrp->rowAttributes() ?>>
        <label for="x_req_material_sgrp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_req_material_sgrp"><?= $Page->req_material_sgrp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_req_material_sgrp" id="z_req_material_sgrp" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_sgrp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_req_material_sgrp" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->req_material_sgrp->getInputTextType() ?>" name="x_req_material_sgrp" id="x_req_material_sgrp" data-table="required_material_compiled_live" data-field="x_req_material_sgrp" value="<?= $Page->req_material_sgrp->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_sgrp->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_sgrp->formatPattern()) ?>"<?= $Page->req_material_sgrp->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->req_material_sgrp->getErrorMessage(false) ?></div>
<?= $Page->req_material_sgrp->Lookup->getParamTag($Page, "p_x_req_material_sgrp") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_product->Visible) { // req_material_product ?>
    <div id="r_req_material_product" class="row"<?= $Page->req_material_product->rowAttributes() ?>>
        <label for="x_req_material_product" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_req_material_product"><?= $Page->req_material_product->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_req_material_product" id="z_req_material_product" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_product->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_req_material_product" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->req_material_product->getInputTextType() ?>" name="x_req_material_product" id="x_req_material_product" data-table="required_material_compiled_live" data-field="x_req_material_product" value="<?= $Page->req_material_product->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_product->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_product->formatPattern()) ?>"<?= $Page->req_material_product->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->req_material_product->getErrorMessage(false) ?></div>
<?= $Page->req_material_product->Lookup->getParamTag($Page, "p_x_req_material_product") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_rid->Visible) { // req_material_rid ?>
    <div id="r_req_material_rid" class="row"<?= $Page->req_material_rid->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_req_material_rid"><?= $Page->req_material_rid->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_req_material_rid" id="z_req_material_rid" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_rid->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_req_material_rid" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->req_material_rid->getInputTextType() ?>" name="x_req_material_rid" id="x_req_material_rid" data-table="required_material_compiled_live" data-field="x_req_material_rid" value="<?= $Page->req_material_rid->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_rid->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_rid->formatPattern()) ?>"<?= $Page->req_material_rid->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->req_material_rid->getErrorMessage(false) ?></div>
<?= $Page->req_material_rid->Lookup->getParamTag($Page, "p_x_req_material_rid") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_packing->Visible) { // req_material_packing ?>
    <div id="r_req_material_packing" class="row"<?= $Page->req_material_packing->rowAttributes() ?>>
        <label for="x_req_material_packing" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_req_material_packing"><?= $Page->req_material_packing->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_packing" id="z_req_material_packing" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_packing->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_req_material_packing" class="ew-search-field ew-search-field-single">
    <select
        id="x_req_material_packing"
        name="x_req_material_packing"
        class="form-select ew-select<?= $Page->req_material_packing->isInvalidClass() ?>"
        <?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
        data-select2-id="frequired_material_compiled_livesearch_x_req_material_packing"
        <?php } ?>
        data-table="required_material_compiled_live"
        data-field="x_req_material_packing"
        data-value-separator="<?= $Page->req_material_packing->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_packing->getPlaceHolder()) ?>"
        <?= $Page->req_material_packing->editAttributes() ?>>
        <?= $Page->req_material_packing->selectOptionListHtml("x_req_material_packing") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_packing->getErrorMessage(false) ?></div>
<?= $Page->req_material_packing->Lookup->getParamTag($Page, "p_x_req_material_packing") ?>
<?php if (!$Page->req_material_packing->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_compiled_livesearch", function() {
    var options = { name: "x_req_material_packing", selectId: "frequired_material_compiled_livesearch_x_req_material_packing" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_compiled_livesearch.lists.req_material_packing?.lookupOptions.length) {
        options.data = { id: "x_req_material_packing", form: "frequired_material_compiled_livesearch" };
    } else {
        options.ajax = { id: "x_req_material_packing", form: "frequired_material_compiled_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_compiled_live.fields.req_material_packing.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_qty->Visible) { // req_material_qty ?>
    <div id="r_req_material_qty" class="row"<?= $Page->req_material_qty->rowAttributes() ?>>
        <label for="x_req_material_qty" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_req_material_qty"><?= $Page->req_material_qty->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_qty->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_req_material_qty" id="z_req_material_qty" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->req_material_qty->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->req_material_qty->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_required_material_compiled_live_req_material_qty" class="ew-search-field">
<input type="<?= $Page->req_material_qty->getInputTextType() ?>" name="x_req_material_qty" id="x_req_material_qty" data-table="required_material_compiled_live" data-field="x_req_material_qty" value="<?= $Page->req_material_qty->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_qty->formatPattern()) ?>"<?= $Page->req_material_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->req_material_qty->getErrorMessage(false) ?></div>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_required_material_compiled_live_req_material_qty" class="ew-search-field2 d-none">
<input type="<?= $Page->req_material_qty->getInputTextType() ?>" name="y_req_material_qty" id="y_req_material_qty" data-table="required_material_compiled_live" data-field="x_req_material_qty" value="<?= $Page->req_material_qty->EditValue2 ?>" size="30" placeholder="<?= HtmlEncode($Page->req_material_qty->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_material_qty->formatPattern()) ?>"<?= $Page->req_material_qty->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->req_material_qty->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->stock->Visible) { // stock ?>
    <div id="r_stock" class="row"<?= $Page->stock->rowAttributes() ?>>
        <label for="x_stock" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_stock"><?= $Page->stock->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_stock" id="z_stock" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->stock->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_stock" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->stock->getInputTextType() ?>" name="x_stock" id="x_stock" data-table="required_material_compiled_live" data-field="x_stock" value="<?= $Page->stock->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->stock->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->stock->formatPattern()) ?>"<?= $Page->stock->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->stock->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->unit->Visible) { // unit ?>
    <div id="r_unit" class="row"<?= $Page->unit->rowAttributes() ?>>
        <label for="x_unit" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_unit"><?= $Page->unit->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_unit" id="z_unit" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->unit->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_unit" class="ew-search-field ew-search-field-single">
    <select
        id="x_unit"
        name="x_unit"
        class="form-select ew-select<?= $Page->unit->isInvalidClass() ?>"
        <?php if (!$Page->unit->IsNativeSelect) { ?>
        data-select2-id="frequired_material_compiled_livesearch_x_unit"
        <?php } ?>
        data-table="required_material_compiled_live"
        data-field="x_unit"
        data-value-separator="<?= $Page->unit->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->unit->getPlaceHolder()) ?>"
        <?= $Page->unit->editAttributes() ?>>
        <?= $Page->unit->selectOptionListHtml("x_unit") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->unit->getErrorMessage(false) ?></div>
<?= $Page->unit->Lookup->getParamTag($Page, "p_x_unit") ?>
<?php if (!$Page->unit->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_compiled_livesearch", function() {
    var options = { name: "x_unit", selectId: "frequired_material_compiled_livesearch_x_unit" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_compiled_livesearch.lists.unit?.lookupOptions.length) {
        options.data = { id: "x_unit", form: "frequired_material_compiled_livesearch" };
    } else {
        options.ajax = { id: "x_unit", form: "frequired_material_compiled_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_compiled_live.fields.unit.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->batch_no->Visible) { // batch_no ?>
    <div id="r_batch_no" class="row"<?= $Page->batch_no->rowAttributes() ?>>
        <label for="x_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_batch_no"><?= $Page->batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_batch_no" id="z_batch_no" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_batch_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->batch_no->getInputTextType() ?>" name="x_batch_no" id="x_batch_no" data-table="required_material_compiled_live" data-field="x_batch_no" value="<?= $Page->batch_no->EditValue ?>" placeholder="<?= HtmlEncode($Page->batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->batch_no->formatPattern()) ?>"<?= $Page->batch_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->batch_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_batch_no->Visible) { // req_batch_no ?>
    <div id="r_req_batch_no" class="row"<?= $Page->req_batch_no->rowAttributes() ?>>
        <label for="x_req_batch_no" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_req_batch_no"><?= $Page->req_batch_no->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_req_batch_no" id="z_req_batch_no" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_batch_no->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_req_batch_no" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->req_batch_no->getInputTextType() ?>" name="x_req_batch_no" id="x_req_batch_no" data-table="required_material_compiled_live" data-field="x_req_batch_no" value="<?= $Page->req_batch_no->EditValue ?>" size="35" placeholder="<?= HtmlEncode($Page->req_batch_no->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->req_batch_no->formatPattern()) ?>"<?= $Page->req_batch_no->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->req_batch_no->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->pp_id->Visible) { // pp_id ?>
    <div id="r_pp_id" class="row"<?= $Page->pp_id->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_pp_id"><?= $Page->pp_id->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_pp_id" id="z_pp_id" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->pp_id->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_pp_id" class="ew-search-field ew-search-field-single">
<?php
if (IsRTL()) {
    $Page->pp_id->EditAttrs["dir"] = "rtl";
}
?>
<span id="as_x_pp_id" class="ew-auto-suggest">
    <input type="<?= $Page->pp_id->getInputTextType() ?>" class="form-control" name="sv_x_pp_id" id="sv_x_pp_id" value="<?= RemoveHtml($Page->pp_id->EditValue) ?>" autocomplete="off" size="30" placeholder="<?= HtmlEncode($Page->pp_id->getPlaceHolder()) ?>" data-placeholder="<?= HtmlEncode($Page->pp_id->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->pp_id->formatPattern()) ?>"<?= $Page->pp_id->editAttributes() ?>>
</span>
<selection-list hidden class="form-control" data-table="required_material_compiled_live" data-field="x_pp_id" data-input="sv_x_pp_id" data-value-separator="<?= $Page->pp_id->displayValueSeparatorAttribute() ?>" name="x_pp_id" id="x_pp_id" value="<?= HtmlEncode($Page->pp_id->AdvancedSearch->SearchValue) ?>"></selection-list>
<div class="invalid-feedback"><?= $Page->pp_id->getErrorMessage(false) ?></div>
<script>
loadjs.ready("frequired_material_compiled_livesearch", function() {
    frequired_material_compiled_livesearch.createAutoSuggest(Object.assign({"id":"x_pp_id","forceSelect":false}, { lookupAllDisplayFields: <?= $Page->pp_id->Lookup->LookupAllDisplayFields ? "true" : "false" ?> }, ew.vars.tables.required_material_compiled_live.fields.pp_id.autoSuggestOptions));
});
</script>
<?= $Page->pp_id->Lookup->getParamTag($Page, "p_x_pp_id") ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->level->Visible) { // level ?>
    <div id="r_level" class="row"<?= $Page->level->rowAttributes() ?>>
        <label for="x_level" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_level"><?= $Page->level->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_level" id="z_level" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->level->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_level" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->level->getInputTextType() ?>" name="x_level" id="x_level" data-table="required_material_compiled_live" data-field="x_level" value="<?= $Page->level->EditValue ?>" size="30" placeholder="<?= HtmlEncode($Page->level->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->level->formatPattern()) ?>"<?= $Page->level->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->level->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->req_material_grp->Visible) { // req_material_grp ?>
    <div id="r_req_material_grp" class="row"<?= $Page->req_material_grp->rowAttributes() ?>>
        <label for="x_req_material_grp" class="<?= $Page->LeftColumnClass ?>"><span id="elh_required_material_compiled_live_req_material_grp"><?= $Page->req_material_grp->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_req_material_grp" id="z_req_material_grp" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->req_material_grp->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_required_material_compiled_live_req_material_grp" class="ew-search-field ew-search-field-single">
    <select
        id="x_req_material_grp"
        name="x_req_material_grp"
        class="form-select ew-select<?= $Page->req_material_grp->isInvalidClass() ?>"
        <?php if (!$Page->req_material_grp->IsNativeSelect) { ?>
        data-select2-id="frequired_material_compiled_livesearch_x_req_material_grp"
        <?php } ?>
        data-table="required_material_compiled_live"
        data-field="x_req_material_grp"
        data-value-separator="<?= $Page->req_material_grp->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->req_material_grp->getPlaceHolder()) ?>"
        <?= $Page->req_material_grp->editAttributes() ?>>
        <?= $Page->req_material_grp->selectOptionListHtml("x_req_material_grp") ?>
    </select>
    <div class="invalid-feedback"><?= $Page->req_material_grp->getErrorMessage(false) ?></div>
<?= $Page->req_material_grp->Lookup->getParamTag($Page, "p_x_req_material_grp") ?>
<?php if (!$Page->req_material_grp->IsNativeSelect) { ?>
<script>
loadjs.ready("frequired_material_compiled_livesearch", function() {
    var options = { name: "x_req_material_grp", selectId: "frequired_material_compiled_livesearch_x_req_material_grp" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (frequired_material_compiled_livesearch.lists.req_material_grp?.lookupOptions.length) {
        options.data = { id: "x_req_material_grp", form: "frequired_material_compiled_livesearch" };
    } else {
        options.ajax = { id: "x_req_material_grp", form: "frequired_material_compiled_livesearch", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.required_material_compiled_live.fields.req_material_grp.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="frequired_material_compiled_livesearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="frequired_material_compiled_livesearch"><?= $Language->phrase("CancelBtn") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="frequired_material_compiled_livesearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("required_material_compiled_live");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
